/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.cast;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DistanceMetricPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HCLSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.SampleSelectionPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.util.awt.GBA;

public class CASTInitDialog
extends AlgorithmDialog {
    protected GBA gba;
    protected EventListener eventListener;
    protected SampleSelectionPanel sampleSelectionPanel;
    protected HCLSelectionPanel hclOpsPanel;
    protected JPanel thresholdPanel;
    protected JLabel thresholdLabel;
    public JTextField thresholdTextField;
    private DistanceMetricPanel metricPanel;
    protected JPanel mainPanel;
    private boolean okPressed = false;

    public CASTInitDialog(JFrame jFrame, boolean bl, String string, boolean bl2) {
        super(jFrame, "CAST: Cluster Affinity Search Technique", bl);
        this.initialize(string, bl2);
    }

    protected void initialize(String string, boolean bl) {
        this.gba = new GBA();
        this.eventListener = new EventListener();
        this.sampleSelectionPanel = new SampleSelectionPanel(Color.white, UIManager.getColor("Label.foreground"), true, "Sample Selection");
        this.metricPanel = new DistanceMetricPanel(string, bl, "Euclidean Distance", "CAST", true, true);
        this.thresholdLabel = new JLabel("Threshold");
        this.thresholdTextField = new JTextField(10);
        this.thresholdTextField.setText("0.8");
        this.thresholdPanel = new JPanel();
        this.thresholdPanel.setLayout(new GridBagLayout());
        this.thresholdPanel.setBackground(Color.white);
        this.thresholdPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Threshold Parameter", 0, 0, new Font("Dialog", 1, 12), Color.black));
        this.gba.add((Container)this.thresholdPanel, (Component)this.thresholdLabel, 0, 0, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 10, 5), 0, 0);
        this.gba.add((Container)this.thresholdPanel, (Component)this.thresholdTextField, 1, 0, 1, 1, 0, 0, 2, 10, new Insets(5, 5, 10, 5), 0, 0);
        this.hclOpsPanel = new HCLSelectionPanel();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setBackground(Color.white);
        this.gba.add((Container)this.mainPanel, (Component)this.sampleSelectionPanel, 0, 0, 1, 1, 1, 1, 2, 10, new Insets(0, 0, 0, 0), 0, 0);
        this.gba.add((Container)this.mainPanel, (Component)this.metricPanel, 0, 1, 1, 1, 1, 1, 2, 10, new Insets(0, 0, 0, 0), 0, 0);
        this.gba.add((Container)this.mainPanel, (Component)this.thresholdPanel, 0, 2, 1, 1, 1, 1, 2, 10, new Insets(0, 0, 0, 0), 0, 0);
        this.gba.add((Container)this.mainPanel, (Component)this.hclOpsPanel, 0, 3, 1, 1, 1, 1, 2, 10, new Insets(0, 0, 0, 0), 0, 0);
        this.setResizable(false);
        this.setActionListeners(this.eventListener);
        this.addContent(this.mainPanel);
        this.setSize(420, 290);
        this.pack();
    }

    public void setVisible(boolean bl) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        super.setVisible(bl);
        if (bl) {
            this.okButton.requestFocus();
        }
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public boolean isClusterGenes() {
        return this.sampleSelectionPanel.isClusterGenesSelected();
    }

    public boolean isHCLSelected() {
        return this.hclOpsPanel.isHCLSelected();
    }

    public int getDistanceMetric() {
        return this.metricPanel.getMetricIndex();
    }

    public boolean isAbsoluteDistance() {
        return this.metricPanel.getAbsoluteSelection();
    }

    public void resetControls() {
        this.sampleSelectionPanel.setClusterGenesSelected(true);
        this.hclOpsPanel.setHCLSelected(false);
        this.thresholdTextField.setText("0.8");
        this.metricPanel.reset();
    }

    public static void main(String[] stringArray) {
        CASTInitDialog cASTInitDialog = new CASTInitDialog(new JFrame(), true, "Euclidean Distance", false);
        cASTInitDialog.show();
        System.exit(0);
    }

    protected void disposeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    protected class EventListener
    implements ActionListener {
        protected EventListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                float f;
                CASTInitDialog.this.okPressed = true;
                try {
                    f = Float.parseFloat(CASTInitDialog.this.thresholdTextField.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(CASTInitDialog.this, "Number format error.", "Number Format Error", 0);
                    CASTInitDialog.this.thresholdTextField.requestFocus();
                    CASTInitDialog.this.thresholdTextField.selectAll();
                    return;
                }
                if (f <= 0.0f || f > 1.0f) {
                    JOptionPane.showMessageDialog(CASTInitDialog.this, "Threshold must be > 0 and <= 1.0", "Input Value Error", 0);
                    CASTInitDialog.this.thresholdTextField.requestFocus();
                    CASTInitDialog.this.thresholdTextField.selectAll();
                    return;
                }
                CASTInitDialog.this.dispose();
            } else if (string.equals("cancel-command")) {
                CASTInitDialog.this.dispose();
            } else if (string.equals("reset-command")) {
                CASTInitDialog.this.resetControls();
            } else if (string.equals("info-command")) {
                HelpWindow helpWindow = new HelpWindow(CASTInitDialog.this, "CAST Initialization Dialog");
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 600);
                    helpWindow.setLocation();
                    helpWindow.show();
                } else {
                    helpWindow.dispose();
                }
            }
        }
    }
}

