/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.image.WritableRaster;
import javax.media.jai.BorderExtenderCopy;
import javax.media.jai.BorderExtenderReflect;
import javax.media.jai.BorderExtenderWrap;
import javax.media.jai.BorderExtenderZero;
import javax.media.jai.JaiI18N;
import javax.media.jai.PlanarImage;

public abstract class BorderExtender {
    public static final int BORDER_ZERO = 0;
    public static final int BORDER_COPY = 1;
    public static final int BORDER_REFLECT = 2;
    public static final int BORDER_WRAP = 3;
    private static final BorderExtender borderExtenderZero = new BorderExtenderZero();
    private static final BorderExtender borderExtenderCopy = new BorderExtenderCopy();
    private static final BorderExtender borderExtenderReflect = new BorderExtenderReflect();
    private static final BorderExtender borderExtenderWrap = new BorderExtenderWrap();

    public static BorderExtender createInstance(int n) {
        switch (n) {
            case 0: {
                return borderExtenderZero;
            }
            case 1: {
                return borderExtenderCopy;
            }
            case 2: {
                return borderExtenderReflect;
            }
            case 3: {
                return borderExtenderWrap;
            }
        }
        throw new IllegalArgumentException(JaiI18N.getString("BorderExtender0"));
    }

    public abstract void extend(WritableRaster var1, PlanarImage var2);
}

