/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.TileCache;

final class ClampOpImage
extends PointOpImage {
    private byte[][] byteTable = null;
    private double[] low;
    private double[] high;

    public ClampOpImage(RenderedImage renderedImage, TileCache tileCache, ImageLayout imageLayout, double[] dArray, double[] dArray2) {
        super(renderedImage, tileCache, imageLayout, true);
        int n = this.getSampleModel().getNumBands();
        if (dArray.length < n || dArray2.length < n) {
            this.low = new double[n];
            this.high = new double[n];
            int n2 = 0;
            while (n2 < n) {
                this.low[n2] = dArray[0];
                this.high[n2] = dArray2[0];
                ++n2;
            }
        } else {
            this.low = (double[])dArray.clone();
            this.high = (double[])dArray2.clone();
        }
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                if (this.byteTable == null) {
                    int n = this.getSampleModel().getNumBands();
                    this.byteTable = new byte[n][256];
                    int n2 = 0;
                    while (n2 < n) {
                        byte[] byArray = this.byteTable[n2];
                        int n3 = (int)this.low[n2];
                        int n4 = (int)this.high[n2];
                        byte by = (byte)n3;
                        byte by2 = (byte)n4;
                        int n5 = 0;
                        while (n5 < 256) {
                            byArray[n5] = n5 < n3 ? by : (n5 > n4 ? by2 : (byte)n5);
                            ++n5;
                        }
                        ++n2;
                    }
                }
                this.computeRectByte(rasterAccessor, rasterAccessor2);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessor, rasterAccessor2);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessor, rasterAccessor2);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessor, rasterAccessor2);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessor, rasterAccessor2);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessor, rasterAccessor2);
                break;
            }
        }
        rasterAccessor2.copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int n8 = 0;
        while (n8 < n3) {
            byte[] byArray3 = byArray[n8];
            byte[] byArray4 = byArray2[n8];
            byte[] byArray5 = this.byteTable[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = n9;
                int n13 = n10;
                n9 += n4;
                n10 += n6;
                int n14 = 0;
                while (n14 < n) {
                    byArray3[n12] = byArray5[byArray4[n13] & 0xFF];
                    n12 += n5;
                    n13 += n7;
                    ++n14;
                }
                ++n11;
            }
            ++n8;
        }
    }

    private void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int n8 = 0;
        while (n8 < n3) {
            double[] dArray3 = dArray[n8];
            double[] dArray4 = dArray2[n8];
            double d = this.low[n8];
            double d2 = this.high[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = n9;
                int n13 = n10;
                n9 += n4;
                n10 += n6;
                int n14 = 0;
                while (n14 < n) {
                    double d3 = dArray4[n13];
                    dArray3[n12] = d3 < d ? d : (d3 > d2 ? d2 : d3);
                    n12 += n5;
                    n13 += n7;
                    ++n14;
                }
                ++n11;
            }
            ++n8;
        }
    }

    private void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int n8 = 0;
        while (n8 < n3) {
            float[] fArray3 = fArray[n8];
            float[] fArray4 = fArray2[n8];
            double d = this.low[n8];
            double d2 = this.high[n8];
            float f = (float)d;
            float f2 = (float)d2;
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = n9;
                int n13 = n10;
                n9 += n4;
                n10 += n6;
                int n14 = 0;
                while (n14 < n) {
                    float f3 = fArray4[n13];
                    fArray3[n12] = (double)f3 < d ? f : ((double)f3 > d2 ? f2 : f3);
                    n12 += n5;
                    n13 += n7;
                    ++n14;
                }
                ++n11;
            }
            ++n8;
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int[][] nArray2 = rasterAccessor2.getIntDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        int[][] nArray4 = rasterAccessor.getIntDataArrays();
        int n8 = 0;
        while (n8 < n3) {
            int[] nArray5 = nArray2[n8];
            int[] nArray6 = nArray4[n8];
            double d = this.low[n8];
            double d2 = this.high[n8];
            int n9 = (int)d;
            int n10 = (int)d2;
            int n11 = nArray[n8];
            int n12 = nArray3[n8];
            int n13 = 0;
            while (n13 < n2) {
                int n14 = n11;
                int n15 = n12;
                n11 += n4;
                n12 += n6;
                int n16 = 0;
                while (n16 < n) {
                    int n17 = nArray6[n15];
                    nArray5[n14] = (double)n17 < d ? n9 : ((double)n17 > d2 ? n10 : n17);
                    n14 += n5;
                    n15 += n7;
                    ++n16;
                }
                ++n13;
            }
            ++n8;
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int n8 = 0;
        while (n8 < n3) {
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            int n9 = (int)this.low[n8];
            int n10 = (int)this.high[n8];
            short s = (short)n9;
            short s2 = (short)n10;
            int n11 = nArray[n8];
            int n12 = nArray2[n8];
            int n13 = 0;
            while (n13 < n2) {
                int n14 = n11;
                int n15 = n12;
                n11 += n4;
                n12 += n6;
                int n16 = 0;
                while (n16 < n) {
                    short s3 = sArray4[n15];
                    sArray3[n14] = s3 < n9 ? s : (s3 > n10 ? s2 : s3);
                    n14 += n5;
                    n15 += n7;
                    ++n16;
                }
                ++n13;
            }
            ++n8;
        }
    }

    private void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int n8 = 0;
        while (n8 < n3) {
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            int n9 = (int)this.low[n8];
            int n10 = (int)this.high[n8];
            short s = (short)n9;
            short s2 = (short)n10;
            int n11 = nArray[n8];
            int n12 = nArray2[n8];
            int n13 = 0;
            while (n13 < n2) {
                int n14 = n11;
                int n15 = n12;
                n11 += n4;
                n12 += n6;
                int n16 = 0;
                while (n16 < n) {
                    int n17 = sArray4[n15] & 0xFFFF;
                    sArray3[n14] = n17 < n9 ? s : (n17 > n10 ? s2 : (short)n17);
                    n14 += n5;
                    n15 += n7;
                    ++n16;
                }
                ++n13;
            }
            ++n8;
        }
    }
}

