/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import JSci.maths.statistics.TDistribution;
import java.util.Random;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.util.Combinations;
import org.tigr.util.FloatMatrix;
import org.tigr.util.QSort;

public class Ttest
extends AbstractAlgorithm {
    public static final int GROUP_A = 1;
    public static final int GROUP_B = 2;
    public static final int NEITHER_GROUP = 3;
    public static final int JUST_ALPHA = 4;
    public static final int STD_BONFERRONI = 5;
    public static final int ADJ_BONFERRONI = 6;
    public static final int BETWEEN_SUBJECTS = 7;
    public static final int ONE_CLASS = 8;
    public static final int MAX_T = 9;
    public static final int MIN_P = 10;
    public static final int PAIRED = 11;
    public static final int FALSE_NUM = 12;
    public static final int FALSE_PROP = 13;
    private boolean stop = false;
    private int function;
    private float factor;
    private boolean absolute;
    private FloatMatrix expMatrix;
    boolean hierarchical_tree;
    boolean drawSigTreesOnly;
    int method_linkage;
    boolean calculate_genes;
    boolean calculate_experiments;
    private Vector[] clusters;
    private int k;
    private int numGenes;
    private int numExps;
    private int falseNum;
    private float alpha;
    private float falseProp;
    private int significanceMethod;
    private boolean isPermut;
    private boolean useWelchDf;
    private boolean calculateAdjFDRPVals;
    private boolean useFastFDRApprox;
    private int[] groupAssignments;
    private int[] pairedGroupAExpts;
    private int[] pairedGroupBExpts;
    private int numCombs;
    boolean useAllCombs;
    int tTestDesign;
    float oneClassMean = 0.0f;
    AlgorithmEvent event;
    double[] tValues;
    double[] oneClassMeans;
    double[] groupAMeans;
    double[] groupBMeans;
    double[] oneClassSDs;
    double[] groupASDs;
    double[] groupBSDs;
    double[] dfValues;
    double[] origPVals;
    double[] adjustedPVals;
    private boolean[] isSig;
    private int hcl_function;
    private boolean hcl_absolute;
    int validN;

    public void abort() {
        this.stop = true;
    }

    public AlgorithmData execute(AlgorithmData algorithmData) throws AlgorithmException {
        int n;
        Object object;
        Object object2;
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        this.function = algorithmParameters.getInt("distance-function", 4);
        this.factor = algorithmParameters.getFloat("distance-factor", 1.0f);
        this.absolute = algorithmParameters.getBoolean("distance-absolute", false);
        this.hcl_function = algorithmParameters.getInt("hcl-distance-function", 4);
        this.hcl_absolute = algorithmParameters.getBoolean("hcl-distance-absolute", false);
        this.hierarchical_tree = algorithmParameters.getBoolean("hierarchical-tree", false);
        if (this.hierarchical_tree) {
            this.drawSigTreesOnly = algorithmParameters.getBoolean("draw-sig-trees-only");
        }
        this.method_linkage = algorithmParameters.getInt("method-linkage", 0);
        this.calculate_genes = algorithmParameters.getBoolean("calculate-genes", false);
        this.calculate_experiments = algorithmParameters.getBoolean("calculate-experiments", false);
        this.expMatrix = algorithmData.getMatrix("experiment");
        this.numGenes = this.expMatrix.getRowDimension();
        this.numExps = this.expMatrix.getColumnDimension();
        this.tTestDesign = algorithmParameters.getInt("tTestDesign", 7);
        if (this.tTestDesign == 8) {
            this.oneClassMean = algorithmParameters.getFloat("oneClassMean", 0.0f);
        }
        this.alpha = algorithmParameters.getFloat("alpha", 0.01f);
        this.significanceMethod = algorithmParameters.getInt("significance-method", 4);
        this.isPermut = algorithmParameters.getBoolean("is-permut", false);
        this.useWelchDf = algorithmParameters.getBoolean("useWelchDf", true);
        this.numCombs = algorithmParameters.getInt("num-combs", 100);
        this.useAllCombs = algorithmParameters.getBoolean("use-all-combs", false);
        if (this.significanceMethod == 12 || this.significanceMethod == 13) {
            this.calculateAdjFDRPVals = algorithmParameters.getBoolean("calculateAdjFDRPVals", false);
            this.useFastFDRApprox = algorithmParameters.getBoolean("useFastFDRApprox", true);
        }
        if (this.significanceMethod == 12) {
            this.falseNum = algorithmParameters.getInt("falseNum", 10);
        }
        if (this.significanceMethod == 13) {
            this.falseProp = algorithmParameters.getFloat("falseProp", 0.05f);
        }
        if (this.tTestDesign == 8 || this.tTestDesign == 7) {
            this.groupAssignments = algorithmData.getIntArray("group-assignments");
        }
        if (this.tTestDesign == 11) {
            object2 = algorithmData.getMatrix("pairedAExptsMatrix");
            object = algorithmData.getMatrix("pairedBExptsMatrix");
            this.pairedGroupAExpts = new int[object2.getRowDimension()];
            this.pairedGroupBExpts = new int[object.getRowDimension()];
            for (int i = 0; i < object2.getRowDimension(); ++i) {
                this.pairedGroupAExpts[i] = (int)((FloatMatrix)object2).A[i][0];
                this.pairedGroupBExpts[i] = (int)((FloatMatrix)object).A[i][0];
            }
        }
        if (this.significanceMethod == 12 || this.significanceMethod == 13) {
            if (this.tTestDesign == 7) {
                this.computeBtnSubOrigVals();
            } else if (this.tTestDesign == 8) {
                this.computeOneClassOrigVals();
            } else if (this.tTestDesign == 11) {
                this.computePairedOrigVals();
            }
            this.origPVals = this.getRawPValsFromTDist();
        } else if (this.tTestDesign == 7) {
            this.computeBtnSubOrigVals();
            this.origPVals = !this.isPermut ? this.getRawPValsFromTDist() : this.getTwoClassRawPValsFromPerms();
        } else if (this.tTestDesign == 8) {
            this.computeOneClassOrigVals();
            this.origPVals = !this.isPermut ? this.getRawPValsFromTDist() : this.getOneClassRawPValsFromPerms();
        } else if (this.tTestDesign == 11) {
            this.computePairedOrigVals();
            this.origPVals = !this.isPermut ? this.getRawPValsFromTDist() : this.getPairedRawPValsFromPerms();
        }
        object2 = new Vector();
        object = new Vector();
        Vector<Integer> vector = new Vector<Integer>();
        if (this.significanceMethod == 12 || this.significanceMethod == 13) {
            boolean[] blArray = new boolean[1];
            blArray = this.significanceMethod == 12 ? this.isGeneSigByFDRNum() : this.isGeneSigByFDRPropNew2();
            if (!this.calculateAdjFDRPVals) {
                this.adjustedPVals = new double[this.numGenes];
            }
            for (int i = 0; i < this.numGenes; ++i) {
                if (blArray[i]) {
                    ((Vector)object).add(new Integer(i));
                    continue;
                }
                vector.add(new Integer(i));
            }
        } else {
            this.adjustedPVals = this.getAdjPVals(this.origPVals, this.significanceMethod);
            this.event = new AlgorithmEvent((Object)this, 1, this.numGenes);
            this.fireValueChanged(this.event);
            this.event.setId(2);
            for (int i = 0; i < this.numGenes; ++i) {
                if (this.stop) {
                    throw new AbortException();
                }
                this.event.setIntValue(i);
                this.event.setDescription("Finding significant genes: Current gene = " + (i + 1));
                this.fireValueChanged(this.event);
                float f = (float)this.adjustedPVals[i];
                if (this.significanceMethod == 6) {
                    if (this.isSig[i]) {
                        ((Vector)object).add(new Integer(i));
                        continue;
                    }
                    vector.add(new Integer(i));
                    continue;
                }
                if (f <= this.alpha) {
                    ((Vector)object).add(new Integer(i));
                    continue;
                }
                vector.add(new Integer(i));
            }
        }
        ((Vector)object2).add(object);
        ((Vector)object2).add(vector);
        this.k = ((Vector)object2).size();
        FloatMatrix floatMatrix = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix2 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix3 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix4 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix5 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix6 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix7 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix8 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix9 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix10 = new FloatMatrix(this.numGenes, 1);
        FloatMatrix floatMatrix11 = new FloatMatrix(this.numGenes, 1);
        for (n = 0; n < floatMatrix9.getRowDimension(); ++n) {
            floatMatrix9.A[n][0] = 0.0f;
        }
        for (n = 0; n < ((Vector)object).size(); ++n) {
            int n2 = (Integer)((Vector)object).get(n);
            floatMatrix9.A[n2][0] = 1.0f;
        }
        for (n = 0; n < this.numGenes; ++n) {
            floatMatrix.A[n][0] = (float)this.origPVals[n];
            floatMatrix2.A[n][0] = (float)this.adjustedPVals[n];
            floatMatrix3.A[n][0] = (float)this.tValues[n];
            floatMatrix4.A[n][0] = (float)this.dfValues[n];
            if (this.tTestDesign == 7 || this.tTestDesign == 11) {
                floatMatrix5.A[n][0] = (float)this.groupAMeans[n];
                floatMatrix6.A[n][0] = (float)this.groupBMeans[n];
                floatMatrix7.A[n][0] = (float)this.groupASDs[n];
                floatMatrix8.A[n][0] = (float)this.groupBSDs[n];
                continue;
            }
            if (this.tTestDesign != 8) continue;
            floatMatrix10.A[n][0] = (float)this.oneClassMeans[n];
            floatMatrix11.A[n][0] = (float)this.oneClassSDs[n];
        }
        this.clusters = new Vector[this.k];
        for (n = 0; n < this.k; ++n) {
            this.clusters[n] = (Vector)((Vector)object2).get(n);
        }
        FloatMatrix floatMatrix12 = this.getMeans(this.clusters);
        FloatMatrix floatMatrix13 = this.getVariances(this.clusters, floatMatrix12);
        AlgorithmEvent algorithmEvent = null;
        if (this.hierarchical_tree) {
            algorithmEvent = new AlgorithmEvent((Object)this, 1, this.clusters.length, "Calculate Hierarchical Trees");
            this.fireValueChanged(algorithmEvent);
            algorithmEvent.setIntValue(0);
            algorithmEvent.setId(2);
            this.fireValueChanged(algorithmEvent);
        }
        Cluster cluster = new Cluster();
        NodeList nodeList = cluster.getNodeList();
        for (int i = 0; i < this.clusters.length; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            int[] nArray = this.convert2int(this.clusters[i]);
            Node node = new Node(nArray);
            nodeList.addNode(node);
            if (!this.hierarchical_tree) continue;
            if (this.drawSigTreesOnly) {
                if (i != 0) continue;
                node.setValues(this.calculateHierarchicalTree(nArray, this.method_linkage, this.calculate_genes, this.calculate_experiments));
                algorithmEvent.setIntValue(i + 1);
                this.fireValueChanged(algorithmEvent);
                continue;
            }
            node.setValues(this.calculateHierarchicalTree(nArray, this.method_linkage, this.calculate_genes, this.calculate_experiments));
            algorithmEvent.setIntValue(i + 1);
            this.fireValueChanged(algorithmEvent);
        }
        AlgorithmData algorithmData2 = new AlgorithmData();
        algorithmData2.addCluster("cluster", cluster);
        algorithmData2.addParam("number-of-clusters", String.valueOf(this.clusters.length));
        algorithmData2.addMatrix("clusters_means", floatMatrix12);
        algorithmData2.addMatrix("clusters_variances", floatMatrix13);
        algorithmData2.addMatrix("rawPValues", floatMatrix);
        algorithmData2.addMatrix("adjPValues", floatMatrix2);
        algorithmData2.addMatrix("tValues", floatMatrix3);
        algorithmData2.addMatrix("dfValues", floatMatrix4);
        algorithmData2.addMatrix("meansAMatrix", floatMatrix5);
        algorithmData2.addMatrix("meansBMatrix", floatMatrix6);
        algorithmData2.addMatrix("sdAMatrix", floatMatrix7);
        algorithmData2.addMatrix("sdBMatrix", floatMatrix8);
        algorithmData2.addMatrix("isSigMatrix", floatMatrix9);
        algorithmData2.addMatrix("oneClassMeansMatrix", floatMatrix10);
        algorithmData2.addMatrix("oneClassSDsMatrix", floatMatrix11);
        return algorithmData2;
    }

    private NodeValueList calculateHierarchicalTree(int[] nArray, int n, boolean bl, boolean bl2) throws AlgorithmException {
        AlgorithmData algorithmData;
        NodeValueList nodeValueList = new NodeValueList();
        AlgorithmData algorithmData2 = new AlgorithmData();
        FloatMatrix floatMatrix = this.getSubExperiment(this.expMatrix, nArray);
        algorithmData2.addMatrix("experiment", floatMatrix);
        algorithmData2.addParam("hcl-distance-function", String.valueOf(this.hcl_function));
        algorithmData2.addParam("hcl-distance-absolute", String.valueOf(this.hcl_absolute));
        algorithmData2.addParam("method-linkage", String.valueOf(n));
        HCL hCL = new HCL();
        if (bl) {
            algorithmData2.addParam("calculate-genes", String.valueOf(true));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        if (bl2) {
            algorithmData2.addParam("calculate-genes", String.valueOf(false));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        return nodeValueList;
    }

    private void addNodeValues(NodeValueList nodeValueList, AlgorithmData algorithmData) {
        nodeValueList.addNodeValue(new NodeValue("child-1-array", (Object)algorithmData.getIntArray("child-1-array")));
        nodeValueList.addNodeValue(new NodeValue("child-2-array", (Object)algorithmData.getIntArray("child-2-array")));
        nodeValueList.addNodeValue(new NodeValue("node-order", (Object)algorithmData.getIntArray("node-order")));
        nodeValueList.addNodeValue(new NodeValue("height", (Object)algorithmData.getMatrix("height").getRowPackedCopy()));
    }

    private FloatMatrix getSubExperiment(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = new FloatMatrix(nArray.length, floatMatrix.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix2.A[i] = floatMatrix.A[nArray[i]];
        }
        return floatMatrix2;
    }

    private void validate(AlgorithmData algorithmData) throws AlgorithmException {
        if (algorithmData.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (algorithmData.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (algorithmData.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (algorithmData.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private int[] convert2int(Vector vector) {
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        return nArray;
    }

    private FloatMatrix getMeans(Vector[] vectorArray) {
        FloatMatrix floatMatrix = new FloatMatrix(vectorArray.length, this.numExps);
        for (int i = 0; i < vectorArray.length; ++i) {
            FloatMatrix floatMatrix2 = this.getMean(vectorArray[i]);
            floatMatrix.A[i] = floatMatrix2.A[0];
        }
        return floatMatrix;
    }

    private FloatMatrix getMean(Vector vector) {
        FloatMatrix floatMatrix = new FloatMatrix(1, this.numExps);
        int n = vector.size();
        int n2 = 0;
        for (int i = 0; i < this.numExps; ++i) {
            float f = 0.0f;
            n2 = 0;
            for (int j = 0; j < n; ++j) {
                float f2 = this.expMatrix.get(((Integer)vector.get(j)).intValue(), i);
                if (Float.isNaN(f2)) continue;
                f += f2;
                ++n2;
            }
            floatMatrix.set(0, i, f / (float)n2);
        }
        return floatMatrix;
    }

    private FloatMatrix getVariances(Vector[] vectorArray, FloatMatrix floatMatrix) {
        int n = floatMatrix.getRowDimension();
        int n2 = floatMatrix.getColumnDimension();
        FloatMatrix floatMatrix2 = new FloatMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                floatMatrix2.set(i, j, this.getSampleVariance(vectorArray[i], j, floatMatrix.get(i, j)));
            }
        }
        return floatMatrix2;
    }

    private float getSampleNormalizedSum(Vector vector, int n, float f) {
        int n2 = vector.size();
        float f2 = 0.0f;
        this.validN = 0;
        for (int i = 0; i < n2; ++i) {
            float f3 = this.expMatrix.get(((Integer)vector.get(i)).intValue(), n);
            if (Float.isNaN(f3)) continue;
            f2 = (float)((double)f2 + Math.pow(f3 - f, 2.0));
            ++this.validN;
        }
        return f2;
    }

    private float getSampleVariance(Vector vector, int n, float f) {
        return (float)Math.sqrt(this.getSampleNormalizedSum(vector, n, f) / (float)(this.validN - 1));
    }

    private boolean[] isGeneSigByFDRPropOld() throws AlgorithmException {
        double[] dArray = new double[this.origPVals.length];
        for (int i = 0; i < this.origPVals.length; ++i) {
            dArray[i] = Double.isNaN(this.origPVals[i]) ? Double.POSITIVE_INFINITY : this.origPVals[i];
        }
        QSort qSort = new QSort(dArray, 1);
        double[] dArray2 = qSort.getSortedDouble();
        int[] nArray = qSort.getOrigIndx();
        boolean[] blArray = new boolean[this.numGenes];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = false;
        }
        double d = this.getYConservative(this.alpha, 0);
        if (dArray2[0] >= d) {
            return blArray;
        }
        blArray[nArray[0]] = true;
        if (this.useFastFDRApprox) {
            for (int i = 1; i < dArray2.length; ++i) {
                int n = (int)Math.floor((float)(i + 1) * this.falseProp);
                int n2 = (int)Math.floor((float)i * this.falseProp);
                double d2 = this.getYConservative(this.alpha, n);
                System.out.println("rGamma = " + n + ", (r - 1)Gamma = " + n2 + ", yKRGamma = " + d2);
                if (n <= n2 && !(dArray2[i] < d2)) break;
                blArray[nArray[i]] = true;
            }
        }
        return blArray;
    }

    private boolean[] isGeneSigByFDRPropNew2() throws AlgorithmException {
        double[] dArray = new double[this.origPVals.length];
        for (int i = 0; i < this.origPVals.length; ++i) {
            dArray[i] = Double.isNaN(this.origPVals[i]) ? Double.POSITIVE_INFINITY : this.origPVals[i];
        }
        QSort qSort = new QSort(dArray, 1);
        double[] dArray2 = qSort.getSortedDouble();
        int[] nArray = qSort.getOrigIndx();
        boolean[] blArray = new boolean[this.numGenes];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = false;
        }
        double[] dArray3 = this.getYKArray();
        if (dArray2[0] >= dArray3[0]) {
            return blArray;
        }
        blArray[nArray[0]] = true;
        if (this.useFastFDRApprox) {
            for (int i = 1; i < dArray2.length; ++i) {
                int n = (int)Math.floor((float)(i + 1) * this.falseProp);
                int n2 = (int)Math.floor((float)i * this.falseProp);
                double d = dArray3[n];
                if (n <= n2 && !(dArray2[i] < d)) break;
                blArray[nArray[i]] = true;
            }
        }
        return blArray;
    }

    private boolean[] isGeneSigByFDRPropNew() throws AlgorithmException {
        double[] dArray = new double[this.origPVals.length];
        for (int i = 0; i < this.origPVals.length; ++i) {
            dArray[i] = Double.isNaN(this.origPVals[i]) ? Double.POSITIVE_INFINITY : this.origPVals[i];
        }
        QSort qSort = new QSort(dArray, 1);
        double[] dArray2 = qSort.getSortedDouble();
        int[] nArray = qSort.getOrigIndx();
        boolean[] blArray = new boolean[this.numGenes];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = false;
        }
        FloatMatrix floatMatrix = new FloatMatrix(this.expMatrix.getRowDimension(), this.expMatrix.getColumnDimension());
        for (int i = 0; i < this.expMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < this.expMatrix.getColumnDimension(); ++j) {
                floatMatrix.A[i][j] = this.expMatrix.A[nArray[i]][j];
            }
        }
        double d = this.getYConservative(this.alpha, 0);
        if (dArray2[0] >= d) {
            return blArray;
        }
        blArray[nArray[0]] = true;
        if (this.useFastFDRApprox) {
            int n = 1;
            int n2 = 100;
            if (n2 > this.numGenes - 1) {
                n2 = this.numGenes - 1;
            }
            int n3 = (int)Math.floor(2.0f * this.falseProp);
            boolean bl = true;
            block4: while (bl) {
                System.out.println("Entering while, sig = " + bl);
                if (n > this.numGenes - 1) break;
                if (n2 > this.numGenes - 1) {
                    n2 = this.numGenes - 1;
                    bl = false;
                }
                System.out.println("currMinGene = " + n + ", currMaxGene = " + n2);
                FloatMatrix floatMatrix2 = floatMatrix.getMatrix(0, n2, 0, floatMatrix.getColumnDimension() - 1);
                double[][] dArray3 = this.getSortedPermPValMatrix(floatMatrix2);
                double d2 = this.getYKFromPMatrix(dArray3, n3);
                for (int i = n; i <= n2; n2 += 100, ++i) {
                    int n4 = (int)Math.floor((float)(i + 1) * this.falseProp);
                    int n5 = (int)Math.floor((float)i * this.falseProp);
                    if (n4 > n2) continue block4;
                    System.out.println("i = " + i + ", rGamma = " + n4 + ",  rMinusOneGamma = " + n5 + ", rGammaPrev = " + n3);
                    if (n4 != n3) {
                        d2 = this.getYKFromPMatrix(dArray3, n4);
                        n3 = n4;
                    }
                    System.out.println("yKRGamma = " + d2);
                    if (n4 <= n5 && !(dArray2[i] < d2)) {
                        bl = false;
                        System.out.println("false");
                        continue block4;
                    }
                    blArray[nArray[i]] = true;
                    System.out.println("true");
                    n = n2 + 1;
                }
            }
        }
        return blArray;
    }

    private double getYKFromPMatrix(double[][] dArray, int n) {
        double[] dArray2 = new double[dArray[n].length];
        for (int i = 0; i < dArray[n].length; ++i) {
            dArray2[i] = dArray[n][i];
        }
        QSort qSort = new QSort(dArray2, 1);
        double[] dArray3 = qSort.getSortedDouble();
        int n2 = (int)Math.floor((float)dArray3.length * this.alpha) - 1;
        if (n2 < 0) {
            n2 = 0;
        }
        return dArray3[n2];
    }

    private double[][] getSortedPermPValMatrix(FloatMatrix floatMatrix) throws AlgorithmException {
        AlgorithmEvent algorithmEvent = new AlgorithmEvent((Object)this, 1, this.numCombs);
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        double[][] dArray = new double[floatMatrix.getRowDimension()][this.numCombs];
        if (this.tTestDesign == 7 && !this.useAllCombs) {
            for (int i = 0; i < this.numCombs; ++i) {
                if (this.stop) {
                    throw new AbortException();
                }
                algorithmEvent.setIntValue(i);
                algorithmEvent.setDescription("Permuting matrix: Current permutation = " + (i + 1));
                this.fireValueChanged(algorithmEvent);
                int[] nArray = new int[1];
                Vector<Integer> vector = new Vector<Integer>();
                for (int j = 0; j < this.groupAssignments.length; ++j) {
                    if (this.groupAssignments[j] == 3) continue;
                    vector.add(new Integer(j));
                }
                int[] nArray2 = new int[vector.size()];
                for (int j = 0; j < nArray2.length; ++j) {
                    nArray2[j] = (Integer)vector.get(j);
                }
                nArray = this.getPermutedValues(this.numExps, nArray2);
                FloatMatrix floatMatrix2 = this.getPermutedMatrix(this.expMatrix, nArray);
                double[] dArray2 = this.getTwoClassUnpairedTValues(floatMatrix2);
                int[] nArray3 = this.getTwoClassDfs(floatMatrix2);
                double[] dArray3 = this.getParametricPVals(dArray2, nArray3);
                for (int j = 0; j < dArray3.length; ++j) {
                    if (!Double.isNaN(dArray3[j])) continue;
                    dArray3[j] = Double.POSITIVE_INFINITY;
                }
                QSort qSort = new QSort(dArray3, 1);
                double[] dArray4 = qSort.getSortedDouble();
                for (int j = 0; j < dArray.length; ++j) {
                    dArray[j][i] = dArray4[i];
                }
            }
        }
        return dArray;
    }

    private boolean[] isGeneSigByFDRNum() throws AlgorithmException {
        int n;
        double[] dArray = new double[this.origPVals.length];
        for (int i = 0; i < this.origPVals.length; ++i) {
            dArray[i] = Double.isNaN(this.origPVals[i]) ? Double.POSITIVE_INFINITY : this.origPVals[i];
        }
        QSort qSort = new QSort(dArray, 1);
        double[] dArray2 = qSort.getSortedDouble();
        int[] nArray = qSort.getOrigIndx();
        boolean[] blArray = new boolean[this.numGenes];
        for (n = 0; n < blArray.length; ++n) {
            blArray[n] = false;
        }
        for (n = 0; n < this.falseNum; ++n) {
            blArray[nArray[n]] = true;
        }
        if (this.useFastFDRApprox) {
            double d = this.getYConservative(this.alpha, this.falseNum);
            for (int i = this.falseNum; i < dArray2.length && dArray2[i] < d; ++i) {
                blArray[nArray[i]] = true;
            }
        } else {
            for (n = this.falseNum; n < this.origPVals.length; ++n) {
            }
        }
        return blArray;
    }

    private double[] getYKArray() throws AlgorithmException {
        double[] dArray;
        Object object;
        Object object2;
        Object object3;
        Object[] objectArray;
        AlgorithmEvent algorithmEvent = new AlgorithmEvent((Object)this, 1, this.numCombs);
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        int n = (int)Math.floor((float)this.numGenes * this.falseProp);
        double[][] dArray2 = new double[n + 1][this.numCombs];
        if (this.tTestDesign == 8) {
            if (!this.useAllCombs) {
                int n2;
                boolean[] blArray = new boolean[1];
                Random random = new Random();
                objectArray = new long[this.numCombs];
                for (n2 = 0; n2 < this.numCombs; ++n2) {
                    objectArray[n2] = random.nextLong();
                }
                for (n2 = 0; n2 < this.numCombs; ++n2) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    algorithmEvent.setIntValue(n2);
                    algorithmEvent.setDescription("Permuting matrix: Current permutation = " + (n2 + 1));
                    this.fireValueChanged(algorithmEvent);
                    object3 = new int[1];
                    Vector<Integer> vector = new Vector<Integer>();
                    for (int i = 0; i < this.groupAssignments.length; ++i) {
                        if (this.groupAssignments[i] != 1) continue;
                        vector.add(new Integer(i));
                    }
                    int[] nArray = new int[vector.size()];
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = (Integer)vector.get(i);
                    }
                    blArray = this.getOneClassChangeSignArray(objectArray[n2], nArray);
                    object2 = this.getOneClassPermMatrix(this.expMatrix, blArray);
                    double[] dArray3 = this.getOneClassTValues((FloatMatrix)object2);
                    object = this.getOneClassDfs((FloatMatrix)object2);
                    double[] dArray4 = this.getParametricPVals(dArray3, (int[])object);
                    for (int i = 0; i < dArray4.length; ++i) {
                        if (!Double.isNaN(dArray4[i])) continue;
                        dArray4[i] = Double.POSITIVE_INFINITY;
                    }
                    QSort qSort = new QSort(dArray4, 1);
                    dArray = qSort.getSortedDouble();
                    for (int i = 0; i < dArray2.length; ++i) {
                        dArray2[i][n2] = dArray[i];
                    }
                }
            } else {
                for (int i = 0; i < this.numCombs; ++i) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    algorithmEvent.setIntValue(i);
                    algorithmEvent.setDescription("Permuting matrix: Current permutation = " + (i + 1));
                    this.fireValueChanged(algorithmEvent);
                    Vector<Integer> vector = new Vector<Integer>();
                    for (int j = 0; j < this.groupAssignments.length; ++j) {
                        if (this.groupAssignments[j] != 1) continue;
                        vector.add(new Integer(j));
                    }
                    int[] nArray = new int[vector.size()];
                    for (int j = 0; j < nArray.length; ++j) {
                        nArray[j] = (Integer)vector.get(j);
                    }
                    boolean[] blArray = this.getOneClassChangeSignArrayAllUniquePerms(i, nArray);
                    object3 = this.getOneClassPermMatrix(this.expMatrix, blArray);
                    double[] dArray5 = this.getOneClassTValues((FloatMatrix)object3);
                    int[] nArray2 = this.getOneClassDfs((FloatMatrix)object3);
                    object2 = this.getParametricPVals(dArray5, nArray2);
                    for (int j = 0; j < ((int[])object2).length; ++j) {
                        if (!Double.isNaN(object2[j])) continue;
                        object2[j] = (int)Double.POSITIVE_INFINITY;
                    }
                    QSort qSort = new QSort((double[])object2, 1);
                    object = qSort.getSortedDouble();
                    for (int j = 0; j < dArray2.length; ++j) {
                        dArray2[j][i] = (double)object[j];
                    }
                }
            }
        } else if (this.tTestDesign == 7) {
            if (!this.useAllCombs) {
                for (int i = 0; i < this.numCombs; ++i) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    algorithmEvent.setIntValue(i);
                    algorithmEvent.setDescription("Permuting matrix: Current permutation = " + (i + 1));
                    this.fireValueChanged(algorithmEvent);
                    int[] nArray = new int[1];
                    Vector<Integer> vector = new Vector<Integer>();
                    for (int j = 0; j < this.groupAssignments.length; ++j) {
                        if (this.groupAssignments[j] == 3) continue;
                        vector.add(new Integer(j));
                    }
                    int[] nArray3 = new int[vector.size()];
                    for (int j = 0; j < nArray3.length; ++j) {
                        nArray3[j] = (Integer)vector.get(j);
                    }
                    nArray = this.getPermutedValues(this.numExps, nArray3);
                    object3 = this.getPermutedMatrix(this.expMatrix, nArray);
                    double[] dArray6 = this.getTwoClassUnpairedTValues((FloatMatrix)object3);
                    int[] nArray4 = this.getTwoClassDfs((FloatMatrix)object3);
                    object2 = this.getParametricPVals(dArray6, nArray4);
                    for (int j = 0; j < ((int[])object2).length; ++j) {
                        if (!Double.isNaN(object2[j])) continue;
                        object2[j] = (int)Double.POSITIVE_INFINITY;
                    }
                    QSort qSort = new QSort((double[])object2, 1);
                    object = qSort.getSortedDouble();
                    for (int j = 0; j < dArray2.length; ++j) {
                        dArray2[j][i] = (double)object[j];
                    }
                }
            } else {
                int n3;
                int[] nArray = new int[this.numExps];
                for (int i = 0; i < this.numExps; ++i) {
                    nArray[i] = i;
                }
                Vector<Integer> vector = new Vector<Integer>();
                int n4 = 0;
                for (int i = 0; i < this.groupAssignments.length; ++i) {
                    if (this.groupAssignments[i] != 3) {
                        vector.add(new Integer(i));
                    }
                    if (this.groupAssignments[i] != 1) continue;
                    ++n4;
                }
                int[] nArray5 = new int[vector.size()];
                for (int i = 0; i < nArray5.length; ++i) {
                    nArray5[i] = (Integer)vector.get(i);
                }
                object3 = new int[n4];
                for (n3 = 0; n3 < ((int[])object3).length; ++n3) {
                    object3[n3] = -1;
                }
                n3 = nArray5.length - n4;
                int n5 = 0;
                while (Combinations.enumerateCombinations((int)nArray5.length, (int)n4, (int[])object3)) {
                    int n6;
                    if (this.stop) {
                        throw new AbortException();
                    }
                    algorithmEvent.setIntValue(n5);
                    algorithmEvent.setDescription("Permuting matrix: Current permutation = " + (n5 + 1));
                    this.fireValueChanged(algorithmEvent);
                    object2 = new int[n3];
                    int n7 = 0;
                    for (n6 = 0; n6 < nArray5.length; ++n6) {
                        if (this.belongsInArray(n6, (int[])object3)) continue;
                        object2[n7] = n6;
                        ++n7;
                    }
                    for (n6 = 0; n6 < ((int[])object3).length; ++n6) {
                        nArray[nArray5[n6]] = nArray5[object3[n6]];
                    }
                    for (n6 = 0; n6 < ((int[])object2).length; ++n6) {
                        nArray[nArray5[((int[])object3).length + n6]] = nArray5[object2[n6]];
                    }
                    object = this.getPermutedMatrix(this.expMatrix, nArray);
                    double[] dArray7 = this.getTwoClassUnpairedTValues((FloatMatrix)object);
                    int[] nArray6 = this.getTwoClassDfs((FloatMatrix)object);
                    dArray = this.getParametricPVals(dArray7, nArray6);
                    for (int i = 0; i < dArray.length; ++i) {
                        if (!Double.isNaN(dArray[i])) continue;
                        dArray[i] = Double.POSITIVE_INFINITY;
                    }
                    QSort qSort = new QSort(dArray, 1);
                    double[] dArray8 = qSort.getSortedDouble();
                    for (int i = 0; i < dArray2.length; ++i) {
                        dArray2[i][n5] = dArray8[i];
                    }
                    ++n5;
                }
            }
        } else if (this.tTestDesign == 11) {
            if (!this.useAllCombs) {
                Random random = new Random();
                for (int i = 0; i < this.numCombs; ++i) {
                    algorithmEvent.setIntValue(i);
                    algorithmEvent.setDescription("Calculating raw p values: Current permutation = " + (i + 1));
                    this.fireValueChanged(algorithmEvent);
                    long l = random.nextLong();
                    if (this.stop) {
                        throw new AbortException();
                    }
                    object3 = this.permuteWithinPairs(l);
                    FloatMatrix floatMatrix = this.getPermutedMatrix(this.expMatrix, (int[])object3);
                    double[] dArray9 = this.getPairedTValues(floatMatrix);
                    object2 = this.getPairedDfs(floatMatrix);
                    double[] dArray10 = this.getParametricPVals(dArray9, (int[])object2);
                    for (int j = 0; j < dArray10.length; ++j) {
                        if (!Double.isNaN(dArray10[j])) continue;
                        dArray10[j] = Double.POSITIVE_INFINITY;
                    }
                    object = new QSort(dArray10, 1);
                    double[] dArray11 = object.getSortedDouble();
                    for (int j = 0; j < dArray2.length; ++j) {
                        dArray2[j][i] = dArray11[j];
                    }
                }
            } else {
                for (int i = 0; i < this.numCombs; ++i) {
                    algorithmEvent.setIntValue(i);
                    algorithmEvent.setDescription("Calculating raw p values: Current permutation = " + (i + 1));
                    this.fireValueChanged(algorithmEvent);
                    int[] nArray = this.permuteWithinPairsAllPerms(i);
                    FloatMatrix floatMatrix = this.getPermutedMatrix(this.expMatrix, nArray);
                    double[] dArray12 = this.getPairedTValues(floatMatrix);
                    object3 = this.getPairedDfs(floatMatrix);
                    double[] dArray13 = this.getParametricPVals(dArray12, (int[])object3);
                    for (int j = 0; j < dArray13.length; ++j) {
                        if (!Double.isNaN(dArray13[j])) continue;
                        dArray13[j] = Double.POSITIVE_INFINITY;
                    }
                    QSort qSort = new QSort(dArray13, 1);
                    object2 = qSort.getSortedDouble();
                    for (int j = 0; j < dArray2.length; ++j) {
                        dArray2[j][i] = object2[j];
                    }
                }
            }
        }
        double[] dArray14 = new double[dArray2.length];
        for (int i = 0; i < dArray2.length; ++i) {
            int n8;
            objectArray = new double[dArray2[i].length];
            for (n8 = 0; n8 < objectArray.length; ++n8) {
                objectArray[n8] = (long)dArray2[i][n8];
            }
            for (n8 = 0; n8 < objectArray.length; ++n8) {
                if (!Double.isNaN(objectArray[n8])) continue;
                objectArray[n8] = (long)Double.POSITIVE_INFINITY;
            }
            QSort qSort = new QSort((double[])objectArray, 1);
            object3 = qSort.getSortedDouble();
            int n9 = (int)Math.floor((float)((int[])object3).length * this.alpha) - 1;
            if (n9 < 0) {
                n9 = 0;
            }
            dArray14[i] = object3[n9];
        }
        return dArray14;
    }

    private double getYConservative(double d, int n) throws AlgorithmException {
        double[] dArray;
        Object object;
        double[] dArray2;
        Object object2;
        Object object3;
        Object object4;
        Object[] objectArray;
        AlgorithmEvent algorithmEvent = new AlgorithmEvent((Object)this, 1, this.numCombs);
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        Vector<Double> vector = new Vector<Double>();
        if (this.tTestDesign == 8) {
            if (!this.useAllCombs) {
                int n2;
                boolean[] blArray = new boolean[1];
                Random random = new Random();
                objectArray = new long[this.numCombs];
                for (n2 = 0; n2 < this.numCombs; ++n2) {
                    objectArray[n2] = random.nextLong();
                }
                for (n2 = 0; n2 < this.numCombs; ++n2) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    algorithmEvent.setIntValue(n2);
                    algorithmEvent.setDescription("Permuting matrix: Current permutation = " + (n2 + 1));
                    this.fireValueChanged(algorithmEvent);
                    object4 = new int[1];
                    Vector<Integer> vector2 = new Vector<Integer>();
                    for (int i = 0; i < this.groupAssignments.length; ++i) {
                        if (this.groupAssignments[i] != 1) continue;
                        vector2.add(new Integer(i));
                    }
                    int[] nArray = new int[vector2.size()];
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = (Integer)vector2.get(i);
                    }
                    blArray = this.getOneClassChangeSignArray(objectArray[n2], nArray);
                    object3 = this.getOneClassPermMatrix(this.expMatrix, blArray);
                    double[] dArray3 = this.getOneClassTValues((FloatMatrix)object3);
                    object2 = this.getOneClassDfs((FloatMatrix)object3);
                    dArray2 = this.getParametricPVals(dArray3, (int[])object2);
                    for (int i = 0; i < dArray2.length; ++i) {
                        if (!Double.isNaN(dArray2[i])) continue;
                        dArray2[i] = Double.POSITIVE_INFINITY;
                    }
                    object = new QSort(dArray2, 1);
                    dArray = object.getSortedDouble();
                    vector.add(new Double(dArray[n]));
                }
            } else {
                for (int i = 0; i < this.numCombs; ++i) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    algorithmEvent.setIntValue(i);
                    algorithmEvent.setDescription("Permuting matrix: Current permutation = " + (i + 1));
                    this.fireValueChanged(algorithmEvent);
                    Vector<Integer> vector3 = new Vector<Integer>();
                    for (int j = 0; j < this.groupAssignments.length; ++j) {
                        if (this.groupAssignments[j] != 1) continue;
                        vector3.add(new Integer(j));
                    }
                    int[] nArray = new int[vector3.size()];
                    for (int j = 0; j < nArray.length; ++j) {
                        nArray[j] = (Integer)vector3.get(j);
                    }
                    boolean[] blArray = this.getOneClassChangeSignArrayAllUniquePerms(i, nArray);
                    object4 = this.getOneClassPermMatrix(this.expMatrix, blArray);
                    double[] dArray4 = this.getOneClassTValues((FloatMatrix)object4);
                    int[] nArray2 = this.getOneClassDfs((FloatMatrix)object4);
                    object3 = this.getParametricPVals(dArray4, nArray2);
                    for (int j = 0; j < ((int[])object3).length; ++j) {
                        if (!Double.isNaN(object3[j])) continue;
                        object3[j] = (int)Double.POSITIVE_INFINITY;
                    }
                    QSort qSort = new QSort((double[])object3, 1);
                    object2 = qSort.getSortedDouble();
                    vector.add(new Double((double)object2[n]));
                }
            }
        } else if (this.tTestDesign == 7) {
            if (!this.useAllCombs) {
                for (int i = 0; i < this.numCombs; ++i) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    algorithmEvent.setIntValue(i);
                    algorithmEvent.setDescription("Permuting matrix: Current permutation = " + (i + 1));
                    this.fireValueChanged(algorithmEvent);
                    int[] nArray = new int[1];
                    Vector<Integer> vector4 = new Vector<Integer>();
                    for (int j = 0; j < this.groupAssignments.length; ++j) {
                        if (this.groupAssignments[j] == 3) continue;
                        vector4.add(new Integer(j));
                    }
                    int[] nArray3 = new int[vector4.size()];
                    for (int j = 0; j < nArray3.length; ++j) {
                        nArray3[j] = (Integer)vector4.get(j);
                    }
                    nArray = this.getPermutedValues(this.numExps, nArray3);
                    object4 = this.getPermutedMatrix(this.expMatrix, nArray);
                    double[] dArray5 = this.getTwoClassUnpairedTValues((FloatMatrix)object4);
                    int[] nArray4 = this.getTwoClassDfs((FloatMatrix)object4);
                    object3 = this.getParametricPVals(dArray5, nArray4);
                    for (int j = 0; j < ((int[])object3).length; ++j) {
                        if (!Double.isNaN(object3[j])) continue;
                        object3[j] = (int)Double.POSITIVE_INFINITY;
                    }
                    QSort qSort = new QSort((double[])object3, 1);
                    object2 = qSort.getSortedDouble();
                    vector.add(new Double((double)object2[n]));
                }
            } else {
                int n3;
                int[] nArray = new int[this.numExps];
                for (int i = 0; i < this.numExps; ++i) {
                    nArray[i] = i;
                }
                Vector<Integer> vector5 = new Vector<Integer>();
                int n4 = 0;
                for (int i = 0; i < this.groupAssignments.length; ++i) {
                    if (this.groupAssignments[i] != 3) {
                        vector5.add(new Integer(i));
                    }
                    if (this.groupAssignments[i] != 1) continue;
                    ++n4;
                }
                int[] nArray5 = new int[vector5.size()];
                for (int i = 0; i < nArray5.length; ++i) {
                    nArray5[i] = (Integer)vector5.get(i);
                }
                object4 = new int[n4];
                for (n3 = 0; n3 < ((int[])object4).length; ++n3) {
                    object4[n3] = -1;
                }
                n3 = nArray5.length - n4;
                int n5 = 0;
                while (Combinations.enumerateCombinations((int)nArray5.length, (int)n4, (int[])object4)) {
                    int n6;
                    if (this.stop) {
                        throw new AbortException();
                    }
                    algorithmEvent.setIntValue(n5);
                    algorithmEvent.setDescription("Permuting matrix: Current permutation = " + (n5 + 1));
                    this.fireValueChanged(algorithmEvent);
                    object3 = new int[n3];
                    int n7 = 0;
                    for (n6 = 0; n6 < nArray5.length; ++n6) {
                        if (this.belongsInArray(n6, (int[])object4)) continue;
                        object3[n7] = n6;
                        ++n7;
                    }
                    for (n6 = 0; n6 < ((int[])object4).length; ++n6) {
                        nArray[nArray5[n6]] = nArray5[object4[n6]];
                    }
                    for (n6 = 0; n6 < ((int[])object3).length; ++n6) {
                        nArray[nArray5[((int[])object4).length + n6]] = nArray5[object3[n6]];
                    }
                    object2 = this.getPermutedMatrix(this.expMatrix, nArray);
                    dArray2 = this.getTwoClassUnpairedTValues((FloatMatrix)object2);
                    object = this.getTwoClassDfs((FloatMatrix)object2);
                    dArray = this.getParametricPVals(dArray2, (int[])object);
                    for (int i = 0; i < dArray.length; ++i) {
                        if (!Double.isNaN(dArray[i])) continue;
                        dArray[i] = Double.POSITIVE_INFINITY;
                    }
                    QSort qSort = new QSort(dArray, 1);
                    double[] dArray6 = qSort.getSortedDouble();
                    vector.add(new Double(dArray6[n]));
                    ++n5;
                }
            }
        } else if (this.tTestDesign == 11) {
            if (!this.useAllCombs) {
                Random random = new Random();
                for (int i = 0; i < this.numCombs; ++i) {
                    algorithmEvent.setIntValue(i);
                    algorithmEvent.setDescription("Calculating raw p values: Current permutation = " + (i + 1));
                    this.fireValueChanged(algorithmEvent);
                    long l = random.nextLong();
                    if (this.stop) {
                        throw new AbortException();
                    }
                    object4 = this.permuteWithinPairs(l);
                    FloatMatrix floatMatrix = this.getPermutedMatrix(this.expMatrix, (int[])object4);
                    double[] dArray7 = this.getPairedTValues(floatMatrix);
                    object3 = this.getPairedDfs(floatMatrix);
                    double[] dArray8 = this.getParametricPVals(dArray7, (int[])object3);
                    for (int j = 0; j < dArray8.length; ++j) {
                        if (!Double.isNaN(dArray8[j])) continue;
                        dArray8[j] = Double.POSITIVE_INFINITY;
                    }
                    object2 = new QSort(dArray8, 1);
                    dArray2 = object2.getSortedDouble();
                    vector.add(new Double(dArray2[n]));
                }
            } else {
                for (int i = 0; i < this.numCombs; ++i) {
                    algorithmEvent.setIntValue(i);
                    algorithmEvent.setDescription("Calculating raw p values: Current permutation = " + (i + 1));
                    this.fireValueChanged(algorithmEvent);
                    int[] nArray = this.permuteWithinPairsAllPerms(i);
                    FloatMatrix floatMatrix = this.getPermutedMatrix(this.expMatrix, nArray);
                    double[] dArray9 = this.getPairedTValues(floatMatrix);
                    object4 = this.getPairedDfs(floatMatrix);
                    double[] dArray10 = this.getParametricPVals(dArray9, (int[])object4);
                    for (int j = 0; j < dArray10.length; ++j) {
                        if (!Double.isNaN(dArray10[j])) continue;
                        dArray10[j] = Double.POSITIVE_INFINITY;
                    }
                    QSort qSort = new QSort(dArray10, 1);
                    object3 = qSort.getSortedDouble();
                    vector.add(new Double(object3[n]));
                }
            }
        }
        double[] dArray11 = new double[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            dArray11[i] = (Double)vector.get(i);
        }
        QSort qSort = new QSort(dArray11, 1);
        objectArray = qSort.getSortedDouble();
        int n8 = (int)Math.floor((double)objectArray.length * d) - 1;
        if (n8 < 0) {
            n8 = 0;
        }
        return objectArray[n8];
    }

    private double getMinY(double d, int n, int n2) {
        return 0.0;
    }

    private double[] getOneClassRawPValsFromPerms() throws AlgorithmException {
        int n;
        this.event = new AlgorithmEvent((Object)this, 1, this.numCombs);
        this.fireValueChanged(this.event);
        this.event.setId(2);
        double[] dArray = new double[this.numGenes];
        for (n = 0; n < this.numGenes; ++n) {
            dArray[n] = Double.isNaN(this.tValues[n]) ? Double.NaN : 0.0;
        }
        if (!this.useAllCombs) {
            int n2;
            boolean[] blArray = new boolean[1];
            Random random = new Random();
            long[] lArray = new long[this.numCombs];
            for (n2 = 0; n2 < this.numCombs; ++n2) {
                lArray[n2] = random.nextLong();
            }
            for (n2 = 0; n2 < this.numCombs; ++n2) {
                if (this.stop) {
                    throw new AbortException();
                }
                this.event.setIntValue(n2);
                this.event.setDescription("Permuting matrix: Current permutation = " + (n2 + 1));
                this.fireValueChanged(this.event);
                int[] nArray = new int[1];
                Vector<Integer> vector = new Vector<Integer>();
                for (int i = 0; i < this.groupAssignments.length; ++i) {
                    if (this.groupAssignments[i] != 1) continue;
                    vector.add(new Integer(i));
                }
                int[] nArray2 = new int[vector.size()];
                for (int i = 0; i < nArray2.length; ++i) {
                    nArray2[i] = (Integer)vector.get(i);
                }
                blArray = this.getOneClassChangeSignArray(lArray[n2], nArray2);
                FloatMatrix floatMatrix = this.getOneClassPermMatrix(this.expMatrix, blArray);
                double[] dArray2 = this.getOneClassTValues(floatMatrix);
                for (int i = 0; i < this.numGenes; ++i) {
                    if (!(this.tValues[i] < dArray2[i])) continue;
                    dArray[i] = dArray[i] + 1.0;
                }
            }
            for (n2 = 0; n2 < this.numGenes; ++n2) {
                dArray[n2] = dArray[n2] / (double)this.numCombs;
            }
        } else {
            for (n = 0; n < this.numCombs; ++n) {
                if (this.stop) {
                    throw new AbortException();
                }
                this.event.setIntValue(n);
                this.event.setDescription("Permuting matrix: Current permutation = " + (n + 1));
                this.fireValueChanged(this.event);
                Vector<Integer> vector = new Vector<Integer>();
                for (int i = 0; i < this.groupAssignments.length; ++i) {
                    if (this.groupAssignments[i] != 1) continue;
                    vector.add(new Integer(i));
                }
                int[] nArray = new int[vector.size()];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = (Integer)vector.get(i);
                }
                boolean[] blArray = this.getOneClassChangeSignArrayAllUniquePerms(n, nArray);
                FloatMatrix floatMatrix = this.getOneClassPermMatrix(this.expMatrix, blArray);
                double[] dArray3 = this.getOneClassTValues(floatMatrix);
                for (int i = 0; i < this.numGenes; ++i) {
                    if (!(this.tValues[i] < dArray3[i])) continue;
                    dArray[i] = dArray[i] + 1.0;
                }
            }
            for (n = 0; n < this.numGenes; ++n) {
                dArray[n] = dArray[n] / (double)this.numCombs;
            }
        }
        return dArray;
    }

    private float getAllCombsOneClassProb(int n) {
        int n2 = this.getNumValidOneClassExpts();
        int n3 = (int)Math.pow(2.0, n2);
        float[] fArray = this.expMatrix.A[n];
        float[] fArray2 = this.getOneClassGeneValues(n);
        float f = (float)Math.abs(this.getOneClassTValue(fArray2));
        if (Float.isNaN(f)) {
            return Float.NaN;
        }
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            boolean[] blArray = this.getOneClassPermutArray(i);
            float[] fArray3 = new float[fArray.length];
            for (int j = 0; j < blArray.length; ++j) {
                fArray3[j] = blArray[j] ? fArray[j] - 2.0f * (fArray[j] - this.oneClassMean) : fArray[j];
            }
            float[] fArray4 = new float[n2];
            int n5 = 0;
            for (int j = 0; j < this.groupAssignments.length; ++j) {
                if (this.groupAssignments[j] != 1) continue;
                fArray4[n5] = fArray3[j];
                ++n5;
            }
            double d = Math.abs(this.getOneClassTValue(fArray4));
            if (!(d > (double)f)) continue;
            ++n4;
        }
        double d = (double)n4 / (double)n3;
        return (float)d;
    }

    private boolean[] getOneClassChangeSignArray(long l, int[] nArray) {
        boolean[] blArray = new boolean[this.numExps];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = false;
        }
        Random random = new Random(l);
        for (int i = 0; i < nArray.length; ++i) {
            blArray[nArray[i]] = random.nextBoolean();
        }
        return blArray;
    }

    private FloatMatrix getOneClassPermMatrix(FloatMatrix floatMatrix, boolean[] blArray) {
        FloatMatrix floatMatrix2 = new FloatMatrix(floatMatrix.getRowDimension(), floatMatrix.getColumnDimension());
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < floatMatrix.getColumnDimension(); ++j) {
                floatMatrix2.A[i][j] = blArray[j] ? floatMatrix.A[i][j] - 2.0f * (floatMatrix.A[i][j] - this.oneClassMean) : floatMatrix.A[i][j];
            }
        }
        return floatMatrix2;
    }

    private boolean[] getOneClassChangeSignArrayAllUniquePerms(int n, int[] nArray) {
        int n2;
        boolean[] blArray = new boolean[this.numExps];
        for (n2 = 0; n2 < blArray.length; ++n2) {
            blArray[n2] = false;
        }
        n2 = nArray.length;
        String string = Integer.toBinaryString(n);
        char[] cArray = string.toCharArray();
        if (cArray.length < n2) {
            int n3;
            Vector<Character> vector = new Vector<Character>();
            for (n3 = 0; n3 < n2 - cArray.length; ++n3) {
                vector.add(new Character('0'));
            }
            for (n3 = 0; n3 < cArray.length; ++n3) {
                vector.add(new Character(cArray[n3]));
            }
            cArray = new char[vector.size()];
            for (n3 = 0; n3 < cArray.length; ++n3) {
                cArray[n3] = ((Character)vector.get(n3)).charValue();
            }
        }
        for (int i = 0; i < nArray.length; ++i) {
            blArray[nArray[i]] = cArray[i] == '1';
        }
        return blArray;
    }

    boolean[] getOneClassPermutArray(int n) {
        int n2;
        int n3;
        boolean[] blArray = new boolean[this.numExps];
        for (n3 = 0; n3 < blArray.length; ++n3) {
            blArray[n3] = false;
        }
        n3 = this.getNumValidOneClassExpts();
        String string = Integer.toBinaryString(n);
        char[] cArray = string.toCharArray();
        if (cArray.length < n3) {
            Vector<Character> vector = new Vector<Character>();
            for (n2 = 0; n2 < n3 - cArray.length; ++n2) {
                vector.add(new Character('0'));
            }
            for (n2 = 0; n2 < cArray.length; ++n2) {
                vector.add(new Character(cArray[n2]));
            }
            cArray = new char[vector.size()];
            for (n2 = 0; n2 < cArray.length; ++n2) {
                cArray[n2] = ((Character)vector.get(n2)).charValue();
            }
        }
        int n4 = 0;
        for (n2 = 0; n2 < blArray.length; ++n2) {
            if (this.groupAssignments[n2] != 1) continue;
            blArray[n2] = cArray[n4] == '1';
            ++n4;
        }
        return blArray;
    }

    public int getNumValidOneClassExpts() {
        int n = 0;
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] != 1) continue;
            ++n;
        }
        return n;
    }

    private float[] getOneClassGeneValues(int n) {
        Vector<Float> vector = new Vector<Float>();
        for (int i = 0; i < this.numExps; ++i) {
            if (this.groupAssignments[i] != 1) continue;
            vector.add(new Float(this.expMatrix.A[n][i]));
        }
        float[] fArray = new float[vector.size()];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = ((Float)vector.get(i)).floatValue();
        }
        return fArray;
    }

    private double getOneClassTValue(int n, FloatMatrix floatMatrix) {
        Vector<Float> vector = new Vector<Float>();
        for (int i = 0; i < this.numExps; ++i) {
            if (this.groupAssignments[i] != 1) continue;
            vector.add(new Float(floatMatrix.A[n][i]));
        }
        float[] fArray = new float[vector.size()];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = ((Float)vector.get(i)).floatValue();
        }
        return this.getOneClassTValue(fArray);
    }

    private float getSomeCombsOneClassProb(int n) {
        int n2;
        int n3 = this.getNumValidOneClassExpts();
        float[] fArray = this.expMatrix.A[n];
        float[] fArray2 = this.getOneClassGeneValues(n);
        float f = (float)Math.abs(this.getOneClassTValue(fArray2));
        if (Float.isNaN(f)) {
            return Float.NaN;
        }
        Random random = new Random();
        long[] lArray = new long[this.numCombs];
        for (n2 = 0; n2 < this.numCombs; ++n2) {
            lArray[n2] = random.nextLong();
        }
        n2 = 0;
        for (int i = 0; i < this.numCombs; ++i) {
            boolean[] blArray = this.getSomeCombsPermutArray(lArray[i]);
            float[] fArray3 = new float[fArray2.length];
            for (int j = 0; j < blArray.length; ++j) {
                fArray3[j] = blArray[j] ? fArray2[j] - 2.0f * (fArray2[j] - this.oneClassMean) : fArray2[j];
            }
            double d = Math.abs(this.getOneClassTValue(fArray3));
            if (!(d > (double)f)) continue;
            ++n2;
        }
        double d = (double)n2 / (double)this.numCombs;
        return (float)d;
    }

    private boolean[] getSomeCombsPermutArray(long l) {
        boolean[] blArray = new boolean[this.getNumValidOneClassExpts()];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = false;
        }
        Random random = new Random(l);
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = random.nextBoolean();
        }
        return blArray;
    }

    private double[] getPairedRawPValsFromPerms() throws AlgorithmException {
        int n;
        this.event = new AlgorithmEvent((Object)this, 1, this.numCombs);
        this.fireValueChanged(this.event);
        this.event.setId(2);
        double[] dArray = new double[this.numGenes];
        for (n = 0; n < this.numGenes; ++n) {
            dArray[n] = Double.isNaN(this.tValues[n]) ? Double.NaN : 0.0;
        }
        if (!this.useAllCombs) {
            Random random = new Random();
            for (int i = 0; i < this.numCombs; ++i) {
                long l = random.nextLong();
                if (this.stop) {
                    throw new AbortException();
                }
                int[] nArray = this.permuteWithinPairs(l);
                FloatMatrix floatMatrix = this.getPermutedMatrix(this.expMatrix, nArray);
                this.event.setIntValue(i);
                this.event.setDescription("Calculating raw p values: Current permutation = " + (i + 1));
                this.fireValueChanged(this.event);
                for (int j = 0; j < this.numGenes; ++j) {
                    double d = this.getPairedTValue(j, floatMatrix);
                    if (!(this.tValues[j] < d)) continue;
                    dArray[j] = dArray[j] + 1.0;
                }
            }
        } else {
            for (n = 0; n < this.numCombs; ++n) {
                if (this.stop) {
                    throw new AbortException();
                }
                int[] nArray = this.permuteWithinPairsAllPerms(n);
                FloatMatrix floatMatrix = this.getPermutedMatrix(this.expMatrix, nArray);
                this.event.setIntValue(n);
                this.event.setDescription("Calculating raw p values: Current permutation = " + (n + 1));
                this.fireValueChanged(this.event);
                for (int i = 0; i < this.numGenes; ++i) {
                    double d = this.getPairedTValue(i, floatMatrix);
                    if (!(this.tValues[i] < d)) continue;
                    dArray[i] = dArray[i] + 1.0;
                }
            }
        }
        for (int i = 0; i < this.numGenes; ++i) {
            dArray[i] = dArray[i] / (double)this.numCombs;
        }
        return dArray;
    }

    private int[] permuteWithinPairsAllPerms(int n) {
        int n2;
        int[] nArray = new int[this.numExps];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = n2;
        }
        boolean[] blArray = this.getChangeSignArrayForAllPairedPerms(n);
        for (int i = 0; i < this.pairedGroupAExpts.length; ++i) {
            boolean bl = blArray[i];
            if (!bl) continue;
            n2 = nArray[this.pairedGroupBExpts[i]];
            nArray[this.pairedGroupBExpts[i]] = nArray[this.pairedGroupAExpts[i]];
            nArray[this.pairedGroupAExpts[i]] = n2;
        }
        return nArray;
    }

    boolean[] getChangeSignArrayForAllPairedPerms(int n) {
        int n2;
        boolean[] blArray = new boolean[this.pairedGroupAExpts.length];
        for (n2 = 0; n2 < blArray.length; ++n2) {
            blArray[n2] = false;
        }
        n2 = this.pairedGroupAExpts.length;
        String string = Integer.toBinaryString(n);
        char[] cArray = string.toCharArray();
        if (cArray.length < n2) {
            int n3;
            Vector<Character> vector = new Vector<Character>();
            for (n3 = 0; n3 < n2 - cArray.length; ++n3) {
                vector.add(new Character('0'));
            }
            for (n3 = 0; n3 < cArray.length; ++n3) {
                vector.add(new Character(cArray[n3]));
            }
            cArray = new char[vector.size()];
            for (n3 = 0; n3 < cArray.length; ++n3) {
                cArray[n3] = ((Character)vector.get(n3)).charValue();
            }
        }
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = cArray[i] == '1';
        }
        return blArray;
    }

    private int[] permuteWithinPairs(long l) {
        int n;
        int[] nArray = new int[this.numExps];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = n;
        }
        Random random = new Random(l);
        for (int i = 0; i < this.pairedGroupAExpts.length; ++i) {
            boolean bl = random.nextBoolean();
            if (!bl) continue;
            n = nArray[this.pairedGroupBExpts[i]];
            nArray[this.pairedGroupBExpts[i]] = nArray[this.pairedGroupAExpts[i]];
            nArray[this.pairedGroupAExpts[i]] = n;
        }
        try {
            Thread.sleep(10L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return nArray;
    }

    private double[] getTwoClassRawPValsFromPerms() throws AlgorithmException {
        int n;
        this.event = new AlgorithmEvent((Object)this, 1, this.numCombs);
        this.fireValueChanged(this.event);
        this.event.setId(2);
        double[] dArray = new double[this.numGenes];
        for (n = 0; n < this.numGenes; ++n) {
            dArray[n] = Double.isNaN(this.tValues[n]) ? Double.NaN : 0.0;
        }
        if (!this.useAllCombs) {
            for (n = 0; n < this.numCombs; ++n) {
                if (this.stop) {
                    throw new AbortException();
                }
                this.event.setIntValue(n);
                this.event.setDescription("Permuting matrix: Current permutation = " + (n + 1));
                this.fireValueChanged(this.event);
                int[] nArray = new int[1];
                Vector<Integer> vector = new Vector<Integer>();
                for (int i = 0; i < this.groupAssignments.length; ++i) {
                    if (this.groupAssignments[i] == 3) continue;
                    vector.add(new Integer(i));
                }
                int[] nArray2 = new int[vector.size()];
                for (int i = 0; i < nArray2.length; ++i) {
                    nArray2[i] = (Integer)vector.get(i);
                }
                nArray = this.getPermutedValues(this.numExps, nArray2);
                FloatMatrix floatMatrix = this.getPermutedMatrix(this.expMatrix, nArray);
                double[] dArray2 = this.getTwoClassUnpairedTValues(floatMatrix);
                for (int i = 0; i < this.numGenes; ++i) {
                    if (!(this.tValues[i] < dArray2[i])) continue;
                    dArray[i] = dArray[i] + 1.0;
                }
            }
            for (n = 0; n < this.numGenes; ++n) {
                dArray[n] = dArray[n] / (double)this.numCombs;
            }
        } else {
            int n2;
            int[] nArray = new int[this.numExps];
            for (int i = 0; i < this.numExps; ++i) {
                nArray[i] = i;
            }
            Vector<Integer> vector = new Vector<Integer>();
            int n3 = 0;
            for (int i = 0; i < this.groupAssignments.length; ++i) {
                if (this.groupAssignments[i] != 3) {
                    vector.add(new Integer(i));
                }
                if (this.groupAssignments[i] != 1) continue;
                ++n3;
            }
            int[] nArray3 = new int[vector.size()];
            for (int i = 0; i < nArray3.length; ++i) {
                nArray3[i] = (Integer)vector.get(i);
            }
            int[] nArray4 = new int[n3];
            for (n2 = 0; n2 < nArray4.length; ++n2) {
                nArray4[n2] = -1;
            }
            n2 = nArray3.length - n3;
            int n4 = 0;
            while (Combinations.enumerateCombinations((int)nArray3.length, (int)n3, (int[])nArray4)) {
                int n5;
                if (this.stop) {
                    throw new AbortException();
                }
                this.event.setIntValue(n4);
                this.event.setDescription("Permuting matrix: Current permutation = " + (n4 + 1));
                this.fireValueChanged(this.event);
                int[] nArray5 = new int[n2];
                int n6 = 0;
                for (n5 = 0; n5 < nArray3.length; ++n5) {
                    if (this.belongsInArray(n5, nArray4)) continue;
                    nArray5[n6] = n5;
                    ++n6;
                }
                for (n5 = 0; n5 < nArray4.length; ++n5) {
                    nArray[nArray3[n5]] = nArray3[nArray4[n5]];
                }
                for (n5 = 0; n5 < nArray5.length; ++n5) {
                    nArray[nArray3[nArray4.length + n5]] = nArray3[nArray5[n5]];
                }
                FloatMatrix floatMatrix = this.getPermutedMatrix(this.expMatrix, nArray);
                double[] dArray3 = this.getTwoClassUnpairedTValues(floatMatrix);
                for (int i = 0; i < this.numGenes; ++i) {
                    if (!(this.tValues[i] < dArray3[i])) continue;
                    dArray[i] = dArray[i] + 1.0;
                }
                ++n4;
            }
            for (int i = 0; i < this.numGenes; ++i) {
                dArray[i] = dArray[i] / (double)n4;
            }
        }
        return dArray;
    }

    private float[][] randomlyPermute(float[] fArray, int[] nArray, int n, int n2) {
        int n3;
        int n4;
        float[][] fArrayArray = new float[][]{new float[n], new float[n2]};
        if (n > n2) {
            fArrayArray[0] = new float[n2];
            fArrayArray[1] = new float[n];
        }
        Vector<Integer> vector = new Vector<Integer>();
        for (n4 = 0; n4 < nArray.length; ++n4) {
            vector.add(new Integer(nArray[n4]));
        }
        for (n4 = 0; n4 < fArrayArray[0].length; ++n4) {
            n3 = (int)Math.round(Math.random() * (double)(vector.size() - 1));
            int n5 = (Integer)vector.remove(n3);
            fArrayArray[0][n4] = fArray[n5];
        }
        for (n4 = 0; n4 < fArrayArray[1].length; ++n4) {
            n3 = (Integer)vector.get(n4);
            fArrayArray[1][n4] = fArray[n3];
        }
        return fArrayArray;
    }

    private double[] getParametricPVals(double[] dArray, int[] nArray) {
        double[] dArray2 = new double[this.numGenes];
        for (int i = 0; i < this.numGenes; ++i) {
            if (Double.isNaN(dArray[i])) {
                dArray2[i] = Double.NaN;
                continue;
            }
            TDistribution tDistribution = new TDistribution(nArray[i]);
            double d = tDistribution.cumulative(dArray[i]);
            double d2 = 2.0 * (1.0 - d);
            if (d2 > 1.0) {
                d2 = 1.0;
            }
            dArray2[i] = d2;
        }
        return dArray2;
    }

    private double[] getRawPValsFromTDist() throws AlgorithmException {
        this.event = new AlgorithmEvent((Object)this, 1, this.numGenes);
        this.fireValueChanged(this.event);
        this.event.setId(2);
        double[] dArray = new double[this.numGenes];
        for (int i = 0; i < this.numGenes; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            this.event.setIntValue(i);
            this.event.setDescription("Calculating raw p values: Current gene = " + (i + 1));
            this.fireValueChanged(this.event);
            if (Double.isNaN(this.tValues[i])) {
                dArray[i] = Double.NaN;
                continue;
            }
            TDistribution tDistribution = new TDistribution((int)this.dfValues[i]);
            double d = tDistribution.cumulative(this.tValues[i]);
            double d2 = 2.0 * (1.0 - d);
            if (d2 > 1.0) {
                d2 = 1.0;
            }
            dArray[i] = d2;
        }
        return dArray;
    }

    private double[] getAdjPVals(double[] dArray, int n) throws AlgorithmException {
        this.event = new AlgorithmEvent((Object)this, 1, this.numGenes);
        this.fireValueChanged(this.event);
        this.event.setId(2);
        double[] dArray2 = new double[dArray.length];
        if (n == 4) {
            dArray2 = dArray;
        }
        if (n == 5) {
            for (int i = 0; i < this.numGenes; ++i) {
                if (this.stop) {
                    throw new AbortException();
                }
                this.event.setIntValue(i);
                this.event.setDescription("Computing adjusted p-values: Current gene = " + (i + 1));
                this.fireValueChanged(this.event);
                double d = dArray[i];
                double d2 = d * (double)this.numGenes;
                if (d2 > 1.0) {
                    d2 = 1.0;
                }
                dArray2[i] = d2;
            }
        }
        if (n == 6) {
            dArray2 = this.getAdjBonfPVals(dArray);
        }
        if (n == 9) {
            dArray2 = this.getMaxTPVals();
        }
        return dArray2;
    }

    private double[] getMaxTPVals() throws AlgorithmException {
        int n;
        int n2;
        QSort qSort;
        double[] dArray = this.tValues;
        double[] dArray2 = new double[this.numGenes];
        int[] nArray = new int[this.numGenes];
        double[] dArray3 = new double[this.numGenes];
        double[][] dArray4 = new double[this.numCombs][this.numGenes];
        double[][] dArray5 = new double[this.numGenes][this.numCombs];
        AlgorithmEvent algorithmEvent = new AlgorithmEvent((Object)this, 1, this.numCombs);
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        if (this.tTestDesign == 7) {
            qSort = new QSort(dArray, 2);
            dArray2 = qSort.getSortedDouble();
            nArray = qSort.getOrigIndx();
            if (!this.useAllCombs) {
                for (int i = 0; i < this.numCombs; ++i) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    algorithmEvent.setIntValue(i);
                    algorithmEvent.setDescription("Permuting matrix: Current permutation = " + (i + 1));
                    this.fireValueChanged(algorithmEvent);
                    int[] nArray2 = new int[1];
                    Vector<Integer> vector = new Vector<Integer>();
                    for (int j = 0; j < this.groupAssignments.length; ++j) {
                        if (this.groupAssignments[j] == 3) continue;
                        vector.add(new Integer(j));
                    }
                    int[] nArray3 = new int[vector.size()];
                    for (int j = 0; j < nArray3.length; ++j) {
                        nArray3[j] = (Integer)vector.get(j);
                    }
                    nArray2 = this.getPermutedValues(this.numExps, nArray3);
                    FloatMatrix floatMatrix = this.getPermutedMatrix(this.expMatrix, nArray2);
                    double[] dArray6 = this.getTwoClassUnpairedTValues(floatMatrix);
                    dArray5[this.numGenes - 1][i] = Double.isNaN(dArray6[nArray[this.numGenes - 1]]) ? Double.NEGATIVE_INFINITY : dArray6[nArray[this.numGenes - 1]];
                    for (int j = this.numGenes - 2; j >= 0; --j) {
                        dArray5[j][i] = Double.isNaN(dArray6[nArray[j]]) ? dArray5[j + 1][i] : Math.max(dArray5[j + 1][i], dArray6[nArray[j]]);
                    }
                }
            } else {
                int n3;
                int[] nArray4 = new int[this.numExps];
                for (int i = 0; i < this.numExps; ++i) {
                    nArray4[i] = i;
                }
                Vector<Integer> vector = new Vector<Integer>();
                int n4 = 0;
                for (int i = 0; i < this.groupAssignments.length; ++i) {
                    if (this.groupAssignments[i] != 3) {
                        vector.add(new Integer(i));
                    }
                    if (this.groupAssignments[i] != 1) continue;
                    ++n4;
                }
                int[] nArray5 = new int[vector.size()];
                for (int i = 0; i < nArray5.length; ++i) {
                    nArray5[i] = (Integer)vector.get(i);
                }
                int[] nArray6 = new int[n4];
                for (n3 = 0; n3 < nArray6.length; ++n3) {
                    nArray6[n3] = -1;
                }
                n3 = nArray5.length - n4;
                int n5 = 0;
                while (Combinations.enumerateCombinations((int)nArray5.length, (int)n4, (int[])nArray6)) {
                    int n6;
                    if (this.stop) {
                        throw new AbortException();
                    }
                    algorithmEvent.setIntValue(n5);
                    algorithmEvent.setDescription("Permuting matrix: Current permutation = " + (n5 + 1));
                    this.fireValueChanged(algorithmEvent);
                    int[] nArray7 = new int[n3];
                    int n7 = 0;
                    for (n6 = 0; n6 < nArray5.length; ++n6) {
                        if (this.belongsInArray(n6, nArray6)) continue;
                        nArray7[n7] = n6;
                        ++n7;
                    }
                    for (n6 = 0; n6 < nArray6.length; ++n6) {
                        nArray4[nArray5[n6]] = nArray5[nArray6[n6]];
                    }
                    for (n6 = 0; n6 < nArray7.length; ++n6) {
                        nArray4[nArray5[nArray6.length + n6]] = nArray5[nArray7[n6]];
                    }
                    FloatMatrix floatMatrix = this.getPermutedMatrix(this.expMatrix, nArray4);
                    double[] dArray7 = this.getTwoClassUnpairedTValues(floatMatrix);
                    dArray5[this.numGenes - 1][n5] = Double.isNaN(dArray7[nArray[this.numGenes - 1]]) ? Double.NEGATIVE_INFINITY : dArray7[nArray[this.numGenes - 1]];
                    for (int i = this.numGenes - 2; i >= 0; --i) {
                        dArray5[i][n5] = Double.isNaN(dArray7[nArray[i]]) ? dArray5[i + 1][n5] : Math.max(dArray5[i + 1][n5], dArray7[nArray[i]]);
                    }
                    ++n5;
                }
            }
        } else if (this.tTestDesign == 11) {
            qSort = new QSort(dArray, 2);
            dArray2 = qSort.getSortedDouble();
            nArray = qSort.getOrigIndx();
            if (!this.useAllCombs) {
                Random random = new Random();
                for (int i = 0; i < this.numCombs; ++i) {
                    int n8;
                    long l = random.nextLong();
                    if (this.stop) {
                        throw new AbortException();
                    }
                    int[] nArray8 = this.permuteWithinPairs(l);
                    FloatMatrix floatMatrix = this.getPermutedMatrix(this.expMatrix, nArray8);
                    algorithmEvent.setIntValue(i);
                    algorithmEvent.setDescription("Permuting matrix: Current permutation = " + (i + 1));
                    this.fireValueChanged(algorithmEvent);
                    double[] dArray8 = new double[this.numGenes];
                    for (n8 = 0; n8 < this.numGenes; ++n8) {
                        dArray8[n8] = this.getPairedTValue(n8, floatMatrix);
                    }
                    dArray5[this.numGenes - 1][i] = Double.isNaN(dArray8[nArray[this.numGenes - 1]]) ? Double.NEGATIVE_INFINITY : dArray8[nArray[this.numGenes - 1]];
                    for (n8 = this.numGenes - 2; n8 >= 0; --n8) {
                        dArray5[n8][i] = Double.isNaN(dArray8[nArray[n8]]) ? dArray5[n8 + 1][i] : Math.max(dArray5[n8 + 1][i], dArray8[nArray[n8]]);
                    }
                }
            } else {
                for (int i = 0; i < this.numCombs; ++i) {
                    int n9;
                    if (this.stop) {
                        throw new AbortException();
                    }
                    int[] nArray9 = this.permuteWithinPairsAllPerms(i);
                    FloatMatrix floatMatrix = this.getPermutedMatrix(this.expMatrix, nArray9);
                    algorithmEvent.setIntValue(i);
                    algorithmEvent.setDescription("Permuting matrix: Current permutation = " + (i + 1));
                    this.fireValueChanged(algorithmEvent);
                    double[] dArray9 = new double[this.numGenes];
                    for (n9 = 0; n9 < this.numGenes; ++n9) {
                        dArray9[n9] = this.getPairedTValue(n9, floatMatrix);
                    }
                    dArray5[this.numGenes - 1][i] = Double.isNaN(dArray9[nArray[this.numGenes - 1]]) ? Double.NEGATIVE_INFINITY : dArray9[nArray[this.numGenes - 1]];
                    for (n9 = this.numGenes - 2; n9 >= 0; --n9) {
                        dArray5[n9][i] = Double.isNaN(dArray9[nArray[n9]]) ? dArray5[n9 + 1][i] : Math.max(dArray5[n9 + 1][i], dArray9[nArray[n9]]);
                    }
                }
            }
        } else if (this.tTestDesign == 8) {
            qSort = new QSort(dArray, 2);
            dArray2 = qSort.getSortedDouble();
            nArray = qSort.getOrigIndx();
            if (!this.useAllCombs) {
                int n10;
                boolean[] blArray = new boolean[1];
                Random random = new Random();
                long[] lArray = new long[this.numCombs];
                for (n10 = 0; n10 < this.numCombs; ++n10) {
                    lArray[n10] = random.nextLong();
                }
                for (n10 = 0; n10 < this.numCombs; ++n10) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    algorithmEvent.setIntValue(n10);
                    algorithmEvent.setDescription("Permuting matrix: Current permutation = " + (n10 + 1));
                    this.fireValueChanged(algorithmEvent);
                    int[] nArray10 = new int[1];
                    Vector<Integer> vector = new Vector<Integer>();
                    for (int i = 0; i < this.groupAssignments.length; ++i) {
                        if (this.groupAssignments[i] != 1) continue;
                        vector.add(new Integer(i));
                    }
                    int[] nArray11 = new int[vector.size()];
                    for (int i = 0; i < nArray11.length; ++i) {
                        nArray11[i] = (Integer)vector.get(i);
                    }
                    blArray = this.getOneClassChangeSignArray(lArray[n10], nArray11);
                    FloatMatrix floatMatrix = this.getOneClassPermMatrix(this.expMatrix, blArray);
                    double[] dArray10 = this.getOneClassTValues(floatMatrix);
                    dArray5[this.numGenes - 1][n10] = Double.isNaN(dArray10[nArray[this.numGenes - 1]]) ? Double.NEGATIVE_INFINITY : dArray10[nArray[this.numGenes - 1]];
                    for (int i = this.numGenes - 2; i >= 0; --i) {
                        dArray5[i][n10] = Double.isNaN(dArray10[nArray[i]]) ? dArray5[i + 1][n10] : Math.max(dArray5[i + 1][n10], dArray10[nArray[i]]);
                    }
                }
            } else {
                for (int i = 0; i < this.numCombs; ++i) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    algorithmEvent.setIntValue(i);
                    algorithmEvent.setDescription("Permuting matrix: Current permutation = " + (i + 1));
                    this.fireValueChanged(algorithmEvent);
                    Vector<Integer> vector = new Vector<Integer>();
                    for (int j = 0; j < this.groupAssignments.length; ++j) {
                        if (this.groupAssignments[j] != 1) continue;
                        vector.add(new Integer(j));
                    }
                    int[] nArray12 = new int[vector.size()];
                    for (int j = 0; j < nArray12.length; ++j) {
                        nArray12[j] = (Integer)vector.get(j);
                    }
                    boolean[] blArray = this.getOneClassChangeSignArrayAllUniquePerms(i, nArray12);
                    FloatMatrix floatMatrix = this.getOneClassPermMatrix(this.expMatrix, blArray);
                    double[] dArray11 = this.getOneClassTValues(floatMatrix);
                    dArray5[this.numGenes - 1][i] = Double.isNaN(dArray11[nArray[this.numGenes - 1]]) ? Double.NEGATIVE_INFINITY : dArray11[nArray[this.numGenes - 1]];
                    for (int j = this.numGenes - 2; j >= 0; --j) {
                        dArray5[j][i] = Double.isNaN(dArray11[nArray[j]]) ? dArray5[j + 1][i] : Math.max(dArray5[j + 1][i], dArray11[nArray[j]]);
                    }
                }
            }
        }
        for (n2 = 0; n2 < this.numGenes; ++n2) {
            int n11 = 0;
            for (int i = 0; i < this.numCombs; ++i) {
                if (!(dArray5[n2][i] >= dArray2[n2])) continue;
                ++n11;
            }
            dArray3[nArray[n2]] = (double)n11 / (double)this.numCombs;
        }
        n2 = 0;
        for (n = 0; n < this.numGenes; ++n) {
            if (!Double.isNaN(dArray[n])) continue;
            dArray3[n] = Double.NaN;
            ++n2;
        }
        for (n = 1; n < this.numGenes - n2; ++n) {
            dArray3[nArray[n]] = Math.max(dArray3[nArray[n]], dArray3[nArray[n - 1]]);
        }
        return dArray3;
    }

    double[] getOneClassTValues(FloatMatrix floatMatrix) {
        double[] dArray = new double[this.numGenes];
        for (int i = 0; i < this.numGenes; ++i) {
            dArray[i] = Math.abs(this.getOneClassTValue(i, floatMatrix));
        }
        return dArray;
    }

    private boolean belongsInArray(int n, int[] nArray) {
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private float getTValue(int n, FloatMatrix floatMatrix) {
        int n2;
        float[] fArray = new float[this.numExps];
        for (n2 = 0; n2 < this.numExps; ++n2) {
            fArray[n2] = floatMatrix.A[n][n2];
        }
        n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 1) {
                ++n2;
                continue;
            }
            if (this.groupAssignments[i] != 2) continue;
            ++n3;
        }
        float[] fArray2 = new float[n2];
        float[] fArray3 = new float[n3];
        n2 = 0;
        n3 = 0;
        for (int i = 0; i < this.groupAssignments.length; ++i) {
            if (this.groupAssignments[i] == 1) {
                fArray2[n2] = fArray[i];
                ++n2;
                continue;
            }
            if (this.groupAssignments[i] != 2) continue;
            fArray3[n3] = fArray[i];
            ++n3;
        }
        float f = this.calculateTValue(fArray2, fArray3);
        return f;
    }

    private double[] getTwoClassUnpairedTValues(FloatMatrix floatMatrix) {
        double[] dArray = new double[this.numGenes];
        for (int i = 0; i < this.numGenes; ++i) {
            dArray[i] = Math.abs(this.getTValue(i, floatMatrix));
        }
        return dArray;
    }

    private FloatMatrix getPermutedMatrix(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = new FloatMatrix(floatMatrix.getRowDimension(), floatMatrix.getColumnDimension());
        for (int i = 0; i < floatMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < floatMatrix.getColumnDimension(); ++j) {
                floatMatrix2.A[i][j] = floatMatrix.A[i][nArray[j]];
            }
        }
        return floatMatrix2;
    }

    private int[] getPermutedValues(int n, int[] nArray) {
        int n2;
        int[] nArray2 = new int[n];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = i;
        }
        int[] nArray3 = new int[nArray.length];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray3[n2] = nArray[n2];
        }
        for (n2 = nArray3.length; n2 > 1; --n2) {
            Random random = new Random();
            int n3 = random.nextInt(n2 - 1);
            int n4 = nArray3[n3];
            nArray3[n3] = nArray3[n2 - 1];
            nArray3[n2 - 1] = n4;
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray2[nArray[n2]] = nArray3[n2];
        }
        try {
            Thread.sleep(10L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return nArray2;
    }

    private double[] getAdjBonfPVals(double[] dArray) {
        int n;
        double[] dArray2 = new double[dArray.length];
        this.isSig = new boolean[dArray.length];
        for (int i = 0; i < this.isSig.length; ++i) {
            this.isSig[i] = false;
        }
        QSort qSort = new QSort(dArray, 1);
        double[] dArray3 = qSort.getSortedDouble();
        int[] nArray = qSort.getOrigIndx();
        int n2 = this.numGenes;
        dArray2[nArray[0]] = dArray3[0] * (double)n2;
        for (n = 1; n < this.numGenes; ++n) {
            if (dArray3[n - 1] < dArray3[n]) {
                --n2;
            }
            if (n2 <= 0) {
                n2 = 1;
            }
            dArray2[nArray[n]] = dArray3[n] * (double)n2;
        }
        for (n = 0; n < dArray2.length; ++n) {
            if (!(dArray2[n] > 1.0)) continue;
            dArray2[n] = 1.0;
        }
        for (n = 0; n < nArray.length && !(dArray2[nArray[n]] > (double)this.alpha); ++n) {
            if (!(dArray2[nArray[n]] <= (double)this.alpha)) continue;
            this.isSig[nArray[n]] = true;
        }
        return dArray2;
    }

    private int[] getPairedDfs(FloatMatrix floatMatrix) {
        int[] nArray = new int[this.numGenes];
        for (int i = 0; i < this.numGenes; ++i) {
            int n;
            float[] fArray = new float[this.numExps];
            for (int j = 0; j < this.numExps; ++j) {
                fArray[j] = floatMatrix.A[i][j];
            }
            float[] fArray2 = new float[this.pairedGroupAExpts.length];
            float[] fArray3 = new float[this.pairedGroupBExpts.length];
            int n2 = 0;
            int n3 = 0;
            for (n = 0; n < this.pairedGroupAExpts.length; ++n) {
                fArray2[n] = fArray[this.pairedGroupAExpts[n]];
                if (!Float.isNaN(fArray[this.pairedGroupAExpts[n]])) {
                    ++n2;
                }
                fArray3[n] = fArray[this.pairedGroupBExpts[n]];
                if (Float.isNaN(fArray[this.pairedGroupBExpts[n]])) continue;
                ++n3;
            }
            if (n2 < 2 || n3 < 2) {
                nArray[i] = -1;
                continue;
            }
            n = 0;
            for (int j = 0; j < this.pairedGroupAExpts.length; ++j) {
                if (Double.isNaN(floatMatrix.A[i][this.pairedGroupAExpts[j]]) || Double.isNaN(floatMatrix.A[i][this.pairedGroupBExpts[j]])) continue;
                ++n;
            }
            nArray[i] = n - 1;
        }
        return nArray;
    }

    private int[] getTwoClassDfs(FloatMatrix floatMatrix) {
        int[] nArray = new int[this.numGenes];
        for (int i = 0; i < this.numGenes; ++i) {
            int n;
            float[] fArray = new float[this.numExps];
            for (n = 0; n < this.numExps; ++n) {
                fArray[n] = floatMatrix.A[i][n];
            }
            n = 0;
            int n2 = 0;
            for (int j = 0; j < this.groupAssignments.length; ++j) {
                if (this.groupAssignments[j] == 1) {
                    ++n;
                    continue;
                }
                if (this.groupAssignments[j] != 2) continue;
                ++n2;
            }
            float[] fArray2 = new float[n];
            float[] fArray3 = new float[n2];
            int n3 = 0;
            int n4 = 0;
            n = 0;
            n2 = 0;
            for (int j = 0; j < this.groupAssignments.length; ++j) {
                if (this.groupAssignments[j] == 1) {
                    fArray2[n] = fArray[j];
                    if (!Float.isNaN(fArray[j])) {
                        ++n3;
                    }
                    ++n;
                    continue;
                }
                if (this.groupAssignments[j] != 2) continue;
                fArray3[n2] = fArray[j];
                if (!Float.isNaN(fArray[j])) {
                    ++n4;
                }
                ++n2;
            }
            nArray[i] = n3 < 2 || n4 < 2 ? -1 : this.calculateDf(fArray2, fArray3);
        }
        return nArray;
    }

    private int[] getOneClassDfs(FloatMatrix floatMatrix) {
        int[] nArray = new int[this.numGenes];
        for (int i = 0; i < this.numGenes; ++i) {
            int n;
            Vector<Float> vector = new Vector<Float>();
            for (int j = 0; j < this.numExps; ++j) {
                if (this.groupAssignments[j] != 1) continue;
                vector.add(new Float(floatMatrix.A[i][j]));
            }
            float[] fArray = new float[vector.size()];
            for (n = 0; n < fArray.length; ++n) {
                fArray[n] = ((Float)vector.get(n)).floatValue();
            }
            n = 0;
            for (int j = 0; j < fArray.length; ++j) {
                if (Float.isNaN(fArray[j])) continue;
                ++n;
            }
            nArray[i] = n - 1;
        }
        return nArray;
    }

    private void computeOneClassOrigVals() throws AlgorithmException {
        this.event = new AlgorithmEvent((Object)this, 1, this.numGenes);
        this.fireValueChanged(this.event);
        this.event.setId(2);
        this.oneClassMeans = new double[this.numGenes];
        this.oneClassSDs = new double[this.numGenes];
        this.dfValues = new double[this.numGenes];
        this.tValues = new double[this.numGenes];
        for (int i = 0; i < this.numGenes; ++i) {
            int n;
            if (this.stop) {
                throw new AbortException();
            }
            this.event.setIntValue(i);
            this.event.setDescription("Calculating t values: Current gene = " + (i + 1));
            this.fireValueChanged(this.event);
            Vector<Float> vector = new Vector<Float>();
            for (int j = 0; j < this.numExps; ++j) {
                if (this.groupAssignments[j] != 1) continue;
                vector.add(new Float(this.expMatrix.A[i][j]));
            }
            float[] fArray = new float[vector.size()];
            for (n = 0; n < fArray.length; ++n) {
                fArray[n] = ((Float)vector.get(n)).floatValue();
            }
            this.tValues[i] = this.getOneClassTValue(fArray);
            this.oneClassMeans[i] = this.getMean(fArray);
            this.oneClassSDs[i] = Math.sqrt(this.getVar(fArray));
            n = 0;
            for (int j = 0; j < fArray.length; ++j) {
                if (Float.isNaN(fArray[j])) continue;
                ++n;
            }
            this.dfValues[i] = n - 1;
        }
    }

    private double getOneClassTValue(float[] fArray) {
        float f = this.getMean(fArray);
        double d = Math.sqrt(this.getVar(fArray));
        int n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            if (Float.isNaN(fArray[i])) continue;
            ++n;
        }
        double d2 = d / Math.sqrt(n);
        double d3 = (double)(f - this.oneClassMean) / d2;
        return Math.abs(d3);
    }

    private void computePairedOrigVals() throws AlgorithmException {
        this.event = new AlgorithmEvent((Object)this, 1, this.numGenes);
        this.fireValueChanged(this.event);
        this.event.setId(2);
        this.groupAMeans = new double[this.numGenes];
        this.groupBMeans = new double[this.numGenes];
        this.groupASDs = new double[this.numGenes];
        this.groupBSDs = new double[this.numGenes];
        this.dfValues = new double[this.numGenes];
        this.tValues = new double[this.numGenes];
        for (int i = 0; i < this.numGenes; ++i) {
            int n;
            if (this.stop) {
                throw new AbortException();
            }
            this.event.setIntValue(i);
            this.event.setDescription("Calculating t values: Current gene = " + (i + 1));
            this.fireValueChanged(this.event);
            float[] fArray = new float[this.numExps];
            for (int j = 0; j < this.numExps; ++j) {
                fArray[j] = this.expMatrix.A[i][j];
            }
            float[] fArray2 = new float[this.pairedGroupAExpts.length];
            float[] fArray3 = new float[this.pairedGroupBExpts.length];
            int n2 = 0;
            int n3 = 0;
            for (n = 0; n < this.pairedGroupAExpts.length; ++n) {
                fArray2[n] = fArray[this.pairedGroupAExpts[n]];
                if (!Float.isNaN(fArray[this.pairedGroupAExpts[n]])) {
                    ++n2;
                }
                fArray3[n] = fArray[this.pairedGroupBExpts[n]];
                if (Float.isNaN(fArray[this.pairedGroupBExpts[n]])) continue;
                ++n3;
            }
            if (n2 < 2 || n3 < 2) {
                this.tValues[i] = Double.NaN;
                this.dfValues[i] = Double.NaN;
                this.groupAMeans[i] = Double.NaN;
                this.groupBMeans[i] = Double.NaN;
                this.groupASDs[i] = Double.NaN;
                this.groupBSDs[i] = Double.NaN;
                continue;
            }
            this.tValues[i] = this.getPairedTValue(i, this.expMatrix);
            n = 0;
            for (int j = 0; j < this.pairedGroupAExpts.length; ++j) {
                if (Double.isNaN(this.expMatrix.A[i][this.pairedGroupAExpts[j]]) || Double.isNaN(this.expMatrix.A[i][this.pairedGroupBExpts[j]])) continue;
                ++n;
            }
            this.dfValues[i] = n - 1;
            this.groupAMeans[i] = this.getMean(fArray2);
            this.groupBMeans[i] = this.getMean(fArray3);
            this.groupASDs[i] = Math.sqrt(this.getVar(fArray2));
            this.groupBSDs[i] = Math.sqrt(this.getVar(fArray3));
        }
    }

    private double getPairedTValue(int n, FloatMatrix floatMatrix) {
        double d = 0.0;
        int n2 = 0;
        for (int i = 0; i < this.pairedGroupAExpts.length; ++i) {
            if (Double.isNaN(floatMatrix.A[n][this.pairedGroupAExpts[i]]) || Double.isNaN(floatMatrix.A[n][this.pairedGroupBExpts[i]])) continue;
            d += (double)(floatMatrix.A[n][this.pairedGroupAExpts[i]] - floatMatrix.A[n][this.pairedGroupBExpts[i]]);
            ++n2;
        }
        if (n2 < 2) {
            return Double.NaN;
        }
        double d2 = d / (double)n2;
        double d3 = 0.0;
        for (int i = 0; i < this.pairedGroupAExpts.length; ++i) {
            if (Double.isNaN(floatMatrix.A[n][this.pairedGroupAExpts[i]]) || Double.isNaN(floatMatrix.A[n][this.pairedGroupBExpts[i]])) continue;
            d3 += Math.pow(floatMatrix.A[n][this.pairedGroupAExpts[i]] - floatMatrix.A[n][this.pairedGroupBExpts[i]], 2.0);
        }
        double d4 = d3 - Math.pow(d, 2.0) / (double)n2;
        double d5 = d4 / (double)(n2 - 1);
        double d6 = Math.sqrt(d5 / (double)n2);
        return Math.abs(d2 / d6);
    }

    private double[] getPairedTValues(FloatMatrix floatMatrix) {
        double[] dArray = new double[floatMatrix.getRowDimension()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.getPairedTValue(i, floatMatrix);
        }
        return dArray;
    }

    private void computeBtnSubOrigVals() throws AlgorithmException {
        this.event = new AlgorithmEvent((Object)this, 1, this.numGenes);
        this.fireValueChanged(this.event);
        this.event.setId(2);
        this.groupAMeans = new double[this.numGenes];
        this.groupBMeans = new double[this.numGenes];
        this.groupASDs = new double[this.numGenes];
        this.groupBSDs = new double[this.numGenes];
        this.dfValues = new double[this.numGenes];
        this.tValues = new double[this.numGenes];
        for (int i = 0; i < this.numGenes; ++i) {
            int n;
            if (this.stop) {
                throw new AbortException();
            }
            this.event.setIntValue(i);
            this.event.setDescription("Calculating t values: Current gene = " + (i + 1));
            this.fireValueChanged(this.event);
            float[] fArray = new float[this.numExps];
            for (n = 0; n < this.numExps; ++n) {
                fArray[n] = this.expMatrix.A[i][n];
            }
            n = 0;
            int n2 = 0;
            for (int j = 0; j < this.groupAssignments.length; ++j) {
                if (this.groupAssignments[j] == 1) {
                    ++n;
                    continue;
                }
                if (this.groupAssignments[j] != 2) continue;
                ++n2;
            }
            float[] fArray2 = new float[n];
            float[] fArray3 = new float[n2];
            int n3 = 0;
            int n4 = 0;
            n = 0;
            n2 = 0;
            for (int j = 0; j < this.groupAssignments.length; ++j) {
                if (this.groupAssignments[j] == 1) {
                    fArray2[n] = fArray[j];
                    if (!Float.isNaN(fArray[j])) {
                        ++n3;
                    }
                    ++n;
                    continue;
                }
                if (this.groupAssignments[j] != 2) continue;
                fArray3[n2] = fArray[j];
                if (!Float.isNaN(fArray[j])) {
                    ++n4;
                }
                ++n2;
            }
            if (n3 < 2 || n4 < 2) {
                this.tValues[i] = Double.NaN;
                this.dfValues[i] = Double.NaN;
                this.groupAMeans[i] = Double.NaN;
                this.groupBMeans[i] = Double.NaN;
                this.groupASDs[i] = Double.NaN;
                this.groupBSDs[i] = Double.NaN;
                continue;
            }
            this.tValues[i] = this.calculateTValue(fArray2, fArray3);
            this.dfValues[i] = this.calculateDf(fArray2, fArray3);
            this.groupAMeans[i] = this.getMean(fArray2);
            this.groupBMeans[i] = this.getMean(fArray3);
            this.groupASDs[i] = Math.sqrt(this.getVar(fArray2));
            this.groupBSDs[i] = Math.sqrt(this.getVar(fArray3));
        }
    }

    private float calculateTValue(float[] fArray, float[] fArray2) {
        int n;
        if (this.useWelchDf) {
            int n2;
            int n3 = fArray.length;
            int n4 = fArray2.length;
            float f = this.getMean(fArray);
            float f2 = this.getMean(fArray2);
            float f3 = this.getVar(fArray);
            float f4 = this.getVar(fArray2);
            int n5 = 0;
            int n6 = 0;
            for (n2 = 0; n2 < fArray.length; ++n2) {
                if (Float.isNaN(fArray[n2])) continue;
                ++n5;
            }
            for (n2 = 0; n2 < fArray2.length; ++n2) {
                if (Float.isNaN(fArray2[n2])) continue;
                ++n6;
            }
            if (n5 < 2 || n6 < 2) {
                return Float.NaN;
            }
            float f5 = (float)((double)(f - f2) / Math.sqrt(f3 / (float)n5 + f4 / (float)n6));
            return Math.abs(f5);
        }
        int n7 = 0;
        int n8 = 0;
        for (n = 0; n < fArray.length; ++n) {
            if (Float.isNaN(fArray[n])) continue;
            ++n7;
        }
        for (n = 0; n < fArray2.length; ++n) {
            if (Float.isNaN(fArray2[n])) continue;
            ++n8;
        }
        if (n7 < 2 || n8 < 2) {
            return Float.NaN;
        }
        float f = this.getSumSquares(fArray);
        float f6 = this.getSumSquares(fArray2);
        float f7 = f + f6;
        float f8 = n7 + n8 - 2;
        float f9 = 1.0f / (float)n7 + 1.0f / (float)n8;
        float f10 = (float)Math.sqrt(f7 * f9 / f8);
        float f11 = this.getMean(fArray);
        float f12 = this.getMean(fArray2);
        float f13 = (f11 - f12) / f10;
        return Math.abs(f13);
    }

    private float getSumSquares(float[] fArray) {
        int n = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            if (Float.isNaN(fArray[i])) continue;
            ++n;
            f += fArray[i];
            f2 += fArray[i] * fArray[i];
        }
        if (n == 0) {
            return Float.NaN;
        }
        float f3 = f2 - f * f / (float)n;
        return f3;
    }

    private int calculateDf(float[] fArray, float[] fArray2) {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < fArray.length; ++n) {
            if (Float.isNaN(fArray[n])) continue;
            ++n2;
        }
        for (n = 0; n < fArray2.length; ++n) {
            if (Float.isNaN(fArray2[n])) continue;
            ++n3;
        }
        if (!this.useWelchDf) {
            n = n2 + n3 - 2;
            if (n < 0) {
                n = 0;
            }
            return n;
        }
        float f = this.getMean(fArray);
        float f2 = this.getMean(fArray2);
        float f3 = this.getVar(fArray);
        float f4 = this.getVar(fArray2);
        float f5 = (float)Math.pow(f3 / (float)n2 + f4 / (float)n3, 2.0);
        float f6 = (float)(Math.pow(f3 / (float)n2, 2.0) / (double)(n2 - 1) + Math.pow(f4 / (float)n3, 2.0) / (double)(n3 - 1));
        int n4 = (int)Math.floor(f5 / f6);
        return n4;
    }

    private float getMean(float[] fArray) {
        float f = 0.0f;
        int n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            if (Float.isNaN(fArray[i])) continue;
            f += fArray[i];
            ++n;
        }
        if (n == 0) {
            return Float.NaN;
        }
        float f2 = f / (float)n;
        if (Float.isInfinite(f2)) {
            return Float.NaN;
        }
        return f2;
    }

    private float getVar(float[] fArray) {
        float f = this.getMean(fArray);
        int n = 0;
        float f2 = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            if (Float.isNaN(fArray[i])) continue;
            f2 = (float)((double)f2 + Math.pow(fArray[i] - f, 2.0));
            ++n;
        }
        if (n < 2) {
            return Float.NaN;
        }
        float f3 = f2 / (float)(n - 1);
        if (Float.isInfinite(f3)) {
            return Float.NaN;
        }
        return f3;
    }
}

