/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.util.FloatMatrix;
import org.tigr.util.awt.ProgressDialog;

public class QTC
extends AbstractAlgorithm {
    private boolean stop = false;
    private int function;
    private float factor;
    ProgressDialog progress;
    private int number_of_genes;
    private int number_of_samples;
    boolean useAbsolute;
    float diameter;
    int minimumClusterSize;
    Vector allClusters = new Vector();
    private double xMax;
    private double xMin;
    private int clusterSize = Integer.MAX_VALUE;
    private boolean qtcGenes;
    private FloatMatrix expMatrix;
    private JackknifedMatrixBySpecifiedExp[] jacked;
    private float[][] proximity;
    private float adjustedDiameter;
    private int hcl_function;
    private boolean hcl_absolute;

    public synchronized AlgorithmData execute(AlgorithmData algorithmData) throws AlgorithmException {
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        this.function = algorithmParameters.getInt("distance-function", 1);
        this.factor = algorithmParameters.getFloat("distance-factor", 1.0f);
        this.qtcGenes = algorithmParameters.getBoolean("qtc-cluster-genes");
        this.useAbsolute = algorithmParameters.getBoolean("use-absolute", false);
        this.diameter = algorithmParameters.getFloat("diameter", 0.2f);
        this.minimumClusterSize = algorithmParameters.getInt("min-cluster-size", 1);
        this.hcl_function = algorithmParameters.getInt("hcl-distance-function", 4);
        this.hcl_absolute = algorithmParameters.getBoolean("hcl-distance-absolute", false);
        boolean bl = algorithmParameters.getBoolean("hierarchical-tree", false);
        int n = algorithmParameters.getInt("method-linkage", 0);
        boolean bl2 = algorithmParameters.getBoolean("calculate-genes", false);
        boolean bl3 = algorithmParameters.getBoolean("calculate-experiments", false);
        this.expMatrix = algorithmData.getMatrix("experiment");
        this.number_of_genes = this.expMatrix.getRowDimension();
        this.number_of_samples = this.expMatrix.getColumnDimension();
        JFrame jFrame = new JFrame();
        this.progress = new ProgressDialog(jFrame, "QTClust -- Progress", false, 6);
        JPanel jPanel = this.progress.getLabelPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JButton jButton = new JButton("Abort");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                QTC.this.stop = true;
                QTC.this.progress.dismiss();
            }
        });
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)jButton, "South");
        this.progress.setMainPanel(jPanel2);
        AlgorithmData algorithmData2 = new AlgorithmData();
        if (this.stop) {
            algorithmData2.addParam("aborted", "true");
            return algorithmData2;
        }
        Vector[] vectorArray = this.calculate(this.useAbsolute, this.diameter, this.minimumClusterSize);
        if (this.stop) {
            algorithmData2.addParam("aborted", "true");
            return algorithmData2;
        }
        FloatMatrix floatMatrix = this.getMeans(vectorArray);
        FloatMatrix floatMatrix2 = this.getVariances(vectorArray, floatMatrix);
        AlgorithmEvent algorithmEvent = null;
        if (bl) {
            algorithmEvent = new AlgorithmEvent((Object)this, 1, vectorArray.length, "Calculate Hierarchical Trees");
            this.fireValueChanged(algorithmEvent);
            algorithmEvent.setIntValue(0);
            algorithmEvent.setId(2);
            this.fireValueChanged(algorithmEvent);
        }
        Cluster cluster = new Cluster();
        NodeList nodeList = cluster.getNodeList();
        for (int i = 0; i < vectorArray.length; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            int[] nArray = this.convert2int(vectorArray[i]);
            Node node = new Node(nArray);
            nodeList.addNode(node);
            if (!bl) continue;
            node.setValues(this.calculateHierarchicalTree(nArray, n, bl2, bl3));
            algorithmEvent.setIntValue(i + 1);
            this.fireValueChanged(algorithmEvent);
        }
        algorithmData2.addCluster("cluster", cluster);
        algorithmData2.addParam("number-of-clusters", String.valueOf(vectorArray.length));
        algorithmData2.addMatrix("clusters_means", floatMatrix);
        algorithmData2.addMatrix("clusters_variances", floatMatrix2);
        return algorithmData2;
    }

    private NodeValueList calculateHierarchicalTree(int[] nArray, int n, boolean bl, boolean bl2) throws AlgorithmException {
        AlgorithmData algorithmData;
        NodeValueList nodeValueList = new NodeValueList();
        AlgorithmData algorithmData2 = new AlgorithmData();
        FloatMatrix floatMatrix = this.qtcGenes ? this.getSubExperiment(this.expMatrix, nArray) : this.getSubExperimentReducedCols(this.expMatrix, nArray);
        algorithmData2.addMatrix("experiment", floatMatrix);
        algorithmData2.addParam("hcl-distance-function", String.valueOf(this.hcl_function));
        algorithmData2.addParam("hcl-distance-absolute", String.valueOf(this.hcl_absolute));
        algorithmData2.addParam("method-linkage", String.valueOf(n));
        HCL hCL = new HCL();
        if (bl) {
            algorithmData2.addParam("calculate-genes", String.valueOf(true));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        if (bl2) {
            algorithmData2.addParam("calculate-genes", String.valueOf(false));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        return nodeValueList;
    }

    private void addNodeValues(NodeValueList nodeValueList, AlgorithmData algorithmData) {
        nodeValueList.addNodeValue(new NodeValue("child-1-array", (Object)algorithmData.getIntArray("child-1-array")));
        nodeValueList.addNodeValue(new NodeValue("child-2-array", (Object)algorithmData.getIntArray("child-2-array")));
        nodeValueList.addNodeValue(new NodeValue("node-order", (Object)algorithmData.getIntArray("node-order")));
        nodeValueList.addNodeValue(new NodeValue("height", (Object)algorithmData.getMatrix("height").getRowPackedCopy()));
    }

    private FloatMatrix getSubExperiment(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = new FloatMatrix(nArray.length, floatMatrix.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix2.A[i] = floatMatrix.A[nArray[i]];
        }
        return floatMatrix2;
    }

    private FloatMatrix getSubExperimentReducedCols(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = floatMatrix.copy();
        FloatMatrix floatMatrix3 = new FloatMatrix(nArray.length, floatMatrix2.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix3.A[i] = floatMatrix2.A[nArray[i]];
        }
        floatMatrix3 = floatMatrix3.transpose();
        return floatMatrix3;
    }

    private void validate(AlgorithmData algorithmData) throws AlgorithmException {
        if (algorithmData.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (algorithmData.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (algorithmData.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (algorithmData.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private int[] convert2int(Vector vector) {
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        return nArray;
    }

    private FloatMatrix getMeans(Vector[] vectorArray) {
        FloatMatrix floatMatrix = new FloatMatrix(vectorArray.length, this.number_of_samples);
        for (int i = 0; i < vectorArray.length; ++i) {
            int n = vectorArray[i].size();
            for (int j = 0; j < this.number_of_samples; ++j) {
                float f = 0.0f;
                int n2 = 0;
                for (int k = 0; k < n; ++k) {
                    float f2 = this.expMatrix.get(((Integer)vectorArray[i].get(k)).intValue(), j);
                    if (Float.isNaN(f2)) continue;
                    f += f2;
                    ++n2;
                }
                floatMatrix.set(i, j, f / (float)n2);
            }
        }
        return floatMatrix;
    }

    private FloatMatrix getVariances(Vector[] vectorArray, FloatMatrix floatMatrix) {
        int n = floatMatrix.getRowDimension();
        int n2 = floatMatrix.getColumnDimension();
        FloatMatrix floatMatrix2 = new FloatMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                float f = floatMatrix.get(i, j);
                int n3 = 0;
                int n4 = vectorArray[i].size();
                float f2 = 0.0f;
                for (int k = 0; k < n4; ++k) {
                    float f3 = this.expMatrix.get(((Integer)vectorArray[i].get(k)).intValue(), j);
                    if (Float.isNaN(f3)) continue;
                    float f4 = f3 - f;
                    f2 += f4 * f4;
                    ++n3;
                }
                floatMatrix2.set(i, j, (float)Math.sqrt(f2) / (float)(n3 - 1));
            }
        }
        return floatMatrix2;
    }

    public boolean isAborted() {
        return this.stop;
    }

    synchronized float getAdjustedDiameter() {
        if (this.function == 4 || this.function == 8) {
            return (float)((double)this.diameter * this.getMaximumDistance());
        }
        if (!this.useAbsolute && this.function == 1 || this.function == 9 || this.function == 10 || this.function == 11 || this.function == 6 || this.function == 2) {
            return 2.0f * this.diameter;
        }
        return this.diameter;
    }

    private double getMaximumDistance() {
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.number_of_genes; ++i) {
            for (int j = 0; j < this.number_of_genes; ++j) {
                double d2;
                if (j == i || !(d < (d2 = this.getDistance(this.expMatrix, i, j)))) continue;
                d = d2;
            }
        }
        return d;
    }

    private double getDistance(FloatMatrix floatMatrix, int n, int n2) {
        double d = 0.0;
        if (this.function == 1) {
            d = ExperimentUtil.genePearson(floatMatrix, null, n, n2, this.factor);
        } else if (this.function == 9) {
            d = ExperimentUtil.geneSpearmanRank(floatMatrix, null, n, n2, this.factor);
        } else if (this.function == 10) {
            d = ExperimentUtil.geneKendallsTau(floatMatrix, null, n, n2, this.factor);
        } else if (this.function == 2) {
            d = ExperimentUtil.geneCosine(floatMatrix, null, n, n2, this.factor);
        } else if (this.function == 11) {
            d = ExperimentUtil.geneMutualInformation(floatMatrix, null, n, n2, this.factor);
        } else if (this.function == 6) {
            d = ExperimentUtil.genePearsonUncentered(floatMatrix, null, n, n2, this.factor);
        } else if (this.function == 7) {
            float f = ExperimentUtil.genePearson(floatMatrix, null, n, n2, this.factor);
            d = f * f;
        } else if (this.function == 4 || this.function == 8) {
            d = ExperimentUtil.geneDistance(floatMatrix, null, n, n2, this.function, this.factor, this.useAbsolute);
        } else if (this.function == 3) {
            double d2 = ExperimentUtil.geneCovariance(floatMatrix, null, n, n2, this.factor);
            if (this.useAbsolute) {
                d2 = Math.abs(d2);
            }
            d = (this.xMax - d2) / (this.xMax - this.xMin);
        } else if (this.function == 5) {
            double d3 = ExperimentUtil.geneDotProduct(floatMatrix, null, n, n2, this.factor);
            if (this.useAbsolute) {
                d3 = Math.abs(d3);
            }
            d = (this.xMax - d3) / (this.xMax - this.xMin);
        }
        if (this.function == 1 || this.function == 9 || this.function == 10 || this.function == 2 || this.function == 11 || this.function == 6 || this.function == 7) {
            d = this.useAbsolute ? 1.0 - Math.abs(d) : 1.0 - d;
        }
        return d;
    }

    private double getMaxCovarOrDotProd() {
        double d = Double.NEGATIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.number_of_genes; ++i) {
            for (int j = 0; j < this.number_of_genes; ++j) {
                if (j == i) continue;
                if (this.function == 5) {
                    d2 = ExperimentUtil.geneDotProduct(this.expMatrix, null, i, j, this.factor);
                    if (this.useAbsolute) {
                        d2 = Math.abs(d2);
                    }
                } else if (this.function == 3) {
                    d2 = ExperimentUtil.geneCovariance(this.expMatrix, null, i, j, this.factor);
                    if (this.useAbsolute) {
                        d2 = Math.abs(d2);
                    }
                }
                if (!(d < d2)) continue;
                d = d2;
            }
        }
        return d;
    }

    private double getMinCovOrDotProd() {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.number_of_genes; ++i) {
            for (int j = 0; j < this.number_of_genes; ++j) {
                if (j == i) continue;
                if (this.function == 5) {
                    d2 = ExperimentUtil.geneDotProduct(this.expMatrix, null, i, j, this.factor);
                    if (this.useAbsolute) {
                        d2 = Math.abs(d2);
                    }
                } else if (this.function == 3) {
                    d2 = ExperimentUtil.geneCovariance(this.expMatrix, null, i, j, this.factor);
                    if (this.useAbsolute) {
                        d2 = Math.abs(d2);
                    }
                }
                if (!(d > d2)) continue;
                d = d2;
            }
        }
        return d;
    }

    public void setMinMaxCovOrDotProd() {
        this.xMax = this.getMaxCovarOrDotProd();
        this.xMin = this.getMinCovOrDotProd();
    }

    private Vector getAllClusters(Vector vector) {
        if (this.stop) {
            return null;
        }
        do {
            Vector vector2 = this.getLargestCluster(vector);
            this.allClusters.add(vector2);
            int n = vector2.size();
            this.progress.setMessage(4, "# of assigned genes: " + (this.number_of_genes - vector.size()));
            this.progress.setMessage(5, "# of genes not yet assigned: " + vector.size());
            this.progress.setMessage(2, "# of clusters formed: " + this.allClusters.size());
            this.progress.setMessage(3, "size of last cluster formed: " + vector2.size());
            vector.removeAll(vector2);
            if (n >= this.minimumClusterSize) continue;
            vector2.addAll(vector);
            return this.allClusters;
        } while (vector.size() != 0);
        this.allClusters.add(new Vector());
        return this.allClusters;
    }

    private Vector getClusterForAGene(Integer n, Vector vector) {
        int n2;
        Vector<Integer> vector2 = new Vector<Integer>();
        vector2.add(n);
        Integer n3 = n;
        int n4 = n;
        float[] fArray = new float[this.number_of_genes];
        for (n2 = 0; n2 < vector.size(); ++n2) {
            fArray[((Integer)vector.get((int)n2)).intValue()] = Float.NEGATIVE_INFINITY;
        }
        while (true) {
            n2 = -1;
            float f = Float.POSITIVE_INFINITY;
            int n5 = 0;
            while (n5 < vector.size()) {
                int n6 = (Integer)vector.get(n5);
                fArray[n6] = Math.max(this.proximity[n6][n4], fArray[n6]);
                if (fArray[n6] > this.adjustedDiameter) {
                    vector.remove(n5);
                    continue;
                }
                if (fArray[n6] < f) {
                    f = fArray[n6];
                    n2 = n5;
                }
                ++n5;
            }
            if (n2 == -1) break;
            n3 = (Integer)vector.remove(n2);
            n4 = n3;
            vector2.add(n3);
        }
        return vector2;
    }

    private double getJackknifeDistance(int n, int n2) {
        JackknifedMatrixBySpecifiedExp jackknifedMatrixBySpecifiedExp = null;
        double d = Math.abs(this.getDistance(this.expMatrix, n, n2));
        for (int i = 0; i < this.number_of_samples; ++i) {
            jackknifedMatrixBySpecifiedExp = this.jacked[i];
            double d2 = this.getDistance(jackknifedMatrixBySpecifiedExp, n, n2);
            d = this.useAbsolute ? Math.max(d, Math.abs(d2)) : Math.max(d, d2);
        }
        return d;
    }

    private Vector getLargestCluster(Vector vector) {
        int n;
        Vector<Vector> vector2 = new Vector<Vector>();
        int n2 = 0;
        for (n = 0; n < vector.size(); ++n) {
            Vector vector3 = (Vector)vector.clone();
            Integer n3 = (Integer)vector3.remove(n);
            Vector vector4 = this.getClusterForAGene(n3, vector3);
            if (vector4.size() == n2) {
                vector2.add(vector4);
                continue;
            }
            if (vector4.size() <= n2) continue;
            vector2.clear();
            vector2.add(vector4);
            n2 = vector4.size();
        }
        n = (int)(Math.random() * (double)vector2.size());
        return (Vector)vector2.get(n);
    }

    public void abort() {
        this.stop = true;
    }

    private Vector[] calculate(boolean bl, float f, int n) throws AlgorithmException {
        int n2;
        if (this.stop) {
            return null;
        }
        if (this.function == 3 || this.function == 5) {
            this.setMinMaxCovOrDotProd();
        }
        this.progress.setMessage(0, "<html><p>Distance: " + AbstractAlgorithm.getDistanceName((int)this.function) + "<p>Absolute? " + (bl ? "Yes" : "No") + "<p>Minimum cluster size: " + n + "<p>Threshold diameter: " + f + "</html>");
        this.progress.setTimerLabel(1, "Running for ", " seconds.", 1000);
        this.progress.setMessage(2, "# of clusters formed: 0");
        this.progress.setMessage(3, "size of last cluster formed: 0");
        this.progress.setMessage(4, "# of assigned genes: 0");
        this.progress.setMessage(5, "# of genes not yet assigned: " + this.number_of_genes);
        this.progress.setVisible(true);
        if (this.stop) {
            return null;
        }
        this.adjustedDiameter = this.getAdjustedDiameter();
        this.jacked = new JackknifedMatrixBySpecifiedExp[this.number_of_samples];
        for (n2 = 0; n2 < this.jacked.length; ++n2) {
            this.jacked[n2] = new JackknifedMatrixBySpecifiedExp(this.expMatrix, n2);
        }
        this.proximity = new float[this.number_of_genes][this.number_of_genes];
        for (n2 = 0; n2 < this.number_of_genes; ++n2) {
            for (int i = 0; i <= n2; ++i) {
                this.proximity[n2][i] = (float)this.getJackknifeDistance(n2, i);
                this.proximity[i][n2] = this.proximity[n2][i];
            }
        }
        this.jacked = null;
        Vector<Integer> vector = new Vector<Integer>();
        Vector vector2 = new Vector();
        vector = new Vector();
        for (int i = 0; i < this.number_of_genes; ++i) {
            vector.add(new Integer(i));
        }
        if (this.stop) {
            return null;
        }
        long l = System.currentTimeMillis();
        vector2 = this.getAllClusters(vector);
        if (this.stop) {
            return null;
        }
        this.progress.dismiss();
        long l2 = System.currentTimeMillis() - l;
        Vector[] vectorArray = vector2.toArray(new Vector[vector2.size()]);
        return vectorArray;
    }

    private class JackknifedMatrixBySpecifiedExp
    extends FloatMatrix {
        FloatMatrix origMatrix;
        int removedExperiment;

        public JackknifedMatrixBySpecifiedExp(FloatMatrix floatMatrix, int n) {
            super(floatMatrix.m, floatMatrix.n - 1);
            this.origMatrix = floatMatrix;
            this.removedExperiment = n;
            for (int i = 0; i < this.m; ++i) {
                int n2 = 0;
                for (int j = 0; j < floatMatrix.n; ++j) {
                    if (j == n) continue;
                    this.A[i][n2] = floatMatrix.A[i][j];
                    ++n2;
                }
            }
        }
    }
}

