/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import JSci.maths.statistics.TDistribution;
import java.util.Vector;
import javax.swing.JButton;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.util.FloatMatrix;

public class PavlidisTemplateMatching
extends AbstractAlgorithm {
    private boolean stop = false;
    private int function;
    private float factor;
    private boolean absolute;
    private int number_of_genes;
    private int number_of_samples;
    private FloatMatrix expMatrix;
    private FloatMatrix newMatrix;
    private long StartTime;
    private long CalculationTime;
    private boolean ptmGenes;
    private double[] pValues;
    private double[] rValues;
    boolean useAbsolute;
    boolean useR;
    boolean drawSigTreesOnly;
    JButton abortButton;
    Vector templateVector;
    FloatMatrix templateVectorMatrix;
    float[] geneTemplate;
    float threshold;
    int origNumGenes;
    int numSamples;
    private int hcl_function;
    private boolean hcl_absolute;
    int validN;

    public AlgorithmData execute(AlgorithmData algorithmData) throws AlgorithmException {
        Node node;
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        this.function = algorithmParameters.getInt("distance-function", 4);
        this.factor = algorithmParameters.getFloat("distance-factor", 1.0f);
        this.absolute = algorithmParameters.getBoolean("distance-absolute", false);
        this.hcl_function = algorithmParameters.getInt("hcl-distance-function", 4);
        this.hcl_absolute = algorithmParameters.getBoolean("hcl-distance-absolute", false);
        this.ptmGenes = algorithmParameters.getBoolean("ptm-cluster-genes", true);
        this.threshold = algorithmParameters.getFloat("threshold", 0.8f);
        this.useAbsolute = algorithmParameters.getBoolean("use-absolute", false);
        this.useR = algorithmParameters.getBoolean("useR", false);
        this.templateVectorMatrix = algorithmData.getMatrix("templateVectorMatrix");
        this.templateVector = this.convertToVector(this.templateVectorMatrix);
        boolean bl = algorithmParameters.getBoolean("hierarchical-tree", false);
        if (bl) {
            this.drawSigTreesOnly = algorithmParameters.getBoolean("draw-sig-trees-only");
        }
        int n = algorithmParameters.getInt("method-linkage", 0);
        boolean bl2 = algorithmParameters.getBoolean("calculate-genes", false);
        boolean bl3 = algorithmParameters.getBoolean("calculate-experiments", false);
        this.expMatrix = algorithmData.getMatrix("experiment");
        this.number_of_genes = this.expMatrix.getRowDimension();
        this.number_of_samples = this.expMatrix.getColumnDimension();
        this.origNumGenes = this.expMatrix.getRowDimension();
        this.numSamples = this.expMatrix.getColumnDimension();
        this.geneTemplate = new float[this.templateVector.size()];
        this.pValues = new double[this.number_of_genes];
        this.rValues = new double[this.number_of_genes];
        for (int i = 0; i < this.templateVector.size(); ++i) {
            this.geneTemplate[i] = ((Float)this.templateVector.get(i)).floatValue();
        }
        Vector[] vectorArray = this.calculate();
        FloatMatrix floatMatrix = this.getMeans(vectorArray);
        FloatMatrix floatMatrix2 = this.getVariances(vectorArray, floatMatrix);
        AlgorithmEvent algorithmEvent = null;
        if (bl) {
            algorithmEvent = new AlgorithmEvent((Object)this, 1, vectorArray.length, "Calculate Hierarchical Trees");
            this.fireValueChanged(algorithmEvent);
            algorithmEvent.setIntValue(0);
            algorithmEvent.setId(2);
            this.fireValueChanged(algorithmEvent);
        }
        Cluster cluster = new Cluster();
        NodeList nodeList = cluster.getNodeList();
        for (int i = 0; i < vectorArray.length; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            int[] nArray = this.convert2int(vectorArray[i]);
            node = new Node(nArray);
            nodeList.addNode(node);
            if (!bl) continue;
            if (this.drawSigTreesOnly) {
                if (i != 0) continue;
                node.setValues(this.calculateHierarchicalTree(nArray, n, bl2, bl3));
                algorithmEvent.setIntValue(i + 1);
                this.fireValueChanged(algorithmEvent);
                continue;
            }
            node.setValues(this.calculateHierarchicalTree(nArray, n, bl2, bl3));
            algorithmEvent.setIntValue(i + 1);
            this.fireValueChanged(algorithmEvent);
        }
        FloatMatrix floatMatrix3 = new FloatMatrix(this.number_of_genes, 1);
        node = new FloatMatrix(this.number_of_genes, 1);
        for (int i = 0; i < this.pValues.length; ++i) {
            floatMatrix3.A[i][0] = (float)this.rValues[i];
            node.A[i][0] = (float)this.pValues[i];
        }
        AlgorithmData algorithmData2 = new AlgorithmData();
        algorithmData2.addCluster("cluster", cluster);
        algorithmData2.addMatrix("clusters_means", floatMatrix);
        algorithmData2.addMatrix("clusters_variances", floatMatrix2);
        algorithmData2.addMatrix("rValuesMatrix", floatMatrix3);
        algorithmData2.addMatrix("pValuesMatrix", (FloatMatrix)node);
        return algorithmData2;
    }

    private NodeValueList calculateHierarchicalTree(int[] nArray, int n, boolean bl, boolean bl2) throws AlgorithmException {
        AlgorithmData algorithmData;
        NodeValueList nodeValueList = new NodeValueList();
        AlgorithmData algorithmData2 = new AlgorithmData();
        FloatMatrix floatMatrix = this.ptmGenes ? this.getSubExperiment(this.expMatrix, nArray) : this.getSubExperimentReducedCols(this.expMatrix, nArray);
        algorithmData2.addMatrix("experiment", floatMatrix);
        algorithmData2.addParam("hcl-distance-function", String.valueOf(this.hcl_function));
        algorithmData2.addParam("hcl-distance-absolute", String.valueOf(this.hcl_absolute));
        algorithmData2.addParam("method-linkage", String.valueOf(n));
        HCL hCL = new HCL();
        if (bl) {
            algorithmData2.addParam("calculate-genes", String.valueOf(true));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        if (bl2) {
            algorithmData2.addParam("calculate-genes", String.valueOf(false));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        return nodeValueList;
    }

    private void addNodeValues(NodeValueList nodeValueList, AlgorithmData algorithmData) {
        nodeValueList.addNodeValue(new NodeValue("child-1-array", (Object)algorithmData.getIntArray("child-1-array")));
        nodeValueList.addNodeValue(new NodeValue("child-2-array", (Object)algorithmData.getIntArray("child-2-array")));
        nodeValueList.addNodeValue(new NodeValue("node-order", (Object)algorithmData.getIntArray("node-order")));
        nodeValueList.addNodeValue(new NodeValue("height", (Object)algorithmData.getMatrix("height").getRowPackedCopy()));
    }

    private FloatMatrix getSubExperiment(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = new FloatMatrix(nArray.length, floatMatrix.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix2.A[i] = floatMatrix.A[nArray[i]];
        }
        return floatMatrix2;
    }

    private FloatMatrix getSubExperimentReducedCols(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = floatMatrix.copy();
        FloatMatrix floatMatrix3 = new FloatMatrix(nArray.length, floatMatrix2.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix3.A[i] = floatMatrix2.A[nArray[i]];
        }
        floatMatrix3 = floatMatrix3.transpose();
        return floatMatrix3;
    }

    private void validate(AlgorithmData algorithmData) throws AlgorithmException {
        if (algorithmData.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (algorithmData.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (algorithmData.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (algorithmData.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private int[] convert2int(Vector vector) {
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        return nArray;
    }

    public void abort() {
        this.stop = true;
    }

    private Vector convertToVector(FloatMatrix floatMatrix) {
        Vector<Float> vector = new Vector<Float>();
        for (int i = 0; i < floatMatrix.A[0].length; ++i) {
            vector.add(new Float(floatMatrix.A[0][i]));
        }
        return vector;
    }

    public Vector itf(Vector vector) {
        Vector<Float> vector2 = new Vector<Float>();
        for (int i = 0; i < vector.size(); ++i) {
            vector2.addElement(new Float(((Integer)vector.elementAt(i)).intValue()));
        }
        return vector2;
    }

    Vector[] calculate() {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < this.origNumGenes; ++i) {
            vector.add(new Integer(i));
        }
        Vector vector2 = (Vector)vector.clone();
        this.StartTime = System.currentTimeMillis();
        Vector vector3 = this.findSimilarGenes();
        vector2.removeAll(vector3);
        this.CalculationTime = System.currentTimeMillis() - this.StartTime;
        Vector[] vectorArray = new Vector[]{vector3, vector2};
        return vectorArray;
    }

    FloatMatrix addTemplateToexpMatrix() {
        int n;
        FloatMatrix floatMatrix = new FloatMatrix(this.origNumGenes + 1, this.numSamples);
        for (n = 0; n < this.origNumGenes; ++n) {
            for (int i = 0; i < this.numSamples; ++i) {
                floatMatrix.A[n][i] = this.expMatrix.A[n][i];
            }
        }
        for (n = 0; n < this.geneTemplate.length; ++n) {
            floatMatrix.A[this.origNumGenes][n] = this.geneTemplate[n];
        }
        return floatMatrix;
    }

    Vector findSimilarGenes() {
        int n;
        Vector vector = new Vector();
        this.newMatrix = this.addTemplateToexpMatrix();
        Vector<Integer> vector2 = new Vector<Integer>();
        for (n = 0; n < this.origNumGenes; ++n) {
            vector2.add(new Integer(n));
        }
        for (n = 0; n < this.origNumGenes; ++n) {
            double d;
            this.rValues[n] = d = (double)ExperimentUtil.genePearson(this.newMatrix, null, n, this.origNumGenes, this.factor);
            this.pValues[n] = this.getProb(d);
            if (this.useR) {
                if (this.useAbsolute) {
                    if (!((d = Math.abs(d)) >= (double)this.threshold)) continue;
                    vector.add(vector2.elementAt(n));
                    continue;
                }
                if (!(d >= (double)this.threshold)) continue;
                vector.add(vector2.elementAt(n));
                continue;
            }
            if (this.useAbsolute) {
                if (!(this.getProb(d) <= (double)this.threshold)) continue;
                vector.add(vector2.elementAt(n));
                continue;
            }
            if (!(d > 0.0) || !(this.getProb(d) <= (double)this.threshold)) continue;
            vector.add(vector2.elementAt(n));
        }
        return vector;
    }

    double getProb(double d) {
        int n = this.geneTemplate.length - 2;
        TDistribution tDistribution = new TDistribution(n);
        double d2 = this.getTValue(Math.abs(d));
        double d3 = 2.0 * (1.0 - tDistribution.cumulative(d2));
        if (d3 > 1.0) {
            d3 = 1.0;
        }
        return d3;
    }

    double getTValue(double d) {
        int n = this.geneTemplate.length;
        double d2 = Math.sqrt((1.0 - d * d) / (double)(n - 2));
        double d3 = d / d2;
        return d3;
    }

    private FloatMatrix getMeans(Vector[] vectorArray) {
        FloatMatrix floatMatrix = new FloatMatrix(vectorArray.length, this.number_of_samples);
        for (int i = 0; i < vectorArray.length; ++i) {
            FloatMatrix floatMatrix2 = this.getMean(vectorArray[i]);
            floatMatrix.A[i] = floatMatrix2.A[0];
        }
        return floatMatrix;
    }

    private FloatMatrix getMean(Vector vector) {
        FloatMatrix floatMatrix = new FloatMatrix(1, this.number_of_samples);
        int n = vector.size();
        int n2 = 0;
        for (int i = 0; i < this.number_of_samples; ++i) {
            float f = 0.0f;
            n2 = 0;
            for (int j = 0; j < n; ++j) {
                float f2 = this.expMatrix.get(((Integer)vector.get(j)).intValue(), i);
                if (Float.isNaN(f2)) continue;
                f += f2;
                ++n2;
            }
            floatMatrix.set(0, i, f / (float)n2);
        }
        return floatMatrix;
    }

    private FloatMatrix getVariances(Vector[] vectorArray, FloatMatrix floatMatrix) {
        int n = floatMatrix.getRowDimension();
        int n2 = floatMatrix.getColumnDimension();
        FloatMatrix floatMatrix2 = new FloatMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                floatMatrix2.set(i, j, this.getSampleVariance(vectorArray[i], j, floatMatrix.get(i, j)));
            }
        }
        return floatMatrix2;
    }

    private float getSampleNormalizedSum(Vector vector, int n, float f) {
        int n2 = vector.size();
        float f2 = 0.0f;
        this.validN = 0;
        for (int i = 0; i < n2; ++i) {
            float f3 = this.expMatrix.get(((Integer)vector.get(i)).intValue(), n);
            if (Float.isNaN(f3)) continue;
            f2 = (float)((double)f2 + Math.pow(f3 - f, 2.0));
            ++this.validN;
        }
        return f2;
    }

    private float getSampleVariance(Vector vector, int n, float f) {
        return (float)Math.sqrt(this.getSampleNormalizedSum(vector, n, f) / (float)(this.validN - 1));
    }
}

