/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.util.Random;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.util.FloatMatrix;
import org.tigr.util.QSort;

public class KNNClassify
extends AbstractAlgorithm {
    private boolean stop = false;
    private int function;
    private float factor;
    private boolean absolute;
    private FloatMatrix expMatrix;
    private Vector[] clusters;
    private Vector[] filteredClassifiersByClass;
    private int k;
    private int numRows;
    private int numCols;
    private int usedNumNeibs;
    private boolean validate;
    private boolean classifyGenes;
    private boolean useVarianceFilter;
    private boolean useCorrelFilter;
    private int numClasses;
    private int numVarFilteredVectors;
    private int numNeighbors;
    private int numPerms;
    private int postVarClassSetSize;
    private int postVarDataSetSize;
    private int postCorrDataSetSize;
    private int origDataSetSize;
    private int origClassSetSize;
    private double correlPValue;
    private int[] classIndices;
    private int[] classes;
    private Vector rowsInAnalysis;
    private Vector filteredClassifierSet;
    private Vector filteredClasses;
    private int hcl_function;
    private boolean hcl_absolute;
    int validN;

    public AlgorithmData execute(AlgorithmData algorithmData) throws AlgorithmException {
        int n;
        int n2;
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        this.function = algorithmParameters.getInt("distance-function", 4);
        this.factor = algorithmParameters.getFloat("distance-factor", 1.0f);
        this.absolute = algorithmParameters.getBoolean("distance-absolute", false);
        boolean bl = algorithmParameters.getBoolean("hierarchical-tree", false);
        int n3 = algorithmParameters.getInt("method-linkage", 0);
        boolean bl2 = algorithmParameters.getBoolean("calculate-genes", false);
        boolean bl3 = algorithmParameters.getBoolean("calculate-experiments", false);
        this.hcl_function = algorithmParameters.getInt("hcl-distance-function", 4);
        this.hcl_absolute = algorithmParameters.getBoolean("hcl-distance-absolute", false);
        this.expMatrix = algorithmData.getMatrix("experiment");
        this.numRows = this.expMatrix.getRowDimension();
        this.numCols = this.expMatrix.getColumnDimension();
        this.validate = algorithmParameters.getBoolean("validate", false);
        if (!this.validate) {
            int n4;
            int n5;
            int n6;
            Object[] objectArray;
            Vector[] vectorArray;
            int n7;
            this.classifyGenes = algorithmParameters.getBoolean("classifyGenes", true);
            this.useVarianceFilter = algorithmParameters.getBoolean("useVarianceFilter", false);
            this.useCorrelFilter = algorithmParameters.getBoolean("useCorrelFilter", false);
            if (this.useCorrelFilter) {
                this.correlPValue = algorithmParameters.getFloat("correlPValue", 0.01f);
                this.numPerms = algorithmParameters.getInt("numPerms", 1000);
            }
            this.numClasses = algorithmParameters.getInt("numClasses", 5);
            this.numNeighbors = algorithmParameters.getInt("numNeighbors", 3);
            this.classIndices = algorithmData.getIntArray("classIndices");
            this.classes = algorithmData.getIntArray("classes");
            this.numVarFilteredVectors = algorithmParameters.getInt("numVarFilteredVectors", this.numRows);
            AlgorithmEvent algorithmEvent = new AlgorithmEvent((Object)this, 1, this.numRows);
            this.fireValueChanged(algorithmEvent);
            algorithmEvent.setId(2);
            this.rowsInAnalysis = new Vector();
            for (n7 = 0; n7 < this.numRows; ++n7) {
                this.rowsInAnalysis.add(new Integer(n7));
            }
            this.filteredClassifierSet = new Vector();
            this.filteredClasses = new Vector();
            for (n7 = 0; n7 < this.classIndices.length; ++n7) {
                this.filteredClassifierSet.add(new Integer(this.classIndices[n7]));
                this.filteredClasses.add(new Integer(this.classes[n7]));
            }
            this.origDataSetSize = this.rowsInAnalysis.size();
            this.origClassSetSize = this.filteredClassifierSet.size();
            if (this.useVarianceFilter) {
                double[] dArray = new double[this.rowsInAnalysis.size()];
                for (int i = 0; i < dArray.length; ++i) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    algorithmEvent.setIntValue(i);
                    algorithmEvent.setDescription("Calculating variance of element = " + (i + 1));
                    this.fireValueChanged(algorithmEvent);
                    dArray[i] = this.getVar(i);
                }
                vectorArray = new QSort(dArray);
                int[] nArray = vectorArray.getOrigIndx();
                objectArray = this.reverse(nArray);
                this.rowsInAnalysis = new Vector();
                for (n6 = 0; n6 < this.numVarFilteredVectors; ++n6) {
                    this.rowsInAnalysis.add(new Integer(objectArray[n6]));
                }
                this.filteredClassifierSet = new Vector();
                this.filteredClasses = new Vector();
                for (n6 = 0; n6 < this.classIndices.length; ++n6) {
                    if (!this.isFoundInVector(this.classIndices[n6], this.rowsInAnalysis)) continue;
                    this.filteredClassifierSet.add(new Integer(this.classIndices[n6]));
                    this.filteredClasses.add(new Integer(this.classes[n6]));
                }
            }
            for (int i = 0; i < this.classIndices.length; ++i) {
                if (!this.isFoundInVector(this.classIndices[i], this.rowsInAnalysis)) continue;
                this.rowsInAnalysis.remove(new Integer(this.classIndices[i]));
            }
            this.postVarDataSetSize = this.rowsInAnalysis.size();
            this.postVarClassSetSize = this.filteredClassifierSet.size();
            AlgorithmEvent algorithmEvent2 = new AlgorithmEvent((Object)this, 1, this.rowsInAnalysis.size());
            this.fireValueChanged(algorithmEvent2);
            algorithmEvent2.setId(2);
            if (this.useCorrelFilter) {
                int n8;
                vectorArray = new Vector();
                for (n8 = 0; n8 < this.rowsInAnalysis.size(); ++n8) {
                    if (this.stop) {
                        throw new AbortException();
                    }
                    algorithmEvent2.setIntValue(n8);
                    algorithmEvent2.setDescription("Applying correlation filter: element " + (n8 + 1));
                    this.fireValueChanged(algorithmEvent2);
                    int n9 = (Integer)this.rowsInAnalysis.get(n8);
                    Random random = new Random();
                    if (!this.passesCorrelationFilter(n9, this.filteredClassifierSet, this.correlPValue, this.numPerms, random.nextLong())) continue;
                    vectorArray.add(new Integer(n9));
                }
                this.rowsInAnalysis = new Vector();
                for (n8 = 0; n8 < vectorArray.size(); ++n8) {
                    this.rowsInAnalysis.add((Integer)vectorArray.get(n8));
                }
            }
            this.postCorrDataSetSize = this.rowsInAnalysis.size();
            vectorArray = new Vector[this.numClasses + 1];
            for (n5 = 0; n5 < vectorArray.length; ++n5) {
                vectorArray[n5] = new Vector();
            }
            this.filteredClassifiersByClass = new Vector[this.numClasses + 1];
            for (n5 = 0; n5 < this.numClasses + 1; ++n5) {
                this.filteredClassifiersByClass[n5] = new Vector();
            }
            for (n5 = 0; n5 < this.filteredClassifierSet.size(); ++n5) {
                int n10 = (Integer)this.filteredClassifierSet.get(n5);
                n6 = (Integer)this.filteredClasses.get(n5);
                this.filteredClassifiersByClass[n6].add(new Integer(n10));
            }
            for (n5 = 0; n5 < this.rowsInAnalysis.size(); ++n5) {
                int n11 = (Integer)this.rowsInAnalysis.get(n5);
                n6 = this.getClassification(n11, this.numNeighbors);
                vectorArray[n6].add(new Integer(n11));
            }
            for (n5 = 0; n5 < this.numRows; ++n5) {
                if (this.rowsInAnalysis.contains(new Integer(n5)) || this.filteredClassifierSet.contains(new Integer(n5))) continue;
                vectorArray[0].add(new Integer(n5));
            }
            Vector[] vectorArray2 = new Vector[this.numClasses + 1];
            objectArray = new Vector[this.numClasses + 1];
            for (n6 = 1; n6 < vectorArray2.length; ++n6) {
                vectorArray2[n6] = new Vector();
                objectArray[n6] = (int)new Vector();
            }
            for (n6 = 0; n6 < this.classIndices.length; ++n6) {
                if (!this.isFoundInVector(this.classIndices[n6], this.filteredClassifierSet)) {
                    vectorArray2[this.classes[n6]].add(new Integer(this.classIndices[n6]));
                    continue;
                }
                objectArray[this.classes[n6]].add(new Integer(this.classIndices[n6]));
            }
            Vector[] vectorArray3 = new Vector[this.numClasses + 1];
            for (n4 = 1; n4 < vectorArray3.length; ++n4) {
                int n12;
                vectorArray3[n4] = new Vector();
                for (n12 = 0; n12 < objectArray[n4].size(); ++n12) {
                    vectorArray3[n4].add((Integer)objectArray[n4].get(n12));
                }
                for (n12 = 0; n12 < vectorArray[n4].size(); ++n12) {
                    vectorArray3[n4].add((Integer)vectorArray[n4].get(n12));
                }
            }
            this.clusters = new Vector[this.numClasses * 4 + 1];
            for (n4 = 1; n4 <= this.numClasses; ++n4) {
                this.clusters[n4 - 1] = (Vector)objectArray[n4];
                this.clusters[n4 - 1 + this.numClasses] = vectorArray2[n4];
                this.clusters[n4 - 1 + 2 * this.numClasses] = vectorArray[n4];
                this.clusters[n4 - 1 + 3 * this.numClasses] = vectorArray3[n4];
            }
            this.clusters[this.numClasses * 4] = vectorArray[0];
            int[][] nArray = this.getCrossValidationStats();
            int[] nArray2 = nArray[0];
            int[] nArray3 = nArray[1];
            int[] nArray4 = new int[this.numClasses + 1];
            for (int i = 0; i < nArray4.length; ++i) {
                nArray4[i] = this.filteredClassifiersByClass[i].size();
            }
            FloatMatrix floatMatrix = this.getMeans(this.clusters);
            FloatMatrix floatMatrix2 = this.getVariances(this.clusters, floatMatrix);
            AlgorithmEvent algorithmEvent3 = null;
            if (bl) {
                algorithmEvent3 = new AlgorithmEvent((Object)this, 1, this.clusters.length, "Calculate Hierarchical Trees");
                this.fireValueChanged(algorithmEvent3);
                algorithmEvent3.setIntValue(0);
                algorithmEvent3.setId(2);
                this.fireValueChanged(algorithmEvent3);
            }
            Cluster cluster = new Cluster();
            NodeList nodeList = cluster.getNodeList();
            for (int i = 0; i < this.clusters.length; ++i) {
                if (this.stop) {
                    throw new AbortException();
                }
                int[] nArray5 = this.convert2int(this.clusters[i]);
                Node node = new Node(nArray5);
                nodeList.addNode(node);
                if (!bl) continue;
                node.setValues(this.calculateHierarchicalTree(nArray5, n3, bl2, bl3));
                algorithmEvent.setIntValue(i + 1);
                this.fireValueChanged(algorithmEvent);
            }
            AlgorithmData algorithmData2 = new AlgorithmData();
            algorithmData2.addParam("usedNumNeibs", String.valueOf(this.usedNumNeibs));
            algorithmData2.addParam("origDataSetSize", String.valueOf(this.origDataSetSize));
            algorithmData2.addParam("origClassSetSize", String.valueOf(this.origClassSetSize));
            if (this.useVarianceFilter) {
                algorithmData2.addParam("postVarDataSetSize", String.valueOf(this.postVarDataSetSize));
                algorithmData2.addParam("postVarClassSetSize", String.valueOf(this.postVarClassSetSize));
            }
            if (this.useCorrelFilter) {
                algorithmData2.addParam("postCorrDataSetSize", String.valueOf(this.postCorrDataSetSize));
            }
            algorithmData2.addIntArray("origNumInFiltTrgSetByClass", nArray4);
            algorithmData2.addIntArray("numberCorrectlyClassifiedByClass", nArray2);
            algorithmData2.addIntArray("numberIncorrectlyClassifiedByClass", nArray3);
            algorithmData2.addCluster("cluster", cluster);
            algorithmData2.addMatrix("clusters_means", floatMatrix);
            algorithmData2.addMatrix("clusters_variances", floatMatrix2);
            return algorithmData2;
        }
        this.classifyGenes = algorithmParameters.getBoolean("classifyGenes", true);
        this.useCorrelFilter = algorithmParameters.getBoolean("useCorrelFilter", false);
        if (this.useCorrelFilter) {
            this.correlPValue = algorithmParameters.getFloat("correlPValue", 0.01f);
            this.numPerms = algorithmParameters.getInt("numPerms", 1000);
        }
        this.numClasses = algorithmParameters.getInt("numClasses", 5);
        this.numNeighbors = algorithmParameters.getInt("numNeighbors", 3);
        this.classIndices = algorithmData.getIntArray("classIndices");
        this.classes = algorithmData.getIntArray("classes");
        this.filteredClassifierSet = new Vector();
        this.filteredClasses = new Vector();
        for (n2 = 0; n2 < this.classIndices.length; ++n2) {
            this.filteredClassifierSet.add(new Integer(this.classIndices[n2]));
            this.filteredClasses.add(new Integer(this.classes[n2]));
        }
        this.origClassSetSize = this.filteredClassifierSet.size();
        this.filteredClassifiersByClass = new Vector[this.numClasses + 1];
        for (n2 = 0; n2 < this.numClasses + 1; ++n2) {
            this.filteredClassifiersByClass[n2] = new Vector();
        }
        for (n2 = 0; n2 < this.filteredClassifierSet.size(); ++n2) {
            int n13 = (Integer)this.filteredClassifierSet.get(n2);
            int n14 = (Integer)this.filteredClasses.get(n2);
            this.filteredClassifiersByClass[n14].add(new Integer(n13));
        }
        int[][] nArray = this.getCrossValidationStats();
        int[] nArray6 = nArray[0];
        int[] nArray7 = nArray[1];
        int[] nArray8 = new int[this.numClasses + 1];
        for (int i = 0; i < nArray8.length; ++i) {
            nArray8[i] = this.filteredClassifiersByClass[i].size();
        }
        Vector<Integer> vector = new Vector<Integer>();
        for (n = 0; n < this.numRows; ++n) {
            vector.add(new Integer(n));
        }
        vector.removeAll(this.filteredClassifierSet);
        this.clusters = new Vector[this.numClasses + 1];
        this.clusters[0] = vector;
        for (n = 1; n < this.numClasses + 1; ++n) {
            this.clusters[n] = this.filteredClassifiersByClass[n];
        }
        FloatMatrix floatMatrix = this.getMeans(this.clusters);
        FloatMatrix floatMatrix3 = this.getVariances(this.clusters, floatMatrix);
        AlgorithmEvent algorithmEvent = null;
        if (bl) {
            algorithmEvent = new AlgorithmEvent((Object)this, 1, this.clusters.length, "Calculate Hierarchical Trees");
            this.fireValueChanged(algorithmEvent);
            algorithmEvent.setIntValue(0);
            algorithmEvent.setId(2);
            this.fireValueChanged(algorithmEvent);
        }
        AlgorithmEvent algorithmEvent4 = new AlgorithmEvent((Object)this, 1, this.numRows);
        this.fireValueChanged(algorithmEvent4);
        algorithmEvent4.setId(2);
        Cluster cluster = new Cluster();
        NodeList nodeList = cluster.getNodeList();
        for (int i = 0; i < this.clusters.length; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            int[] nArray9 = this.convert2int(this.clusters[i]);
            Node node = new Node(nArray9);
            nodeList.addNode(node);
            if (!bl) continue;
            node.setValues(this.calculateHierarchicalTree(nArray9, n3, bl2, bl3));
            algorithmEvent4.setIntValue(i + 1);
            this.fireValueChanged(algorithmEvent4);
        }
        AlgorithmData algorithmData3 = new AlgorithmData();
        algorithmData3.addParam("usedNumNeibs", String.valueOf(this.usedNumNeibs));
        algorithmData3.addIntArray("origNumInFiltTrgSetByClass", nArray8);
        algorithmData3.addIntArray("numberCorrectlyClassifiedByClass", nArray6);
        algorithmData3.addIntArray("numberIncorrectlyClassifiedByClass", nArray7);
        algorithmData3.addCluster("cluster", cluster);
        algorithmData3.addMatrix("clusters_means", floatMatrix);
        algorithmData3.addMatrix("clusters_variances", floatMatrix3);
        return algorithmData3;
    }

    private NodeValueList calculateHierarchicalTree(int[] nArray, int n, boolean bl, boolean bl2) throws AlgorithmException {
        AlgorithmData algorithmData;
        NodeValueList nodeValueList = new NodeValueList();
        AlgorithmData algorithmData2 = new AlgorithmData();
        FloatMatrix floatMatrix = this.classifyGenes ? this.getSubExperiment(this.expMatrix, nArray) : this.getSubExperimentReducedCols(this.expMatrix, nArray);
        algorithmData2.addMatrix("experiment", floatMatrix);
        algorithmData2.addParam("hcl-distance-function", String.valueOf(this.hcl_function));
        algorithmData2.addParam("hcl-distance-absolute", String.valueOf(this.hcl_absolute));
        algorithmData2.addParam("method-linkage", String.valueOf(n));
        HCL hCL = new HCL();
        if (bl) {
            algorithmData2.addParam("calculate-genes", String.valueOf(true));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        if (bl2) {
            algorithmData2.addParam("calculate-genes", String.valueOf(false));
            algorithmData = hCL.execute(algorithmData2);
            this.validate(algorithmData);
            this.addNodeValues(nodeValueList, algorithmData);
        }
        return nodeValueList;
    }

    private void addNodeValues(NodeValueList nodeValueList, AlgorithmData algorithmData) {
        nodeValueList.addNodeValue(new NodeValue("child-1-array", (Object)algorithmData.getIntArray("child-1-array")));
        nodeValueList.addNodeValue(new NodeValue("child-2-array", (Object)algorithmData.getIntArray("child-2-array")));
        nodeValueList.addNodeValue(new NodeValue("node-order", (Object)algorithmData.getIntArray("node-order")));
        nodeValueList.addNodeValue(new NodeValue("height", (Object)algorithmData.getMatrix("height").getRowPackedCopy()));
    }

    private FloatMatrix getSubExperiment(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = new FloatMatrix(nArray.length, floatMatrix.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix2.A[i] = floatMatrix.A[nArray[i]];
        }
        return floatMatrix2;
    }

    private FloatMatrix getSubExperimentReducedCols(FloatMatrix floatMatrix, int[] nArray) {
        FloatMatrix floatMatrix2 = floatMatrix.copy();
        FloatMatrix floatMatrix3 = new FloatMatrix(nArray.length, floatMatrix2.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix3.A[i] = floatMatrix2.A[nArray[i]];
        }
        floatMatrix3 = floatMatrix3.transpose();
        return floatMatrix3;
    }

    private void validate(AlgorithmData algorithmData) throws AlgorithmException {
        if (algorithmData.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (algorithmData.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (algorithmData.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (algorithmData.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private int[] convert2int(Vector vector) {
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        return nArray;
    }

    public void abort() {
        this.stop = true;
    }

    private FloatMatrix getMeans(Vector[] vectorArray) {
        FloatMatrix floatMatrix = new FloatMatrix(vectorArray.length, this.numCols);
        for (int i = 0; i < vectorArray.length; ++i) {
            FloatMatrix floatMatrix2 = this.getMean(vectorArray[i]);
            floatMatrix.A[i] = floatMatrix2.A[0];
        }
        return floatMatrix;
    }

    private FloatMatrix getMean(Vector vector) {
        FloatMatrix floatMatrix = new FloatMatrix(1, this.numCols);
        int n = vector.size();
        int n2 = 0;
        for (int i = 0; i < this.numCols; ++i) {
            float f = 0.0f;
            n2 = 0;
            for (int j = 0; j < n; ++j) {
                float f2 = this.expMatrix.get(((Integer)vector.get(j)).intValue(), i);
                if (Float.isNaN(f2)) continue;
                f += f2;
                ++n2;
            }
            floatMatrix.set(0, i, f / (float)n2);
        }
        return floatMatrix;
    }

    private FloatMatrix getVariances(Vector[] vectorArray, FloatMatrix floatMatrix) {
        int n = floatMatrix.getRowDimension();
        int n2 = floatMatrix.getColumnDimension();
        FloatMatrix floatMatrix2 = new FloatMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                floatMatrix2.set(i, j, this.getSampleVariance(vectorArray[i], j, floatMatrix.get(i, j)));
            }
        }
        return floatMatrix2;
    }

    private float getSampleNormalizedSum(Vector vector, int n, float f) {
        int n2 = vector.size();
        float f2 = 0.0f;
        this.validN = 0;
        for (int i = 0; i < n2; ++i) {
            float f3 = this.expMatrix.get(((Integer)vector.get(i)).intValue(), n);
            if (Float.isNaN(f3)) continue;
            f2 = (float)((double)f2 + Math.pow(f3 - f, 2.0));
            ++this.validN;
        }
        return f2;
    }

    private float getSampleVariance(Vector vector, int n, float f) {
        return (float)Math.sqrt(this.getSampleNormalizedSum(vector, n, f) / (float)(this.validN - 1));
    }

    private int getClassification(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int[] nArray = new int[this.numClasses + 1];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 0;
        }
        float[] fArray = new float[this.filteredClassifierSet.size()];
        int n6 = n2 <= this.filteredClassifierSet.size() ? n2 : this.filteredClassifierSet.size();
        this.usedNumNeibs = n6;
        for (int i = 0; i < this.filteredClassifierSet.size(); ++i) {
            float f;
            int n7 = (Integer)this.filteredClassifierSet.get(i);
            fArray[i] = f = ExperimentUtil.geneEuclidianDistance(this.expMatrix, null, n, n7, this.factor);
        }
        QSort qSort = new QSort(fArray);
        int[] nArray2 = qSort.getOrigIndx();
        for (n5 = 0; n5 < n6; ++n5) {
            n4 = nArray2[n5];
            n3 = (Integer)this.filteredClasses.get(n4);
            nArray[n3] = nArray[n3] + 1;
        }
        n5 = 0;
        for (n4 = 1; n4 < nArray.length; ++n4) {
            n5 = Math.max(n5, nArray[n4]);
        }
        n4 = 0;
        n3 = 0;
        for (int i = 1; i < nArray.length; ++i) {
            if (n5 != nArray[i]) continue;
            ++n4;
            n3 = i;
        }
        if (n4 == 1) {
            return n3;
        }
        return 0;
    }

    private int getClassificationForCrossValid(int n, int n2, Vector vector, Vector vector2) {
        int n3;
        int n4;
        int n5;
        int[] nArray = new int[this.numClasses + 1];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 0;
        }
        float[] fArray = new float[vector.size()];
        int n6 = n2 <= vector.size() ? n2 : vector.size();
        this.usedNumNeibs = n6;
        for (int i = 0; i < vector.size(); ++i) {
            float f;
            int n7 = (Integer)vector.get(i);
            fArray[i] = f = ExperimentUtil.geneEuclidianDistance(this.expMatrix, null, n, n7, this.factor);
        }
        QSort qSort = new QSort(fArray);
        int[] nArray2 = qSort.getOrigIndx();
        for (n5 = 0; n5 < n6; ++n5) {
            n4 = nArray2[n5];
            n3 = (Integer)vector2.get(n4);
            nArray[n3] = nArray[n3] + 1;
        }
        n5 = 0;
        for (n4 = 1; n4 < nArray.length; ++n4) {
            n5 = Math.max(n5, nArray[n4]);
        }
        n4 = 0;
        n3 = 0;
        for (int i = 1; i < nArray.length; ++i) {
            if (n5 != nArray[i]) continue;
            ++n4;
            n3 = i;
        }
        if (n4 == 1) {
            return n3;
        }
        return 0;
    }

    private int[][] getCrossValidationStats() throws AlgorithmException {
        int[] nArray = new int[this.numClasses + 1];
        int[] nArray2 = new int[this.numClasses + 1];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 0;
            nArray2[i] = 0;
        }
        AlgorithmEvent algorithmEvent = new AlgorithmEvent((Object)this, 1, this.filteredClassifierSet.size());
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        for (int i = 0; i < this.filteredClassifierSet.size(); ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            algorithmEvent.setIntValue(i);
            algorithmEvent.setDescription("Cross-validation: testing classifier " + (i + 1));
            this.fireValueChanged(algorithmEvent);
            Vector vector = (Vector)this.filteredClassifierSet.clone();
            vector.remove(i);
            Vector vector2 = (Vector)this.filteredClasses.clone();
            vector2.remove(i);
            int n = (Integer)this.filteredClassifierSet.get(i);
            if (!this.useCorrelFilter) {
                int n2 = this.getClassificationForCrossValid(n, this.numNeighbors, vector, vector2);
                if (this.filteredClassifiersByClass[n2].contains(new Integer(n))) {
                    int n3 = n2;
                    nArray[n3] = nArray[n3] + 1;
                    continue;
                }
                int n4 = n2;
                nArray2[n4] = nArray2[n4] + 1;
                continue;
            }
            Random random = new Random();
            if (!this.passesCorrelationFilter(n, vector, this.correlPValue, this.numPerms, random.nextLong())) continue;
            int n5 = this.getClassificationForCrossValid(n, this.numNeighbors, vector, vector2);
            if (this.filteredClassifiersByClass[n5].contains(new Integer(n))) {
                int n6 = n5;
                nArray[n6] = nArray[n6] + 1;
                continue;
            }
            int n7 = n5;
            nArray2[n7] = nArray2[n7] + 1;
        }
        int[][] nArrayArray = new int[][]{nArray, nArray2};
        return nArrayArray;
    }

    private boolean passesCorrelationFilter(int n, Vector vector, double d, int n2, long l) {
        int n3;
        boolean bl = false;
        double d2 = this.getRMax(n, vector);
        float[] fArray = new float[this.numCols];
        int n4 = 0;
        long[] lArray = new long[n2];
        Random random = new Random(l);
        for (n3 = 0; n3 < lArray.length; ++n3) {
            lArray[n3] = random.nextLong();
        }
        for (n3 = 0; n3 < n2; ++n3) {
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = this.expMatrix.A[n][i];
            }
            float[] fArray2 = this.getPermutedValues(n, lArray[n3]);
            double d3 = this.getPermRMax(fArray2, vector);
            if (!(d3 > d2)) continue;
            ++n4;
        }
        double d4 = (double)n4 / (double)n2;
        bl = d4 <= d;
        return bl;
    }

    private double getPermRMax(float[] fArray, Vector vector) {
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < vector.size(); ++i) {
            int n = (Integer)vector.get(i);
            float[] fArray2 = this.getRowValues(n);
            double d2 = this.getCorr(fArray, fArray2);
            d = Math.max(d, d2);
        }
        return d;
    }

    private double getCorr(float[] fArray, float[] fArray2) {
        int n;
        int n2 = fArray.length;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            double d6 = fArray[n];
            double d7 = fArray2[n];
            if (Double.isNaN(d6) || Double.isNaN(d7)) continue;
            ++n3;
            d += d6 * d7;
            d3 += d6 * d6;
            d5 += d7 * d7;
            d2 += d6;
            d4 += d7;
        }
        if (n3 == 0) {
            return 0.0;
        }
        n = 0;
        for (int i = 1; i < n2; ++i) {
            if (Float.isNaN(fArray[i]) || Float.isNaN(fArray2[i])) continue;
            if (fArray[i] != fArray[i - 1]) {
                n = 1;
                break;
            }
            if (fArray2[i] == fArray2[i - 1]) continue;
            n = 1;
            break;
        }
        if (n == 0) {
            return 1.0;
        }
        double d8 = d2 / (double)n3;
        double d9 = d4 / (double)n3;
        double d10 = d - d2 * d9 - d8 * d4 + d8 * d9 * (double)n3;
        double d11 = d3 - d8 * d2 * 2.0 + d8 * d8 * (double)n3;
        double d12 = d5 - d9 * d4 * 2.0 + d9 * d9 * (double)n3;
        double d13 = d11 * d12;
        return d10 / (Math.sqrt(d13) + Double.MIN_VALUE) * (double)this.factor;
    }

    private float[] getRowValues(int n) {
        float[] fArray = new float[this.numCols];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = this.expMatrix.A[n][i];
        }
        return fArray;
    }

    private float[] getPermutedValues(int n, long l) {
        float[] fArray = new float[this.numCols];
        float[] fArray2 = new float[this.numCols];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = this.expMatrix.A[n][i];
        }
        Random random = new Random(l);
        for (int i = fArray.length; i > 1; --i) {
            int n2 = random.nextInt(i - 1);
            float f = fArray[n2];
            fArray[n2] = fArray[i - 1];
            fArray[i - 1] = f;
        }
        return fArray;
    }

    private double getRMax(int n, Vector vector) {
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < vector.size(); ++i) {
            int n2 = (Integer)vector.get(i);
            double d2 = ExperimentUtil.genePearson(this.expMatrix, null, n2, n, this.factor);
            d = Math.max(d, d2);
        }
        return d;
    }

    private boolean isFoundInVector(int n, Vector vector) {
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            if (n != (Integer)vector.get(i)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private int[] reverse(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        int n2 = nArray.length - 1;
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[n] = nArray[n2];
            ++n;
            --n2;
        }
        return nArray2;
    }

    private double getVar(int n) {
        float[] fArray = new float[this.numCols];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = this.expMatrix.A[n][i];
        }
        return this.getVar(fArray);
    }

    private double getVar(float[] fArray) {
        float f = this.getMean(fArray);
        int n = 0;
        float f2 = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            if (Float.isNaN(fArray[i])) continue;
            f2 = (float)((double)f2 + Math.pow(fArray[i] - f, 2.0));
            ++n;
        }
        if (n < 2) {
            return Double.NaN;
        }
        float f3 = f2 / (float)(n - 1);
        if (Float.isInfinite(f3)) {
            return Double.NaN;
        }
        return f3;
    }

    private float getMean(float[] fArray) {
        float f = 0.0f;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < fArray.length; ++i) {
            if (Float.isNaN(fArray[i])) continue;
            f += fArray[i];
            ++n;
            ++n2;
        }
        if (n == 0) {
            return Float.NaN;
        }
        float f2 = f / (float)n;
        if (Float.isInfinite(f2)) {
            return Float.NaN;
        }
        return f2;
    }
}

