/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.Complex3Vector;
import JSci.maths.ComplexVector;
import JSci.maths.Double3Vector;
import JSci.maths.DoubleVector;
import JSci.maths.IntegerVector;
import JSci.maths.VectorDimensionException;

public class Integer3Vector
extends IntegerVector {
    public Integer3Vector() {
        super(3);
    }

    public Integer3Vector(int[] nArray) {
        super(nArray);
    }

    public Integer3Vector(int n, int n2, int n3) {
        super(3);
        this.vector[0] = n;
        this.vector[1] = n2;
        this.vector[2] = n3;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Integer3Vector) {
            Integer3Vector integer3Vector = (Integer3Vector)object;
            return this.vector[0] == integer3Vector.vector[0] && this.vector[1] == integer3Vector.vector[1] && this.vector[2] == integer3Vector.vector[2];
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5);
        stringBuffer.append(this.vector[0]).append(',').append(this.vector[1]).append(',').append(this.vector[2]);
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.norm());
    }

    public DoubleVector toDoubleVector() {
        return new Double3Vector(this.vector[0], this.vector[1], this.vector[2]);
    }

    public ComplexVector toComplexVector() {
        double[] dArray = new double[]{this.vector[0], this.vector[1], this.vector[2]};
        return new Complex3Vector(dArray, new double[3]);
    }

    public int getComponent(int n) {
        if (n >= 0 && n < 3) {
            return this.vector[n];
        }
        throw new VectorDimensionException("Invalid component.");
    }

    public void setComponent(int n, int n2) {
        if (n < 0 || n >= 3) {
            throw new VectorDimensionException("Invalid component.");
        }
        this.vector[n] = n2;
    }

    public double norm(int n) {
        double d = Math.pow(this.vector[0], n) + Math.pow(this.vector[1], n) + Math.pow(this.vector[2], n);
        return Math.pow(d, 1.0 / (double)n);
    }

    public double norm() {
        int n = this.vector[0] * this.vector[0] + this.vector[1] * this.vector[1] + this.vector[2] * this.vector[2];
        return Math.sqrt(n);
    }

    public double infNorm() {
        int n = this.vector[0];
        if (this.vector[1] > n) {
            n = this.vector[1];
        }
        if (this.vector[2] > n) {
            n = this.vector[2];
        }
        return n;
    }

    public Integer3Vector add(Integer3Vector integer3Vector) {
        return new Integer3Vector(this.vector[0] + integer3Vector.vector[0], this.vector[1] + integer3Vector.vector[1], this.vector[2] + integer3Vector.vector[2]);
    }

    public Integer3Vector subtract(Integer3Vector integer3Vector) {
        return new Integer3Vector(this.vector[0] - integer3Vector.vector[0], this.vector[1] - integer3Vector.vector[1], this.vector[2] - integer3Vector.vector[2]);
    }

    public IntegerVector scalarMultiply(int n) {
        return new Integer3Vector(n * this.vector[0], n * this.vector[1], n * this.vector[2]);
    }

    public int scalarProduct(Integer3Vector integer3Vector) {
        return this.vector[0] * integer3Vector.vector[0] + this.vector[1] * integer3Vector.vector[1] + this.vector[2] * integer3Vector.vector[2];
    }

    public Integer3Vector multiply(Integer3Vector integer3Vector) {
        return new Integer3Vector(this.vector[1] * integer3Vector.vector[2] - integer3Vector.vector[1] * this.vector[2], this.vector[2] * integer3Vector.vector[0] - integer3Vector.vector[2] * this.vector[0], this.vector[0] * integer3Vector.vector[1] - integer3Vector.vector[0] * this.vector[1]);
    }
}

