/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.statistics;

import JSci.maths.ExtraMath;
import JSci.maths.statistics.OutOfRangeException;
import JSci.maths.statistics.ProbabilityDistribution;

public final class PoissonDistribution
extends ProbabilityDistribution {
    private double lambda;

    public PoissonDistribution(double d) {
        if (d <= 0.0) {
            throw new OutOfRangeException("The interval should be (strictly) positive.");
        }
        this.lambda = d;
    }

    public double getIntervalParameter() {
        return this.lambda;
    }

    public double getMean() {
        return this.lambda;
    }

    public double getVariance() {
        return this.lambda;
    }

    public double probability(double d) {
        this.checkRange(d, 0.0, Double.MAX_VALUE);
        return Math.exp(d * Math.log(this.lambda) - this.lambda - ExtraMath.logFactorial(d));
    }

    public double cumulative(double d) {
        this.checkRange(d, 0.0, Double.MAX_VALUE);
        double d2 = 0.0;
        double d3 = 0.0;
        while (d3 <= d) {
            d2 += this.probability(d3);
            d3 += 1.0;
        }
        return d2;
    }

    public double inverse(double d) {
        this.checkRange(d);
        return Math.floor(this.findRoot(d, this.lambda, 0.0, Double.MAX_VALUE));
    }
}

