/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.groups;

import JSci.maths.Complex;
import JSci.maths.ComplexDiagonalMatrix;
import JSci.maths.ComplexMatrix;
import JSci.maths.ComplexSquareMatrix;
import JSci.maths.DoubleVector;

public class LieGroup {
    private ComplexSquareMatrix[] generators;
    private ComplexSquareMatrix identityMatrix;

    public LieGroup(ComplexSquareMatrix[] complexSquareMatrixArray) {
        this.generators = complexSquareMatrixArray;
        this.identityMatrix = ComplexDiagonalMatrix.identity(this.generators[0].rows());
    }

    public final int dimension() {
        return this.generators.length;
    }

    public ComplexSquareMatrix getElement(DoubleVector doubleVector) {
        if (this.generators.length != doubleVector.dimension()) {
            throw new IllegalArgumentException("The vector should match the generators.");
        }
        ComplexMatrix complexMatrix = this.generators[0].scalarMultiply(doubleVector.getComponent(0));
        int n = 1;
        while (n < this.generators.length) {
            complexMatrix = complexMatrix.add(this.generators[n].scalarMultiply(doubleVector.getComponent(n)));
            ++n;
        }
        return (ComplexSquareMatrix)this.identityMatrix.add(complexMatrix.scalarMultiply(Complex.I));
    }

    public ComplexSquareMatrix identity() {
        return this.identityMatrix;
    }

    public final boolean isIdentity(ComplexSquareMatrix complexSquareMatrix) {
        return this.identityMatrix.equals(complexSquareMatrix);
    }

    public final boolean isInverse(ComplexSquareMatrix complexSquareMatrix, ComplexSquareMatrix complexSquareMatrix2) {
        return this.isIdentity(complexSquareMatrix.multiply(complexSquareMatrix2));
    }
}

