/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.groups;

import JSci.maths.groups.DiscreteGroup;

public final class CyclicGroup
extends DiscreteGroup {
    private String[] elements;

    public CyclicGroup(int n) {
        super("Z" + n);
        this.elements = new String[n];
        this.elements[0] = "e";
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 1;
        while (n2 < n) {
            stringBuffer.append('c');
            this.elements[n2] = stringBuffer.toString();
            ++n2;
        }
    }

    public String compose(String string, String string2) {
        if (this.isIdentity(string)) {
            return string2;
        }
        if (this.isIdentity(string2)) {
            return string;
        }
        String string3 = string + string2;
        if (string3.length() == this.elements.length) {
            return this.identity();
        }
        if (string3.length() < this.elements.length) {
            return string3;
        }
        return string3.substring(this.elements.length);
    }

    public String identity() {
        return this.elements[0];
    }

    public String inverse(String string) {
        if (this.isIdentity(string)) {
            return this.identity();
        }
        return this.elements[this.elements.length - 1].substring(string.length() - 1);
    }
}

