/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.Double3Vector;
import JSci.maths.MathDouble;
import JSci.maths.MathInteger;
import JSci.maths.algebras.CStarAlgebraMember;
import JSci.maths.algebras.ModuleMember;
import JSci.maths.algebras.VectorSpaceMember;
import JSci.maths.fields.FieldMember;
import JSci.maths.fields.RingMember;
import JSci.maths.groups.AbelianGroupMember;

public final class Quaternion
implements FieldMember,
CStarAlgebraMember {
    private static final long serialVersionUID = 1605315490425547301L;
    private double re;
    private double imi;
    private double imj;
    private double imk;

    public Quaternion(double d, Double3Vector double3Vector) {
        this.re = d;
        this.imi = double3Vector.vector[0];
        this.imj = double3Vector.vector[1];
        this.imk = double3Vector.vector[2];
    }

    public Quaternion(double d, double d2, double d3, double d4) {
        this.re = d;
        this.imi = d2;
        this.imj = d3;
        this.imk = d4;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Quaternion) {
            Quaternion quaternion = (Quaternion)object;
            return Math.abs(this.re - quaternion.re) <= GlobalSettings.ZERO_TOL && Math.abs(this.imi - quaternion.imi) <= GlobalSettings.ZERO_TOL && Math.abs(this.imj - quaternion.imj) <= GlobalSettings.ZERO_TOL && Math.abs(this.imk - quaternion.imk) <= GlobalSettings.ZERO_TOL;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append(this.re);
        if (this.imi >= 0.0) {
            stringBuffer.append("+");
        }
        stringBuffer.append(this.imi);
        stringBuffer.append("i");
        if (this.imj >= 0.0) {
            stringBuffer.append("+");
        }
        stringBuffer.append(this.imj);
        stringBuffer.append("j");
        if (this.imk >= 0.0) {
            stringBuffer.append("+");
        }
        stringBuffer.append(this.imk);
        stringBuffer.append("k");
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.norm());
    }

    public boolean isNaN() {
        return this.re == Double.NaN || this.imi == Double.NaN || this.imj == Double.NaN || this.imk == Double.NaN;
    }

    public boolean isInfinite() {
        return this.re == Double.POSITIVE_INFINITY || this.re == Double.NEGATIVE_INFINITY || this.imi == Double.POSITIVE_INFINITY || this.imi == Double.NEGATIVE_INFINITY || this.imj == Double.POSITIVE_INFINITY || this.imj == Double.NEGATIVE_INFINITY || this.imk == Double.POSITIVE_INFINITY || this.imk == Double.NEGATIVE_INFINITY;
    }

    public double real() {
        return this.re;
    }

    public Double3Vector imag() {
        return new Double3Vector(this.imi, this.imj, this.imk);
    }

    public double norm() {
        return Math.sqrt(this.sumSquares());
    }

    public double sumSquares() {
        return this.re * this.re + this.imi * this.imi + this.imj * this.imj + this.imk * this.imk;
    }

    public AbelianGroupMember negate() {
        return new Quaternion(-this.re, -this.imi, -this.imj, -this.imk);
    }

    public FieldMember inverse() {
        double d = this.sumSquares();
        return new Quaternion(this.re / d, -this.imi / d, -this.imj / d, -this.imk / d);
    }

    public CStarAlgebraMember involution() {
        return this.conjugate();
    }

    public Quaternion conjugate() {
        return new Quaternion(this.re, -this.imi, -this.imj, -this.imk);
    }

    public AbelianGroupMember add(AbelianGroupMember abelianGroupMember) {
        if (abelianGroupMember instanceof Quaternion) {
            return this.add((Quaternion)abelianGroupMember);
        }
        if (abelianGroupMember instanceof MathDouble) {
            return this.addReal(((MathDouble)abelianGroupMember).value());
        }
        if (abelianGroupMember instanceof MathInteger) {
            return this.addReal(((MathInteger)abelianGroupMember).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Quaternion add(Quaternion quaternion) {
        return new Quaternion(this.re + quaternion.re, this.imi + quaternion.imi, this.imj + quaternion.imj, this.imk + quaternion.imk);
    }

    public Quaternion addReal(double d) {
        return new Quaternion(this.re + d, this.imi, this.imj, this.imk);
    }

    public Quaternion addImag(Double3Vector double3Vector) {
        return new Quaternion(this.re, this.imi + double3Vector.vector[0], this.imj + double3Vector.vector[1], this.imk + double3Vector.vector[2]);
    }

    public AbelianGroupMember subtract(AbelianGroupMember abelianGroupMember) {
        if (abelianGroupMember instanceof Quaternion) {
            return this.subtract((Quaternion)abelianGroupMember);
        }
        if (abelianGroupMember instanceof MathDouble) {
            return this.subtractReal(((MathDouble)abelianGroupMember).value());
        }
        if (abelianGroupMember instanceof MathInteger) {
            return this.subtractReal(((MathInteger)abelianGroupMember).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Quaternion subtract(Quaternion quaternion) {
        return new Quaternion(this.re - quaternion.re, this.imi - quaternion.imi, this.imj - quaternion.imj, this.imk - quaternion.imk);
    }

    public Quaternion subtractReal(double d) {
        return new Quaternion(this.re - d, this.imi, this.imj, this.imk);
    }

    public Quaternion subtractImag(Double3Vector double3Vector) {
        return new Quaternion(this.re, this.imi - double3Vector.vector[0], this.imj - double3Vector.vector[1], this.imk - double3Vector.vector[2]);
    }

    public ModuleMember scalarMultiply(RingMember ringMember) {
        if (ringMember instanceof MathDouble) {
            return this.multiply(((MathDouble)ringMember).value());
        }
        if (ringMember instanceof MathInteger) {
            return this.multiply(((MathInteger)ringMember).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public RingMember multiply(RingMember ringMember) {
        if (ringMember instanceof Quaternion) {
            return this.multiply((Quaternion)ringMember);
        }
        if (ringMember instanceof MathDouble) {
            return this.multiply(((MathDouble)ringMember).value());
        }
        if (ringMember instanceof MathInteger) {
            return this.multiply(((MathInteger)ringMember).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Quaternion multiply(Quaternion quaternion) {
        return new Quaternion(this.re * quaternion.re - this.imi * quaternion.imi - this.imj * quaternion.imj - this.imk * quaternion.imk, this.re * quaternion.imi + quaternion.re * this.imi + (this.imj * quaternion.imk - quaternion.imj * this.imk), this.re * quaternion.imj + quaternion.re * this.imj + (this.imk * quaternion.imi - quaternion.imk * this.imi), this.re * quaternion.imk + quaternion.re * this.imk + (this.imi * quaternion.imj - quaternion.imi * this.imj));
    }

    public Quaternion multiply(double d) {
        return new Quaternion(d * this.re, d * this.imi, d * this.imj, d * this.imk);
    }

    public VectorSpaceMember scalarDivide(FieldMember fieldMember) {
        if (fieldMember instanceof MathDouble) {
            return this.divide(((MathDouble)fieldMember).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public FieldMember divide(FieldMember fieldMember) {
        if (fieldMember instanceof Quaternion) {
            return this.divide((Quaternion)fieldMember);
        }
        if (fieldMember instanceof MathDouble) {
            return this.divide(((MathDouble)fieldMember).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Quaternion divide(Quaternion quaternion) {
        double d = quaternion.sumSquares();
        return new Quaternion((this.re * quaternion.re + this.imi * quaternion.imi + this.imj * quaternion.imj + this.imk * quaternion.imk) / d, (quaternion.re * this.imi - this.re * quaternion.imi - (this.imj * quaternion.imk - quaternion.imj * this.imk)) / d, (quaternion.re * this.imj - this.re * quaternion.imj - (this.imk * quaternion.imi - quaternion.imk * this.imi)) / d, (quaternion.re * this.imk - this.re * quaternion.imk - (this.imi * quaternion.imj - quaternion.imi * this.imj)) / d);
    }

    public Quaternion divide(double d) {
        return new Quaternion(this.re / d, this.imi / d, this.imj / d, this.imk / d);
    }
}

