/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.ComplexMatrix;
import JSci.maths.DimensionException;
import JSci.maths.DoubleMatrix;
import JSci.maths.IntegerSquareMatrix;
import JSci.maths.IntegerVector;
import JSci.maths.MathInteger;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;
import JSci.maths.algebras.ModuleMember;
import JSci.maths.algebras.VectorSpaceMember;
import JSci.maths.fields.FieldMember;
import JSci.maths.fields.RingMember;
import JSci.maths.groups.AbelianGroupMember;

public class IntegerMatrix
extends Matrix {
    protected static final int ARRAY_2D = 1;
    protected int[][] matrix;

    protected IntegerMatrix() {
    }

    public IntegerMatrix(int n, int n2) {
        this();
        this.storageFormat = 1;
        this.matrix = new int[n][n2];
    }

    public IntegerMatrix(int[][] nArray) {
        this();
        this.storageFormat = 1;
        this.matrix = nArray;
    }

    public IntegerMatrix(IntegerVector[] integerVectorArray) {
        this(integerVectorArray[0].dimension(), integerVectorArray.length);
        int n = 0;
        while (n < this.matrix.length) {
            int n2 = 0;
            while (n2 < this.matrix[0].length) {
                this.matrix[n][n2] = integerVectorArray[n2].getComponent(n);
                ++n2;
            }
            ++n;
        }
    }

    protected void finalize() throws Throwable {
        this.matrix = null;
        super.finalize();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof IntegerMatrix && this.matrix.length == ((IntegerMatrix)object).rows() && this.matrix[0].length == ((IntegerMatrix)object).columns()) {
            IntegerMatrix integerMatrix = (IntegerMatrix)object;
            int n = 0;
            while (n < this.matrix.length) {
                int n2 = 0;
                while (n2 < this.matrix[0].length) {
                    if (this.matrix[n][n2] != integerMatrix.getElement(n, n2)) {
                        return false;
                    }
                    ++n2;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.matrix.length * this.matrix[0].length);
        int n = 0;
        while (n < this.matrix.length) {
            int n2 = 0;
            while (n2 < this.matrix[0].length) {
                stringBuffer.append(this.matrix[n][n2]);
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.infNorm());
    }

    public DoubleMatrix toDoubleMatrix() {
        double[][] dArray = new double[this.matrix.length][this.matrix[0].length];
        int n = 0;
        while (n < this.matrix.length) {
            int n2 = 0;
            while (n2 < this.matrix[0].length) {
                dArray[n][n2] = this.matrix[n][n2];
                ++n2;
            }
            ++n;
        }
        return new DoubleMatrix(dArray);
    }

    public ComplexMatrix toComplexMatrix() {
        double[][] dArray = new double[this.matrix.length][this.matrix[0].length];
        double[][] dArray2 = new double[this.matrix.length][this.matrix[0].length];
        int n = 0;
        while (n < this.matrix.length) {
            int n2 = 0;
            while (n2 < this.matrix[0].length) {
                dArray[n][n2] = this.matrix[n][n2];
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(dArray, dArray2);
    }

    public int getElement(int n, int n2) {
        if (n >= 0 && n < this.matrix.length && n2 >= 0 && n2 < this.matrix[0].length) {
            return this.matrix[n][n2];
        }
        throw new MatrixDimensionException("Invalid element.");
    }

    public void setElement(int n, int n2, int n3) {
        if (n < 0 || n >= this.matrix.length || n2 < 0 || n2 >= this.matrix[0].length) {
            throw new MatrixDimensionException("Invalid element.");
        }
        this.matrix[n][n2] = n3;
    }

    public int infNorm() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.matrix.length) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.matrix[0].length) {
                n3 += Math.abs(this.matrix[n2][n4]);
                ++n4;
            }
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    public double frobeniusNorm() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.matrix.length) {
            int n3 = 0;
            while (n3 < this.matrix[0].length) {
                n += this.matrix[n2][n3] * this.matrix[n2][n3];
                ++n3;
            }
            ++n2;
        }
        return Math.sqrt(n);
    }

    public int rows() {
        return this.matrix.length;
    }

    public int columns() {
        return this.matrix[0].length;
    }

    public AbelianGroupMember negate() {
        int[][] nArray = new int[this.matrix.length][this.matrix[0].length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n][0] = -this.matrix[n][0];
            int n2 = 1;
            while (n2 < nArray[0].length) {
                nArray[n][n2] = -this.matrix[n][n2];
                ++n2;
            }
            ++n;
        }
        return new IntegerMatrix(nArray);
    }

    public AbelianGroupMember add(AbelianGroupMember abelianGroupMember) {
        if (abelianGroupMember instanceof IntegerMatrix) {
            return this.add((IntegerMatrix)abelianGroupMember);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public IntegerMatrix add(IntegerMatrix integerMatrix) {
        switch (integerMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(integerMatrix);
            }
        }
        if (this.matrix.length == integerMatrix.rows() && this.matrix[0].length == integerMatrix.columns()) {
            int[][] nArray = new int[this.matrix.length][this.matrix[0].length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n][0] = this.matrix[n][0] + integerMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < nArray[0].length) {
                    nArray[n][n2] = this.matrix[n][n2] + integerMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerMatrix rawAdd(IntegerMatrix integerMatrix) {
        if (this.matrix.length == integerMatrix.matrix.length && this.matrix[0].length == integerMatrix.matrix[0].length) {
            int[][] nArray = new int[this.matrix.length][this.matrix[0].length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n][0] = this.matrix[n][0] + integerMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < nArray[0].length) {
                    nArray[n][n2] = this.matrix[n][n2] + integerMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new IntegerMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbelianGroupMember subtract(AbelianGroupMember abelianGroupMember) {
        if (abelianGroupMember instanceof IntegerMatrix) {
            return this.subtract((IntegerMatrix)abelianGroupMember);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public IntegerMatrix subtract(IntegerMatrix integerMatrix) {
        switch (integerMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(integerMatrix);
            }
        }
        if (this.matrix.length == integerMatrix.rows() && this.matrix[0].length == integerMatrix.columns()) {
            int[][] nArray = new int[this.matrix.length][this.matrix[0].length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n][0] = this.matrix[n][0] - integerMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < nArray[0].length) {
                    nArray[n][n2] = this.matrix[n][n2] - integerMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerMatrix rawSubtract(IntegerMatrix integerMatrix) {
        if (this.matrix.length == integerMatrix.matrix.length && this.matrix[0].length == integerMatrix.matrix[0].length) {
            int[][] nArray = new int[this.matrix.length][this.matrix[0].length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n][0] = this.matrix[n][0] - integerMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < nArray[0].length) {
                    nArray[n][n2] = this.matrix[n][n2] - integerMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new IntegerMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ModuleMember scalarMultiply(RingMember ringMember) {
        if (ringMember instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)ringMember).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public IntegerMatrix scalarMultiply(int n) {
        int[][] nArray = new int[this.matrix.length][this.matrix[0].length];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2][0] = n * this.matrix[n2][0];
            int n3 = 1;
            while (n3 < nArray[0].length) {
                nArray[n2][n3] = n * this.matrix[n2][n3];
                ++n3;
            }
            ++n2;
        }
        return new IntegerMatrix(nArray);
    }

    public VectorSpaceMember scalarDivide(FieldMember fieldMember) {
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public IntegerVector multiply(IntegerVector integerVector) {
        if (this.matrix[0].length == integerVector.dimension()) {
            int[] nArray = new int[this.matrix.length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = this.matrix[n][0] * integerVector.getComponent(0);
                int n2 = 1;
                while (n2 < this.matrix[0].length) {
                    int n3 = n;
                    nArray[n3] = nArray[n3] + this.matrix[n][n2] * integerVector.getComponent(n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerVector(nArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public RingMember multiply(RingMember ringMember) {
        if (ringMember instanceof IntegerMatrix) {
            return this.multiply((IntegerMatrix)ringMember);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public IntegerMatrix multiply(IntegerMatrix integerMatrix) {
        switch (integerMatrix.storageFormat) {
            case 1: {
                return this.rawMultiply(integerMatrix);
            }
        }
        if (this.matrix[0].length == integerMatrix.rows()) {
            int[][] nArray = new int[this.matrix.length][integerMatrix.columns()];
            int n = 0;
            while (n < nArray.length) {
                int n2 = 0;
                while (n2 < nArray[0].length) {
                    nArray[n][n2] = this.matrix[n][0] * integerMatrix.getElement(0, n2);
                    int n3 = 1;
                    while (n3 < this.matrix[0].length) {
                        int[] nArray2 = nArray[n];
                        int n4 = n2;
                        nArray2[n4] = nArray2[n4] + this.matrix[n][n3] * integerMatrix.getElement(n3, n2);
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            if (nArray.length == nArray[0].length) {
                return new IntegerSquareMatrix(nArray);
            }
            return new IntegerMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private IntegerMatrix rawMultiply(IntegerMatrix integerMatrix) {
        if (this.matrix[0].length == integerMatrix.matrix.length) {
            int[][] nArray = new int[this.matrix.length][integerMatrix.matrix[0].length];
            int n = 0;
            while (n < nArray.length) {
                int n2 = 0;
                while (n2 < nArray[0].length) {
                    nArray[n][n2] = this.matrix[n][0] * integerMatrix.matrix[0][n2];
                    int n3 = 1;
                    while (n3 < this.matrix[0].length) {
                        int[] nArray2 = nArray[n];
                        int n4 = n2;
                        nArray2[n4] = nArray2[n4] + this.matrix[n][n3] * integerMatrix.matrix[n3][n2];
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            if (nArray.length == nArray[0].length) {
                return new IntegerSquareMatrix(nArray);
            }
            return new IntegerMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public Matrix transpose() {
        int[][] nArray = new int[this.matrix[0].length][this.matrix.length];
        int n = 0;
        while (n < nArray[0].length) {
            nArray[0][n] = this.matrix[n][0];
            int n2 = 1;
            while (n2 < nArray.length) {
                nArray[n2][n] = this.matrix[n][n2];
                ++n2;
            }
            ++n;
        }
        return new IntegerMatrix(nArray);
    }
}

