/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.AbstractMath;
import JSci.maths.ArrayMath;

public final class EngineerMath
extends AbstractMath {
    private EngineerMath() {
    }

    public static double[] runningAverage(double[] dArray, int n) {
        if (dArray.length < n) {
            throw new IllegalArgumentException("Array must be at least as long as the required width : " + dArray.length + " < " + n);
        }
        if ((n & 1) == 0) {
            throw new IllegalArgumentException("The parameter 'width' must be odd : " + n);
        }
        if (dArray.length == 0) {
            throw new IllegalArgumentException("Empty array, nothing to compute!");
        }
        int n2 = n >> 1;
        double[] dArray2 = new double[dArray.length];
        dArray2[0] = ArrayMath.mean(ArrayMath.extract(0, n - 1, dArray));
        int n3 = 1;
        while (n3 < n2) {
            dArray2[n3] = dArray2[0];
            ++n3;
        }
        int n4 = n2;
        while (n4 < dArray.length - n2 - 1) {
            dArray2[n4] = ArrayMath.mean(ArrayMath.extract(n4 - n2, n4 + n2, dArray));
            ++n4;
        }
        dArray2[dArray.length - n2 - 1] = ArrayMath.mean(ArrayMath.extract(dArray.length - 1 - n + 1, dArray.length - 1, dArray));
        int n5 = dArray.length - n2;
        while (n5 < dArray.length) {
            dArray2[n5] = dArray2[dArray.length - n2 - 1];
            ++n5;
        }
        return dArray2;
    }

    public static double[] runningMedian(double[] dArray, int n) {
        if (dArray.length < n) {
            throw new IllegalArgumentException("Array must be at least as long as the required width : " + dArray.length + " < " + n);
        }
        if ((n & 1) == 0) {
            throw new IllegalArgumentException("The parameter 'width' must be odd : " + n);
        }
        if (dArray.length == 0) {
            throw new IllegalArgumentException("Empty array, nothing to compute!");
        }
        int n2 = n >> 1;
        double[] dArray2 = new double[dArray.length];
        dArray2[0] = ArrayMath.median(ArrayMath.extract(0, n - 1, dArray));
        int n3 = 1;
        while (n3 < n2) {
            dArray2[n3] = dArray2[0];
            ++n3;
        }
        int n4 = n2;
        while (n4 < dArray.length - n2 - 1) {
            dArray2[n4] = ArrayMath.median(ArrayMath.extract(n4 - n2, n4 + n2, dArray));
            ++n4;
        }
        dArray2[dArray.length - n2 - 1] = ArrayMath.median(ArrayMath.extract(dArray.length - 1 - n + 1, dArray.length - 1, dArray));
        int n5 = dArray.length - n2;
        while (n5 < dArray.length) {
            dArray2[n5] = dArray2[dArray.length - n2 - 1];
            ++n5;
        }
        return dArray2;
    }

    public static double icf(double[] dArray) {
        double d = 0.0;
        int n = 0;
        while (n < dArray.length) {
            if (dArray[n] != 0.0) {
                if (dArray[n] < 0.0) {
                    throw new IllegalArgumentException("You cannot take the ICF of a array having negative components : v [" + n + "] = " + dArray[n] + " < 0");
                }
                d -= dArray[n] * Math.log(dArray[n]);
            }
            ++n;
        }
        return d;
    }

    public static double entropy(double[] dArray) {
        double[] dArray2 = ArrayMath.abs(dArray);
        double d = ArrayMath.mass(dArray2);
        if (d == 0.0) {
            return 0.0;
        }
        dArray2 = ArrayMath.scalarMultiply(1.0 / d, dArray2);
        return EngineerMath.icf(dArray2);
    }

    public static double entropy(int[] nArray) {
        int[] nArray2 = ArrayMath.abs(nArray);
        int n = ArrayMath.mass(nArray2);
        if (n == 0) {
            return 0.0;
        }
        double[] dArray = ArrayMath.scalarMultiply(1.0 / (double)n, nArray2);
        return EngineerMath.icf(dArray);
    }

    public static double[] resample(double[] dArray, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("New length must be strictly positive : " + n + " <=0 ");
        }
        double[] dArray2 = new double[n];
        int n2 = 0;
        while (n2 < n) {
            double d = (double)n2 / (double)(n - 1) * (double)(dArray.length - 1);
            int n3 = (int)Math.floor(d);
            int n4 = (int)Math.ceil(d);
            double d2 = d - (double)n3;
            dArray2[n2] = dArray[n3] * d2 + dArray[n4] * (1.0 - d2);
            ++n2;
        }
        return dArray2;
    }
}

