/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.ArrayMath;
import JSci.maths.DimensionException;
import JSci.maths.DoubleDiagonalMatrix;
import JSci.maths.DoubleMatrix;
import JSci.maths.DoubleVector;
import JSci.maths.LinearMath;
import JSci.maths.Mapping;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;
import JSci.maths.MaximumIterationsExceededException;

public class DoubleSquareMatrix
extends DoubleMatrix {
    protected transient DoubleSquareMatrix[] LU;
    protected transient int[] LUpivot;

    protected DoubleSquareMatrix() {
    }

    public DoubleSquareMatrix(int n) {
        super(n, n);
    }

    public DoubleSquareMatrix(double[][] dArray) {
        super(dArray);
        if (dArray.length != dArray[0].length) {
            this.matrix = null;
            throw new MatrixDimensionException("The array is not square.");
        }
    }

    public DoubleSquareMatrix(DoubleVector[] doubleVectorArray) {
        super(doubleVectorArray);
        if (doubleVectorArray.length != doubleVectorArray[0].dimension()) {
            this.matrix = null;
            throw new MatrixDimensionException("The array does not form a square matrix.");
        }
    }

    public boolean isSymmetric() {
        return this.equals(this.transpose());
    }

    public boolean isUnitary() {
        return this.multiply(this.transpose()).equals(DoubleDiagonalMatrix.identity(this.matrix[0].length));
    }

    public double det() {
        if (this.matrix.length == 2) {
            return this.matrix[0][0] * this.matrix[1][1] - this.matrix[0][1] * this.matrix[1][0];
        }
        DoubleSquareMatrix[] doubleSquareMatrixArray = this.luDecompose(null);
        double d = doubleSquareMatrixArray[1].matrix[0][0];
        int n = 1;
        while (n < this.matrix.length) {
            d *= doubleSquareMatrixArray[1].matrix[n][n];
            ++n;
        }
        return d * (double)this.LUpivot[this.matrix.length];
    }

    public double trace() {
        double d = this.matrix[0][0];
        int n = 1;
        while (n < this.matrix.length) {
            d += this.matrix[n][n];
            ++n;
        }
        return d;
    }

    public double operatorNorm() throws MaximumIterationsExceededException {
        return Math.sqrt(ArrayMath.max(LinearMath.eigenvalueSolveSymmetric((DoubleSquareMatrix)this.transpose().multiply(this))));
    }

    public DoubleMatrix add(DoubleMatrix doubleMatrix) {
        switch (doubleMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(doubleMatrix);
            }
        }
        if (this.matrix.length == doubleMatrix.rows() && this.matrix.length == doubleMatrix.columns()) {
            double[][] dArray = new double[this.matrix.length][this.matrix.length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.matrix[n][0] + doubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.matrix[n][n2] + doubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleSquareMatrix rawAdd(DoubleMatrix doubleMatrix) {
        if (this.matrix.length == doubleMatrix.matrix.length && this.matrix.length == doubleMatrix.matrix[0].length) {
            double[][] dArray = new double[this.matrix.length][this.matrix.length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.matrix[n][0] + doubleMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.matrix[n][n2] + doubleMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix add(DoubleSquareMatrix doubleSquareMatrix) {
        switch (doubleSquareMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(doubleSquareMatrix);
            }
        }
        if (this.matrix.length == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.matrix.length][this.matrix.length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.matrix[n][0] + doubleSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.matrix[n][n2] + doubleSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleMatrix subtract(DoubleMatrix doubleMatrix) {
        switch (doubleMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(doubleMatrix);
            }
        }
        if (this.matrix.length == doubleMatrix.rows() && this.matrix.length == doubleMatrix.columns()) {
            double[][] dArray = new double[this.matrix.length][this.matrix.length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.matrix[n][0] - doubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.matrix[n][n2] - doubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleSquareMatrix rawSubtract(DoubleMatrix doubleMatrix) {
        if (this.matrix.length == doubleMatrix.matrix.length && this.matrix.length == doubleMatrix.matrix[0].length) {
            double[][] dArray = new double[this.matrix.length][this.matrix.length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.matrix[n][0] - doubleMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.matrix[n][n2] - doubleMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix subtract(DoubleSquareMatrix doubleSquareMatrix) {
        switch (doubleSquareMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(doubleSquareMatrix);
            }
        }
        if (this.matrix.length == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.matrix.length][this.matrix.length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.matrix[n][0] - doubleSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.matrix[n][n2] - doubleSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleMatrix scalarMultiply(double d) {
        double[][] dArray = new double[this.matrix.length][this.matrix.length];
        int n = 0;
        while (n < dArray.length) {
            dArray[n][0] = d * this.matrix[n][0];
            int n2 = 1;
            while (n2 < dArray.length) {
                dArray[n][n2] = d * this.matrix[n][n2];
                ++n2;
            }
            ++n;
        }
        return new DoubleSquareMatrix(dArray);
    }

    public double scalarProduct(DoubleMatrix doubleMatrix) {
        switch (doubleMatrix.storageFormat) {
            case 1: {
                return this.rawScalarProduct(doubleMatrix);
            }
        }
        if (this.matrix.length == doubleMatrix.rows() && this.matrix.length == doubleMatrix.columns()) {
            double d = 0.0;
            int n = 0;
            while (n < this.matrix.length) {
                d += this.matrix[n][0] * doubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.matrix.length) {
                    d += this.matrix[n][n2] * doubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private double rawScalarProduct(DoubleMatrix doubleMatrix) {
        if (this.matrix.length == doubleMatrix.matrix.length && this.matrix.length == doubleMatrix.matrix[0].length) {
            double d = 0.0;
            int n = 0;
            while (n < this.matrix.length) {
                d += this.matrix[n][0] * doubleMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < this.matrix.length) {
                    d += this.matrix[n][n2] * doubleMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleSquareMatrix doubleSquareMatrix) {
        switch (doubleSquareMatrix.storageFormat) {
            case 1: {
                return this.rawScalarProduct(doubleSquareMatrix);
            }
        }
        if (this.matrix.length == doubleSquareMatrix.rows()) {
            double d = 0.0;
            int n = 0;
            while (n < this.matrix.length) {
                d += this.matrix[n][0] * doubleSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.matrix.length) {
                    d += this.matrix[n][n2] * doubleSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleVector multiply(DoubleVector doubleVector) {
        if (this.matrix.length == doubleVector.dimension()) {
            double[] dArray = new double[this.matrix.length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n] = this.matrix[n][0] * doubleVector.getComponent(0);
                int n2 = 1;
                while (n2 < this.matrix.length) {
                    int n3 = n;
                    dArray[n3] = dArray[n3] + this.matrix[n][n2] * doubleVector.getComponent(n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleVector(dArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public DoubleSquareMatrix multiply(DoubleSquareMatrix doubleSquareMatrix) {
        switch (doubleSquareMatrix.storageFormat) {
            case 1: {
                return this.rawMultiply(doubleSquareMatrix);
            }
        }
        if (this.matrix.length == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.matrix.length][this.matrix.length];
            int n = 0;
            while (n < dArray.length) {
                int n2 = 0;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.matrix[n][0] * doubleSquareMatrix.getElement(0, n2);
                    int n3 = 1;
                    while (n3 < dArray.length) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + this.matrix[n][n3] * doubleSquareMatrix.getElement(n3, n2);
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private DoubleSquareMatrix rawMultiply(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.matrix.length == doubleSquareMatrix.matrix.length) {
            double[][] dArray = new double[this.matrix.length][this.matrix.length];
            int n = 0;
            while (n < dArray.length) {
                int n2 = 0;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.matrix[n][0] * doubleSquareMatrix.matrix[0][n2];
                    int n3 = 1;
                    while (n3 < dArray.length) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + this.matrix[n][n3] * doubleSquareMatrix.matrix[n3][n2];
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public Matrix transpose() {
        double[][] dArray = new double[this.matrix.length][this.matrix.length];
        int n = 0;
        while (n < dArray.length) {
            dArray[0][n] = this.matrix[n][0];
            int n2 = 1;
            while (n2 < dArray.length) {
                dArray[n2][n] = this.matrix[n][n2];
                ++n2;
            }
            ++n;
        }
        return new DoubleSquareMatrix(dArray);
    }

    public DoubleSquareMatrix inverse() {
        int n;
        int n2;
        double[][] dArray = new double[this.matrix.length][this.matrix.length];
        double[][] dArray2 = new double[this.matrix.length][this.matrix.length];
        DoubleSquareMatrix[] doubleSquareMatrixArray = this.luDecompose(null);
        dArray[0][0] = 1.0 / doubleSquareMatrixArray[0].matrix[0][0];
        dArray2[0][0] = 1.0 / doubleSquareMatrixArray[1].matrix[0][0];
        int n3 = 1;
        while (n3 < this.matrix.length) {
            dArray[n3][n3] = 1.0 / doubleSquareMatrixArray[0].matrix[n3][n3];
            dArray2[n3][n3] = 1.0 / doubleSquareMatrixArray[1].matrix[n3][n3];
            ++n3;
        }
        n3 = 0;
        while (n3 < this.matrix.length - 1) {
            n2 = n3 + 1;
            while (n2 < this.matrix.length) {
                double d = 0.0;
                double d2 = 0.0;
                n = n3;
                while (n < n2) {
                    d2 -= doubleSquareMatrixArray[0].matrix[n2][n] * dArray[n][n3];
                    d -= dArray2[n3][n] * doubleSquareMatrixArray[1].matrix[n][n2];
                    ++n;
                }
                dArray[n2][n3] = d2 / doubleSquareMatrixArray[0].matrix[n2][n2];
                dArray2[n3][n2] = d / doubleSquareMatrixArray[1].matrix[n2][n2];
                ++n2;
            }
            ++n3;
        }
        double[][] dArray3 = new double[this.matrix.length][this.matrix.length];
        n3 = 0;
        while (n3 < this.matrix.length) {
            n2 = 0;
            while (n2 < n3) {
                n = n3;
                while (n < this.matrix.length) {
                    double[] dArray4 = dArray3[n3];
                    int n4 = this.LUpivot[n2];
                    dArray4[n4] = dArray4[n4] + dArray2[n3][n] * dArray[n][n2];
                    ++n;
                }
                ++n2;
            }
            n2 = n3;
            while (n2 < this.matrix.length) {
                n = n2;
                while (n < this.matrix.length) {
                    double[] dArray5 = dArray3[n3];
                    int n5 = this.LUpivot[n2];
                    dArray5[n5] = dArray5[n5] + dArray2[n3][n] * dArray[n][n2];
                    ++n;
                }
                ++n2;
            }
            ++n3;
        }
        return new DoubleSquareMatrix(dArray3);
    }

    public DoubleSquareMatrix[] luDecompose(int[] nArray) {
        if (this.LU != null) {
            if (nArray != null) {
                System.arraycopy(this.LUpivot, 0, nArray, 0, nArray.length);
            }
            return this.LU;
        }
        double[][] dArray = new double[this.matrix.length][this.matrix.length];
        double[][] dArray2 = new double[this.matrix.length][this.matrix.length];
        double[] dArray3 = new double[this.matrix.length];
        if (nArray == null) {
            nArray = new int[this.matrix.length + 1];
        }
        int n = 0;
        while (n < this.matrix.length) {
            nArray[n] = n;
            ++n;
        }
        nArray[this.matrix.length] = 1;
        int n2 = 0;
        while (n2 < this.matrix.length) {
            int n3;
            double d;
            n = 0;
            while (n < n2) {
                d = this.matrix[nArray[n]][n2];
                n3 = 0;
                while (n3 < n) {
                    d -= dArray2[n][n3] * dArray2[n3][n2];
                    ++n3;
                }
                dArray2[n][n2] = d;
                ++n;
            }
            double d2 = 0.0;
            int n4 = n2;
            n = n2;
            while (n < this.matrix.length) {
                d = this.matrix[nArray[n]][n2];
                n3 = 0;
                while (n3 < n2) {
                    d -= dArray2[n][n3] * dArray2[n3][n2];
                    ++n3;
                }
                dArray2[n][n2] = d;
                if ((d = Math.abs(d)) > d2) {
                    d2 = d;
                    n4 = n;
                }
                ++n;
            }
            if (n4 != n2) {
                System.arraycopy(dArray2[n2], 0, dArray3, 0, n2 + 1);
                System.arraycopy(dArray2[n4], 0, dArray2[n2], 0, n2 + 1);
                System.arraycopy(dArray3, 0, dArray2[n4], 0, n2 + 1);
                n3 = nArray[n2];
                nArray[n2] = nArray[n4];
                nArray[n4] = n3;
                nArray[this.matrix.length] = -nArray[this.matrix.length];
            }
            n = n2 + 1;
            while (n < this.matrix.length) {
                double[] dArray4 = dArray2[n];
                int n5 = n2;
                dArray4[n5] = dArray4[n5] / d2;
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.matrix.length) {
            dArray[n2][n2] = 1.0;
            n = n2 + 1;
            while (n < this.matrix.length) {
                dArray[n][n2] = dArray2[n][n2];
                dArray2[n][n2] = 0.0;
                ++n;
            }
            ++n2;
        }
        this.LU = new DoubleSquareMatrix[2];
        this.LU[0] = new DoubleSquareMatrix(dArray);
        this.LU[1] = new DoubleSquareMatrix(dArray2);
        this.LUpivot = new int[nArray.length];
        System.arraycopy(nArray, 0, this.LUpivot, 0, nArray.length);
        return this.LU;
    }

    public DoubleSquareMatrix[] choleskyDecompose() {
        double[][] dArray = new double[this.matrix.length][this.matrix.length];
        double[][] dArray2 = new double[this.matrix.length][this.matrix.length];
        double d = Math.sqrt(this.matrix[0][0]);
        dArray2[0][0] = d;
        dArray[0][0] = d;
        int n = 1;
        while (n < this.matrix.length) {
            double d2 = this.matrix[n][0] / dArray[0][0];
            dArray2[0][n] = d2;
            dArray[n][0] = d2;
            ++n;
        }
        int n2 = 1;
        while (n2 < this.matrix.length) {
            double d3 = this.matrix[n2][n2];
            n = 0;
            while (n < n2) {
                d3 -= dArray[n2][n] * dArray[n2][n];
                ++n;
            }
            double d4 = Math.sqrt(d3);
            dArray2[n2][n2] = d4;
            dArray[n2][n2] = d4;
            n = n2 + 1;
            while (n < this.matrix.length) {
                d3 = this.matrix[n][n2];
                int n3 = 0;
                while (n3 < n) {
                    d3 -= dArray[n2][n3] * dArray2[n3][n];
                    ++n3;
                }
                double d5 = d3 / dArray2[n2][n2];
                dArray2[n2][n] = d5;
                dArray[n][n2] = d5;
                ++n;
            }
            ++n2;
        }
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleSquareMatrix[]{new DoubleSquareMatrix(dArray), new DoubleSquareMatrix(dArray2)};
        return doubleSquareMatrixArray;
    }

    public DoubleSquareMatrix[] polarDecompose() {
        double[] dArray;
        DoubleVector[] doubleVectorArray = new DoubleVector[this.matrix.length];
        try {
            dArray = LinearMath.eigenSolveSymmetric(this, doubleVectorArray);
        }
        catch (MaximumIterationsExceededException maximumIterationsExceededException) {
            return null;
        }
        double[][] dArray2 = new double[this.matrix.length][this.matrix.length];
        double[][] dArray3 = new double[this.matrix.length][this.matrix.length];
        int n = 0;
        while (n < this.matrix.length) {
            double d = Math.abs(dArray[n]);
            dArray2[n][0] = dArray[n] * doubleVectorArray[n].getComponent(0) / d;
            dArray3[n][0] = d * doubleVectorArray[n].getComponent(0);
            int n2 = 1;
            while (n2 < this.matrix.length) {
                dArray2[n][n2] = dArray[n] * doubleVectorArray[n].getComponent(n2) / d;
                dArray3[n][n2] = d * doubleVectorArray[n].getComponent(n2);
                ++n2;
            }
            ++n;
        }
        double[][] dArray4 = new double[this.matrix.length][this.matrix.length];
        double[][] dArray5 = new double[this.matrix.length][this.matrix.length];
        int n3 = 0;
        while (n3 < this.matrix.length) {
            int n4 = 0;
            while (n4 < this.matrix.length) {
                dArray4[n3][n4] = doubleVectorArray[0].getComponent(n3) * dArray2[0][n4];
                dArray5[n3][n4] = doubleVectorArray[0].getComponent(n3) * dArray3[0][n4];
                int n5 = 1;
                while (n5 < this.matrix.length) {
                    double[] dArray6 = dArray4[n3];
                    int n6 = n4;
                    dArray6[n6] = dArray6[n6] + doubleVectorArray[n5].getComponent(n3) * dArray2[n5][n4];
                    double[] dArray7 = dArray5[n3];
                    int n7 = n4;
                    dArray7[n7] = dArray7[n7] + doubleVectorArray[n5].getComponent(n3) * dArray3[n5][n4];
                    ++n5;
                }
                ++n4;
            }
            ++n3;
        }
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleSquareMatrix[]{new DoubleSquareMatrix(dArray4), new DoubleSquareMatrix(dArray5)};
        return doubleSquareMatrixArray;
    }

    public DoubleMatrix mapElements(Mapping mapping) {
        double[][] dArray = new double[this.matrix.length][this.matrix.length];
        int n = 0;
        while (n < dArray.length) {
            dArray[n][0] = mapping.map(this.matrix[n][0]);
            int n2 = 1;
            while (n2 < dArray.length) {
                dArray[n][n2] = mapping.map(this.matrix[n][n2]);
                ++n2;
            }
            ++n;
        }
        return new DoubleSquareMatrix(dArray);
    }
}

