/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audio;

import com.sun.j3d.audio.AudioClipData;
import com.sun.j3d.audio.HaeAudioStream;
import com.sun.j3d.audio.HaeException;
import com.sun.j3d.audio.HaeWaveStreamBuffer;
import com.sun.j3d.audio.InvalidAudioFormatException;
import java.io.IOException;

class HaeAudioStreamClip
extends HaeAudioStream {
    AudioClipData clipData;
    public static final int CLIP_START = 0;
    public static final int CLIP_END = -1;
    public static final int CONTINUOUS_LOOP = -1;
    int startFrame = 0;
    int endFrame = 0;
    int numLoops = 0;
    int currentLoop = 0;
    boolean looping = true;

    public HaeAudioStreamClip(AudioClipData audioClipData, String string) throws HaeException, InvalidAudioFormatException {
        super(audioClipData.acis, string);
        this.clipData = audioClipData;
        this.endFrame = audioClipData.acis.getTotalFrames();
    }

    protected boolean getWavedata(HaeWaveStreamBuffer haeWaveStreamBuffer, int n) {
        boolean bl = false;
        try {
            int n2 = n;
            int n3 = 0;
            int n4 = this.currentLoop < this.numLoops && this.looping ? this.endFrame - this.clipData.acis.getCurrentFrame() : this.clipData.acis.getRemainingFrames();
            if (n4 <= 0 && (this.currentLoop < this.numLoops || this.numLoops == -1) && this.looping) {
                this.clipData.seek(this.startFrame);
                ++this.currentLoop;
                n4 = this.endFrame - this.clipData.acis.getCurrentFrame();
            }
            if (n4 < 0) {
                n4 = 0;
            }
            n2 = Math.min(n, n4);
            byte[] byArray = haeWaveStreamBuffer.allocateByte(n2);
            n3 = this.clipData.acis.getConvertedData(byArray, n2);
            this.m_samplesSubmitted += (long)n3;
            if (this.clipData.acis.streamIsFinished() && (this.currentLoop >= this.numLoops || !this.looping)) {
                this.processEndOfMedia();
                bl = true;
            }
            haeWaveStreamBuffer.reduceFrameCount(n3);
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(this.getClass().getName()) + "(" + this.getStreamName() + ") Exception during getWavedata callback. " + exception);
        }
        catch (Error error) {
            System.err.println(String.valueOf(this.getClass().getName()) + "(" + this.getStreamName() + ") Error during getWavedata callback. " + error);
        }
        if (this.verbose) {
            this.trace.println("getWavedata returning: " + (bl ^ true));
        }
        return bl ^ true;
    }

    public void seek(int n) throws IOException, HaeException {
        this.clipData.seek(n);
        if (this.numLoops > 0 && n > this.endFrame) {
            this.looping = false;
        }
        if (this.numLoops > 0 && n < this.endFrame) {
            this.looping = true;
        }
    }

    public void setLoop(int n, int n2, int n3) throws HaeException {
        if (n3 == 0) {
            this.numLoops = 0;
            this.startFrame = 0;
            this.endFrame = this.clipData.acis.getTotalFrames();
            return;
        }
        if (n2 == -1) {
            n2 = this.clipData.acis.getTotalFrames();
        }
        if (n2 <= n) {
            throw new HaeException("endFrame must be greater than startFrame");
        }
        if (n2 > this.clipData.acis.getTotalFrames()) {
            throw new HaeException("requested loop end position past end of clip");
        }
        if (n3 < 0 && n3 == -1) {
            throw new HaeException("negative number of loops requested: " + n3);
        }
        this.startFrame = n;
        this.endFrame = n2;
        this.numLoops = n3;
        if (this.clipData.acis.getCurrentFrame() > n2) {
            this.looping = false;
        }
    }

    public void start(double d, double d2, boolean bl) throws HaeException {
        this.currentLoop = 0;
        super.start(d, d2, bl);
    }
}

