/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audio;

import com.sun.j3d.audio.Format;

class AudioFormat
implements Format {
    public static final String JAUDIO_G711_ULAW = "JAUDIO_G711_ULAW";
    public static final String JAUDIO_G711_ALAW = "JAUDIO_G711_ALAW";
    public static final String JAUDIO_LINEAR = "JAUDIO_LINEAR";
    public static final String JAUDIO_FLOAT = "JAUDIO_FLOAT";
    public static final String JAUDIO_DOUBLE = "JAUDIO_DOUBLE";
    public static final String JAUDIO_G722 = "JAUDIO_G722";
    public static final String JAUDIO_G723_3 = "JAUDIO_G723_3";
    public static final String JAUDIO_G723_5 = "JAUDIO_G723_5";
    public static final String JAUDIO_G721_ADPCM = "JAUDIO_G721_ADPCM";
    public static final String JAUDIO_DBI_ADPCM = "JAUDIO_DBI_ADPCM";
    public static final String JAUDIO_OKI_ADPCM = "JAUDIO_OKI_ADPCM";
    public static final String JAUDIO_DIGISTD = "JAUDIO_DIGISTD";
    public static final String JAUDIO_DIGIFIX = "JAUDIO_DIGIFIX";
    public static final String JAUDIO_DVI = "JAUDIO_DVI";
    public static final String JAUDIO_LINEAR8 = "JAUDIO_LINEAR8";
    public static final String JAUDIO_MAC6 = "JAUDIO_MAC6";
    public static final String JAUDIO_MAC3 = "JAUDIO_MAC3";
    public static final String JAUDIO_GSM = "JAUDIO_GSM";
    private int iSampleRate;
    private String sEncode;
    private int iSampleSize;
    private int iSamplePerUnit;
    private int iChannels;
    private int cbSoundSize;
    private int cbSoundWorth;
    private boolean bigEndian;
    private boolean signed;

    public AudioFormat(int n, String string, int n2, int n3, int n4, boolean bl, boolean bl2) {
        this.iSampleRate = n;
        this.iSamplePerUnit = n3;
        this.sEncode = string;
        this.iSampleSize = n2;
        this.iChannels = n4;
        this.bigEndian = bl;
        this.signed = bl2;
        this.cbSoundSize = this.iChannels * this.iSampleSize / 8;
        this.cbSoundWorth = this.iSampleRate * this.cbSoundSize;
    }

    public int getChannels() {
        return this.iChannels;
    }

    public String getEncoding() {
        return this.sEncode;
    }

    public int getMaxSoundSize() {
        return this.cbSoundWorth;
    }

    public int getSamplePerUnit() {
        return this.iSamplePerUnit;
    }

    public int getSampleRate() {
        return this.iSampleRate;
    }

    public int getSampleSize() {
        return this.iSampleSize;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public Format match(Format format) {
        if (!(format instanceof AudioFormat)) {
            return null;
        }
        AudioFormat audioFormat = (AudioFormat)format;
        if (audioFormat.iSampleRate != this.iSampleRate) {
            return null;
        }
        if (audioFormat.iSampleSize != this.iSampleSize) {
            return null;
        }
        if (audioFormat.iSamplePerUnit != this.iSamplePerUnit) {
            return null;
        }
        if (audioFormat.iChannels != this.iChannels) {
            return null;
        }
        if (audioFormat.bigEndian != this.bigEndian) {
            return null;
        }
        if (audioFormat.signed != this.signed) {
            return null;
        }
        if (!audioFormat.sEncode.equals(this.sEncode)) {
            return null;
        }
        return audioFormat;
    }

    public String toString() {
        String string;
        switch (this.iChannels) {
            case 1: {
                string = "mono, ";
                break;
            }
            case 2: {
                string = "stereo, ";
                break;
            }
            default: {
                string = String.valueOf(String.valueOf(this.iChannels)) + " channel, ";
            }
        }
        int n = 8 / this.iSamplePerUnit * this.iSampleSize;
        String string2 = String.valueOf(string) + String.valueOf(n) + " bit " + String.valueOf(this.iSampleRate) + "Hz, " + this.getEncoding() + ", " + (this.signed ? "signed " : "unsigned ") + (this.bigEndian ? "big-endian " : "little-endian ") + "audio data";
        return string2;
    }
}

