/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audio;

import com.sun.j3d.audio.AudioContainerInputStream;
import com.sun.j3d.audio.AudioFormat;
import com.sun.j3d.audio.BadAudioHeaderException;
import com.sun.j3d.audio.HaeException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;

class AudioClipData {
    URL url = null;
    boolean isCached = false;
    AudioContainerInputStream acis = null;

    AudioClipData(URL uRL, boolean bl) throws BadAudioHeaderException, IOException {
        this.acis = AudioContainerInputStream.getStream(uRL.openStream());
        if (this.acis.getTotalFrames() == 0) {
            throw new BadAudioHeaderException("incomplete header information for creating an AudioClipData: no data chunk size found.");
        }
        this.url = uRL;
        this.isCached = bl;
        if (bl) {
            this.acis.setData();
        }
    }

    AudioClipData(byte[] byArray) throws BadAudioHeaderException, IOException {
        this.acis = AudioContainerInputStream.getStream(new ByteArrayInputStream(byArray));
        if (this.acis.getTotalFrames() == 0) {
            throw new BadAudioHeaderException("incomplete header information for creating an AudioClipData: no data chunk size found.");
        }
        this.isCached = true;
    }

    void seek(int n) throws IOException, HaeException {
        if (n > this.acis.getTotalFrames()) {
            throw new HaeException("requested seek position " + n + " exceeds total frame length " + this.acis.getTotalFrames());
        }
        AudioFormat audioFormat = this.acis.getInputFormat();
        int n2 = audioFormat.getSampleSize() * audioFormat.getChannels();
        int n3 = this.acis.getCurrentFrame();
        if (n > n3) {
            long l = (n - n3) * n2;
            long l2 = this.skipBytes(l);
        } else {
            if (this.acis.stream instanceof ByteArrayInputStream) {
                this.acis.stream.reset();
                if (this.url == null) {
                    this.skipBytes(this.acis.headerSize);
                }
            } else {
                this.acis.stream.close();
                this.acis.stream = this.url.openStream();
                this.skipBytes(this.acis.headerSize);
            }
            long l = n * n2;
            long l3 = this.skipBytes(l);
        }
        this.acis.setCurrentFrame(n);
    }

    long skipBytes(long l) throws IOException {
        long l2 = 0L;
        while (l2 < l) {
            l2 += this.acis.stream.skip(l - l2);
        }
        return l2;
    }
}

