/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.remote.protocol.parser;

import java.util.LinkedList;
import org.tigr.remote.protocol.parser.CheckPath;
import org.tigr.remote.protocol.parser.ParserException;
import org.tigr.util.ConfMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class ResponseHandlerBase
extends DefaultHandler {
    private LinkedList m_elements = new LinkedList();
    protected CheckPath m_path = new CheckPath(this.m_elements);
    protected ConfMap m_config;

    public ResponseHandlerBase(ConfMap confMap) {
        this.m_config = confMap;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.m_elements.addLast(string3);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.m_elements.removeLast();
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.processError(new Exception("[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage()));
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.processError(new Exception("[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage()));
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.processError(new Exception("[FatalError] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage()));
    }

    private String getLocationString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sAXParseException.getSystemId();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getColumnNumber());
        return stringBuffer.toString();
    }

    protected String getCurrentElement() {
        return (String)this.m_elements.getLast();
    }

    protected void processError(Exception exception) throws SAXException {
        throw new SAXException(new ParserException("Processing error", exception));
    }
}

