/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.remote.gateway;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.tigr.remote.gateway.util.IQueue;
import org.tigr.remote.gateway.util.Queue;

class SessionState {
    private PipedInputStream m_in;
    private PipedOutputStream m_out;
    private IQueue m_queue = new Queue();
    private IQueue m_requestQueue = new Queue();
    private boolean m_monitor = false;

    public void connect() throws IOException {
        this.m_out = new PipedOutputStream();
        this.m_in = new PipedInputStream(this.m_out);
    }

    public void checkConnected() {
        if (this.m_out == null || this.m_in == null) {
            throw new NullPointerException("Program error: pipe streams are not connected");
        }
    }

    public void free() {
        this.m_in = null;
        this.m_out = null;
    }

    public void createMonitor() throws IOException {
        if (this.m_monitor) {
            throw new IOException("Sesion monitor exists");
        }
        this.m_monitor = true;
    }

    public void releaseMonitor() {
        this.m_monitor = false;
    }

    public boolean isLocked() {
        return this.m_monitor;
    }

    public IQueue getMessageQueue() {
        return this.m_queue;
    }

    public IQueue getRequestQueue() {
        return this.m_requestQueue;
    }

    public InputStream getInputPipe() {
        return this.m_in;
    }

    public OutputStream getOutputPipe() {
        return this.m_out;
    }
}

