/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.util.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.BevelBorder;
import org.tigr.microarray.mev.FloatSlideData;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideDataElement;
import org.tigr.microarray.mev.ISlideMetaData;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.SlideDataElement;
import org.tigr.microarray.mev.TMEV;
import org.tigr.util.StringSplitter;

public class SlideDataLoader
extends JDialog {
    private static final int BUFFER_SIZE = 131072;
    private int result = 2;
    private ISlideData[] data;
    private ISlideMetaData meta;
    private File[] files;
    private boolean stop = false;
    private Exception exception;
    private LoadingPanel loadingPanel = new LoadingPanel();
    private boolean fillMissingSpots = false;

    public SlideDataLoader(JFrame jFrame, ISlideMetaData iSlideMetaData, File file, boolean bl) {
        this(jFrame, iSlideMetaData, new File[]{file}, bl);
    }

    public SlideDataLoader(JFrame jFrame, ISlideMetaData iSlideMetaData, File[] fileArray, boolean bl) {
        super(jFrame, "Slide Data Loading", true);
        this.meta = iSlideMetaData;
        this.files = fileArray;
        this.fillMissingSpots = bl;
        Listener listener = new Listener();
        this.loadingPanel.setFilesCount(fileArray.length);
        JPanel jPanel = this.createBtnsPanel(listener);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        container.add((Component)this.loadingPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        container.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(4, 8, 4, 8), 0, 0));
        this.addWindowListener(listener);
        this.pack();
    }

    public int showModal() throws Exception {
        return this.showModal(false);
    }

    public int showModal(boolean bl) throws Exception {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        Thread thread = new Thread(new Loader(bl));
        thread.setPriority(1);
        thread.start();
        this.show();
        if (this.isException()) {
            throw this.getException();
        }
        return this.result;
    }

    public ISlideData[] getData() {
        return this.data;
    }

    public ISlideData getData(int n) {
        if (this.data == null || n >= this.data.length || n < 0) {
            return null;
        }
        return this.data[n];
    }

    private boolean isException() {
        return this.exception != null;
    }

    private Exception getException() {
        return this.exception;
    }

    private void setException(Exception exception) {
        this.exception = exception;
    }

    private ISlideData[] loadData() throws IOException {
        if (this.files.length < 1) {
            return null;
        }
        ISlideData[] iSlideDataArray = new ISlideData[this.files.length];
        int n = 0;
        for (int i = 0; i < this.files.length; ++i) {
            if (this.stop) {
                return null;
            }
            this.loadingPanel.setFilesProgress(i);
            this.loadingPanel.setRemain(this.files.length - i);
            this.loadingPanel.setFileName(this.files[i].getPath());
            if (i == 0) {
                n = this.getCountOfLines(this.files[i]);
                this.loadingPanel.setLinesCount(n);
                if (this.meta == null) {
                    iSlideDataArray[i] = this.fillMissingSpots ? this.loadSlideDataFillAllSpots(this.files[i]) : this.loadSlideData(this.files[i]);
                    this.meta = iSlideDataArray[i].getSlideMetaData();
                    continue;
                }
                iSlideDataArray[i] = this.loadFloatSlideData(this.files[i], n, this.meta);
                continue;
            }
            iSlideDataArray[i] = this.loadFloatSlideData(this.files[i], n, this.meta);
        }
        return iSlideDataArray;
    }

    private ISlideData loadFloatSlideData(File file, int n, ISlideMetaData iSlideMetaData) throws IOException {
        String string;
        int n2 = TMEV.getCoordinatePairCount() * 2;
        int n3 = TMEV.getIntensityCount();
        int n4 = TMEV.getHeaderRowCount();
        if (!TMEV.indicesAdjusted()) {
            TMEV.setUniqueIDIndex(TMEV.getUniqueIDIndex() - 9);
            TMEV.setNameIndex(TMEV.getNameIndex() - 9);
            TMEV.setIndicesAdjusted(true);
        }
        FloatSlideData floatSlideData = new FloatSlideData(iSlideMetaData);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file), 131072);
        StringSplitter stringSplitter = new StringSplitter('\t');
        float[] fArray = new float[n3];
        int n5 = 0;
        int n6 = 0;
        while ((string = bufferedReader.readLine()) != null) {
            if (n5 < n4) {
                ++n5;
                continue;
            }
            this.loadingPanel.setFileProgress(n6);
            stringSplitter.init(string);
            stringSplitter.passTokens(n2);
            for (int i = 0; i < n3; ++i) {
                fArray[i] = stringSplitter.nextFloatToken(0.0f);
            }
            floatSlideData.setIntensities(n6, fArray[0], fArray[1]);
            ++n6;
        }
        bufferedReader.close();
        floatSlideData.setSlideDataName(file.getName());
        floatSlideData.setSlideFileName(file.getPath());
        return floatSlideData;
    }

    private ISlideData loadSlideDataFillAllSpots(File file) throws IOException {
        int n;
        SlideDataElement slideDataElement;
        String string;
        if (!TMEV.indicesAdjusted()) {
            TMEV.setUniqueIDIndex(TMEV.getUniqueIDIndex() - 9);
            TMEV.setNameIndex(TMEV.getNameIndex() - 9);
            TMEV.setIndicesAdjusted(true);
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = TMEV.getCoordinatePairCount();
        int n5 = TMEV.getIntensityCount();
        int n6 = TMEV.getHeaderRowCount();
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        float[] fArray = new float[n5];
        String[] stringArray = new String[TMEV.getFieldNames().length];
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file), 131072);
        StringSplitter stringSplitter = new StringSplitter('\t');
        int n7 = 0;
        while ((string = bufferedReader.readLine()) != null) {
            if (n7 < n6) {
                ++n7;
                continue;
            }
            stringSplitter.init(string);
            int n8 = stringSplitter.nextIntToken();
            int n9 = stringSplitter.nextIntToken();
            if (n8 > n2) {
                n2 = n8;
            }
            if (n9 <= n3) continue;
            n3 = n9;
        }
        SlideData slideData = new SlideData(n2, n3);
        bufferedReader.close();
        bufferedReader = new BufferedReader(new FileReader(file));
        n7 = 0;
        int n10 = 0;
        boolean[][] blArray = new boolean[n2][n3];
        while ((string = bufferedReader.readLine()) != null) {
            int n11;
            if (n7 < n6) {
                ++n7;
                continue;
            }
            this.loadingPanel.setFileProgress(n10++);
            stringSplitter.init(string);
            for (n11 = 0; n11 < n4; ++n11) {
                nArray[n11] = stringSplitter.nextIntToken();
                nArray2[n11] = stringSplitter.nextIntToken();
            }
            for (n11 = 0; n11 < n5; ++n11) {
                fArray[n11] = stringSplitter.nextFloatToken(0.0f);
            }
            for (n11 = 0; n11 < TMEV.getFieldNames().length; ++n11) {
                if (stringSplitter.hasMoreTokens()) {
                    String string2 = stringSplitter.nextToken();
                    if (string2.equals("null")) {
                        stringArray[n11] = "";
                        continue;
                    }
                    stringArray[n11] = string2;
                    continue;
                }
                stringArray[n11] = "";
            }
            blArray[nArray[0] - 1][nArray2[0] - 1] = true;
            slideDataElement = new SlideDataElement(nArray, nArray2, fArray, stringArray);
            slideData.addSlideDataElement(slideDataElement);
        }
        bufferedReader.close();
        fArray[0] = 0.0f;
        fArray[1] = 0.0f;
        String[] stringArray2 = new String[TMEV.getFieldNames().length];
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray2[n] = "";
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                if (blArray[n][i]) continue;
                slideDataElement = new SlideDataElement(new int[]{n + 1, 1, 1}, new int[]{i + 1, 1, 1}, fArray, stringArray2);
                slideData.insertElementAt(slideDataElement, n * n3 + i);
            }
        }
        slideData.setSlideDataName(file.getName());
        slideData.setSlideFileName(file.getPath());
        return slideData;
    }

    public static ISlideData fillBlankSpots(ISlideData iSlideData) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < iSlideData.getSize(); ++i) {
            ISlideDataElement iSlideDataElement = iSlideData.getSlideDataElement(i);
            int n3 = iSlideDataElement.getRow(0);
            int n4 = iSlideDataElement.getColumn(0);
            n = Math.max(n, n3);
            n2 = Math.max(n2, n4);
        }
        return SlideDataLoader.fillBlankSpots(iSlideData, n, n2);
    }

    public static ISlideData fillBlankSpots(ISlideData iSlideData, int n, int n2) {
        ISlideDataElement iSlideDataElement;
        int n3;
        String[] stringArray = new String[TMEV.getFieldNames().length];
        float[] fArray = new float[TMEV.getIntensityCount()];
        boolean[][] blArray = new boolean[n][n2];
        if (iSlideData.getSize() == n * n2) {
            return iSlideData;
        }
        for (n3 = 0; n3 < iSlideData.getSize(); ++n3) {
            iSlideDataElement = iSlideData.getSlideDataElement(n3);
            blArray[iSlideDataElement.getRow((int)0) - 1][iSlideDataElement.getColumn((int)0) - 1] = true;
        }
        for (n3 = 0; n3 < TMEV.getIntensityCount(); ++n3) {
            fArray[n3] = 0.0f;
        }
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            stringArray[n3] = "";
        }
        if (iSlideData instanceof SlideData) {
            for (n3 = 0; n3 < n; ++n3) {
                for (int i = 0; i < n2; ++i) {
                    if (blArray[n3][i]) continue;
                    iSlideDataElement = new SlideDataElement(new int[]{n3 + 1, 1, 1}, new int[]{i + 1, 1, 1}, fArray, stringArray);
                    ((SlideData)iSlideData).insertElementAt(iSlideDataElement, n3 * n2 + i);
                }
            }
        }
        return iSlideData;
    }

    private ISlideData loadSlideData(File file) throws IOException {
        String string;
        if (!TMEV.indicesAdjusted()) {
            TMEV.setUniqueIDIndex(TMEV.getUniqueIDIndex() - 9);
            TMEV.setNameIndex(TMEV.getNameIndex() - 9);
            TMEV.setIndicesAdjusted(true);
        }
        int n = 0;
        int n2 = 0;
        int n3 = TMEV.getCoordinatePairCount();
        int n4 = TMEV.getIntensityCount();
        int n5 = TMEV.getHeaderRowCount();
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        float[] fArray = new float[n4];
        String[] stringArray = new String[TMEV.getFieldNames().length];
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file), 131072);
        StringSplitter stringSplitter = new StringSplitter('\t');
        int n6 = 0;
        while ((string = bufferedReader.readLine()) != null) {
            if (n6 < n5) {
                ++n6;
                continue;
            }
            stringSplitter.init(string);
            int n7 = stringSplitter.nextIntToken();
            int n8 = stringSplitter.nextIntToken();
            if (n7 > n) {
                n = n7;
            }
            if (n8 <= n2) continue;
            n2 = n8;
        }
        SlideData slideData = new SlideData(n, n2);
        bufferedReader.close();
        bufferedReader = new BufferedReader(new FileReader(file));
        n6 = 0;
        int n9 = 0;
        while ((string = bufferedReader.readLine()) != null) {
            int n10;
            if (n6 < n5) {
                ++n6;
                continue;
            }
            this.loadingPanel.setFileProgress(n9++);
            stringSplitter.init(string);
            for (n10 = 0; n10 < n3; ++n10) {
                nArray[n10] = stringSplitter.nextIntToken();
                nArray2[n10] = stringSplitter.nextIntToken();
            }
            for (n10 = 0; n10 < n4; ++n10) {
                fArray[n10] = stringSplitter.nextFloatToken(0.0f);
            }
            for (n10 = 0; n10 < TMEV.getFieldNames().length; ++n10) {
                if (stringSplitter.hasMoreTokens()) {
                    String string2 = stringSplitter.nextToken();
                    if (string2.equals("null")) {
                        stringArray[n10] = "";
                        continue;
                    }
                    stringArray[n10] = string2;
                    continue;
                }
                stringArray[n10] = "";
            }
            SlideDataElement slideDataElement = new SlideDataElement(nArray, nArray2, fArray, stringArray);
            slideData.addSlideDataElement(slideDataElement);
        }
        bufferedReader.close();
        slideData.setSlideDataName(file.getName());
        slideData.setSlideFileName(file.getPath());
        return slideData;
    }

    public ISlideData[] loadStanford() throws Exception {
        String string;
        if (this.files.length < 1) {
            return null;
        }
        if (!TMEV.indicesAdjusted()) {
            TMEV.setUniqueIDIndex(TMEV.getUniqueIDIndex() - 1);
            TMEV.setNameIndex(TMEV.getNameIndex() - 1);
            TMEV.setIndicesAdjusted(true);
        }
        int n = TMEV.getHeaderRowCount();
        int n2 = TMEV.getHeaderColumnCount();
        int n3 = this.getCountOfLines(this.files[0]);
        if (n3 <= 0) {
            throw new Exception("There are no spot data.");
        }
        this.loadingPanel.setFilesProgress(0);
        this.loadingPanel.setRemain(1);
        this.loadingPanel.setFileName(this.files[0].getPath());
        this.loadingPanel.setLinesCount(n3);
        int[] nArray = new int[]{0, 1, 0};
        int[] nArray2 = new int[]{0, 1, 0};
        String[] stringArray = new String[n2];
        int n4 = n3;
        ISlideData[] iSlideDataArray = null;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.files[0]));
        StringSplitter stringSplitter = new StringSplitter('\t');
        int n5 = 0;
        int n6 = 1;
        int n7 = 1;
        while ((string = bufferedReader.readLine()) != null) {
            int n8;
            if (this.stop) {
                return null;
            }
            stringSplitter.init(string);
            if (n5 == 0) {
                int n9;
                n8 = stringSplitter.countTokens() + 1 - n2;
                iSlideDataArray = new ISlideData[n8];
                iSlideDataArray[0] = new SlideData(n4, 1);
                for (n9 = 1; n9 < iSlideDataArray.length; ++n9) {
                    iSlideDataArray[n9] = new FloatSlideData(iSlideDataArray[0].getSlideMetaData(), n3);
                }
                stringSplitter.passTokens(n2);
                for (n9 = 0; n9 < n8; ++n9) {
                    iSlideDataArray[n9].setSlideDataName(stringSplitter.nextToken());
                }
            } else if (n5 >= n) {
                nArray[0] = nArray[2] = n7++;
                nArray2[0] = nArray2[2] = n6;
                n6 = n6 == 1 ? 1 : ++n6;
                for (n8 = 0; n8 < n2; ++n8) {
                    stringArray[n8] = stringSplitter.nextToken();
                }
                SlideDataElement slideDataElement = new SlideDataElement(nArray, nArray2, new float[2], stringArray);
                iSlideDataArray[0].addSlideDataElement(slideDataElement);
                for (n8 = 0; n8 < iSlideDataArray.length; ++n8) {
                    float f;
                    float f2 = 100000.0f;
                    try {
                        f = (float)(100000.0 * Math.pow(2.0, Float.parseFloat(stringSplitter.nextToken())));
                    }
                    catch (Exception exception) {
                        f = 0.0f;
                        f2 = 0.0f;
                    }
                    iSlideDataArray[n8].setIntensities(n5 - n, f2, f);
                }
            }
            this.loadingPanel.setFileProgress(++n5);
        }
        bufferedReader.close();
        return iSlideDataArray;
    }

    private int getCountOfLines(File file) throws IOException {
        String string;
        int n = 0;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            ++n;
        }
        bufferedReader.close();
        return n - TMEV.getHeaderRowCount();
    }

    private void abort() {
        this.stop = true;
    }

    private void setResult(int n) {
        this.result = n;
    }

    private JPanel createBtnsPanel(ActionListener actionListener) {
        JPanel jPanel = new JPanel(new BorderLayout());
        JButton jButton = new JButton("Cancel");
        jButton.setActionCommand("cancel-command");
        jButton.addActionListener(actionListener);
        jPanel.add((Component)jButton, "East");
        this.getRootPane().setDefaultButton(jButton);
        return jPanel;
    }

    static /* synthetic */ ISlideData[] access$302(SlideDataLoader slideDataLoader, ISlideData[] iSlideDataArray) {
        slideDataLoader.data = iSlideDataArray;
        return iSlideDataArray;
    }

    private class Loader
    implements Runnable {
        private boolean stanford;

        public Loader(boolean bl) {
            this.stanford = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                SlideDataLoader.access$302(SlideDataLoader.this, this.stanford ? SlideDataLoader.this.loadStanford() : SlideDataLoader.this.loadData());
                if (SlideDataLoader.this.data == null) {
                    SlideDataLoader.this.setResult(2);
                } else {
                    SlideDataLoader.this.setResult(0);
                }
            }
            catch (Exception exception) {
                SlideDataLoader.this.setException(exception);
            }
            finally {
                SlideDataLoader.this.dispose();
            }
        }
    }

    private class LoadingPanel
    extends JPanel {
        private JProgressBar filesProgress = new JProgressBar();
        private JProgressBar fileProgress = new JProgressBar();
        private JLabel filesLabel = new JLabel("Remain: ");
        private JLabel fileLabel = new JLabel("File: ");

        public LoadingPanel() {
            this.setPreferredSize(new Dimension(350, 120));
            this.setBorder(new BevelBorder(0));
            this.setLayout(new GridBagLayout());
            this.filesProgress.setStringPainted(true);
            this.fileProgress.setStringPainted(true);
            this.add((Component)this.filesLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this.filesProgress, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.add((Component)this.fileLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
            this.add((Component)this.fileProgress, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        }

        public void setFilesCount(int n) {
            this.filesProgress.setMaximum(n);
        }

        public void setLinesCount(int n) {
            this.fileProgress.setMaximum(n);
        }

        public void setFilesProgress(int n) {
            this.filesProgress.setValue(n);
        }

        public void setFileProgress(int n) {
            this.fileProgress.setValue(n);
        }

        public void setFileName(String string) {
            this.fileLabel.setText("File: " + string);
        }

        public void setRemain(int n) {
            this.filesLabel.setText("Remains: " + String.valueOf(n) + " file(s)");
        }
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SlideDataLoader.this.abort();
            SlideDataLoader.this.setResult(2);
            SlideDataLoader.this.dispose();
        }

        public void windowClosing(WindowEvent windowEvent) {
            SlideDataLoader.this.abort();
            SlideDataLoader.this.setResult(-1);
            SlideDataLoader.this.dispose();
        }
    }
}

