/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.util;

import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideMetaData;

public class SlideDataSorter {
    public static final int SORT_BY_LOCATION = 9000;
    public static final int SORT_BY_RATIO = 9001;
    private ISlideData slideData;

    public SlideDataSorter() {
    }

    public SlideDataSorter(ISlideData iSlideData) {
        if (iSlideData == null) {
            throw new IllegalArgumentException("SlideData is null.");
        }
        this.slideData = iSlideData;
    }

    public void setSlideData(ISlideData iSlideData) {
        this.slideData = iSlideData;
    }

    public int[] sort(int[] nArray, int n) {
        SlideDataSorter.sort(nArray, new IndicesComparator(n));
        return nArray;
    }

    public static void sort(int[] nArray, IndicesComparator indicesComparator) {
        int[] nArray2 = SlideDataSorter.cloneArray(nArray);
        SlideDataSorter.mergeSort(nArray2, nArray, 0, nArray.length, indicesComparator);
    }

    private static int[] cloneArray(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = nArray.length;
        while (--n >= 0) {
            nArray2[n] = nArray[n];
        }
        return nArray2;
    }

    private static void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    private static void mergeSort(int[] nArray, int[] nArray2, int n, int n2, IndicesComparator indicesComparator) {
        int n3 = n2 - n;
        if (n3 < 7) {
            for (int i = n; i < n2; ++i) {
                for (int j = i; j > n && indicesComparator.compare(nArray2[j - 1], nArray2[j]) > 0; --j) {
                    SlideDataSorter.swap(nArray2, j, j - 1);
                }
            }
            return;
        }
        int n4 = (n + n2) / 2;
        SlideDataSorter.mergeSort(nArray2, nArray, n, n4, indicesComparator);
        SlideDataSorter.mergeSort(nArray2, nArray, n4, n2, indicesComparator);
        if (indicesComparator.compare(nArray[n4 - 1], nArray[n4]) <= 0) {
            System.arraycopy(nArray, n, nArray2, n, n3);
            return;
        }
        int n5 = n;
        int n6 = n4;
        for (int i = n; i < n2; ++i) {
            nArray2[i] = n6 >= n2 || n5 < n4 && indicesComparator.compare(nArray[n5], nArray[n6]) <= 0 ? nArray[n5++] : nArray[n6++];
        }
    }

    private class IndicesComparator {
        private int type;

        public IndicesComparator(int n) {
            this.type = n;
        }

        public int compare(int n, int n2) {
            switch (this.type) {
                case 9000: {
                    ISlideMetaData iSlideMetaData = SlideDataSorter.this.slideData.getSlideMetaData();
                    int n3 = iSlideMetaData.getColumns();
                    if (iSlideMetaData.getRow(n) * n3 + iSlideMetaData.getColumn(n) < iSlideMetaData.getRow(n2) * n3 + iSlideMetaData.getColumn(n2)) {
                        return -1;
                    }
                    return 1;
                }
                case 9001: {
                    float f = SlideDataSorter.this.slideData.getRatio(n, 0);
                    float f2 = SlideDataSorter.this.slideData.getRatio(n2, 0);
                    if (Float.isNaN(f) && Float.isNaN(f2)) {
                        return -1;
                    }
                    if (Float.isNaN(f) && !Float.isNaN(f2)) {
                        return -1;
                    }
                    if (!Float.isNaN(f) && Float.isNaN(f2)) {
                        return 1;
                    }
                    if (f < f2) {
                        return -1;
                    }
                    return 1;
                }
            }
            ISlideMetaData iSlideMetaData = SlideDataSorter.this.slideData.getSlideMetaData();
            String string = iSlideMetaData.getValueAt(n, this.type);
            String string2 = iSlideMetaData.getValueAt(n2, this.type);
            return string.compareTo(string2);
        }
    }
}

