/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script.util;

import java.util.Arrays;
import java.util.Vector;
import org.tigr.microarray.mev.DetectionFilter;
import org.tigr.microarray.mev.FoldFilter;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.util.Adjustment;
import org.tigr.util.FloatMatrix;
import org.tigr.util.QSort;

public class ScriptDataTransformer {
    private Experiment experiment;
    private IFramework framework;

    public ScriptDataTransformer(Experiment experiment, IFramework iFramework) {
        this.experiment = experiment.copy();
        this.framework = iFramework;
    }

    public Experiment transformData(AlgorithmData algorithmData) {
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        String string = algorithmParameters.getString("name");
        if (string == null) {
            return null;
        }
        if (string.equals("Percentage Cutoff")) {
            float f = algorithmParameters.getFloat("percent-cutoff");
            this.experiment = this.createPercentCutoffExperiment(f);
        } else if (string.equals("Lower Cutoff")) {
            float f = algorithmParameters.getFloat("cy3-lower-cutoff");
            float f2 = algorithmParameters.getFloat("cy5-lower-cutoff");
        } else if (string.equals("Affy Detection Filter")) {
            this.experiment = this.applyAffyDetectionFilter(algorithmData);
        } else if (string.equals("Affy Fold Filter")) {
            this.experiment = this.applyAffyFoldFilter(algorithmData);
        } else if (string.equals("Normalize Spots")) {
            Adjustment.normalizeSpots(this.experiment.getMatrix());
        } else if (string.equals("Divide Spots by RMS")) {
            Adjustment.divideSpotsRMS(this.experiment.getMatrix());
        } else if (string.equals("Divide Spots by SD")) {
            Adjustment.divideSpotsSD(this.experiment.getMatrix());
        } else if (string.equals("Mean Center Spots")) {
            Adjustment.meanCenterSpots(this.experiment.getMatrix());
        } else if (string.equals("Median Center Spots")) {
            Adjustment.medianCenterSpots(this.experiment.getMatrix());
        } else if (string.equals("Digital Spots")) {
            Adjustment.digitalSpots(this.experiment.getMatrix());
        } else if (string.equals("Normalize Experiments")) {
            Adjustment.normalizeExperiments(this.experiment.getMatrix());
        } else if (string.equals("Divide Experiments by RMS")) {
            Adjustment.divideExperimentsRMS(this.experiment.getMatrix());
        } else if (string.equals("Divide Experiments by SD")) {
            Adjustment.divideExperimentsSD(this.experiment.getMatrix());
        } else if (string.equals("Mean Center Experiments")) {
            Adjustment.meanCenterExperiments(this.experiment.getMatrix());
        } else if (string.equals("Median Center Experiments")) {
            Adjustment.medianCenterExperiments(this.experiment.getMatrix());
        } else if (string.equals("Digital Experiments")) {
            Adjustment.digitalExperiments(this.experiment.getMatrix());
        }
        return this.experiment;
    }

    private Experiment createPercentCutoffExperiment(float f) {
        FloatMatrix floatMatrix = this.experiment.getMatrix();
        int[] nArray = this.experiment.getRowMappingArrayCopy();
        int n = floatMatrix.getColumnDimension();
        int n2 = (int)((float)n * (f / 100.0f));
        boolean[] blArray = new boolean[floatMatrix.getRowDimension()];
        int n3 = 0;
        block0: for (int i = 0; i < blArray.length; ++i) {
            int n4 = 0;
            for (int j = 0; j < n; ++j) {
                if (!Float.isNaN(floatMatrix.A[i][j])) {
                    ++n4;
                }
                if (n4 <= n2) continue;
                blArray[i] = true;
                ++n3;
                continue block0;
            }
        }
        float[][] fArray = new float[n3][n];
        int[] nArray2 = new int[n3];
        int n5 = 0;
        for (int i = 0; i < floatMatrix.A.length; ++i) {
            if (!blArray[i]) continue;
            nArray2[n5] = nArray[i];
            for (int j = 0; j < n; ++j) {
                fArray[n5][j] = floatMatrix.A[i][j];
            }
            ++n5;
        }
        return new Experiment(new FloatMatrix(fArray), this.experiment.getColumnIndicesCopy(), nArray2);
    }

    public Experiment getTrimmedExperiment(int[] nArray, boolean bl) {
        if (bl) {
            return this.getReducedExperiment_GeneReduction(nArray);
        }
        return this.getReducedExperiment_ExperimentReduction(nArray);
    }

    private Experiment getReducedExperiment_GeneReduction(int[] nArray) {
        FloatMatrix floatMatrix = this.experiment.getMatrix();
        int[] nArray2 = this.experiment.getRowMappingArrayCopy();
        int n = floatMatrix.getColumnDimension();
        float[][] fArray = new float[nArray.length][n];
        int[] nArray3 = new int[nArray.length];
        boolean bl = false;
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            nArray3[i] = n2 = nArray2[nArray[i]];
            for (int j = 0; j < n; ++j) {
                fArray[i][j] = floatMatrix.A[nArray[i]][j];
            }
        }
        return new Experiment(new FloatMatrix(fArray), this.experiment.getColumnIndicesCopy(), nArray3);
    }

    private Experiment getReducedExperiment_ExperimentReduction(int[] nArray) {
        FloatMatrix floatMatrix = this.experiment.getMatrix();
        int n = floatMatrix.getRowDimension();
        float[][] fArray = new float[n][nArray.length];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                fArray[i][j] = floatMatrix.A[i][nArray[j]];
            }
        }
        return new Experiment(new FloatMatrix(fArray), nArray, this.experiment.getRowMappingArrayCopy());
    }

    public int[][] selectClusters(AlgorithmData algorithmData, int[][] nArray) {
        int[][] nArrayArray;
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        int n = algorithmParameters.getInt("desired-cluster-count");
        int n2 = algorithmParameters.getInt("minimum-cluster-size");
        boolean bl = algorithmParameters.getBoolean("process-gene-clusters");
        String string = algorithmParameters.getString("name");
        if (string.equals("Diversity Ranking Cluster Selection")) {
            int n3;
            int n4 = algorithmParameters.getInt("distance-function");
            boolean bl2 = algorithmParameters.getBoolean("use-absolute");
            boolean bl3 = algorithmParameters.getBoolean("use-centroid-based-variability");
            int[][] nArray2 = this.getClustersBasedOnDiversityRank(algorithmData, this.experiment.getMatrix(), nArray, bl, bl3, n4, bl2);
            int n5 = 0;
            Vector<int[]> vector = new Vector<int[]>();
            for (n3 = 0; n3 < nArray2.length && n5 < n; ++n3) {
                if (nArray2[n3].length < n2) continue;
                vector.add(nArray2[n3]);
                ++n5;
            }
            nArrayArray = new int[vector.size()][];
            for (n3 = 0; n3 < nArrayArray.length; ++n3) {
                nArrayArray[n3] = (int[])vector.elementAt(n3);
            }
        } else {
            int n6;
            boolean bl4;
            FloatMatrix floatMatrix = this.experiment.getMatrix();
            if (!bl) {
                floatMatrix = floatMatrix.transpose();
            }
            FloatMatrix floatMatrix2 = this.getMeans(floatMatrix, nArray);
            if (!bl) {
                floatMatrix = floatMatrix.transpose();
            }
            int[][] nArray3 = (bl4 = algorithmParameters.getBoolean("use-centroid-variance")) ? this.getClustersBasedOnVarianceRank(algorithmData, floatMatrix2, nArray, bl) : this.getClustersBasedOnEntropyRank(algorithmData, floatMatrix2, nArray, bl);
            int n7 = 0;
            Vector<int[]> vector = new Vector<int[]>();
            for (n6 = 0; n6 < nArray3.length && n7 < n; ++n6) {
                if (nArray3[n6].length < n2) continue;
                vector.add(nArray3[n6]);
                ++n7;
            }
            nArrayArray = new int[vector.size()][];
            for (n6 = 0; n6 < nArrayArray.length; ++n6) {
                nArrayArray[n6] = (int[])vector.elementAt(n6);
            }
        }
        return nArrayArray;
    }

    private int[][] getClustersBasedOnDiversityRank(AlgorithmData algorithmData, FloatMatrix floatMatrix, int[][] nArray, boolean bl, boolean bl2, int n, boolean bl3) {
        float[] fArray;
        int[][] nArrayArray = new int[nArray.length][];
        if (!bl) {
            floatMatrix = floatMatrix.transpose();
        }
        if (bl2) {
            FloatMatrix floatMatrix2 = this.getMeans(floatMatrix, nArray);
            fArray = this.getCentroidBasedDiversities(floatMatrix, floatMatrix2, nArray, n, bl3);
        } else {
            fArray = this.getGeneBasedDiversities(floatMatrix, nArray, n, bl3);
        }
        QSort qSort = new QSort(fArray);
        fArray = qSort.getSorted();
        int[] nArray2 = qSort.getOrigIndx();
        for (int i = 0; i < nArrayArray.length; ++i) {
            nArrayArray[i] = nArray[nArray2[i]];
        }
        String[] stringArray = new String[fArray.length];
        String[] stringArray2 = new String[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            stringArray[i] = String.valueOf(fArray[i]);
            stringArray2[i] = String.valueOf(nArrayArray[i].length);
        }
        algorithmData.addStringArray("diversity-value-array", stringArray);
        algorithmData.addStringArray("cluster-population-array", stringArray2);
        if (!bl) {
            floatMatrix = floatMatrix.transpose();
        }
        return nArrayArray;
    }

    private FloatMatrix getMeans(FloatMatrix floatMatrix, int[][] nArray) {
        FloatMatrix floatMatrix2 = new FloatMatrix(nArray.length, floatMatrix.getColumnDimension());
        for (int i = 0; i < nArray.length; ++i) {
            floatMatrix2.A[i] = this.getMeans(floatMatrix, nArray[i]);
        }
        return floatMatrix2;
    }

    private float[] getMeans(FloatMatrix floatMatrix, int[] nArray) {
        int n = floatMatrix.getColumnDimension();
        float[] fArray = new float[n];
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < n; ++i) {
            f2 = 0.0f;
            f = 0.0f;
            for (int j = 0; j < nArray.length; ++j) {
                float f3 = floatMatrix.get(nArray[j], i);
                if (Float.isNaN(f3)) continue;
                f += f3;
                f2 += 1.0f;
            }
            fArray[i] = f2 > 0.0f ? f / f2 : Float.NaN;
        }
        return fArray;
    }

    private float[] getCentroidBasedDiversities(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int[][] nArray, int n, boolean bl) {
        float[] fArray = new float[nArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = 0.0f;
            for (int j = 0; j < nArray[i].length; ++j) {
                int n2 = i;
                fArray[n2] = fArray[n2] + ExperimentUtil.geneDistance((FloatMatrix)floatMatrix2, (FloatMatrix)floatMatrix, (int)i, (int)nArray[i][j], (int)n, (float)1.0f, (boolean)bl);
            }
            int n3 = i;
            fArray[n3] = fArray[n3] / (float)nArray[i].length;
        }
        return fArray;
    }

    private float[] getGeneBasedDiversities(FloatMatrix floatMatrix, int[][] nArray, int n, boolean bl) {
        float[] fArray = new float[nArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = 0.0f;
            for (int j = 0; j < nArray[i].length; ++j) {
                for (int k = 0; k < nArray[i].length / 2; ++k) {
                    int n2 = i;
                    fArray[n2] = fArray[n2] + ExperimentUtil.geneDistance((FloatMatrix)floatMatrix, (FloatMatrix)floatMatrix, (int)nArray[i][j], (int)nArray[i][k], (int)n, (float)1.0f, (boolean)bl);
                }
            }
            int n3 = i;
            fArray[n3] = (float)((double)fArray[n3] / (Math.pow(nArray[i].length, 2.0) / 2.0 - (double)(nArray[i].length / 2)));
        }
        return fArray;
    }

    private int[][] getClustersBasedOnVarianceRank(AlgorithmData algorithmData, FloatMatrix floatMatrix, int[][] nArray, boolean bl) {
        float[] fArray = this.getCentroidVariances(floatMatrix);
        int[][] nArrayArray = new int[nArray.length][];
        QSort qSort = new QSort(fArray, 2);
        fArray = qSort.getSorted();
        int[] nArray2 = qSort.getOrigIndx();
        for (int i = 0; i < nArrayArray.length; ++i) {
            nArrayArray[i] = nArray[nArray2[i]];
        }
        String[] stringArray = new String[fArray.length];
        String[] stringArray2 = new String[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            stringArray[i] = String.valueOf(fArray[i]);
            stringArray2[i] = String.valueOf(nArrayArray[i].length);
        }
        algorithmData.addStringArray("diversity-value-array", stringArray);
        algorithmData.addStringArray("cluster-population-array", stringArray2);
        return nArrayArray;
    }

    private float[] getCentroidVariances(FloatMatrix floatMatrix) {
        float[] fArray = new float[floatMatrix.getRowDimension()];
        int n = floatMatrix.getColumnDimension();
        for (int i = 0; i < fArray.length; ++i) {
            float f = 0.0f;
            float f2 = this.getMean(floatMatrix.A[i]);
            for (int j = 0; j < n; ++j) {
                f = (float)((double)f + Math.pow(floatMatrix.A[i][j] - f2, 2.0));
            }
            fArray[i] = f;
        }
        return fArray;
    }

    private float getMean(float[] fArray) {
        float f = 0.0f;
        int n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            if (Float.isNaN(fArray[i])) continue;
            ++n;
            f += fArray[i];
        }
        return n > 0 ? f / (float)n : 0.0f;
    }

    private int[][] getClustersBasedOnEntropyRank(AlgorithmData algorithmData, FloatMatrix floatMatrix, int[][] nArray, boolean bl) {
        float[] fArray = new float[floatMatrix.getRowDimension()];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = (float)this.getEntropy(floatMatrix.A[i]);
        }
        int[][] nArrayArray = new int[nArray.length][];
        QSort qSort = new QSort(fArray, 2);
        fArray = qSort.getSorted();
        int[] nArray2 = qSort.getOrigIndx();
        for (int i = 0; i < nArrayArray.length; ++i) {
            nArrayArray[i] = nArray[nArray2[i]];
        }
        String[] stringArray = new String[fArray.length];
        String[] stringArray2 = new String[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            stringArray[i] = String.valueOf(fArray[i]);
            stringArray2[i] = String.valueOf(nArrayArray[i].length);
        }
        algorithmData.addStringArray("diversity-value-array", stringArray);
        algorithmData.addStringArray("cluster-population-array", stringArray2);
        return nArrayArray;
    }

    private double getEntropy(float[] fArray) {
        int n = 10;
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        int n2 = 0;
        int[] nArray = new int[n];
        int n3 = fArray.length;
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (Double.isNaN(fArray[n2])) continue;
            d = Math.min(d, (double)fArray[n2]);
            d2 = Math.max(d2, (double)fArray[n2]);
            ++n4;
        }
        double d3 = (d2 - d) / (double)n;
        if (d3 == 0.0) {
            return -1.0 * Math.log(1.0) / Math.log(2.0);
        }
        if (d == Double.MAX_VALUE) {
            return 0.0;
        }
        Arrays.fill(nArray, 0);
        for (n2 = 0; n2 < n3; ++n2) {
            if (Double.isNaN(fArray[n2])) continue;
            int n5 = (int)Math.ceil(((double)fArray[n2] - d) / d3) - 1;
            if (n5 < 0) {
                n5 = 0;
            }
            int n6 = n5;
            nArray[n6] = nArray[n6] + 1;
        }
        if (n4 == 0) {
            return 0.0;
        }
        double d4 = 0.0;
        for (n2 = 0; n2 < n; ++n2) {
            if (nArray[n2] == 0) continue;
            double d5 = (double)nArray[n2] / (double)n4;
            d4 += d5 * Math.log(d5) / Math.log(2.0);
        }
        return -d4;
    }

    private Experiment applyAffyDetectionFilter(AlgorithmData algorithmData) {
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        IData iData = this.framework.getData();
        int[] nArray = this.experiment.getRowMappingArrayCopy();
        int[] nArray2 = this.experiment.getColumnIndicesCopy();
        int n = this.experiment.getNumberOfGenes();
        int n2 = this.experiment.getNumberOfSamples();
        String[] stringArray = new String[n2];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = iData.getFullSampleName(nArray2[i]);
        }
        DetectionFilter detectionFilter = new DetectionFilter(stringArray);
        detectionFilter.set_both(algorithmParameters.getBoolean("is-required-in-both-groups"));
        int[] nArray3 = algorithmData.getIntArray("number-required");
        for (int i = 0; i < nArray3.length; ++i) {
            detectionFilter.set_num_required(i, nArray3[i]);
        }
        int[] nArray4 = algorithmData.getIntArray("group-memberships");
        for (int i = 0; i < nArray4.length; ++i) {
            detectionFilter.set_group_membership(nArray4[i], i);
        }
        String[] stringArray2 = new String[n2];
        boolean[] blArray = new boolean[n];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                stringArray2[j] = iData.getFeature(nArray2[j]).getDetection(nArray[i]);
            }
            boolean bl = detectionFilter.keep_gene(stringArray2);
            if (!bl) continue;
            blArray[i] = true;
            ++n3;
        }
        FloatMatrix floatMatrix = this.experiment.getMatrix();
        float[][] fArray = new float[n3][n2];
        int[] nArray5 = new int[n3];
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            if (!blArray[i]) continue;
            nArray5[n4] = nArray[i];
            fArray[n4] = floatMatrix.A[i];
            ++n4;
        }
        return new Experiment(new FloatMatrix(fArray), nArray2, nArray5);
    }

    private Experiment applyAffyFoldFilter(AlgorithmData algorithmData) {
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        IData iData = this.framework.getData();
        FloatMatrix floatMatrix = this.experiment.getMatrix();
        int[] nArray = this.experiment.getRowMappingArrayCopy();
        int[] nArray2 = this.experiment.getColumnIndicesCopy();
        int n = this.experiment.getNumberOfGenes();
        int n2 = this.experiment.getNumberOfSamples();
        String[] stringArray = new String[n2];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = iData.getFullSampleName(nArray2[i]);
        }
        FoldFilter foldFilter = new FoldFilter(stringArray);
        float f = algorithmParameters.getFloat("fold-change");
        int[] nArray3 = algorithmData.getIntArray("number-of-members");
        String string = algorithmParameters.getString("divider-string");
        foldFilter.set_fold_change(f);
        foldFilter.set_divider(string);
        int[] nArray4 = algorithmData.getIntArray("group-memberships");
        for (int i = 0; i < nArray4.length; ++i) {
            foldFilter.set_group_membership(nArray4[i], i);
        }
        float[] fArray = new float[n2];
        boolean[] blArray = new boolean[n];
        int n3 = 0;
        float[] fArray2 = new float[n];
        for (int i = 0; i < n; ++i) {
            boolean bl = foldFilter.keep_gene(floatMatrix.A[i]);
            if (!bl) continue;
            blArray[i] = true;
            ++n3;
        }
        float[][] fArray3 = new float[n3][n2];
        int[] nArray5 = new int[n3];
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            if (!blArray[i]) continue;
            nArray5[n4] = nArray[i];
            fArray3[n4] = floatMatrix.A[i];
            ++n4;
        }
        return new Experiment(new FloatMatrix(fArray3), nArray2, nArray5);
    }
}

