/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.apache.xerces.parsers.DOMParser;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.script.ScriptManager;
import org.tigr.microarray.mev.script.util.AlgorithmNode;
import org.tigr.microarray.mev.script.util.AlgorithmSet;
import org.tigr.microarray.mev.script.util.ErrorLog;
import org.tigr.microarray.mev.script.util.ParameterAttributes;
import org.tigr.microarray.mev.script.util.ScriptParameterException;
import org.tigr.microarray.mev.script.util.ScriptTree;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ParameterValidator
extends DefaultHandler {
    Element validationRoot;
    boolean haveValidationRoot;

    public boolean loadParameterConstraints() {
        try {
            File file = TMEV.getConfigurationFile("ParameterConstraints.xml");
            DOMParser dOMParser = new DOMParser();
            dOMParser.setFeature("http://xml.org/sax/features/validation", true);
            dOMParser.setErrorHandler((ErrorHandler)this);
            dOMParser.parse(file.toURL().toString());
            this.validationRoot = dOMParser.getDocument().getDocumentElement();
            this.haveValidationRoot = true;
        }
        catch (NullPointerException nullPointerException) {
            this.haveValidationRoot = false;
            JOptionPane.showMessageDialog(new JFrame(), "The parameter validation feature in support of scripting could not be initialized.\nThe constraint file \"ParameterConstraints.xml\" could not be located.\nScript capabilities will operate without full parameter validation", "Parameter Validation Initialization Error", 0);
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.haveValidationRoot = false;
            JOptionPane.showMessageDialog(new JFrame(), "The parameter validation feature in support of scripting could not be initialized properly.\n\"ParameterConstraints.xml\" contained errors reported in the console window.\nScript capabilities will operate without full parameter validation", "Parameter Validation Initialization Error", 0);
            return false;
        }
        return true;
    }

    public boolean isEnabled() {
        return this.haveValidationRoot;
    }

    public boolean validate(ScriptManager scriptManager, ScriptTree scriptTree, ErrorLog errorLog) {
        AlgorithmSet[] algorithmSetArray = scriptTree.getAlgorithmSets();
        boolean bl = true;
        errorLog.reset();
        NodeList nodeList = this.validationRoot.getElementsByTagName("script_algorithm");
        for (int i = 0; i < algorithmSetArray.length; ++i) {
            for (int j = 0; j < algorithmSetArray[i].getAlgorithmCount(); ++j) {
                AlgorithmNode algorithmNode = algorithmSetArray[i].getAlgorithmNodeAt(j);
                if (this.validateAlgorithm(algorithmNode, nodeList, errorLog)) continue;
                bl = false;
            }
        }
        return bl;
    }

    private boolean validateAlgorithm(AlgorithmNode algorithmNode, NodeList nodeList, ErrorLog errorLog) {
        AlgorithmData algorithmData = algorithmNode.getAlgorithmData();
        Map map = algorithmData.getParams().getMap();
        Iterator iterator = map.keySet().iterator();
        String string = algorithmNode.getAlgorithmName();
        boolean bl = true;
        if (string == null) {
            return false;
        }
        if (algorithmNode.getAlgorithmType().equals("data-adjustment")) {
            return true;
        }
        Element element = this.getAlgorithmElement(string, nodeList);
        if (element == null) {
            JOptionPane.showMessageDialog(new JFrame(), "The " + string + " algorithm does not have information to support parameter validation." + "\nPlease be aware that script loading will proceed without validation of this algorithm.", "Unsupported Parameter Validation", 2);
            return true;
        }
        if (element == null) {
            ScriptParameterException scriptParameterException = this.createScriptParameterException(algorithmNode, "Parameter constraint information is not available for this algorithm. The algorithm parameters can not be validated.");
            errorLog.recordParameterError(scriptParameterException);
            return false;
        }
        Vector vector = this.validateRequiredParameters(map.keySet(), element);
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                ScriptParameterException scriptParameterException = new ScriptParameterException(algorithmNode.getAlgorithmName(), algorithmNode.getID(), algorithmNode.getDataNodeRef(), (String)vector.elementAt(i), "N/A", "Missing required parameter.");
                errorLog.recordParameterError(scriptParameterException);
            }
            bl = false;
        }
        while (iterator.hasNext()) {
            String string2;
            String string3 = (String)iterator.next();
            if (this.validateParameter(string3, string2 = (String)map.get(string3), element, algorithmNode, errorLog)) continue;
            bl = false;
        }
        return bl;
    }

    private Element getAlgorithmElement(String string, NodeList nodeList) {
        Element element = null;
        Element element2 = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            element = (Element)nodeList.item(i);
            if (!element.getAttribute("name").equals(string)) continue;
            element2 = element;
            break;
        }
        return element2;
    }

    private Vector validateRequiredParameters(Set set, Element element) {
        Vector<String> vector = new Vector<String>();
        NodeList nodeList = element.getElementsByTagName("param");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!((Element)nodeList.item(i)).getAttribute("val_level").equalsIgnoreCase("REQUIRED")) continue;
            vector.add(((Element)nodeList.item(i)).getAttribute("key"));
        }
        Vector vector2 = new Vector(set);
        Vector vector3 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            if (vector2.contains((String)vector.elementAt(i))) continue;
            vector3.add(vector.elementAt(i));
        }
        return vector3;
    }

    private boolean validateParameter(String string, String string2, Element element, AlgorithmNode algorithmNode, ErrorLog errorLog) {
        NodeList nodeList = element.getElementsByTagName("param");
        Element element2 = this.getParameterElement(nodeList, string);
        boolean bl = true;
        if (element2 == null) {
            ScriptParameterException scriptParameterException = this.createScriptParameterException(algorithmNode, element2, string2, "Invalid key. Key name not recognized.");
            errorLog.recordParameterError(scriptParameterException);
            return false;
        }
        if (!this.validateValueType(string2, element2, element, errorLog)) {
            ScriptParameterException scriptParameterException = this.createScriptParameterException(algorithmNode, element2, string2, "Incorrect value type.");
            errorLog.recordParameterError(scriptParameterException);
            bl = false;
        }
        if (!this.validateValueConstraints(algorithmNode.getAlgorithmName(), string, string2)) {
            // empty if block
        }
        return bl;
    }

    private ScriptParameterException createScriptParameterException(AlgorithmNode algorithmNode, Element element, String string, String string2) {
        ScriptParameterException scriptParameterException = new ScriptParameterException(algorithmNode.getAlgorithmName(), algorithmNode.getID(), algorithmNode.getDataNodeRef(), element.getAttribute("key"), string, string2);
        return scriptParameterException;
    }

    private ScriptParameterException createScriptParameterException(AlgorithmNode algorithmNode, String string) {
        ScriptParameterException scriptParameterException = new ScriptParameterException(algorithmNode.getAlgorithmName(), algorithmNode.getID(), algorithmNode.getDataNodeRef(), "N/A", "N/A", string);
        return scriptParameterException;
    }

    private Element getParameterElement(NodeList nodeList, String string) {
        Element element = null;
        for (int i = 0; i < nodeList.getLength() && !(element = (Element)nodeList.item(i)).getAttribute("key").equals(string); ++i) {
        }
        return element;
    }

    private boolean validateValueType(String string, Element element, Element element2, ErrorLog errorLog) {
        String string2 = element.getAttribute("value_type");
        boolean bl = true;
        try {
            if (string2.equals("boolean")) {
                if (!string.equals("true") && !string.equals("false")) {
                    bl = true;
                }
            } else if (string2.equals("int")) {
                Integer.parseInt(string);
            } else if (string2.equals("long")) {
                Long.parseLong(string);
            } else if (string2.equals("float")) {
                Float.parseFloat(string);
            } else if (string2.equals("double")) {
                Double.parseDouble(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return bl;
    }

    private boolean validateValueConstraints(String string, String string2, String string3) {
        ParameterAttributes parameterAttributes = this.getParameterAttributes(string, string2);
        if (parameterAttributes == null || !parameterAttributes.hasConstraints()) {
            return true;
        }
        return this.checkConstraints(string3, parameterAttributes.getValueType(), parameterAttributes.getMin(), parameterAttributes.getMax());
    }

    private boolean checkConstraints(String string, String string2, String string3, String string4) {
        if (string2.equals("int")) {
            int n = Integer.parseInt(string);
            if (!string3.equals("") && !string4.equals("")) {
                return n >= Integer.parseInt(string3) && n <= Integer.parseInt(string4);
            }
            if (!string4.equals("")) {
                return n <= Integer.parseInt(string4);
            }
            if (!string3.equals("")) {
                return n >= Integer.parseInt(string3);
            }
            return true;
        }
        if (string2.equals("float")) {
            float f = Float.parseFloat(string);
            if (!string3.equals("") && !string4.equals("")) {
                return f >= Float.parseFloat(string3) && f <= Float.parseFloat(string4);
            }
            if (!string4.equals("")) {
                return f <= Float.parseFloat(string4);
            }
            if (!string3.equals("")) {
                return f >= Float.parseFloat(string3);
            }
            return true;
        }
        if (string2.equals("long")) {
            long l = Long.parseLong(string);
            if (!string3.equals("") && !string4.equals("")) {
                return l >= Long.parseLong(string3) && l <= Long.parseLong(string4);
            }
            if (!string4.equals("")) {
                return l <= Long.parseLong(string4);
            }
            if (!string3.equals("")) {
                return l >= Long.parseLong(string3);
            }
            return true;
        }
        if (string2.equals("double")) {
            double d = Double.parseDouble(string);
            if (!string3.equals("") && !string4.equals("")) {
                return d >= Double.parseDouble(string3) && d <= Double.parseDouble(string4);
            }
            if (!string4.equals("")) {
                return d <= Double.parseDouble(string4);
            }
            if (!string3.equals("")) {
                return d >= Double.parseDouble(string3);
            }
            return true;
        }
        return true;
    }

    public String getValidParameterTable(String string) {
        if (!this.isEnabled()) {
            return null;
        }
        String string2 = null;
        Element element = this.findAlgorithmElement(string);
        if (element != null) {
            Element element2 = (Element)element.getElementsByTagName("param_list").item(0);
            if (element2 == null) {
                return null;
            }
            NodeList nodeList = element2.getElementsByTagName("param");
            string2 = "";
            string2 = "<h2>Valid Script Parameters for " + string + "</h2>";
            string2 = string2 + "<p>Note: Parameters that are not listed as \"Always\" required usually depend on the value of other entered parameters to determine if they are required.</p>";
            string2 = string2 + "<table border=3><th>Key</th><th>Value Type</th><th>Min</th><th>Max</th><th>Required</th>";
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element3 = (Element)nodeList.item(i);
                NodeList nodeList2 = element3.getElementsByTagName("constraint");
                String string3 = element3.getAttribute("key");
                String string4 = element3.getAttribute("value_type");
                String string5 = element3.getAttribute("val_level");
                String string6 = " ";
                String string7 = " ";
                if (nodeList2 != null && nodeList2.getLength() > 0) {
                    Element element4 = (Element)nodeList2.item(0);
                    string6 = element4.getAttribute("min");
                    string7 = element4.getAttribute("max");
                }
                string2 = string2 + "<tr><td>" + string3 + "</td><td>" + string4 + "</td><td>" + string6 + "</td><td>" + string7 + "</td><td>" + (string5.equalsIgnoreCase("REQUIRED") ? "Always" : "Dependent") + "</td></tr>";
            }
            string2 = string2 + "</table>";
        }
        return string2;
    }

    public Hashtable getParameterHash(String string) {
        Element element = this.findAlgorithmElement(string);
        if (element == null) {
            return null;
        }
        Element element2 = (Element)element.getElementsByTagName("param_list").item(0);
        Hashtable<String, ParameterAttributes> hashtable = new Hashtable<String, ParameterAttributes>();
        NodeList nodeList = element2.getElementsByTagName("param");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            ParameterAttributes parameterAttributes;
            Element element3 = (Element)nodeList.item(i);
            String string2 = element3.getAttribute("key");
            String string3 = element3.getAttribute("value_type");
            String string4 = element3.getAttribute("val_level");
            NodeList nodeList2 = null;
            nodeList2 = element3.getElementsByTagName("constraint");
            if (nodeList2 == null || nodeList2.getLength() == 0) {
                parameterAttributes = new ParameterAttributes(string2, string3, string4);
            } else {
                Element element4 = (Element)nodeList2.item(0);
                String string5 = element4.getAttribute("min");
                String string6 = element4.getAttribute("max");
                parameterAttributes = new ParameterAttributes(string2, string3, string4, string5, string6);
            }
            hashtable.put(string2, parameterAttributes);
        }
        return hashtable;
    }

    public ParameterAttributes getParameterAttributes(String string, String string2) {
        Hashtable hashtable = this.getParameterHash(string);
        if (hashtable == null) {
            return null;
        }
        return (ParameterAttributes)hashtable.get(string2);
    }

    public void checkAlgorithmsForDataDependance(ScriptTree scriptTree, ScriptManager scriptManager) {
        AlgorithmSet[] algorithmSetArray = scriptTree.getAlgorithmSets();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < algorithmSetArray.length; ++i) {
            for (int j = 0; j < algorithmSetArray[i].getAlgorithmCount(); ++j) {
                String string = algorithmSetArray[i].getAlgorithmNodeAt(j).getAlgorithmName();
                Element element = this.findAlgorithmElement(string);
                if (element == null || !element.getAttribute("input_data_dep").equals("true") || vector.contains(string)) continue;
                vector.addElement(string);
            }
        }
        if (vector.size() > 0) {
            JTextPane jTextPane = new JTextPane();
            jTextPane.setContentType("text/html");
            jTextPane.setEditable(false);
            jTextPane.setMargin(new Insets(10, 10, 10, 5));
            String string = "<html><center><h2>Data Dependent Script Algorithms</h2></center>";
            string = string + "<hr size=3>The processing of the following algorithm";
            string = vector.size() == 1 ? string + " is " : string + "s are ";
            string = string + "dependent on the number and order of the loaded experiments.<br>";
            string = string + "<center><b>";
            for (int i = 0; i < vector.size(); ++i) {
                string = string + (String)vector.elementAt(i) + "<br>";
            }
            string = string + "</b><br></center>";
            string = string + "Please verify that the data set (number of loaded experiments and their order) is appropriate for the listed algorithms.</html>";
            jTextPane.setText(string);
            JScrollPane jScrollPane = new JScrollPane(jTextPane);
            jScrollPane.setViewportBorder(BorderFactory.createLineBorder(Color.black));
            jScrollPane.getViewport().setViewSize(new Dimension(450, 275));
            jScrollPane.setPreferredSize(new Dimension(450, 275));
            JOptionPane.showMessageDialog(scriptManager.getFrame(), jScrollPane, "Data Set Dependent Algorithms", -1);
        }
    }

    private Element findAlgorithmElement(String string) {
        NodeList nodeList = this.validationRoot.getElementsByTagName("script_algorithm");
        Element element = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string2 = null;
            element = (Element)nodeList.item(i);
            string2 = element.getAttribute("name");
            if (string2 == null || !string2.equals(string)) continue;
            return element;
        }
        return null;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
    }
}

