/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.script.ScriptManager;
import org.tigr.microarray.mev.script.scriptGUI.ScriptXMLViewer;
import org.tigr.microarray.mev.script.util.ScriptParameterException;
import org.xml.sax.SAXParseException;

public class ErrorLog {
    Vector fatalErrors;
    Vector errors;
    Vector warnings;
    Vector parameterErrors;
    ScriptManager manager;
    ErrorLogDialog eDialog;
    File scriptFile;
    int result = 2;

    public ErrorLog(ScriptManager scriptManager) {
        this.manager = scriptManager;
        this.reset();
        this.eDialog = new ErrorLogDialog();
    }

    public void reset() {
        this.fatalErrors = new Vector();
        this.errors = new Vector();
        this.warnings = new Vector();
        this.parameterErrors = new Vector();
    }

    public void setFile(File file) {
        this.scriptFile = file;
    }

    public boolean isValid() {
        return this.fatalErrors.size() == 0 && this.errors.size() == 0;
    }

    public boolean hasWarnings() {
        return this.warnings.size() != 0;
    }

    public boolean hasErrors() {
        return this.errors.size() != 0;
    }

    public boolean hasFatalErrors() {
        return this.fatalErrors.size() != 0;
    }

    public boolean hasParameterErrors() {
        return this.parameterErrors.size() != 0;
    }

    public boolean isEmpty() {
        return this.isValid() && !this.hasWarnings();
    }

    public void recordWarning(SAXParseException sAXParseException) {
        this.warnings.add(sAXParseException);
    }

    public void recordError(SAXParseException sAXParseException) {
        this.errors.add(sAXParseException);
    }

    public void recordFatalError(SAXParseException sAXParseException) {
        this.fatalErrors.add(sAXParseException);
    }

    public void recordParameterError(ScriptParameterException scriptParameterException) {
        this.parameterErrors.add(scriptParameterException);
    }

    public void reportAllListings() {
        this.eDialog.updateContent();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.eDialog.setLocation((dimension.width - this.eDialog.getSize().width) / 2, (dimension.height - this.eDialog.getSize().height) / 2);
        this.eDialog.show();
    }

    public void reportFatalErrors() {
        this.eDialog.updateContent();
        this.eDialog.show();
    }

    public void reportErrors() {
        this.eDialog.updateContent();
        this.eDialog.show();
    }

    public void reportWarnings() {
        this.eDialog.updateContent();
        this.eDialog.show();
    }

    public String[] getFataErrors() {
        return null;
    }

    public String[] getErrors() {
        return null;
    }

    public String[] getWarnings() {
        return null;
    }

    private class ErrorLogDialog
    extends AlgorithmDialog {
        JTextPane pane;
        String text;
        JScrollPane sPane;
        boolean isEditing = false;

        public ErrorLogDialog() {
            super(new JFrame(), "Script Error Log", true);
            this.buttonPanel.remove(this.okButton);
            this.buttonPanel.remove(this.cancelButton);
            this.buttonPanel.remove(this.resetButton);
            this.cancelButton.setText("Edit Script");
            this.cancelButton.setActionCommand("edit-command");
            this.cancelButton.setSize(120, 30);
            this.cancelButton.setPreferredSize(new Dimension(120, 30));
            this.okButton.setText("Close Log");
            this.okButton.setActionCommand("close-command");
            this.okButton.setSize(120, 30);
            this.okButton.setPreferredSize(new Dimension(120, 30));
            this.buttonPanel.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.buttonPanel.add((Component)this.okButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 20, 0, 0), 0, 0));
            this.buttonPanel.validate();
            this.pane = new JTextPane();
            this.pane.setEditable(false);
            this.pane.setMargin(new Insets(0, 10, 5, 15));
            this.pane.setBackground(new Color(252, 253, 196));
            this.pane.setContentType("text/html");
            this.sPane = new JScrollPane(this.pane);
            this.addContent(this.sPane);
            this.setActionListeners((ActionListener)((Object)new Listener()));
            this.setSize(550, 600);
        }

        public void updateContent() {
            String string;
            String string2;
            int n;
            SAXParseException sAXParseException;
            int n2;
            boolean bl = false;
            this.text = new String();
            this.text = this.text + "<html><body>";
            if (ErrorLog.this.fatalErrors.size() > 0) {
                bl = true;
                this.text = this.text + "<h2>Fatal Errors</h2><h3>The following Fatal Error";
                if (ErrorLog.this.fatalErrors.size() > 1) {
                    this.text = this.text + "s";
                }
                this.text = this.text + " occured during parsing and validation.</h2>";
                this.text = this.text + "<p>Note: Fatal Errors indicate that the input script had fundamental problems in script construction such as unpaired tags.  Loading will be terminated so that the reported errors can be corrected.  MeV does not have to be closed while corrections are made to the input script.</p>";
                this.text = this.text + "<table border=3><th>Line</th><th>Error</th></tr>";
                for (n2 = 0; n2 < ErrorLog.this.fatalErrors.size(); ++n2) {
                    sAXParseException = (SAXParseException)ErrorLog.this.fatalErrors.elementAt(n2);
                    n = sAXParseException.getLineNumber();
                    string2 = n >= 0 ? String.valueOf(n) : "N/A";
                    string = sAXParseException.getMessage();
                    this.text = this.text + "<tr><td align=center>" + string2 + "</td><td>" + string + "</td></tr>";
                }
                this.text = this.text + "</table>";
            }
            if (ErrorLog.this.errors.size() > 0) {
                if (bl) {
                    this.text = this.text + "<br><hr size=3>";
                }
                this.text = this.text + "<h2>Validation Errors</h2><h3>The following Validation Error";
                if (ErrorLog.this.errors.size() > 1) {
                    this.text = this.text + "s";
                }
                this.text = this.text + " occured during parsing and validation.</h2>";
                this.text = this.text + "<p>Note: Validation Errors indicate that the input script did not conform to the conventions of the document type definition.  Loading will be terminated so that the reported errors can be corrected.  MeV does not have to be closed while corrections are made to the input script.</p>";
                this.text = this.text + "<table border=3><tr><th>Line</th><th>Error</th></tr>";
                for (n2 = 0; n2 < ErrorLog.this.errors.size(); ++n2) {
                    sAXParseException = (SAXParseException)ErrorLog.this.errors.elementAt(n2);
                    n = sAXParseException.getLineNumber();
                    string2 = n >= 0 ? String.valueOf(n) : "N/A";
                    string = sAXParseException.getMessage();
                    this.text = this.text + "<tr><td align=center>" + string2 + "</td><td>" + string + "</td></tr>";
                }
                this.text = this.text + "</table>";
            }
            if (ErrorLog.this.warnings.size() > 0) {
                if (bl) {
                    this.text = this.text + "<br><hr size=3>";
                }
                this.text = this.text + "<h2>Warnings</h2><h3>The following Warning";
                if (ErrorLog.this.warnings.size() > 1) {
                    this.text = this.text + "s";
                }
                this.text = this.text + " occured during parsing and validation.</h2>";
                if (!bl) {
                    this.text = this.text + "<p>Note: The script has loaded with some reported warnings If you would like to stop the script load hit stop otherwise hit continue to complete the loading.</p>";
                }
                this.text = this.text + "<table border=3><th>Line</th><th>Error</th></tr>";
                for (n2 = 0; n2 < ErrorLog.this.warnings.size(); ++n2) {
                    sAXParseException = (SAXParseException)ErrorLog.this.warnings.elementAt(n2);
                    n = sAXParseException.getLineNumber();
                    string2 = n >= 0 ? String.valueOf(n) : "N/A";
                    string = sAXParseException.getMessage();
                    this.text = this.text + "<tr><td align=center>" + string2 + "</td><td>" + string + "</td></tr>";
                }
                this.text = this.text + "</table>";
            }
            if (ErrorLog.this.parameterErrors.size() > 0) {
                Object object;
                String string3;
                Vector vector = new Vector();
                Hashtable hashtable = new Hashtable();
                for (int i = 0; i < ErrorLog.this.parameterErrors.size(); ++i) {
                    ScriptParameterException scriptParameterException = (ScriptParameterException)ErrorLog.this.parameterErrors.elementAt(i);
                    string3 = scriptParameterException.getAlgoritmName();
                    if (hashtable.containsKey(string3)) {
                        ((Vector)hashtable.get(string3)).add(scriptParameterException);
                        continue;
                    }
                    object = new Vector<ScriptParameterException>();
                    ((Vector)object).add(scriptParameterException);
                    hashtable.put(string3, object);
                }
                if (bl) {
                    this.text = this.text + "<br><hr size=3>";
                }
                this.text = this.text + "<h2>Script Parameter Validation Errors</h2><h3>The following Error";
                if (ErrorLog.this.parameterErrors.size() > 1) {
                    this.text = this.text + "s";
                }
                this.text = this.text + " occurred during parameter validation.</h3>";
                this.text = this.text + "<p>Note: The parameter warnings are reported so that you are aware of possible script errors that could abort processing during script execution.</p>";
                this.text = this.text + "<br><hr size=3>";
                object = hashtable.keys();
                int n3 = 0;
                while (object.hasMoreElements()) {
                    if (n3 > 0) {
                        this.text = this.text + "<br><hr size=3>";
                    }
                    ++n3;
                    string3 = (String)object.nextElement();
                    Vector vector2 = (Vector)hashtable.get(string3);
                    this.text = this.text + "<table border=3><th>Algorithm</th><th>Alg. Index</th><th>Data Ref.</th><th>Key</th><th>Error</th>";
                    for (int i = 0; i < vector2.size(); ++i) {
                        ScriptParameterException scriptParameterException = (ScriptParameterException)vector2.elementAt(i);
                        this.text = this.text + "<tr><td>" + string3 + "</td><td>" + String.valueOf(scriptParameterException.getAlgorithmIndex()) + "</td><td>" + String.valueOf(scriptParameterException.getDataReference()) + "</td><td>" + scriptParameterException.getKey() + "</td><td><b>" + scriptParameterException.getMessage() + "</b></td></tr>";
                    }
                    this.text = this.text + "</table>";
                    String string4 = ErrorLog.this.manager.getValidParametersTable(string3);
                    if (string4 == null) continue;
                    this.text = this.text + string4;
                }
            }
            this.text = this.text + "</body></html>";
            this.setText(this.text);
        }

        public void setText(String string) {
            this.text = string;
            this.pane.setText(this.text);
            this.pane.setCaretPosition(0);
            this.pane.repaint();
        }

        private class Listener
        extends DialogListener {
            private Listener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                String string = actionEvent.getActionCommand();
                if (string.equals("close-command")) {
                    ErrorLogDialog.this.dispose();
                } else if (string.equals("edit-command")) {
                    if (ErrorLogDialog.this.isEditing) {
                        return;
                    }
                    ErrorLogDialog.this.isEditing = true;
                    ErrorLogDialog.this.cancelButton.setEnabled(false);
                    ScriptXMLViewer scriptXMLViewer = new ScriptXMLViewer(((ErrorLogDialog)ErrorLogDialog.this).ErrorLog.this.scriptFile);
                    if (scriptXMLViewer.getText().length() > 10) {
                        Point point = ErrorLogDialog.this.getLocation();
                        int n = ErrorLogDialog.this.getWidth();
                        int n2 = ErrorLogDialog.this.sPane.getHeight();
                        JScrollPane jScrollPane = new JScrollPane(scriptXMLViewer.getContentComponent());
                        jScrollPane.setRowHeaderView(scriptXMLViewer.getRowHeaderComponent());
                        JSplitPane jSplitPane = new JSplitPane(1, ErrorLogDialog.this.sPane, jScrollPane);
                        jSplitPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                        jSplitPane.setDividerLocation((int)((double)n * 0.65));
                        jSplitPane.setPreferredSize(new Dimension(n + n / 2, n2));
                        jSplitPane.setSize(n + n / 2, n2);
                        ErrorLogDialog.this.addContent(jSplitPane);
                        ErrorLogDialog.this.pack();
                        if (point != null) {
                            ErrorLogDialog.this.setLocation(point.x - n / 4, point.y);
                        }
                    } else {
                        JOptionPane.showMessageDialog((Component)((Object)ErrorLogDialog.this), "Couldn't load script file into script editor.", "Script Editor Loading Error", 2);
                    }
                } else if (string.equals("info-command")) {
                    HelpWindow helpWindow = new HelpWindow((JDialog)((Object)ErrorLogDialog.this), "Error Log");
                    if (helpWindow.getWindowContent()) {
                        helpWindow.setSize(450, 650);
                        helpWindow.setLocation();
                        helpWindow.show();
                    } else {
                        helpWindow.setVisible(false);
                        helpWindow.dispose();
                    }
                }
            }

            public void windowClosing(WindowEvent windowEvent) {
                ((ErrorLogDialog)ErrorLogDialog.this).ErrorLog.this.result = -1;
                ErrorLogDialog.this.dispose();
            }
        }
    }
}

