/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.parsers.DOMParser;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.script.ScriptManager;
import org.tigr.microarray.mev.script.event.ScriptDocumentEvent;
import org.tigr.microarray.mev.script.event.ScriptEventListener;
import org.tigr.microarray.mev.script.util.AlgorithmNode;
import org.tigr.microarray.mev.script.util.ErrorLog;
import org.tigr.util.FloatMatrix;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DocumentBase
extends DefaultHandler
implements Serializable {
    public static final long serialVersionUID = 1000102010302010001L;
    protected String tm4ScriptVersion = "1.0";
    protected String mevScriptVersion = "1.0";
    protected ScriptManager manager;
    protected Document document;
    protected String scriptText;
    protected Element root;
    protected Element mevElement;
    protected Element primaryDataElement;
    protected Element commentElement;
    protected Element analysisElement;
    protected int currDataID = 1;
    protected int currAlgSetID = 1;
    protected String lineSeparator = System.getProperty("line.separator");
    protected String indent = "   ";
    protected int parseErrors = 0;
    protected ErrorLog errorLog;
    private Vector listeners;
    protected boolean parsedScript = false;
    protected boolean isTextCurrent = false;

    public DocumentBase(ScriptManager scriptManager) {
        this.manager = scriptManager;
        this.errorLog = new ErrorLog(scriptManager);
        this.listeners = new Vector();
        DOMImplementationImpl dOMImplementationImpl = new DOMImplementationImpl();
        DocumentType documentType = dOMImplementationImpl.createDocumentType("TM4ML", null, "../../config/mev_script_dtd.dtd");
        this.document = dOMImplementationImpl.createDocument(null, "TM4ML", documentType);
        this.root = this.document.getDocumentElement();
        this.root.setAttribute("version", this.tm4ScriptVersion);
        this.mevElement = this.document.createElement("mev");
        this.mevElement.setAttribute("version", this.mevScriptVersion);
        this.root.appendChild(this.mevElement);
        this.analysisElement = this.document.createElement("analysis");
        this.primaryDataElement = this.document.createElement("primary_data");
        this.primaryDataElement.setAttribute("id", "1");
        this.createAlgorithmSet(1);
        this.mevElement.appendChild(this.primaryDataElement);
        this.mevElement.appendChild(this.analysisElement);
        this.scriptText = new String("");
        this.updateScript();
    }

    public DocumentBase(String string, String string2, String string3, ScriptManager scriptManager) {
        this.manager = scriptManager;
        this.errorLog = new ErrorLog(scriptManager);
        this.listeners = new Vector();
        DOMImplementationImpl dOMImplementationImpl = new DOMImplementationImpl();
        DocumentType documentType = dOMImplementationImpl.createDocumentType("TM4ML", null, "../../config/mev_script_dtd.dtd");
        this.document = dOMImplementationImpl.createDocument(null, "TM4ML", documentType);
        this.root = this.document.getDocumentElement();
        this.root.setAttribute("version", this.tm4ScriptVersion);
        this.mevElement = this.document.createElement("mev");
        this.mevElement.setAttribute("version", this.mevScriptVersion);
        this.root.appendChild(this.mevElement);
        if (string != null) {
            this.setDateComment(string);
        }
        if (string2 != null) {
            this.setNameComment(string2);
        }
        if (string3 != null) {
            this.setDescriptionComment(string3);
        }
        this.analysisElement = this.document.createElement("analysis");
        this.primaryDataElement = this.document.createElement("primary_data");
        this.primaryDataElement.setAttribute("id", "1");
        this.createAlgorithmSet(1);
        this.mevElement.appendChild(this.primaryDataElement);
        this.mevElement.appendChild(this.analysisElement);
        this.scriptText = new String("");
        this.updateScript();
    }

    public DocumentBase(DocumentBase documentBase) {
        this.manager = documentBase.getManager();
        this.document = this.copyDocument(documentBase.getDocument());
    }

    private Document copyDocument(Document document) {
        DOMImplementationImpl dOMImplementationImpl = new DOMImplementationImpl();
        DocumentType documentType = dOMImplementationImpl.createDocumentType("TM4ML", null, "../../config/mev_script_dtd.dtd");
        Document document2 = dOMImplementationImpl.createDocument(null, "TM4ML", documentType);
        this.copyChildren(document.getDocumentElement(), document2.getDocumentElement(), document2);
        this.isTextCurrent = false;
        return document2;
    }

    private void copyChildren(Node node, Node node2, Document document) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            Node node4 = document.importNode(node3, false);
            node2.appendChild(node4);
            if (!node3.hasChildNodes()) continue;
            this.copyChildren(node3, node4, document);
        }
        this.isTextCurrent = false;
    }

    public void setDocument(Document document) {
        this.document = document;
        this.updateScript();
    }

    public Document getDocument() {
        return this.document;
    }

    public ScriptManager getManager() {
        return this.manager;
    }

    public void setDateComment(String string) {
        Comment comment = this.document.createComment(" Original Script Creation Date: " + string + " ");
        this.mevElement.appendChild(comment);
        this.updateScript();
    }

    public void setNameComment(String string) {
        Comment comment = this.document.createComment(" Script Name: " + string + " ");
        this.mevElement.appendChild(comment);
        this.updateScript();
    }

    public void setDescriptionComment(String string) {
        Comment comment = this.document.createComment(" Script Description: " + string + " ");
        this.mevElement.appendChild(comment);
        this.updateScript();
    }

    private Element createAlgorithmSet(int n) {
        Element element = this.document.createElement("alg_set");
        element.setAttribute("set_id", String.valueOf(this.currAlgSetID));
        element.setAttribute("input_data_ref", String.valueOf(n));
        this.analysisElement.appendChild(element);
        ++this.currAlgSetID;
        this.isTextCurrent = false;
        return element;
    }

    private Element getAlgorithmSetByID(int n) {
        String string = String.valueOf(n);
        NodeList nodeList = this.analysisElement.getElementsByTagName("alg_set");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!string.equals(((Element)nodeList.item(i)).getAttribute("set_id"))) continue;
            return (Element)nodeList.item(i);
        }
        return null;
    }

    private Element getAlgorithmSetByDataRef(int n) {
        int n2 = -1;
        String string = String.valueOf(n);
        if (n == 1) {
            return this.getAlgorithmSetByID(1);
        }
        NodeList nodeList = this.document.getElementsByTagName("algorithm");
        Node node = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!string.equals(((Element)node2).getAttribute("input_data_ref"))) continue;
            node = node2;
            break;
        }
        if (node == null) {
            return this.createAlgorithmSet(n);
        }
        return (Element)node.getParentNode();
    }

    public boolean appendAlgorithm(AlgorithmData algorithmData, int n) {
        Element element = this.document.createElement("algorithm");
        boolean bl = false;
        Element element2 = this.getAlgorithmSetByDataRef(n);
        if (element2 == null) {
            return false;
        }
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        String string = algorithmParameters.getString("name");
        String string2 = algorithmParameters.getString("alg-type");
        int n2 = element2.getElementsByTagName("algorithm").getLength() + 1;
        if (string != null) {
            String[] stringArray;
            element.setAttribute("alg_name", string);
            element.setAttribute("input_data_ref", String.valueOf(n));
            element.setAttribute("alg_id", String.valueOf(n2));
            element.setAttribute("alg_type", String.valueOf(string2));
            this.addParameterList(element, algorithmParameters);
            Element element3 = this.document.createElement("mlist");
            Map map = algorithmData.getIntArrays();
            if (map.size() > 0) {
                this.addIntArrays(map, element3);
            }
            if ((map = algorithmData.getStringArrays()).size() > 0) {
                this.addStringArrays(map, element3);
            }
            if ((map = algorithmData.getMatrixes()).size() > 0) {
                this.addMatrices(map, element3);
            }
            if (element3.getChildNodes().getLength() > 0) {
                element.appendChild(element3);
            }
            if ((stringArray = algorithmData.getStringArray("output-nodes")) != null) {
                Element element4 = this.document.createElement("output_data");
                String string3 = algorithmData.getParams().getString("output-class");
                if (string3 != null) {
                    element4.setAttribute("output_class", string3);
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    ++this.currDataID;
                    Element element5 = this.document.createElement("data_node");
                    element5.setAttribute("data_node_id", String.valueOf(this.currDataID));
                    element5.setAttribute("name", stringArray[i]);
                    element4.appendChild(element5);
                }
                element.appendChild(element4);
            }
        }
        element2.appendChild(element);
        bl = true;
        this.isTextCurrent = false;
        this.fireScriptEvent();
        return bl;
    }

    private void addParameterList(Element element, AlgorithmParameters algorithmParameters) {
        Map map = algorithmParameters.getMap();
        String string = "";
        String string2 = "";
        if (map.size() > 1) {
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            Element element2 = this.document.createElement("plist");
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                string2 = (String)map.get(string);
                if (string.equals("name") || string.equals("output-class") || string.equals("alg-type")) continue;
                Element element3 = this.document.createElement("param");
                element3.setAttribute("key", string);
                element3.setAttribute("value", string2);
                element2.appendChild(element3);
            }
            element.appendChild(element2);
        }
    }

    private void addIntArrays(Map map, Element element) {
        int n;
        Object[] objectArray = map.keySet().toArray();
        String[] stringArray = new String[objectArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = (String)objectArray[n];
        }
        for (n = 0; n < stringArray.length; ++n) {
            int[] nArray = (int[])map.get(stringArray[n]);
            Element element2 = this.document.createElement("matrix");
            element2.setAttribute("name", stringArray[n]);
            element2.setAttribute("type", "int-array");
            element2.setAttribute("row_dim", String.valueOf(nArray.length));
            element2.setAttribute("col_dim", "1");
            for (int i = 0; i < nArray.length; ++i) {
                Element element3 = this.document.createElement("element");
                element3.setAttribute("row", String.valueOf(i));
                element3.setAttribute("col", "0");
                element3.setAttribute("value", String.valueOf(nArray[i]));
                element2.appendChild(element3);
            }
            element.appendChild(element2);
        }
    }

    private void addStringArrays(Map map, Element element) {
        int n;
        Object[] objectArray = map.keySet().toArray();
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < objectArray.length; ++n) {
            String string = (String)objectArray[n];
            if (string.equals("output-nodes")) continue;
            vector.add(string);
        }
        if (vector.size() < 1) {
            return;
        }
        for (n = 0; n < vector.size(); ++n) {
            String[] stringArray = (String[])map.get((String)vector.elementAt(n));
            Element element2 = this.document.createElement("matrix");
            element2.setAttribute("name", (String)vector.elementAt(n));
            element2.setAttribute("type", "string-array");
            element2.setAttribute("row_dim", String.valueOf(stringArray.length));
            element2.setAttribute("col_dim", "1");
            for (int i = 0; i < stringArray.length; ++i) {
                Element element3 = this.document.createElement("element");
                element3.setAttribute("row", String.valueOf(i));
                element3.setAttribute("col", "0");
                element3.setAttribute("value", stringArray[i]);
                element2.appendChild(element3);
            }
            element.appendChild(element2);
        }
    }

    private void addMatrices(Map map, Element element) {
        int n;
        Object[] objectArray = map.keySet().toArray();
        String[] stringArray = new String[objectArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = (String)objectArray[n];
        }
        for (n = 0; n < stringArray.length; ++n) {
            FloatMatrix floatMatrix = (FloatMatrix)map.get(stringArray[n]);
            Element element2 = this.document.createElement("matrix");
            element2.setAttribute("name", stringArray[n]);
            element2.setAttribute("type", "FloatMatrix");
            element2.setAttribute("row_dim", String.valueOf(floatMatrix.getRowDimension()));
            element2.setAttribute("col_dim", String.valueOf(floatMatrix.getColumnDimension()));
            this.addMatrixElements(floatMatrix, element2);
            element.appendChild(element2);
        }
    }

    private void addMatrixElements(FloatMatrix floatMatrix, Element element) {
        float[][] fArray = floatMatrix.A;
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < fArray[i].length; ++j) {
                Element element2 = this.document.createElement("element");
                element2.setAttribute("row", String.valueOf(i));
                element2.setAttribute("col", String.valueOf(j));
                element2.setAttribute("value", String.valueOf(fArray[i][j]));
                element.appendChild(element2);
            }
        }
    }

    public void writeDocument(String string) throws IOException {
        FileWriter fileWriter = new FileWriter(string);
        this.serialize(fileWriter);
        fileWriter.flush();
        fileWriter.close();
    }

    private void writeDocument(Writer writer) throws IOException {
        this.serialize(writer);
    }

    private void serialize(Writer writer) throws IOException {
        this.serializeNode(this.document, writer, "");
    }

    private void serializeNode(Node node, Writer writer, String string) throws IOException {
        switch (node.getNodeType()) {
            case 9: {
                writer.write("<?xml version=\"1.0\"?>");
                writer.write(this.lineSeparator);
                writer.write("<!DOCTYPE TM4ML SYSTEM \"mev_script_dtd.dtd\">");
                writer.write(this.lineSeparator);
                Document document = (Document)node;
                this.serializeNode(document.getDocumentElement(), writer, " ");
                break;
            }
            case 1: {
                boolean bl = false;
                String string2 = node.getNodeName();
                writer.write(string + "<" + string2);
                NamedNodeMap namedNodeMap = node.getAttributes();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    Node node2 = namedNodeMap.item(i);
                    writer.write(" " + node2.getNodeName() + "=\"" + node2.getNodeValue() + "\"");
                }
                NodeList nodeList = node.getChildNodes();
                if (nodeList.getLength() > 0) {
                    writer.write(">");
                    if (nodeList.item(0) != null && nodeList.item(0).getNodeType() == 1) {
                        writer.write(this.lineSeparator);
                    }
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        this.serializeNode(nodeList.item(i), writer, string + this.indent);
                    }
                    if (nodeList.item(0) != null && nodeList.item(nodeList.getLength() - 1).getNodeType() == 1) {
                        writer.write(string);
                    }
                    writer.write("</" + string2 + ">");
                } else {
                    writer.write("/>");
                }
                writer.write(this.lineSeparator);
                break;
            }
            case 3: {
                writer.write(node.getNodeValue());
                break;
            }
            case 8: {
                String string3 = node.getNodeValue();
                writer.write("<!--");
                StringTokenizer stringTokenizer = new StringTokenizer(string3, " ");
                while (stringTokenizer.hasMoreElements()) {
                    int n = 0;
                    while (n < 50) {
                        String string4 = stringTokenizer.nextToken();
                        writer.write(string4);
                        n = string4.length();
                    }
                    writer.write(this.lineSeparator);
                }
                writer.write("-->");
            }
        }
    }

    public void updateScript() {
        if (!this.isTextCurrent) {
            try {
                this.scriptText = "";
                this.writeScriptText(this.document, "");
                this.isTextCurrent = true;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void writeScriptText(Node node, String string) throws IOException {
        switch (node.getNodeType()) {
            case 9: {
                this.scriptText = this.scriptText + "<?xml version=\"1.0\"?>";
                this.scriptText = this.scriptText + this.lineSeparator;
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    this.writeScriptText(nodeList.item(i), "");
                }
                break;
            }
            case 1: {
                String string2 = node.getNodeName();
                this.scriptText = this.scriptText + string + "<" + string2;
                NamedNodeMap namedNodeMap = node.getAttributes();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    Node node2 = namedNodeMap.item(i);
                    this.scriptText = this.scriptText + " " + node2.getNodeName() + "=\"" + node2.getNodeValue() + "\"";
                }
                NodeList nodeList = node.getChildNodes();
                if (nodeList.getLength() > 0) {
                    this.scriptText = this.scriptText + ">";
                    if (nodeList.item(0) != null) {
                        this.scriptText = this.scriptText + this.lineSeparator;
                    }
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        if (nodeList.item(i).getNodeType() == 3) continue;
                        this.writeScriptText(nodeList.item(i), string + this.indent);
                    }
                    if (nodeList.item(0) != null) {
                        this.scriptText = this.scriptText + string;
                    }
                    this.scriptText = this.scriptText + "</" + string2 + ">";
                } else {
                    this.scriptText = this.scriptText + "/>";
                }
                this.scriptText = this.scriptText + this.lineSeparator;
                break;
            }
            case 3: {
                int n;
                String string3 = node.getNodeValue();
                String string4 = "";
                if (string3.indexOf("\n") != -1 && this.scriptText.lastIndexOf(10) == this.scriptText.length() - 1 && (n = string3.lastIndexOf("\n") + 1) < string3.length()) {
                    string4 = string3.substring(n);
                    string3 = string4 = string4 + string3.substring(0, n - 1);
                }
                this.scriptText = this.scriptText + string3;
                break;
            }
            case 8: {
                String string5 = node.getNodeValue();
                this.scriptText = this.scriptText + string + "<!--";
                this.scriptText = this.scriptText + string5;
                this.scriptText = this.scriptText + "-->" + this.lineSeparator + this.lineSeparator;
                break;
            }
            case 10: {
                DocumentType documentType = (DocumentType)node;
                this.scriptText = this.scriptText + "<!DOCTYPE " + documentType.getName();
                this.scriptText = this.scriptText + " SYSTEM ";
                this.scriptText = this.scriptText + "\"" + documentType.getSystemId() + "\">";
                this.scriptText = this.scriptText + this.lineSeparator;
            }
        }
    }

    public String toString() {
        return this.scriptText;
    }

    public ErrorLog getErrorLog() {
        return this.errorLog;
    }

    public void showErrorLog() {
    }

    public int getErrorCount() {
        return this.parseErrors;
    }

    public boolean loadXMLFile(File file, Progress progress) throws Exception {
        int n;
        int n2;
        if (!file.exists()) {
            return false;
        }
        progress.setUnits(4);
        progress.setValue(1);
        progress.setDescription("Parsing File");
        this.errorLog.setFile(file);
        DOMParser dOMParser = new DOMParser();
        try {
            dOMParser.setFeature("http://xml.org/sax/features/validation", true);
            dOMParser.setErrorHandler((ErrorHandler)this);
            dOMParser.parse(file.toURL().toString());
        }
        catch (Exception exception) {
            return false;
        }
        this.document = dOMParser.getDocument();
        this.root = this.document.getDocumentElement();
        NodeList nodeList = this.root.getElementsByTagName("mev");
        if (nodeList != null && nodeList.getLength() > 0) {
            this.mevElement = (Element)nodeList.item(0);
        }
        if ((nodeList = this.root.getElementsByTagName("primary_data")) != null && nodeList.getLength() > 0) {
            this.primaryDataElement = (Element)nodeList.item(0);
        }
        if ((nodeList = this.root.getElementsByTagName("analysis")) != null && nodeList.getLength() > 0) {
            this.analysisElement = (Element)nodeList.item(0);
        }
        progress.setValue(2);
        progress.setDescription("Checking Algorithm Sets");
        nodeList = this.root.getElementsByTagName("alg_set");
        if (nodeList != null && nodeList.getLength() > 0) {
            n2 = -1;
            for (n = 0; n < nodeList.getLength(); ++n) {
                this.currAlgSetID = Integer.parseInt(((Element)nodeList.item(n)).getAttribute("set_id"));
                if (this.currAlgSetID <= n2) continue;
                n2 = this.currAlgSetID;
            }
            this.currAlgSetID = this.currAlgSetID < 0 ? 0 : n2;
            ++this.currAlgSetID;
        }
        progress.setValue(2);
        progress.setDescription("Setting Output ID");
        nodeList = this.root.getElementsByTagName("data_node");
        if (nodeList != null && nodeList.getLength() > 0) {
            n2 = -1;
            for (n = 0; n < nodeList.getLength(); ++n) {
                this.currDataID = Integer.parseInt(((Element)nodeList.item(n)).getAttribute("data_node_id"));
                if (this.currDataID <= n2) continue;
                n2 = this.currDataID;
            }
            this.currDataID = this.currDataID < 0 ? 0 : n2;
        }
        progress.setValue(3);
        progress.setDescription("Internal Serialization");
        this.parsedScript = true;
        this.updateScript();
        progress.setValue(4);
        progress.setDescription("Done");
        progress.dispose();
        return this.validateDocument();
    }

    public boolean validateDocument() {
        return true;
    }

    public boolean modifyParameter(Hashtable hashtable, String string, String string2) {
        NodeList nodeList = this.document.getElementsByTagName("algorithm");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            if (!this.algorithmMatches(hashtable, element)) continue;
            return this.modifyAlgorithmParameter(element, string, string2);
        }
        return false;
    }

    private boolean modifyAlgorithmParameter(Element element, String string, String string2) {
        NodeList nodeList = element.getElementsByTagName("param");
        this.isTextCurrent = false;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string3 = element2.getAttribute("key");
            if (string.indexOf(string3) <= -1) continue;
            element2.setAttribute("value", string2);
            this.fireScriptEvent();
            return true;
        }
        return false;
    }

    private boolean algorithmMatches(Hashtable hashtable, Element element) {
        Enumeration enumeration = hashtable.keys();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            String string3 = element.getAttribute(string);
            if (string3.equals(string2)) continue;
            return false;
        }
        return true;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        System.err.println("Warning:  " + sAXParseException);
        ++this.parseErrors;
        this.errorLog.recordWarning(sAXParseException);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        System.err.println("Error:  " + sAXParseException);
        this.errorLog.recordError(sAXParseException);
        ++this.parseErrors;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        System.err.println("Fatal Error:  " + sAXParseException);
        this.errorLog.recordFatalError(sAXParseException);
        ++this.parseErrors;
    }

    public void addDocumentListener(ScriptEventListener scriptEventListener) {
        if (!this.listeners.contains(scriptEventListener)) {
            this.listeners.add(scriptEventListener);
        }
    }

    private void fireScriptEvent() {
        ScriptDocumentEvent scriptDocumentEvent = new ScriptDocumentEvent(this);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ScriptEventListener)this.listeners.elementAt(i)).documentChanged(scriptDocumentEvent);
        }
    }

    public void removeScriptListener(ScriptEventListener scriptEventListener) {
        this.listeners.remove(scriptEventListener);
    }

    public void removeAlgorithm(AlgorithmNode algorithmNode) {
        int n = algorithmNode.getID();
        int n2 = algorithmNode.getDataNodeRef();
        String string = algorithmNode.getAlgorithmName();
        Element element = this.getAlgorithmSetByDataRef(n2);
        Element element2 = null;
        boolean bl = false;
        if (element != null) {
            NodeList nodeList = element.getElementsByTagName("algorithm");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                element2 = (Element)nodeList.item(i);
                if (!String.valueOf(n).equals(element2.getAttribute("alg_id")) || !string.equals(element2.getAttribute("alg_name"))) continue;
                bl = true;
                break;
            }
            if (bl) {
                if (element2 == null) {
                    return;
                }
                Node node = element2.getParentNode();
                if (node != null) {
                    Node node2;
                    int n3;
                    nodeList = element2.getElementsByTagName("data_node");
                    String[] stringArray = new String[nodeList.getLength()];
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node node3 = nodeList.item(i);
                        stringArray[i] = ((Element)node3).getAttribute("data_node_id");
                    }
                    Vector vector = this.getDependentDataIDs(element2, nodeList);
                    nodeList = this.analysisElement.getElementsByTagName("alg_set");
                    Vector<Node> vector2 = new Vector<Node>();
                    int n4 = nodeList.getLength();
                    for (n3 = 0; n3 < n4; ++n3) {
                        Node node4 = nodeList.item(n3);
                        String string2 = ((Element)node4).getAttribute("set_id");
                        for (int i = 0; i < vector.size(); ++i) {
                            if (!string2.equals((String)vector.elementAt(i))) continue;
                            vector2.addElement(node4);
                        }
                    }
                    for (n3 = 0; n3 < vector2.size(); ++n3) {
                        this.analysisElement.removeChild((Element)vector2.elementAt(n3));
                    }
                    node.removeChild(element2);
                    if (node.getChildNodes().getLength() == 0 && (node2 = node.getParentNode()) != null && node.getNodeName().equals("alg_set") && !((Element)node).getAttribute("set_id").equals("1")) {
                        node2.removeChild(node);
                    }
                }
                this.isTextCurrent = false;
                this.fireScriptEvent();
            }
        }
    }

    private Vector getDependentDataIDs(Element element, NodeList nodeList) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            vector.addElement(element2.getAttribute("data_node_id"));
        }
        this.getDependentDataIDs(vector, 0, this.analysisElement.getElementsByTagName("alg_set"));
        return vector;
    }

    private void getDependentDataIDs(Vector vector, int n, NodeList nodeList) {
        if (vector.size() <= n) {
            return;
        }
        int n2 = vector.size();
        int n3 = 0;
        for (int i = n; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            for (int j = 0; j < nodeList.getLength(); ++j) {
                Element element = (Element)nodeList.item(j);
                String string2 = element.getAttribute("set_id");
                if (!string2.equals(string)) continue;
                NodeList nodeList2 = element.getElementsByTagName("data_node");
                for (int k = 0; k < nodeList2.getLength(); ++k) {
                    String string3 = ((Element)nodeList2.item(k)).getAttribute("data_node_id");
                    if (vector.contains(string3)) continue;
                    ++n3;
                    vector.addElement(string3);
                }
            }
        }
        this.getDependentDataIDs(vector, n2, nodeList);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.tm4ScriptVersion);
        objectOutputStream.writeObject(this.mevScriptVersion);
        objectOutputStream.writeObject(this.manager);
        objectOutputStream.writeObject(this.document);
        objectOutputStream.writeObject(this.scriptText);
        objectOutputStream.writeObject(this.root);
        objectOutputStream.writeObject(this.mevElement);
        objectOutputStream.writeObject(this.primaryDataElement);
        objectOutputStream.writeObject(this.commentElement);
        objectOutputStream.writeObject(this.analysisElement);
        objectOutputStream.writeInt(this.currDataID);
        objectOutputStream.writeInt(this.currAlgSetID);
        objectOutputStream.writeObject(this.lineSeparator);
        objectOutputStream.writeObject(this.indent);
        objectOutputStream.writeBoolean(this.errorLog != null);
        objectOutputStream.writeBoolean(this.parsedScript);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.tm4ScriptVersion = (String)objectInputStream.readObject();
        this.mevScriptVersion = (String)objectInputStream.readObject();
        this.manager = (ScriptManager)objectInputStream.readObject();
        this.document = (Document)objectInputStream.readObject();
        this.scriptText = (String)objectInputStream.readObject();
        this.root = (Element)objectInputStream.readObject();
        this.mevElement = (Element)objectInputStream.readObject();
        this.primaryDataElement = (Element)objectInputStream.readObject();
        this.commentElement = (Element)objectInputStream.readObject();
        this.analysisElement = (Element)objectInputStream.readObject();
        this.currDataID = objectInputStream.readInt();
        this.currAlgSetID = objectInputStream.readInt();
        this.lineSeparator = (String)objectInputStream.readObject();
        this.indent = (String)objectInputStream.readObject();
        this.parsedScript = objectInputStream.readBoolean();
    }
}

