/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script.scriptGUI;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.microarray.mev.script.util.AlgorithmNode;
import org.tigr.microarray.mev.script.util.DataNode;
import org.tigr.microarray.mev.script.util.ScriptNode;

public class ScriptTreeRenderer
implements TreeCellRenderer {
    private ScriptNodeLabel label;
    private JPanel labelPanel;
    private DataNode algSetRoot = null;
    private boolean highlightAlgSet = false;
    boolean showToolTips = true;
    private Icon scriptAnalysisIcon = GUIFactory.getIcon((String)"ScriptAnalysis.gif");
    private Icon scriptGeneAnalysisIcon = GUIFactory.getIcon((String)"ScriptGeneAlgorithm.gif");
    private Icon scriptExperimentAnalysisIcon = GUIFactory.getIcon((String)"ScriptExperimentAlgorithm.gif");
    private Icon scriptClusterSelectionAnalysisIcon = GUIFactory.getIcon((String)"ScriptClusterSelectionAlgorithm.gif");
    private Icon scriptAdjustmentAlgIcon = GUIFactory.getIcon((String)"adjustment_algorithm.gif");
    private Icon scriptEmptyAnalysisIcon = GUIFactory.getIcon((String)"TreeBallLeaf.gif");
    private Icon scriptVisAlgNodeIcon = GUIFactory.getIcon((String)"ScriptVisAlgorithmNode.gif");
    private Icon scriptDataNodeIcon = GUIFactory.getIcon((String)"ScriptDataNode.gif");
    private Icon scriptPrimaryDataNodeIcon = GUIFactory.getIcon((String)"ScriptPrimaryDataNode.gif");
    private Icon scriptMultiDataNodeIcon = GUIFactory.getIcon((String)"ScriptMultiDataNodeShaded.gif");
    private Color dataNodeColor;
    private Color algNodeColor;

    public ScriptTreeRenderer() {
        this.label = new ScriptNodeLabel();
        this.dataNodeColor = new Color(209, 248, 203);
        this.algNodeColor = new Color(255, 255, 195);
        this.labelPanel = new JPanel(new GridBagLayout());
        this.labelPanel.setBackground(Color.white);
        this.labelPanel.add((Component)this.label, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(8, 0, 0, 0), 5, 0));
    }

    public void clearHighlights() {
        this.highlightAlgSet = false;
        this.label.setScriptNodeHighlighted(false);
    }

    public void highlightAlgSet(DataNode dataNode) {
        this.highlightAlgSet = true;
        this.algSetRoot = dataNode;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (!this.highlightAlgSet) {
            this.label.setScriptNodeSelected(bl);
        } else {
            this.label.setScriptNodeSelected(false);
            this.checkHighlight((ScriptNode)object);
        }
        if (object instanceof DataNode) {
            this.label.setBackgroundColor(this.dataNodeColor);
            this.label.setRounded(false);
            DataNode dataNode = (DataNode)object;
            String string = dataNode.toString();
            if (string.indexOf("Primary") != -1) {
                this.label.setIcon(this.scriptPrimaryDataNodeIcon);
            } else if (string.indexOf("Multi") != -1) {
                this.label.setIcon(this.scriptMultiDataNodeIcon);
            } else {
                this.label.setIcon(this.scriptDataNodeIcon);
            }
            this.label.setText(string);
        } else if (object instanceof AlgorithmNode) {
            this.label.setBackgroundColor(this.algNodeColor);
            this.label.setRounded(true);
            AlgorithmNode algorithmNode = (AlgorithmNode)object;
            String string = algorithmNode.toString();
            if (string != null && !string.equals("") || !string.equals(" ")) {
                if (algorithmNode.getAlgorithmType().equals("cluster")) {
                    this.label.setIcon(this.scriptAnalysisIcon);
                } else if (algorithmNode.getAlgorithmType().equals("cluster-genes")) {
                    this.label.setIcon(this.scriptGeneAnalysisIcon);
                } else if (algorithmNode.getAlgorithmType().equals("cluster-experiments")) {
                    this.label.setIcon(this.scriptExperimentAnalysisIcon);
                } else if (algorithmNode.getAlgorithmType().equals("data-adjustment")) {
                    this.label.setIcon(this.scriptAdjustmentAlgIcon);
                } else if (algorithmNode.getAlgorithmType().equals("data-visualization")) {
                    this.label.setIcon(this.scriptVisAlgNodeIcon);
                } else if (algorithmNode.getAlgorithmType().equals("cluster-selection")) {
                    this.label.setIcon(this.scriptClusterSelectionAnalysisIcon);
                }
                this.label.setText(string + " [" + algorithmNode.getDataNodeRef() + "," + algorithmNode.getID() + "] ");
            } else {
                this.label.setText("Empty Algorithm ");
                this.label.setBorder(BorderFactory.createLineBorder(Color.blue, 3));
                this.label.setIcon(this.scriptEmptyAnalysisIcon);
            }
        }
        this.label.validate();
        this.labelPanel.validate();
        return this.labelPanel;
    }

    private void checkHighlight(ScriptNode scriptNode) {
        ScriptNode scriptNode2 = (ScriptNode)scriptNode.getParent();
        if (this.algSetRoot == null) {
            return;
        }
        if (scriptNode == this.algSetRoot || scriptNode2 != null && scriptNode2 == this.algSetRoot || scriptNode2 != null && scriptNode2.getParent() != null && scriptNode2.getParent() == this.algSetRoot) {
            this.label.setScriptNodeHighlighted(true);
        } else {
            this.label.setScriptNodeHighlighted(false);
        }
    }

    private class ScriptNodeLabel
    extends JLabel {
        boolean showRound;
        boolean sel;
        boolean highlighted;
        Color backgroundColor;

        public ScriptNodeLabel() {
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(3, 6, 3, 8));
            this.backgroundColor = new Color(249, 249, 112);
        }

        public void setBackgroundColor(Color color) {
            this.backgroundColor = color;
        }

        public void setScriptNodeSelected(boolean bl) {
            this.sel = bl;
        }

        public void setScriptNodeHighlighted(boolean bl) {
            this.highlighted = bl;
            if (bl && this.sel) {
                this.sel = false;
            }
        }

        public void setRounded(boolean bl) {
            this.showRound = bl;
        }

        public void paintComponent(Graphics graphics) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            graphics.setColor(this.backgroundColor);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.showRound) {
                if (this.sel) {
                    graphics2D.fillRoundRect(2, 2, n - 4, n2 - 4, 19, 19);
                    graphics2D.setColor(Color.blue);
                    graphics2D.drawRoundRect(1, 1, n - 3, n2 - 3, 19, 19);
                    graphics2D.drawRoundRect(0, 0, n - 1, n2 - 1, 20, 20);
                    graphics2D.setColor(Color.black);
                    super.paintComponent(graphics);
                } else if (this.highlighted) {
                    graphics2D.fillRoundRect(2, 2, n - 4, n2 - 4, 19, 19);
                    graphics2D.setColor(new Color(176, 23, 54));
                    graphics2D.drawRoundRect(1, 1, n - 3, n2 - 3, 19, 19);
                    graphics2D.drawRoundRect(0, 0, n - 1, n2 - 1, 20, 20);
                    graphics2D.setColor(Color.black);
                    super.paintComponent(graphics);
                } else if (!ScriptTreeRenderer.this.highlightAlgSet) {
                    graphics2D.fillRoundRect(1, 1, n - 2, n2 - 2, 19, 19);
                    graphics2D.setColor(Color.black);
                    graphics2D.drawRoundRect(0, 0, n - 1, n2 - 1, 20, 20);
                    graphics2D.setColor(Color.black);
                    super.paintComponent(graphics);
                } else {
                    Color color = graphics.getColor();
                    Composite composite = graphics2D.getComposite();
                    graphics2D.setComposite(AlphaComposite.getInstance(3, 0.25f));
                    graphics2D.fillRoundRect(1, 1, n - 2, n2 - 2, 19, 19);
                    graphics2D.setColor(Color.black);
                    graphics2D.drawRoundRect(0, 0, n - 1, n2 - 1, 20, 20);
                    graphics2D.setColor(Color.black);
                    super.paintComponent(graphics);
                    graphics.setColor(color);
                    graphics2D.setComposite(composite);
                }
            } else {
                graphics2D.fillRect(0, 0, n, n2);
                if (this.sel) {
                    graphics2D.setColor(Color.blue);
                    graphics2D.drawRect(1, 1, n - 3, n2 - 3);
                    graphics2D.drawRect(0, 0, n - 1, n2 - 1);
                    graphics2D.setColor(Color.black);
                    super.paintComponent(graphics);
                } else if (this.highlighted) {
                    graphics2D.setColor(new Color(176, 23, 54));
                    graphics2D.drawRect(1, 1, n - 3, n2 - 3);
                    graphics2D.drawRect(0, 0, n - 1, n2 - 1);
                    graphics2D.setColor(Color.black);
                    super.paintComponent(graphics);
                } else if (!ScriptTreeRenderer.this.highlightAlgSet) {
                    graphics2D.setColor(Color.black);
                    graphics2D.drawRect(0, 0, n - 1, n2 - 1);
                    graphics2D.setColor(Color.black);
                    super.paintComponent(graphics);
                } else {
                    Color color = graphics.getColor();
                    Composite composite = graphics2D.getComposite();
                    graphics2D.setComposite(AlphaComposite.getInstance(3, 0.25f));
                    graphics2D.setColor(Color.black);
                    graphics2D.drawRect(0, 0, n - 1, n2 - 1);
                    graphics2D.setColor(Color.black);
                    super.paintComponent(graphics);
                    graphics.setColor(color);
                    graphics2D.setComposite(composite);
                }
            }
        }
    }
}

