/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script.scriptGUI;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.tigr.microarray.mev.action.ActionManager;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;

public class ScriptAlgorithmInitDialog
extends AlgorithmDialog {
    private int result;
    private int algorithmIndex = -1;
    private String algorithmType;
    private String currentAlgorithmName;
    private JPanel mainPanel;
    private ActionManager actionManager;
    private PreviewPanel previewPanel;
    private AlgorithmSelectionPanel algSelPanel;
    private AdjustmentSelectionPanel adjSelPanel;
    private ClusterSelectionPanel clusterSelectionPanel;

    public ScriptAlgorithmInitDialog(ActionManager actionManager, String string, boolean bl) {
        super(new JFrame(), "Script Algorithm Initialization Dialog", true);
        this.actionManager = actionManager;
        this.algorithmType = "cluster";
        this.result = 2;
        this.mainPanel = new JPanel(new GridBagLayout());
        this.mainPanel.setBackground(Color.white);
        this.previewPanel = new PreviewPanel();
        this.algSelPanel = new AlgorithmSelectionPanel(this.actionManager);
        this.adjSelPanel = new AdjustmentSelectionPanel(bl);
        this.clusterSelectionPanel = new ClusterSelectionPanel();
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("Analysis Algorithms", (Component)((Object)this.algSelPanel));
        jTabbedPane.addTab("Adjustment Algorithms", (Component)((Object)this.adjSelPanel));
        jTabbedPane.addTab("Cluster Selection Algorithms", this.clusterSelectionPanel);
        if (string.equals("multi-gene-cluster-output") || string.equals("multi-experiment-cluster-output") || string.equals("multi-cluster-output")) {
            jTabbedPane.setEnabledAt(0, false);
            jTabbedPane.setEnabledAt(1, false);
            jTabbedPane.setSelectedIndex(2);
        } else {
            jTabbedPane.setEnabledAt(2, false);
        }
        this.mainPanel.add((Component)((Object)this.previewPanel), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)jTabbedPane, new GridBagConstraints(0, 1, 1, 2, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        Listener listener = new Listener();
        this.addWindowListener((WindowListener)((Object)listener));
        this.addContent(this.mainPanel);
        this.setActionListeners((ActionListener)((Object)listener));
        this.pack();
        if (!bl) {
            this.setSize(new Dimension(510, 587));
        } else {
            this.setSize(new Dimension(510, 665));
        }
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public void onReset() {
        this.previewPanel.reset();
        this.algSelPanel.reset();
        this.adjSelPanel.reset();
        this.clusterSelectionPanel.reset();
        this.algorithmIndex = -1;
        this.algorithmType = "";
        this.currentAlgorithmName = "";
    }

    public String getAlgorithmType() {
        return this.algorithmType;
    }

    public String getAlgorithmName() {
        return this.currentAlgorithmName;
    }

    public int getAlgorithmIndex() {
        String string;
        if (this.currentAlgorithmName != null && (string = (String)this.algSelPanel.indexHash.get(this.currentAlgorithmName)) != null) {
            return Integer.parseInt(string);
        }
        return -1;
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == ScriptAlgorithmInitDialog.this.okButton) {
                ScriptAlgorithmInitDialog.this.result = 0;
                ScriptAlgorithmInitDialog.this.dispose();
            } else if (object == ScriptAlgorithmInitDialog.this.cancelButton) {
                ScriptAlgorithmInitDialog.this.result = 2;
                ScriptAlgorithmInitDialog.this.dispose();
            } else if (object == ScriptAlgorithmInitDialog.this.resetButton) {
                ScriptAlgorithmInitDialog.this.onReset();
            } else if (object == ScriptAlgorithmInitDialog.this.infoButton) {
                HelpWindow helpWindow = new HelpWindow((JDialog)((Object)ScriptAlgorithmInitDialog.this), "Script Algorithm Initialization Dialog");
                if (helpWindow.getWindowContent()) {
                    helpWindow.setSize(450, 650);
                    helpWindow.setLocation();
                    helpWindow.show();
                } else {
                    helpWindow.setVisible(false);
                    helpWindow.dispose();
                }
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            ScriptAlgorithmInitDialog.this.result = -1;
            ScriptAlgorithmInitDialog.this.dispose();
        }
    }

    private class ClusterSelectionPanel
    extends JPanel {
        JRadioButton diversityButton;
        JRadioButton centroidEntropyButton;
        JRadioButton noButton;

        public ClusterSelectionPanel() {
            this.setLayout(new GridBagLayout());
            ButtonListener buttonListener = new ButtonListener();
            ParameterPanel parameterPanel = new ParameterPanel();
            parameterPanel.setLayout((LayoutManager)new GridBagLayout());
            this.diversityButton = new JRadioButton("Diversity Ranking Cluster Selection", false);
            this.diversityButton.setFocusPainted(false);
            this.diversityButton.setOpaque(false);
            this.diversityButton.addActionListener(buttonListener);
            this.centroidEntropyButton = new JRadioButton("Centroid Variance or Entropy Cluster Selection", false);
            this.centroidEntropyButton.setFocusPainted(false);
            this.centroidEntropyButton.setOpaque(false);
            this.centroidEntropyButton.addActionListener(buttonListener);
            this.noButton = new JRadioButton("hidden", true);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.diversityButton);
            buttonGroup.add(this.centroidEntropyButton);
            buttonGroup.add(this.noButton);
            parameterPanel.add((Component)this.centroidEntropyButton, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
            parameterPanel.add((Component)this.diversityButton, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(20, 0, 0, 0), 0, 0));
            this.add((Component)parameterPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public void reset() {
            this.noButton.setSelected(true);
        }

        private class ButtonListener
        implements ActionListener {
            private ButtonListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (ClusterSelectionPanel.this.diversityButton.isSelected()) {
                    ScriptAlgorithmInitDialog.this.previewPanel.setValues("Cluster Selection", "Diversity Ranking Cluster Selection");
                    ScriptAlgorithmInitDialog.this.algorithmType = "cluster-selection";
                    ScriptAlgorithmInitDialog.this.currentAlgorithmName = "Diversity Ranking Cluster Selection";
                } else if (ClusterSelectionPanel.this.centroidEntropyButton.isSelected()) {
                    ScriptAlgorithmInitDialog.this.previewPanel.setValues("Cluster Selection", "Centroid Entropy Ranking Cluster Selection");
                    ScriptAlgorithmInitDialog.this.algorithmType = "cluster-selection";
                    ScriptAlgorithmInitDialog.this.currentAlgorithmName = "Centroid Entropy/Variance Ranking Cluster Selection";
                }
            }
        }
    }

    private class NormalizationSelectionPanel
    extends JPanel {
        private NormalizationSelectionPanel() {
        }
    }

    private class AdjustmentSelectionPanel
    extends ParameterPanel {
        ButtonGroup bg;
        JCheckBox noneBox;

        public AdjustmentSelectionPanel(boolean bl) {
            super("Adjustment Selection");
            this.setLayout(new GridBagLayout());
            AdjustmentBoxListener adjustmentBoxListener = new AdjustmentBoxListener();
            this.bg = new ButtonGroup();
            this.noneBox = new JCheckBox("none", true);
            this.bg.add(this.noneBox);
            ParameterPanel parameterPanel = new ParameterPanel("Gene/Row Filters");
            parameterPanel.setLayout((LayoutManager)new GridBagLayout());
            JCheckBox jCheckBox = this.createCheckBox("Percentage Cutoff", "Requires x% valid expression values to retain a gene", adjustmentBoxListener);
            JCheckBox jCheckBox2 = this.createCheckBox("Lower Cutoffs", "Cy3 and Cy5 must have a minium value \n to retain gene. (see info page)", adjustmentBoxListener);
            parameterPanel.add((Component)jCheckBox, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 0, 10, 25), 0, 0));
            parameterPanel.add((Component)jCheckBox2, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 25, 10, 0), 0, 0));
            ParameterPanel parameterPanel2 = new ParameterPanel("Gene/Row Based Adjustments");
            parameterPanel2.setLayout((LayoutManager)new GridBagLayout());
            JCheckBox jCheckBox3 = this.createCheckBox("Normalize Genes/Rows", "Adjust Vector ||v||=1", adjustmentBoxListener);
            JCheckBox jCheckBox4 = this.createCheckBox("Divide Genes/Rows by RMS", "Divide values by spot's RMS", adjustmentBoxListener);
            JCheckBox jCheckBox5 = this.createCheckBox("Divide Genes/Rows by SD", "Divide values by spot's SD", adjustmentBoxListener);
            JCheckBox jCheckBox6 = this.createCheckBox("Mean Center Genes/Rows", "Divide values by spot's Mean", adjustmentBoxListener);
            JCheckBox jCheckBox7 = this.createCheckBox("Median Center Genes/Rows", "Divide values by spot's Median", adjustmentBoxListener);
            JCheckBox jCheckBox8 = this.createCheckBox("Digital Genes/Rows", "Bins spot's values into log2(#Spots) int value bins ", adjustmentBoxListener);
            parameterPanel2.add((Component)jCheckBox3, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 10, 10, 0), 0, 0));
            parameterPanel2.add((Component)jCheckBox4, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
            parameterPanel2.add((Component)jCheckBox5, (Object)new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
            parameterPanel2.add((Component)jCheckBox6, (Object)new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
            parameterPanel2.add((Component)jCheckBox7, (Object)new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
            parameterPanel2.add((Component)jCheckBox8, (Object)new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
            ParameterPanel parameterPanel3 = new ParameterPanel("Sample/Column Based Adjustments");
            parameterPanel3.setLayout((LayoutManager)new GridBagLayout());
            JCheckBox jCheckBox9 = this.createCheckBox("Normalize Samples/Columns", "Adjust Vector ||v||=1", adjustmentBoxListener);
            JCheckBox jCheckBox10 = this.createCheckBox("Divide Samples/Columns by RMS", "Divide values by sample's RMS", adjustmentBoxListener);
            JCheckBox jCheckBox11 = this.createCheckBox("Divide Samples/Columns by SD", "Divide values by sample's SD", adjustmentBoxListener);
            JCheckBox jCheckBox12 = this.createCheckBox("Mean Center Samples/Columns", "Divide values by sample's Mean", adjustmentBoxListener);
            JCheckBox jCheckBox13 = this.createCheckBox("Median Center Samples/Columns", "Divide values by sample's Median", adjustmentBoxListener);
            JCheckBox jCheckBox14 = this.createCheckBox("Digital Samples/Columns", "Bins values into log2(#Exps) int value bins ", adjustmentBoxListener);
            parameterPanel3.add((Component)jCheckBox9, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 10, 10, 0), 0, 0));
            parameterPanel3.add((Component)jCheckBox10, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
            parameterPanel3.add((Component)jCheckBox11, (Object)new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
            parameterPanel3.add((Component)jCheckBox12, (Object)new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
            parameterPanel3.add((Component)jCheckBox13, (Object)new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
            parameterPanel3.add((Component)jCheckBox14, (Object)new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
            this.add((Component)parameterPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
            this.add((Component)parameterPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
            this.add((Component)parameterPanel3, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
            if (bl) {
                ParameterPanel parameterPanel4 = new ParameterPanel("Affimetrix Filtering Options");
                parameterPanel4.setLayout((LayoutManager)new GridBagLayout());
                JCheckBox jCheckBox15 = this.createCheckBox("Detection Filter", "Filters by detection flag.", adjustmentBoxListener);
                JCheckBox jCheckBox16 = this.createCheckBox("Fold Filter", "Filters by fold change.", adjustmentBoxListener);
                parameterPanel4.add((Component)jCheckBox15, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 0, 10, 25), 0, 0));
                parameterPanel4.add((Component)jCheckBox16, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 25, 10, 0), 0, 0));
                this.add((Component)parameterPanel4, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
            }
        }

        private JCheckBox createCheckBox(String string, String string2, ActionListener actionListener) {
            JCheckBox jCheckBox = new JCheckBox(string);
            jCheckBox.setBackground(Color.white);
            jCheckBox.setFocusPainted(false);
            jCheckBox.setActionCommand(string);
            jCheckBox.setToolTipText(string2);
            jCheckBox.addActionListener(actionListener);
            this.bg.add(jCheckBox);
            return jCheckBox;
        }

        public void reset() {
            this.noneBox.setSelected(true);
        }

        private class AdjustmentBoxListener
        implements ActionListener {
            private AdjustmentBoxListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                ScriptAlgorithmInitDialog.this.currentAlgorithmName = string;
                ScriptAlgorithmInitDialog.this.previewPanel.setValues("Adjustment Algorithm", string);
                ScriptAlgorithmInitDialog.this.algorithmType = "data-adjustment";
            }
        }
    }

    private class AlgorithmSelectionPanel
    extends ParameterPanel {
        ButtonPanel buttonPanel;
        ButtonListener listener;
        Hashtable descriptions;
        Hashtable indexHash;

        AlgorithmSelectionPanel(ActionManager actionManager) {
            super("Algorithm Selection");
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.white);
            this.listener = new ButtonListener();
            this.buttonPanel = new ButtonPanel();
            this.buttonPanel.setLayout(new GridBagLayout());
            this.buttonPanel.setBackground(Color.white);
            this.descriptions = new Hashtable();
            this.indexHash = new Hashtable();
            this.addAlgorithmButtons(actionManager);
            this.add(this.buttonPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        private void addAlgorithmButtons(ActionManager actionManager) {
            Action action;
            int n = 0;
            while ((action = actionManager.getAction("analysis-action" + String.valueOf(n))) != null) {
                ++n;
            }
            int n2 = 1;
            int n3 = n;
            while ((n3 += ++n2 * (n3 = (int)Math.floor(n / n2)) < n ? 1 : 0) > n2) {
            }
            n = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    action = actionManager.getAction("analysis-action" + String.valueOf(n4));
                    if (action != null) {
                        JButton jButton = new JButton();
                        jButton.setFocusPainted(false);
                        jButton.setActionCommand((String)action.getValue("Name"));
                        jButton.addActionListener(this.listener);
                        jButton.setIcon((Icon)action.getValue("LargeIcon"));
                        jButton.setText("");
                        jButton.setToolTipText((String)action.getValue("ShortDescription"));
                        jButton.setPreferredSize(new Dimension(45, 45));
                        jButton.setBorder(BorderFactory.createBevelBorder(0));
                        gridBagConstraints.gridx = j;
                        gridBagConstraints.gridy = i;
                        this.buttonPanel.add((Component)jButton, gridBagConstraints);
                        this.descriptions.put(action.getValue("Name"), action.getValue("ShortDescription"));
                        this.indexHash.put(action.getValue("Name"), String.valueOf(n4));
                        try {
                            Class<?> clazz = Class.forName((String)action.getValue("command-parameter"));
                            IClusterGUI iClusterGUI = (IClusterGUI)clazz.newInstance();
                            jButton.setEnabled(iClusterGUI instanceof IScriptGUI);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++n4;
                }
            }
        }

        public void reset() {
            this.buttonPanel.setSelected(false);
            this.buttonPanel.repaint();
        }

        private class ButtonListener
        implements ActionListener {
            private ButtonListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                ScriptAlgorithmInitDialog.this.currentAlgorithmName = string;
                Object object = actionEvent.getSource();
                if (object != null && object instanceof JButton) {
                    AlgorithmSelectionPanel.this.buttonPanel.setSelection((JButton)object);
                    ScriptAlgorithmInitDialog.this.algorithmType = "cluster";
                    ScriptAlgorithmInitDialog.this.previewPanel.setValues("Analysis Algorithm", string + ": " + (String)AlgorithmSelectionPanel.this.descriptions.get(string));
                }
            }
        }

        private class ButtonPanel
        extends JPanel {
            boolean isSelected = false;
            Point selectedSector;
            JButton selectedButton;

            public void setSelection(JButton jButton) {
                this.isSelected = true;
                this.selectedButton = jButton;
                this.repaint();
            }

            public void setSelected(boolean bl) {
                this.isSelected = bl;
            }

            public void paint(Graphics graphics) {
                super.paint(graphics);
                if (this.isSelected && this.selectedButton != null) {
                    this.selectedSector = this.selectedButton.getLocation();
                    graphics.setColor(Color.blue);
                    graphics.drawRect(this.selectedSector.x - 5, this.selectedSector.y - 5, 54, 54);
                    graphics.drawRect(this.selectedSector.x - 4, this.selectedSector.y - 4, 52, 52);
                }
            }
        }
    }

    private class PreviewPanel
    extends ParameterPanel {
        JTextField categoryValueField;
        JTextField algValueField;

        public PreviewPanel() {
            super("Selection Preview");
            super.setLayout((LayoutManager)new GridBagLayout());
            JLabel jLabel = new JLabel("Algorithm Category: ");
            this.categoryValueField = new JTextField("Not Selected", 25);
            this.categoryValueField.setEditable(false);
            JLabel jLabel2 = new JLabel("Algorithm: ");
            this.algValueField = new JTextField("Not Selected", 25);
            this.algValueField.setEditable(false);
            this.add(jLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 20, 0, 0), 0, 0));
            this.add(this.categoryValueField, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 10, 0, 0), 0, 0));
            this.add(jLabel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 20, 5, 0), 0, 0));
            this.add(this.algValueField, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(10, 10, 5, 0), 0, 0));
        }

        public void reset() {
            this.algValueField.setText("Not Selected");
            this.categoryValueField.setText("Not Selected");
        }

        public void setValues(String string, String string2) {
            this.algValueField.setText(string2);
            this.categoryValueField.setText(string);
        }
    }
}

