/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.script;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.util.FloatMatrix;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ScriptHandler {
    String tm4ScriptVersion = "1.0";
    String mevScriptVersion = "1.0";
    Document document;
    Element root;
    Element mevElement;
    Element primaryDataElement;
    Element analysisElement;
    int currAnalysisID = 1;
    int currDataID = 1;
    String lineSeparator = "\n";
    String indent = "   ";

    public ScriptHandler() {
        DOMImplementationImpl dOMImplementationImpl = new DOMImplementationImpl();
        this.document = dOMImplementationImpl.createDocument(null, "tm4", null);
        this.root = this.document.getDocumentElement();
        this.root.setAttribute("version", this.tm4ScriptVersion);
        this.mevElement = this.document.createElement("mev");
        this.mevElement.setAttribute("version", this.mevScriptVersion);
        this.root.appendChild(this.mevElement);
        this.analysisElement = this.document.createElement("analysis");
        this.primaryDataElement = this.document.createElement("primary_data");
        Element element = this.document.createElement("file_list");
        this.primaryDataElement.appendChild(element);
        this.mevElement.appendChild(this.primaryDataElement);
        this.mevElement.appendChild(this.analysisElement);
    }

    public Document getDocument() {
        return this.document;
    }

    public void createAlgorithmSet(int n, int n2) {
        Element element = this.document.createElement("alg_set");
        element.setAttribute("set_id", String.valueOf(n));
        element.setAttribute("input_data_ref", String.valueOf(n2));
        this.analysisElement.appendChild(element);
    }

    public Element getAlgorithmSetByID(int n) {
        String string = String.valueOf(n);
        NodeList nodeList = this.analysisElement.getElementsByTagName("alg_set");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!string.equals(((Element)nodeList.item(i)).getAttribute("set_id"))) continue;
            return (Element)nodeList.item(i);
        }
        return null;
    }

    public boolean appendAlgorithm(AlgorithmData algorithmData, int n, int n2, int n3) {
        Element element = this.document.createElement("algorithm");
        Element element2 = this.getAlgorithmSetByID(n2);
        if (element2 == null) {
            return false;
        }
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        String string = algorithmParameters.getString("name");
        if (string != null) {
            String[] stringArray;
            element.setAttribute("name", string);
            element.setAttribute("input_data_ref", String.valueOf(n3));
            element.setAttribute("alg_id", String.valueOf(n));
            this.addParameterList(element, algorithmParameters);
            Element element3 = this.document.createElement("mlist");
            Map map = algorithmData.getIntArrays();
            if (map.size() > 0) {
                this.addIntArrays(map, element3);
            }
            if ((map = algorithmData.getStringArrays()).size() > 0) {
                this.addStringArrays(map, element3);
            }
            if ((map = algorithmData.getMatrixes()).size() > 0) {
                this.addMatrices(map, element3);
            }
            if (element3.getChildNodes().getLength() > 0) {
                element.appendChild(element3);
            }
            if ((stringArray = algorithmData.getStringArray("output-nodes")) != null) {
                Element element4 = this.document.createElement("output_data");
                for (int i = 0; i < stringArray.length; ++i) {
                    Element element5 = this.document.createElement("data_node");
                    element5.setAttribute("data_node_id", String.valueOf(this.currDataID));
                    element5.setAttribute("name", stringArray[i]);
                    element4.appendChild(element5);
                    ++this.currDataID;
                }
                element.appendChild(element4);
            }
        }
        element2.appendChild(element);
        return true;
    }

    public void addParameterList(Element element, AlgorithmParameters algorithmParameters) {
        Map map = algorithmParameters.getMap();
        String string = "";
        String string2 = "";
        if (map.size() > 1) {
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            Element element2 = this.document.createElement("plist");
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                string2 = (String)map.get(string);
                if (string.equals("name")) continue;
                Element element3 = this.document.createElement("param");
                element3.setAttribute("key", string);
                element3.setAttribute("val", string2);
                element2.appendChild(element3);
            }
            element.appendChild(element2);
        }
    }

    public void addIntArrays(Map map, Element element) {
        int n;
        Object[] objectArray = map.keySet().toArray();
        String[] stringArray = new String[objectArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = (String)objectArray[n];
        }
        for (n = 0; n < stringArray.length; ++n) {
            int[] nArray = (int[])map.get(stringArray[n]);
            Element element2 = this.document.createElement("matrix");
            element2.setAttribute("name", stringArray[n]);
            element2.setAttribute("type", "int");
            element2.setAttribute("row_dim", String.valueOf(nArray.length));
            for (int i = 0; i < nArray.length; ++i) {
                Element element3 = this.document.createElement("element");
                element3.setAttribute("row", String.valueOf(i));
                element3.setAttribute("col", "0");
                element3.setAttribute("val", String.valueOf(nArray[n]));
                element2.appendChild(element3);
            }
            element.appendChild(element2);
        }
    }

    public void addStringArrays(Map map, Element element) {
        int n;
        Object[] objectArray = map.keySet().toArray();
        String[] stringArray = new String[objectArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = (String)objectArray[n];
        }
        for (n = 0; n < stringArray.length; ++n) {
            String[] stringArray2 = (String[])map.get(stringArray[n]);
            Element element2 = this.document.createElement("matrix");
            element2.setAttribute("name", stringArray[n]);
            element2.setAttribute("type", "String");
            element2.setAttribute("row_dim", String.valueOf(stringArray2.length));
            for (int i = 0; i < stringArray2.length; ++i) {
                Element element3 = this.document.createElement("element");
                element3.setAttribute("row", String.valueOf(i));
                element3.setAttribute("col", "0");
                element3.setAttribute("val", stringArray2[n]);
                element2.appendChild(element3);
            }
            element.appendChild(element2);
        }
    }

    public void addMatrices(Map map, Element element) {
        int n;
        Object[] objectArray = map.keySet().toArray();
        String[] stringArray = new String[objectArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = (String)objectArray[n];
        }
        for (n = 0; n < stringArray.length; ++n) {
            FloatMatrix floatMatrix = (FloatMatrix)map.get(stringArray[n]);
            Element element2 = this.document.createElement("matrix");
            element2.setAttribute("name", stringArray[n]);
            element2.setAttribute("type", "FloatMatrix");
            element2.setAttribute("row_dim", String.valueOf(floatMatrix.getRowDimension()));
            this.addMatrixElements(floatMatrix, element2);
            element.appendChild(element2);
        }
    }

    public void addMatrixElements(FloatMatrix floatMatrix, Element element) {
        float[][] fArray = floatMatrix.A;
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < fArray[i].length; ++j) {
                Element element2 = this.document.createElement("element");
                element2.setAttribute("row", String.valueOf(i));
                element2.setAttribute("col", String.valueOf(j));
                element2.setAttribute("val", String.valueOf(fArray[i][j]));
                element.appendChild(element2);
            }
        }
    }

    public void writeDocument(String string) throws IOException {
        FileWriter fileWriter = new FileWriter(string);
        this.serialize(this.document, fileWriter);
        fileWriter.flush();
        fileWriter.close();
    }

    public void writeDocument(Document document, Writer writer) throws IOException {
        this.serialize(document, writer);
    }

    private void serialize(Document document, Writer writer) throws IOException {
        this.serializeNode(document, writer, "");
    }

    private void serializeNode(Node node, Writer writer, String string) throws IOException {
        switch (node.getNodeType()) {
            case 9: {
                writer.write("<?xml version=\"1.0\"?>");
                writer.write(this.lineSeparator);
                Document document = (Document)node;
                this.serializeNode(document.getDocumentElement(), writer, " ");
                break;
            }
            case 1: {
                String string2 = node.getNodeName();
                writer.write(string + "<" + string2);
                NamedNodeMap namedNodeMap = node.getAttributes();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    Node node2 = namedNodeMap.item(i);
                    writer.write(" " + node2.getNodeName() + "=\"" + node2.getNodeValue() + "\"");
                }
                NodeList nodeList = node.getChildNodes();
                if (nodeList.getLength() > 0) {
                    writer.write(">");
                    if (nodeList.item(0) != null && nodeList.item(0).getNodeType() == 1) {
                        writer.write(this.lineSeparator);
                    }
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        this.serializeNode(nodeList.item(i), writer, string + this.indent);
                    }
                    if (nodeList.item(0) != null && nodeList.item(nodeList.getLength() - 1).getNodeType() == 1) {
                        writer.write(string);
                    }
                    writer.write("</" + string2 + ">");
                } else {
                    writer.write("/>");
                }
                writer.write(this.lineSeparator);
                break;
            }
            case 3: {
                writer.write(node.getNodeValue());
                break;
            }
        }
    }
}

