/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file.agilent;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.tigr.microarray.mev.file.agilent.ColumnMismatchException;
import org.tigr.microarray.mev.file.agilent.Extract;
import org.tigr.microarray.mev.file.agilent.Reader;

public class MeVerizer {
    public static String HEADER_HEADER = "FEATURES";
    public static String FUDGE = "FUDGE";
    public static String PLACE_HOLDER = "MOTHRA";
    public static boolean PARSE_BY_HEADERS = true;
    public static boolean PARSE_BY_INDICES = false;
    private String mHeaders;
    private String columnDef;
    private String headerLine;
    private int iHeaders;
    private Vector vExtract;

    public MeVerizer(String string, String string2) throws ColumnMismatchException {
        this.mHeaders = string;
        this.columnDef = string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "\t");
        if (stringTokenizer.countTokens() != stringTokenizer2.countTokens()) {
            throw new ColumnMismatchException("Header columns are mismatched");
        }
    }

    public void parseExtract(File file, boolean bl, String string) throws IOException {
        Vector vector = this.readFileAsVector(file);
        this.iHeaders = this.findHeaderRow(vector, HEADER_HEADER);
        this.headerLine = this.findHeaderString(vector, HEADER_HEADER);
        this.vExtract = this.createExtract(vector, this.headerLine, this.iHeaders, bl, string);
    }

    private Vector createExtract(Vector vector, String string, int n, boolean bl, String string2) {
        Vector<Extract> vector2 = new Vector<Extract>();
        for (int i = n + 1; i < vector.size(); ++i) {
            String string3 = (String)vector.elementAt(i);
            Extract extract = new Extract();
            if (bl) {
                extract.parseLineByHeaders(string, string3, this.columnDef, string2);
            } else {
                extract.parseLineByIndex(this.columnDef, string3, string2);
            }
            vector2.add(extract);
        }
        return vector2;
    }

    private String findHeaderString(Vector vector, String string) {
        String string2 = null;
        for (int i = 0; i < vector.size(); ++i) {
            String string3 = (String)vector.elementAt(i);
            if (!string3.startsWith(string)) continue;
            string2 = string3;
        }
        return string2;
    }

    private int findHeaderRow(Vector vector, String string) {
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = (String)vector.elementAt(i);
            if (!string2.startsWith(string)) continue;
            n = i;
        }
        return n;
    }

    private Vector readFileAsVector(File file) throws IOException {
        Reader reader = new Reader();
        reader.readFile(file);
        return reader.getVNullLine(PLACE_HOLDER);
    }

    public String getFileString() {
        StringBuffer stringBuffer = new StringBuffer(this.mHeaders + "\r\n");
        for (int i = 0; i < this.vExtract.size(); ++i) {
            Extract extract = (Extract)this.vExtract.elementAt(i);
            String string = extract.getParsedLine();
            stringBuffer.append(string);
            stringBuffer.append("\r\n");
        }
        return stringBuffer.toString();
    }

    public Vector checkHeaders() {
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.columnDef, "\t");
        while (stringTokenizer.hasMoreTokens()) {
            vector2.add(stringTokenizer.nextToken());
        }
        StringTokenizer stringTokenizer2 = new StringTokenizer(this.headerLine, "\t");
        while (stringTokenizer2.hasMoreTokens()) {
            vector3.add(stringTokenizer2.nextToken());
        }
        for (int i = 0; i < vector2.size(); ++i) {
            String string = (String)vector2.elementAt(i);
            boolean bl = false;
            for (int j = 0; j < vector3.size(); ++j) {
                String string2 = (String)vector3.elementAt(j);
                if (!string.toLowerCase().equals(string2.toLowerCase())) continue;
                bl = true;
            }
            if (bl) continue;
            vector.add(string);
        }
        return vector;
    }
}

