/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file.agilent;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.tigr.microarray.file.AgilentAnnFileParser;
import org.tigr.microarray.file.AgilentMevFileParser;
import org.tigr.microarray.mev.FloatSlideData;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideMetaData;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.SlideDataElement;
import org.tigr.microarray.mev.SpotInformationData;
import org.tigr.microarray.mev.file.ExpressionFileLoader;
import org.tigr.microarray.mev.file.FileTreePane;
import org.tigr.microarray.mev.file.FileTreePaneEvent;
import org.tigr.microarray.mev.file.FileTreePaneListener;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;
import org.tigr.microarray.mev.file.agilent.AgilentFileFilter;
import org.tigr.util.awt.GBA;

public class AgilentMevFileLoader
extends ExpressionFileLoader {
    private GBA gba = new GBA();
    private AgilentMevFileLoaderPanel amflp = new AgilentMevFileLoaderPanel();
    private boolean loadEnabled = false;
    private String[] uidArray;
    private String mHeaderLine = "UID\tIA\tIB\tR\tC\tMR\tMC\tFlagA\tFlagB\tBGA\tBGB\tSDIA\tSDIB\tSDBGA\tSDBGB\tMedianA\tMedianB";
    private String columnDefLine = "FeatureNum\tgDyeNormSignal\trDyeNormSignal\tRow\tCol\tgIsFeatNonUnifOL\trIsFeatNonUnifOL\tgBGMedianSignal\trBGMedianSignal\tgPixSDev\trPixSDev\tgBGPixSDev\trBGPixSDev\tgMedianSignal\trMedianSignal";
    private String replacement = "1";

    public AgilentMevFileLoader(SuperExpressionFileLoader superExpressionFileLoader) {
        super(superExpressionFileLoader);
    }

    public Vector loadExpressionFiles() throws IOException {
        int n;
        Object[] objectArray = this.amflp.getMevSelectedListModel().toArray();
        Object[] objectArray2 = this.amflp.getAnnSelectedListModel().toArray();
        Vector<ISlideData> vector = new Vector<ISlideData>();
        ISlideMetaData iSlideMetaData = null;
        this.setFilesCount(objectArray.length);
        for (n = 0; n < objectArray.length; ++n) {
            this.setFileName(((File)objectArray[n]).getName());
            if (n == 0) {
                ISlideData iSlideData = this.loadSlideData((File)objectArray[n]);
                vector.add(iSlideData);
                iSlideMetaData = iSlideData.getSlideMetaData();
            } else {
                vector.add(this.loadFloatSlideData((File)objectArray[n], iSlideMetaData));
            }
            this.setFilesProgress(n);
        }
        if (!this.amflp.noAnnFileBox.isSelected()) {
            for (n = 0; n < objectArray2.length; ++n) {
                this.loadAnnotationFile((SlideData)vector.elementAt(0), (File)objectArray2[n]);
            }
        } else {
            this.loadAnnotationFromMevFile((File)objectArray[0], (SlideData)vector.elementAt(0));
        }
        return vector;
    }

    public ISlideData loadExpressionFile(File file) {
        return null;
    }

    public void loadAnnotationFromMevFile(File file, SlideData slideData) {
        int n;
        AgilentMevFileParser agilentMevFileParser = new AgilentMevFileParser();
        agilentMevFileParser.loadFile(file);
        SpotInformationData spotInformationData = agilentMevFileParser.getSpotInformation();
        int n2 = spotInformationData.getSize();
        String[] stringArray = spotInformationData.getSpotInformationHeader();
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < stringArray.length; ++n) {
            vector.add(stringArray[n]);
        }
        this.setTMEVFieldNames(vector);
        for (n = 1; n < n2; ++n) {
            ((SlideDataElement)slideData.getSlideDataElement(n)).setExtraFields(spotInformationData.getSpotInformationArray(n));
        }
    }

    public ISlideData loadSlideData(File file) throws IOException {
        SlideData slideData = null;
        AgilentMevFileParser agilentMevFileParser = new AgilentMevFileParser();
        agilentMevFileParser.loadFile(file);
        if (agilentMevFileParser.isMevFileLoaded()) {
            int n;
            Vector vector = agilentMevFileParser.getColumnHeaders();
            String[][] stringArray = agilentMevFileParser.getDataMatrix();
            int n2 = stringArray[0].length;
            int n3 = stringArray.length;
            this.uidArray = new String[stringArray.length];
            int n4 = 0;
            int n5 = 0;
            for (n = 0; n < stringArray.length; ++n) {
                n4 = Math.max(n4, Integer.parseInt(stringArray[n][3]));
                n5 = Math.max(n5, Integer.parseInt(stringArray[n][4]));
            }
            slideData = new SlideData(n4, n5);
            this.setLinesCount(stringArray.length);
            for (n = 0; n < stringArray.length; ++n) {
                int[] nArray = new int[3];
                int[] nArray2 = new int[3];
                float[] fArray = new float[2];
                this.uidArray[n] = stringArray[n][0];
                fArray[0] = Float.parseFloat(stringArray[n][1]);
                fArray[1] = Float.parseFloat(stringArray[n][2]);
                nArray[0] = Integer.parseInt(stringArray[n][3]);
                nArray2[0] = Integer.parseInt(stringArray[n][4]);
                nArray[1] = Integer.parseInt(stringArray[n][5]);
                nArray2[1] = Integer.parseInt(stringArray[n][6]);
                nArray[2] = Integer.parseInt(stringArray[n][7]);
                nArray2[2] = Integer.parseInt(stringArray[n][8]);
                SlideDataElement slideDataElement = new SlideDataElement(String.valueOf(n + 1), nArray, nArray2, fArray, null);
                slideData.add(slideDataElement);
                this.setFileProgress(n);
            }
            if (!this.amflp.noAnnFileBox.isSelected()) {
                slideData.setSpotInformationData(agilentMevFileParser.getSpotInformation());
            }
            slideData.setSlideDataName(file.getName());
            slideData.setSlideFileName(file.getPath());
        }
        return slideData;
    }

    public ISlideData loadFloatSlideData(File file, ISlideMetaData iSlideMetaData) throws IOException {
        AgilentMevFileParser agilentMevFileParser = new AgilentMevFileParser();
        agilentMevFileParser.loadFile(file);
        FloatSlideData floatSlideData = new FloatSlideData(iSlideMetaData);
        if (agilentMevFileParser.isMevFileLoaded()) {
            Vector vector = agilentMevFileParser.getColumnHeaders();
            String[][] stringArray = agilentMevFileParser.getDataMatrix();
            this.setLinesCount(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                floatSlideData.setIntensities(i, Float.parseFloat(stringArray[i][1]), Float.parseFloat(stringArray[i][2]));
                this.setFileProgress(i);
            }
            if (!this.amflp.noAnnFileBox.isSelected()) {
                floatSlideData.setSpotInformationData(agilentMevFileParser.getSpotInformation());
            }
        }
        floatSlideData.setSlideDataName(file.getName());
        floatSlideData.setSlideFileName(file.getPath());
        return floatSlideData;
    }

    public Vector loadAnnotationFile(SlideData slideData, File file) throws IOException {
        AgilentAnnFileParser agilentAnnFileParser = new AgilentAnnFileParser();
        agilentAnnFileParser.loadFile(file);
        if (agilentAnnFileParser.isAnnFileLoaded()) {
            Vector vector = agilentAnnFileParser.getColumnHeaders();
            Vector<String> vector2 = new Vector<String>();
            for (int i = 3; i < vector.size(); ++i) {
                vector2.add((String)vector.elementAt(i));
            }
            this.setTMEVFieldNames(vector2);
            String[][] stringArray = agilentAnnFileParser.getDataMatrix();
            Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
            int n = slideData.size();
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = new String[stringArray[i].length - 3];
                System.arraycopy(stringArray[i], 3, stringArray2, 0, stringArray[i].length - 3);
                hashtable.put(stringArray[i][0], stringArray2);
            }
            for (int i = 0; i < n; ++i) {
                String[] stringArray3 = (String[])hashtable.get(this.uidArray[i]);
                ((SlideDataElement)slideData.getSlideDataElement(i)).setExtraFields(stringArray3);
            }
        }
        return new Vector();
    }

    public FileFilter getFileFilter() {
        AgilentFileFilter agilentFileFilter = new AgilentFileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().toLowerCase().endsWith(".txt");
            }

            public String getDescription() {
                return "Agilent Oligo Feature Extraction Files (*.txt)";
            }
        };
        return agilentFileFilter;
    }

    public FileFilter getAnnotationFileFilter() {
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().endsWith(".txt");
            }

            public String getDescription() {
                return "Agilent Pattern Files (*.txt)";
            }
        };
        return fileFilter;
    }

    public boolean checkLoadEnable() {
        this.setLoadEnabled(this.loadEnabled);
        return this.loadEnabled;
    }

    public void markLoadEnabled(boolean bl) {
        this.loadEnabled = bl;
        this.checkLoadEnable();
    }

    public JPanel getFileLoaderPanel() {
        return this.amflp;
    }

    public void processFileList(String string, Vector vector) {
        this.amflp.setPath(string);
        if (vector == null) {
            return;
        }
        FileFilter fileFilter = this.getFileFilter();
        FileFilter fileFilter2 = this.getAnnotationFileFilter();
        this.amflp.getMevAvailableListModel().clear();
        this.amflp.getAnnAvailableListModel().clear();
        for (int i = 0; i < vector.size(); ++i) {
            File file = new File((String)vector.elementAt(i));
            if (fileFilter.accept(file)) {
                this.amflp.getMevAvailableListModel().addElement(new File((String)vector.elementAt(i)));
            }
            if (!fileFilter2.accept(file)) continue;
            this.amflp.getAnnAvailableListModel().addElement(new File((String)vector.elementAt(i)));
        }
    }

    public String getFilePath() {
        if (this.amflp.getMevSelectedListModel().getSize() < 1) {
            return null;
        }
        return ((File)this.amflp.getMevSelectedListModel().getElementAt(0)).getAbsolutePath();
    }

    public void openDataPath() {
        this.amflp.openDataPath();
    }

    private class AgilentMevFileLoaderPanel
    extends JPanel {
        FileTreePane fileTreePane;
        JTextField pathTextField;
        JPanel mevSelectionPanel;
        JPanel mevListPanel;
        JLabel mevAvailableLabel;
        JLabel mevSelectedLabel;
        JList mevAvailableList;
        JList mevSelectedList;
        JScrollPane mevAvailableScrollPane;
        JScrollPane mevSelectedScrollPane;
        JButton mevAddButton;
        JButton mevAddAllButton;
        JButton mevRemoveButton;
        JButton mevRemoveAllButton;
        JPanel mevButtonPanel;
        JPanel annSelectionPanel;
        JPanel annListPanel;
        JLabel annAvailableLabel;
        JLabel annSelectedLabel;
        JList annAvailableList;
        JList annSelectedList;
        JScrollPane annAvailableScrollPane;
        JScrollPane annSelectedScrollPane;
        JButton annAddButton;
        JButton annAddAllButton;
        JButton annRemoveButton;
        JButton annRemoveAllButton;
        JPanel annButtonPanel;
        JTextField annFieldsTextField;
        JPanel selectionPanel;
        JSplitPane splitPane;
        JPanel fileLoaderPanel;
        JCheckBox noAnnFileBox;
        JPanel updatePanel;

        public AgilentMevFileLoaderPanel() {
            this.setLayout(new GridBagLayout());
            this.fileTreePane = new FileTreePane(SuperExpressionFileLoader.DATA_PATH);
            this.fileTreePane.addFileTreePaneListener(new FileTreePaneEventHandler());
            this.fileTreePane.setPreferredSize(new Dimension(200, 50));
            this.pathTextField = new JTextField();
            this.pathTextField.setEditable(false);
            this.pathTextField.setBorder(new TitledBorder(new EtchedBorder(), "Selected Path"));
            this.pathTextField.setForeground(Color.black);
            this.pathTextField.setFont(new Font("monospaced", 1, 12));
            this.mevSelectionPanel = new JPanel();
            this.mevSelectionPanel.setLayout(new GridBagLayout());
            this.mevSelectionPanel.setBorder(new TitledBorder(new EtchedBorder(), AgilentMevFileLoader.this.getFileFilter().getDescription()));
            this.mevAvailableLabel = new JLabel("Available");
            this.mevSelectedLabel = new JLabel("Selected");
            this.mevAvailableList = new JList(new DefaultListModel());
            this.mevAvailableList.setCellRenderer(new ListRenderer());
            this.mevSelectedList = new JList(new DefaultListModel());
            this.mevSelectedList.setCellRenderer(new ListRenderer());
            this.mevAvailableScrollPane = new JScrollPane(this.mevAvailableList);
            this.mevSelectedScrollPane = new JScrollPane(this.mevSelectedList);
            this.mevAddButton = new JButton("Add");
            this.mevAddButton.addActionListener(new EventHandler());
            this.mevAddAllButton = new JButton("Add All");
            this.mevAddAllButton.addActionListener(new EventHandler());
            this.mevRemoveButton = new JButton("Remove");
            this.mevRemoveButton.addActionListener(new EventHandler());
            this.mevRemoveAllButton = new JButton("Remove All");
            this.mevRemoveAllButton.addActionListener(new EventHandler());
            Dimension dimension = this.mevRemoveAllButton.getPreferredSize();
            this.mevAddButton.setPreferredSize(dimension);
            this.mevAddAllButton.setPreferredSize(dimension);
            this.mevRemoveButton.setPreferredSize(dimension);
            this.mevRemoveAllButton.setPreferredSize(dimension);
            this.mevButtonPanel = new JPanel();
            this.mevButtonPanel.setLayout(new GridBagLayout());
            AgilentMevFileLoader.this.gba.add((Container)this.mevButtonPanel, (Component)this.mevAddButton, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            AgilentMevFileLoader.this.gba.add((Container)this.mevButtonPanel, (Component)this.mevAddAllButton, 0, 1, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            AgilentMevFileLoader.this.gba.add((Container)this.mevButtonPanel, (Component)this.mevRemoveButton, 0, 2, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            AgilentMevFileLoader.this.gba.add((Container)this.mevButtonPanel, (Component)this.mevRemoveAllButton, 0, 3, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.mevListPanel = new JPanel();
            this.mevListPanel.setLayout(new GridBagLayout());
            AgilentMevFileLoader.this.gba.add((Container)this.mevListPanel, (Component)this.mevAvailableLabel, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            AgilentMevFileLoader.this.gba.add((Container)this.mevListPanel, (Component)this.mevSelectedLabel, 2, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            AgilentMevFileLoader.this.gba.add((Container)this.mevListPanel, (Component)this.mevAvailableScrollPane, 0, 1, 1, 4, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            AgilentMevFileLoader.this.gba.add((Container)this.mevListPanel, (Component)this.mevButtonPanel, 1, 1, 1, 4, 0, 1, 3, 10, new Insets(5, 5, 5, 5), 0, 0);
            AgilentMevFileLoader.this.gba.add((Container)this.mevListPanel, (Component)this.mevSelectedScrollPane, 2, 1, 1, 4, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            AgilentMevFileLoader.this.gba.add((Container)this.mevSelectionPanel, (Component)this.mevListPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.noAnnFileBox = new JCheckBox("Use Annotation Contained in MeV File (no annotation file)", false);
            this.noAnnFileBox.setFocusPainted(false);
            this.noAnnFileBox.setActionCommand("use-annotation-in-mev-file");
            this.noAnnFileBox.addActionListener(new EventHandler());
            this.annSelectionPanel = new JPanel();
            this.annSelectionPanel.setLayout(new GridBagLayout());
            this.annSelectionPanel.setBorder(new TitledBorder(new EtchedBorder(), AgilentMevFileLoader.this.getAnnotationFileFilter().getDescription()));
            this.annAvailableLabel = new JLabel("Available");
            this.annSelectedLabel = new JLabel("Selected");
            this.annAvailableList = new JList(new DefaultListModel());
            this.annAvailableList.setCellRenderer(new ListRenderer());
            this.annSelectedList = new JList(new DefaultListModel());
            this.annSelectedList.setCellRenderer(new ListRenderer());
            this.annAvailableScrollPane = new JScrollPane(this.annAvailableList);
            this.annSelectedScrollPane = new JScrollPane(this.annSelectedList);
            this.annAddButton = new JButton("Add");
            this.annAddButton.addActionListener(new EventHandler());
            this.annAddAllButton = new JButton("Add All");
            this.annAddAllButton.addActionListener(new EventHandler());
            this.annRemoveButton = new JButton("Remove");
            this.annRemoveButton.addActionListener(new EventHandler());
            this.annRemoveAllButton = new JButton("Remove All");
            this.annRemoveAllButton.addActionListener(new EventHandler());
            Dimension dimension2 = this.annRemoveAllButton.getPreferredSize();
            this.annAddButton.setPreferredSize(dimension2);
            this.annAddAllButton.setPreferredSize(dimension2);
            this.annRemoveButton.setPreferredSize(dimension2);
            this.annRemoveAllButton.setPreferredSize(dimension2);
            this.mevAddAllButton.setFocusPainted(false);
            this.mevAddButton.setFocusPainted(false);
            this.mevRemoveAllButton.setFocusPainted(false);
            this.mevRemoveButton.setFocusPainted(false);
            this.annAddAllButton.setFocusPainted(false);
            this.annAddButton.setFocusPainted(false);
            this.annRemoveAllButton.setFocusPainted(false);
            this.annRemoveButton.setFocusPainted(false);
            this.annButtonPanel = new JPanel();
            this.annButtonPanel.setLayout(new GridBagLayout());
            AgilentMevFileLoader.this.gba.add((Container)this.annButtonPanel, (Component)this.annAddButton, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            AgilentMevFileLoader.this.gba.add((Container)this.annButtonPanel, (Component)this.annAddAllButton, 0, 1, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            AgilentMevFileLoader.this.gba.add((Container)this.annButtonPanel, (Component)this.annRemoveButton, 0, 2, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            AgilentMevFileLoader.this.gba.add((Container)this.annButtonPanel, (Component)this.annRemoveAllButton, 0, 3, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.annListPanel = new JPanel();
            this.annListPanel.setLayout(new GridBagLayout());
            AgilentMevFileLoader.this.gba.add((Container)this.annListPanel, (Component)this.annAvailableLabel, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            AgilentMevFileLoader.this.gba.add((Container)this.annListPanel, (Component)this.annSelectedLabel, 2, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            AgilentMevFileLoader.this.gba.add((Container)this.annListPanel, (Component)this.annAvailableScrollPane, 0, 1, 1, 4, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            AgilentMevFileLoader.this.gba.add((Container)this.annListPanel, (Component)this.annButtonPanel, 1, 1, 1, 4, 0, 1, 3, 10, new Insets(5, 5, 5, 5), 0, 0);
            AgilentMevFileLoader.this.gba.add((Container)this.annListPanel, (Component)this.annSelectedScrollPane, 2, 1, 1, 4, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.annFieldsTextField = new JTextField();
            this.annFieldsTextField.setEditable(false);
            this.annFieldsTextField.setBorder(new TitledBorder(new EtchedBorder(), "Annotation Fields"));
            this.annFieldsTextField.setForeground(Color.black);
            this.annFieldsTextField.setFont(new Font("serif", 1, 12));
            AgilentMevFileLoader.this.gba.add((Container)this.annSelectionPanel, (Component)this.annListPanel, 0, 0, 1, 2, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            AgilentMevFileLoader.this.gba.add((Container)this.annSelectionPanel, (Component)this.annFieldsTextField, 0, 2, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.selectionPanel = new JPanel();
            this.selectionPanel.setLayout(new GridBagLayout());
            AgilentMevFileLoader.this.gba.add((Container)this.selectionPanel, (Component)this.pathTextField, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            AgilentMevFileLoader.this.gba.add((Container)this.selectionPanel, (Component)this.mevSelectionPanel, 0, 1, 1, 2, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            AgilentMevFileLoader.this.gba.add((Container)this.selectionPanel, (Component)this.annSelectionPanel, 0, 4, 1, 2, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.splitPane = new JSplitPane(1, this.fileTreePane, this.selectionPanel);
            this.fileLoaderPanel = new JPanel();
            this.fileLoaderPanel.setLayout(new GridBagLayout());
            AgilentMevFileLoader.this.gba.add((Container)this.fileLoaderPanel, (Component)this.splitPane, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            AgilentMevFileLoader.this.gba.add((Container)this, (Component)this.fileLoaderPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        }

        public void setPath(String string) {
            this.pathTextField.setText(string);
        }

        public void openDataPath() {
            this.fileTreePane.openDataPath();
        }

        public void validateLists() {
            if (((DefaultListModel)this.mevSelectedList.getModel()).size() > 0) {
                if (((DefaultListModel)this.annSelectedList.getModel()).size() > 0) {
                    AgilentMevFileLoader.this.markLoadEnabled(true);
                } else {
                    AgilentMevFileLoader.this.markLoadEnabled(false);
                }
            } else {
                AgilentMevFileLoader.this.markLoadEnabled(false);
            }
        }

        public void onMevAdd() {
            int n;
            int[] nArray = this.mevAvailableList.getSelectedIndices();
            Object[] objectArray = new Object[nArray.length];
            for (n = nArray.length - 1; n >= 0; --n) {
                Object e = ((DefaultListModel)this.mevAvailableList.getModel()).getElementAt(nArray[n]);
                objectArray[n] = e;
            }
            for (n = 0; n < nArray.length; ++n) {
                ((DefaultListModel)this.mevSelectedList.getModel()).addElement(objectArray[n]);
            }
            this.validateLists();
        }

        public void onMevAddAll() {
            int n = ((DefaultListModel)this.mevAvailableList.getModel()).size();
            for (int i = 0; i < n; ++i) {
                Object e = ((DefaultListModel)this.mevAvailableList.getModel()).getElementAt(i);
                ((DefaultListModel)this.mevSelectedList.getModel()).addElement(e);
            }
            this.validateLists();
        }

        public void onMevRemove() {
            int[] nArray = this.mevSelectedList.getSelectedIndices();
            for (int i = nArray.length - 1; i >= 0; --i) {
                ((DefaultListModel)this.mevSelectedList.getModel()).remove(nArray[i]);
            }
            this.validateLists();
        }

        public void onMevRemoveAll() {
            ((DefaultListModel)this.mevSelectedList.getModel()).removeAllElements();
            this.validateLists();
        }

        public void onAnnAdd() {
            int n;
            int[] nArray = this.annAvailableList.getSelectedIndices();
            Object[] objectArray = new Object[nArray.length];
            for (n = nArray.length - 1; n >= 0; --n) {
                Object e = ((DefaultListModel)this.annAvailableList.getModel()).getElementAt(nArray[n]);
                objectArray[n] = e;
            }
            for (n = 0; n < nArray.length; ++n) {
                ((DefaultListModel)this.annSelectedList.getModel()).addElement(objectArray[n]);
            }
            this.validateLists();
        }

        public void onAnnAddAll() {
            int n = ((DefaultListModel)this.annAvailableList.getModel()).size();
            for (int i = 0; i < n; ++i) {
                Object e = ((DefaultListModel)this.annAvailableList.getModel()).getElementAt(i);
                ((DefaultListModel)this.annSelectedList.getModel()).addElement(e);
            }
            this.validateLists();
        }

        public void onAnnRemove() {
            int[] nArray = this.annSelectedList.getSelectedIndices();
            for (int i = nArray.length - 1; i >= 0; --i) {
                ((DefaultListModel)this.annSelectedList.getModel()).remove(nArray[i]);
            }
            this.validateLists();
        }

        public void onAnnRemoveAll() {
            ((DefaultListModel)this.annSelectedList.getModel()).removeAllElements();
            this.validateLists();
        }

        public void onUseMevAnn() {
            if (this.noAnnFileBox.isSelected()) {
                this.enableAnnotationPanel(false);
            } else {
                this.enableAnnotationPanel(true);
            }
        }

        public void enableAnnotationPanel(boolean bl) {
            this.annAddAllButton.setEnabled(bl);
            this.annAddButton.setEnabled(bl);
            this.annRemoveAllButton.setEnabled(bl);
            this.annRemoveButton.setEnabled(bl);
            this.annAvailableLabel.setEnabled(bl);
            this.annSelectedLabel.setEnabled(bl);
            this.annAvailableList.setEnabled(bl);
            this.annSelectedList.setEnabled(bl);
            if (!bl) {
                this.annAvailableList.setBackground(Color.lightGray);
                this.annSelectedList.setBackground(Color.lightGray);
            } else {
                this.annAvailableList.setBackground(Color.white);
                this.annSelectedList.setBackground(Color.white);
            }
        }

        public DefaultListModel getMevAvailableListModel() {
            return (DefaultListModel)this.mevAvailableList.getModel();
        }

        public DefaultListModel getAnnAvailableListModel() {
            return (DefaultListModel)this.annAvailableList.getModel();
        }

        public DefaultListModel getMevSelectedListModel() {
            return (DefaultListModel)this.mevSelectedList.getModel();
        }

        public DefaultListModel getAnnSelectedListModel() {
            return (DefaultListModel)this.annSelectedList.getModel();
        }

        private class FileTreePaneEventHandler
        implements FileTreePaneListener {
            private FileTreePaneEventHandler() {
            }

            public void nodeSelected(FileTreePaneEvent fileTreePaneEvent) {
                String string = (String)fileTreePaneEvent.getValue("Path");
                Vector vector = (Vector)fileTreePaneEvent.getValue("Filenames");
                AgilentMevFileLoader.this.processFileList(string, vector);
            }

            public void nodeCollapsed(FileTreePaneEvent fileTreePaneEvent) {
            }

            public void nodeExpanded(FileTreePaneEvent fileTreePaneEvent) {
            }
        }

        private class EventHandler
        implements ActionListener {
            private EventHandler() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object == AgilentMevFileLoaderPanel.this.mevAddButton) {
                    AgilentMevFileLoaderPanel.this.onMevAdd();
                } else if (object == AgilentMevFileLoaderPanel.this.mevAddAllButton) {
                    AgilentMevFileLoaderPanel.this.onMevAddAll();
                } else if (object == AgilentMevFileLoaderPanel.this.mevRemoveButton) {
                    AgilentMevFileLoaderPanel.this.onMevRemove();
                } else if (object == AgilentMevFileLoaderPanel.this.mevRemoveAllButton) {
                    AgilentMevFileLoaderPanel.this.onMevRemoveAll();
                } else if (object == AgilentMevFileLoaderPanel.this.annAddButton) {
                    AgilentMevFileLoaderPanel.this.onAnnAdd();
                } else if (object == AgilentMevFileLoaderPanel.this.annAddAllButton) {
                    AgilentMevFileLoaderPanel.this.onAnnAddAll();
                } else if (object == AgilentMevFileLoaderPanel.this.annRemoveButton) {
                    AgilentMevFileLoaderPanel.this.onAnnRemove();
                } else if (object == AgilentMevFileLoaderPanel.this.annRemoveAllButton) {
                    AgilentMevFileLoaderPanel.this.onAnnRemoveAll();
                } else if (object == AgilentMevFileLoaderPanel.this.noAnnFileBox) {
                    AgilentMevFileLoaderPanel.this.onUseMevAnn();
                }
            }
        }

        private class ListRenderer
        extends DefaultListCellRenderer {
            private ListRenderer() {
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                File file = (File)object;
                this.setText(file.getName());
                return this;
            }
        }
    }
}

