/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.tigr.microarray.mev.FloatSlideData;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.SlideDataElement;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.file.ExpressionFileLoader;
import org.tigr.microarray.mev.file.FileTreePane;
import org.tigr.microarray.mev.file.FileTreePaneEvent;
import org.tigr.microarray.mev.file.FileTreePaneListener;
import org.tigr.microarray.mev.file.GBA;
import org.tigr.microarray.mev.file.StringSplitter;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;

public class StanfordFileLoader
extends ExpressionFileLoader {
    private GBA gba = new GBA();
    private boolean stop = false;
    private StanfordFileLoaderPanel sflp = new StanfordFileLoaderPanel();

    public StanfordFileLoader(SuperExpressionFileLoader superExpressionFileLoader) {
        super(superExpressionFileLoader);
    }

    public Vector loadExpressionFiles() throws IOException {
        return this.loadStanfordExpressionFile(new File(this.sflp.fileNameTextField.getText()));
    }

    public ISlideData loadExpressionFile(File file) {
        return null;
    }

    public Vector loadStanfordExpressionFile_old(File file) throws IOException {
        String string;
        int n = this.sflp.getXRow() + 1;
        int n2 = this.sflp.getXColumn();
        int n3 = this.getCountOfLines(file);
        int n4 = n3 - n;
        if (n4 <= 0) {
            JOptionPane.showMessageDialog(this.superLoader.getFrame(), "There is no spot data available.", "TDMS Load Error", 1);
        }
        int[] nArray = new int[]{0, 1, 0};
        int[] nArray2 = new int[]{0, 1, 0};
        String[] stringArray = new String[n2];
        int n5 = n4;
        ISlideData[] iSlideDataArray = null;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        StringSplitter stringSplitter = new StringSplitter('\t');
        int n6 = 0;
        int n7 = 1;
        int n8 = 1;
        this.setFilesCount(1);
        this.setRemain(1);
        this.setFilesProgress(0);
        this.setLinesCount(n3);
        this.setFileProgress(0);
        while ((string = bufferedReader.readLine()) != null) {
            int n9;
            if (this.stop) {
                return null;
            }
            stringSplitter.init(string);
            if (n6 == 0) {
                int n10;
                n9 = stringSplitter.countTokens() + 1 - n2;
                iSlideDataArray = new ISlideData[n9];
                iSlideDataArray[0] = new SlideData(n5, 1);
                iSlideDataArray[0].setSlideFileName(file.getPath());
                for (int i = 1; i < iSlideDataArray.length; ++i) {
                    iSlideDataArray[i] = new FloatSlideData(iSlideDataArray[0].getSlideMetaData(), n4);
                    iSlideDataArray[i].setSlideFileName(file.getPath());
                }
                String[] stringArray2 = new String[n2];
                for (n10 = 0; n10 < n2; ++n10) {
                    stringArray2[n10] = stringSplitter.nextToken();
                }
                TMEV.setFieldNames(stringArray2);
                for (n10 = 0; n10 < n9; ++n10) {
                    iSlideDataArray[n10].setSlideDataName(stringSplitter.nextToken());
                }
            } else if (n6 >= n) {
                nArray[0] = nArray[2] = n8++;
                nArray2[0] = nArray2[2] = n7;
                n7 = n7 == 1 ? 1 : ++n7;
                for (n9 = 0; n9 < n2; ++n9) {
                    stringArray[n9] = stringSplitter.nextToken();
                }
                SlideDataElement slideDataElement = new SlideDataElement(String.valueOf(n8 + 1), nArray, nArray2, new float[2], stringArray);
                iSlideDataArray[0].addSlideDataElement(slideDataElement);
                for (n9 = 0; n9 < iSlideDataArray.length; ++n9) {
                    float f;
                    float f2 = 1.0f;
                    try {
                        String string2 = stringSplitter.nextToken();
                        f = Float.parseFloat(string2);
                    }
                    catch (Exception exception) {
                        f2 = 0.0f;
                        f = Float.NaN;
                    }
                    iSlideDataArray[n9].setIntensities(n6 - n, f2, f);
                }
            }
            this.setFileProgress(n6);
            ++n6;
        }
        bufferedReader.close();
        Vector<ISlideData> vector = new Vector<ISlideData>(iSlideDataArray.length);
        for (int i = 0; i < iSlideDataArray.length; ++i) {
            vector.add(iSlideDataArray[i]);
        }
        this.setFilesProgress(1);
        return vector;
    }

    public Vector loadStanfordExpressionFile(File file) throws IOException {
        String string;
        int n = this.sflp.getXRow() + 1;
        int n2 = this.sflp.getXColumn();
        int n3 = this.getCountOfLines(file);
        int n4 = n3 - n;
        if (n4 <= 0) {
            JOptionPane.showMessageDialog(this.superLoader.getFrame(), "There is no spot data available.", "TDMS Load Error", 1);
        }
        int[] nArray = new int[]{0, 1, 0};
        int[] nArray2 = new int[]{0, 1, 0};
        String[] stringArray = new String[n2];
        int n5 = n4;
        ISlideData[] iSlideDataArray = null;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        StringSplitter stringSplitter = new StringSplitter('\t');
        int n6 = 0;
        int n7 = 1;
        int n8 = 1;
        this.setFilesCount(1);
        this.setRemain(1);
        this.setFilesProgress(0);
        this.setLinesCount(n3);
        this.setFileProgress(0);
        while ((string = bufferedReader.readLine()) != null) {
            if (this.stop) {
                return null;
            }
            stringSplitter.init(string);
            if (n6 == 0) {
                int n9;
                int n10 = stringSplitter.countTokens() + 1 - n2;
                iSlideDataArray = new ISlideData[n10];
                iSlideDataArray[0] = new SlideData(n5, 1);
                iSlideDataArray[0].setSlideFileName(file.getPath());
                for (int i = 1; i < iSlideDataArray.length; ++i) {
                    iSlideDataArray[i] = new FloatSlideData(iSlideDataArray[0].getSlideMetaData(), n4);
                    iSlideDataArray[i].setSlideFileName(file.getPath());
                }
                String[] stringArray2 = new String[n2];
                for (n9 = 0; n9 < n2; ++n9) {
                    stringArray2[n9] = stringSplitter.nextToken();
                }
                TMEV.setFieldNames(stringArray2);
                for (n9 = 0; n9 < n10; ++n9) {
                    iSlideDataArray[n9].setSlideDataName(stringSplitter.nextToken());
                }
            } else if (n6 >= n) {
                int n11;
                nArray[0] = nArray[2] = n8++;
                nArray2[0] = nArray2[2] = n7;
                n7 = n7 == 1 ? 1 : ++n7;
                for (n11 = 0; n11 < n2; ++n11) {
                    stringArray[n11] = stringSplitter.nextToken();
                }
                SlideDataElement slideDataElement = new SlideDataElement(String.valueOf(n8 + 1), nArray, nArray2, new float[2], stringArray);
                iSlideDataArray[0].addSlideDataElement(slideDataElement);
                for (n11 = 0; n11 < iSlideDataArray.length; ++n11) {
                    float f;
                    float f2 = 1.0f;
                    try {
                        String string2 = stringSplitter.nextToken();
                        f = Float.parseFloat(string2);
                    }
                    catch (Exception exception) {
                        f2 = 0.0f;
                        f = Float.NaN;
                    }
                    iSlideDataArray[n11].setIntensities(n6 - n, f2, f);
                }
            } else {
                for (int i = 0; i < n2 - 1; ++i) {
                    stringSplitter.nextToken();
                }
                String string3 = stringSplitter.nextToken();
                for (int i = 0; i < iSlideDataArray.length; ++i) {
                    iSlideDataArray[i].addNewSampleLabel(string3, stringSplitter.nextToken());
                }
            }
            this.setFileProgress(n6);
            ++n6;
        }
        bufferedReader.close();
        Vector<ISlideData> vector = new Vector<ISlideData>(iSlideDataArray.length);
        for (int i = 0; i < iSlideDataArray.length; ++i) {
            vector.add(iSlideDataArray[i]);
        }
        this.setFilesProgress(1);
        return vector;
    }

    public FileFilter getFileFilter() {
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().endsWith(".txt");
            }

            public String getDescription() {
                return "Tab Delimited, Multiple Sample Files (TDMS) (*.txt)";
            }
        };
        return fileFilter;
    }

    public boolean checkLoadEnable() {
        int n = this.sflp.getXRow() + 1;
        int n2 = this.sflp.getXColumn();
        if (n2 < 0) {
            return false;
        }
        TableModel tableModel = this.sflp.getTable().getModel();
        String string = "";
        for (int i = 0; i < n2; ++i) {
            string = string + tableModel.getColumnName(i) + (i + 1 == n2 ? "" : ", ");
        }
        this.sflp.setFieldsText(string);
        if (n >= 1 && n2 >= 0) {
            this.setLoadEnabled(true);
            return true;
        }
        this.setLoadEnabled(false);
        return false;
    }

    public boolean validateFile(File file) {
        return true;
    }

    public JPanel getFileLoaderPanel() {
        return this.sflp;
    }

    public void processStanfordFile(File file) {
        Vector<String> vector = new Vector<String>();
        Vector vector2 = new Vector();
        Vector<String> vector3 = null;
        BufferedReader bufferedReader = null;
        String string = null;
        if (!this.validateFile(file)) {
            return;
        }
        this.sflp.setFileName(file.getAbsolutePath());
        DefaultTableModel defaultTableModel = new DefaultTableModel(){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        try {
            bufferedReader = new BufferedReader(new FileReader(file), 131072);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        try {
            int n;
            StringSplitter stringSplitter = new StringSplitter('\t');
            string = bufferedReader.readLine();
            stringSplitter.init(string);
            for (n = 0; n < stringSplitter.countTokens() + 1; ++n) {
                vector.add(stringSplitter.nextToken());
            }
            defaultTableModel.setColumnIdentifiers(vector);
            n = 0;
            while ((string = bufferedReader.readLine()) != null && n < 100) {
                ++n;
                stringSplitter.init(string);
                vector3 = new Vector<String>();
                for (int i = 0; i < stringSplitter.countTokens() + 1; ++i) {
                    try {
                        vector3.add(stringSplitter.nextToken());
                        continue;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        vector3.add(" ");
                    }
                }
                vector2.add(vector3);
                defaultTableModel.addRow(vector3);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.sflp.setTableModel(defaultTableModel);
    }

    public String getFilePath() {
        return this.sflp.fileNameTextField.getText();
    }

    public void openDataPath() {
        this.sflp.openDataPath();
    }

    private class StanfordFileLoaderPanel
    extends JPanel {
        FileTreePane fileTreePane;
        JTextField fileNameTextField;
        JPanel fileSelectionPanel;
        JTable expressionTable;
        JLabel instructionsLabel;
        JScrollPane tableScrollPane;
        JPanel tablePanel;
        JPanel fileLoaderPanel;
        JTextField fieldsTextField;
        JPanel fieldsPanel;
        JSplitPane splitPane;
        JList availableList;
        JScrollPane availableScrollPane;
        private int xRow = -1;
        private int xColumn = -1;

        public StanfordFileLoaderPanel() {
            this.setLayout(new GridBagLayout());
            this.fileTreePane = new FileTreePane(SuperExpressionFileLoader.DATA_PATH);
            this.fileTreePane.addFileTreePaneListener(new FileTreePaneEventHandler());
            this.fileTreePane.setPreferredSize(new Dimension(200, 50));
            this.fileNameTextField = new JTextField();
            this.fileNameTextField.setEditable(false);
            this.fileNameTextField.setForeground(Color.black);
            this.fileNameTextField.setFont(new Font("monospaced", 1, 12));
            this.fileSelectionPanel = new JPanel();
            this.fileSelectionPanel.setLayout(new GridBagLayout());
            this.fileSelectionPanel.setBorder(new TitledBorder(new EtchedBorder(), "Selected TDMS File"));
            StanfordFileLoader.this.gba.add(this.fileSelectionPanel, this.fileNameTextField, 0, 0, 2, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.expressionTable = new JTable();
            this.expressionTable.setCellSelectionEnabled(true);
            this.expressionTable.setColumnSelectionAllowed(false);
            this.expressionTable.setRowSelectionAllowed(false);
            this.expressionTable.setAutoResizeMode(0);
            this.expressionTable.getTableHeader().setReorderingAllowed(false);
            this.expressionTable.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ StanfordFileLoaderPanel this$1;
                {
                    this.this$1 = stanfordFileLoaderPanel;
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    StanfordFileLoaderPanel.access$202(this.this$1, this.this$1.expressionTable.rowAtPoint(mouseEvent.getPoint()));
                    StanfordFileLoaderPanel.access$302(this.this$1, this.this$1.expressionTable.columnAtPoint(mouseEvent.getPoint()));
                    StanfordFileLoaderPanel.access$400(this.this$1).checkLoadEnable();
                }
            });
            this.tableScrollPane = new JScrollPane(this.expressionTable, 22, 32);
            this.instructionsLabel = new JLabel();
            this.instructionsLabel.setForeground(Color.red);
            String string = "<html>Click the upper-leftmost expression value. Click the <b>Load</b> button to finish.</html>";
            this.instructionsLabel.setText(string);
            this.tablePanel = new JPanel();
            this.tablePanel.setLayout(new GridBagLayout());
            this.tablePanel.setBorder(new TitledBorder(new EtchedBorder(), "Expression Table"));
            StanfordFileLoader.this.gba.add(this.tablePanel, this.tableScrollPane, 0, 0, 1, 2, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            StanfordFileLoader.this.gba.add(this.tablePanel, this.instructionsLabel, 0, 2, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.fieldsTextField = new JTextField();
            this.fieldsTextField.setEditable(false);
            this.fieldsTextField.setForeground(Color.black);
            this.fieldsTextField.setFont(new Font("serif", 1, 12));
            this.fieldsPanel = new JPanel();
            this.fieldsPanel.setLayout(new GridBagLayout());
            this.fieldsPanel.setBorder(new TitledBorder(new EtchedBorder(), "Annotation Fields"));
            StanfordFileLoader.this.gba.add(this.fieldsPanel, this.fieldsTextField, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.fileLoaderPanel = new JPanel();
            this.fileLoaderPanel.setLayout(new GridBagLayout());
            this.availableList = new JList(new DefaultListModel());
            this.availableList.setSelectionMode(0);
            this.availableList.setCellRenderer(new ListRenderer());
            this.availableList.addListSelectionListener(new ListListener());
            this.availableScrollPane = new JScrollPane(this.availableList);
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setPreferredSize(new Dimension(10, 100));
            jPanel.setBorder(new TitledBorder(new EtchedBorder(), "Available Files (*.txt)"));
            StanfordFileLoader.this.gba.add(jPanel, this.availableScrollPane, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            StanfordFileLoader.this.gba.add(this.fileLoaderPanel, jPanel, 0, 0, 1, 4, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            StanfordFileLoader.this.gba.add(this.fileLoaderPanel, this.fileSelectionPanel, 1, 0, 1, 1, 3, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            StanfordFileLoader.this.gba.add(this.fileLoaderPanel, this.tablePanel, 1, 1, 1, 2, 3, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            StanfordFileLoader.this.gba.add(this.fileLoaderPanel, this.fieldsPanel, 1, 3, 1, 1, 3, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.splitPane = new JSplitPane(1, this.fileTreePane, this.fileLoaderPanel);
            StanfordFileLoader.this.gba.add(this, this.splitPane, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.splitPane.setDividerLocation(0.5);
        }

        public void openDataPath() {
            this.fileTreePane.openDataPath();
        }

        public JTable getTable() {
            return this.expressionTable;
        }

        public int getXColumn() {
            return this.xColumn;
        }

        public int getXRow() {
            return this.xRow;
        }

        public void selectStanfordFile() {
            JFileChooser jFileChooser = new JFileChooser(SuperExpressionFileLoader.DATA_PATH);
            jFileChooser.setFileFilter(StanfordFileLoader.this.getFileFilter());
            int n = jFileChooser.showDialog(this, "Select");
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                StanfordFileLoader.this.processStanfordFile(file);
            }
        }

        public void setFileName(String string) {
            this.fileNameTextField.setText(string);
        }

        public void setTableModel(TableModel tableModel) {
            this.expressionTable.setModel(tableModel);
            int n = this.expressionTable.getColumnCount();
            for (int i = 0; i < n; ++i) {
                this.expressionTable.getColumnModel().getColumn(i).setMinWidth(75);
            }
        }

        public void setFieldsText(String string) {
            this.fieldsTextField.setText(string);
        }

        static /* synthetic */ int access$202(StanfordFileLoaderPanel stanfordFileLoaderPanel, int n) {
            stanfordFileLoaderPanel.xRow = n;
            return stanfordFileLoaderPanel.xRow;
        }

        static /* synthetic */ int access$302(StanfordFileLoaderPanel stanfordFileLoaderPanel, int n) {
            stanfordFileLoaderPanel.xColumn = n;
            return stanfordFileLoaderPanel.xColumn;
        }

        private class FileTreePaneEventHandler
        implements FileTreePaneListener {
            private FileTreePaneEventHandler() {
            }

            public void nodeSelected(FileTreePaneEvent fileTreePaneEvent) {
                String string = (String)fileTreePaneEvent.getValue("Path");
                Vector vector = (Vector)fileTreePaneEvent.getValue("Filenames");
                if (vector.size() < 1) {
                    return;
                }
                String string2 = (String)vector.elementAt(0);
                ((DefaultListModel)StanfordFileLoaderPanel.this.availableList.getModel()).clear();
                for (int i = 0; i < vector.size(); ++i) {
                    File file = new File((String)vector.elementAt(i));
                    FileFilter fileFilter = StanfordFileLoader.this.getFileFilter();
                    if (!fileFilter.accept(file)) continue;
                    ((DefaultListModel)StanfordFileLoaderPanel.this.availableList.getModel()).addElement(new File((String)vector.elementAt(i)));
                }
            }

            public void nodeCollapsed(FileTreePaneEvent fileTreePaneEvent) {
            }

            public void nodeExpanded(FileTreePaneEvent fileTreePaneEvent) {
            }
        }

        private class ListListener
        implements ListSelectionListener {
            private ListListener() {
            }

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                File file = (File)StanfordFileLoaderPanel.this.availableList.getSelectedValue();
                if (file == null || !file.exists()) {
                    return;
                }
                StanfordFileLoader.this.processStanfordFile(file);
            }
        }

        private class ListRenderer
        extends DefaultListCellRenderer {
            private ListRenderer() {
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                File file = (File)object;
                this.setText(file.getName());
                return this;
            }
        }
    }
}

