/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.file;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.tigr.microarray.file.AnnFileParser;
import org.tigr.microarray.mev.FloatSlideData;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideMetaData;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.SlideDataElement;
import org.tigr.microarray.mev.SpotInformationData;
import org.tigr.microarray.mev.file.ExpressionFileLoader;
import org.tigr.microarray.mev.file.FileTreePane;
import org.tigr.microarray.mev.file.FileTreePaneEvent;
import org.tigr.microarray.mev.file.FileTreePaneListener;
import org.tigr.microarray.mev.file.GBA;
import org.tigr.microarray.mev.file.MevParser;
import org.tigr.microarray.mev.file.SlideLoaderProgressBar;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;

public class MevFileLoader
extends ExpressionFileLoader {
    private GBA gba = new GBA();
    private MevFileLoaderPanel mflp = new MevFileLoaderPanel();
    private boolean loadEnabled = false;
    private String[] uidArray;
    boolean haveSRandSC;
    boolean loadMedianIntensities = false;
    private boolean haveAnnMatch = false;

    public MevFileLoader(SuperExpressionFileLoader superExpressionFileLoader) {
        super(superExpressionFileLoader);
        this.mflp.splitPane.setDividerLocation(0.6);
        this.mflp.validate();
    }

    public Vector loadExpressionFiles() throws IOException {
        int n;
        Object[] objectArray = this.mflp.getMevSelectedListModel().toArray();
        Object[] objectArray2 = this.mflp.getAnnSelectedListModel().toArray();
        Vector<ISlideData> vector = new Vector<ISlideData>();
        ISlideMetaData iSlideMetaData = null;
        this.loadMedianIntensities = this.mflp.loadMedButton.isSelected();
        this.setFilesCount(objectArray.length);
        this.setRemain(objectArray.length);
        for (n = 0; n < objectArray.length; ++n) {
            this.setFileName(((File)objectArray[n]).getName());
            if (n == 0) {
                ISlideData iSlideData = this.loadSlideData((File)objectArray[n]);
                if (iSlideData == null) {
                    return null;
                }
                vector.add(iSlideData);
                iSlideMetaData = iSlideData.getSlideMetaData();
            } else {
                vector.add(this.loadFloatSlideData((File)objectArray[n], iSlideMetaData));
            }
            this.setRemain(objectArray.length - n - 1);
            this.setFilesProgress(n);
        }
        if (!this.mflp.noAnnFileBox.isSelected()) {
            for (n = 0; n < objectArray2.length; ++n) {
                this.loadAnnotationFile((SlideData)vector.elementAt(0), (File)objectArray2[n]);
            }
        } else {
            this.loadAnnotationFromMevFile((File)objectArray[0], (SlideData)vector.elementAt(0));
        }
        if (this.mflp.noAnnFileBox.isSelected() || objectArray2 == null || objectArray2.length == 0) {
            this.haveAnnMatch = true;
        }
        if (!this.haveAnnMatch) {
            String string = "The selected annoation file";
            if (objectArray2 != null && objectArray2.length > 1) {
                string = string + "s";
            }
            string = string + " did not have have UID's that matched any UID's \n";
            string = string + "in the selected mev files.";
            JOptionPane.showMessageDialog(this.mflp, string, "Annotation Mismatch Warning", 2);
        }
        return vector;
    }

    public ISlideData loadExpressionFile(File file) {
        return null;
    }

    public void loadAnnotationFromMevFile(File file, SlideData slideData) {
        int n;
        MevParser mevParser = new MevParser();
        mevParser.loadFile(file);
        SpotInformationData spotInformationData = mevParser.getSpotInformation();
        int n2 = spotInformationData.getSize();
        String[] stringArray = spotInformationData.getSpotInformationHeader();
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < stringArray.length; ++n) {
            vector.add(stringArray[n]);
        }
        this.setTMEVFieldNames(vector);
        for (n = 0; n < n2; ++n) {
            ((SlideDataElement)slideData.getSlideDataElement(n)).setExtraFields(spotInformationData.getSpotInformationArray(n));
        }
    }

    public ISlideData loadSlideData(File file) throws IOException {
        SlideData slideData = null;
        MevParser mevParser = new MevParser();
        mevParser.loadFile(file);
        if (mevParser.isMevFileLoaded()) {
            int n;
            Object object;
            Object object2;
            Vector vector = mevParser.getColumnHeaders();
            int n2 = this.getIntensityColumn(vector, 1);
            int n3 = this.getIntensityColumn(vector, 2);
            if (n2 == -1 || n3 == -1) {
                if (this.loadMedianIntensities) {
                    JOptionPane.showMessageDialog(this.mflp, "Error loading " + file.getName() + "\n" + "The file was missing median intensity columns indicated by\n" + "the header names MedA and MedB", "Load Error", 0);
                } else {
                    JOptionPane.showMessageDialog(this.mflp, "Error loading " + file.getName() + "\n" + "The file was missing intensity columns indicated by\n" + "the header names IA and IB", "Load Error", 0);
                }
                return null;
            }
            this.haveSRandSC = false;
            if (vector.size() > 7) {
                object2 = (String)vector.elementAt(7);
                object = (String)vector.elementAt(8);
                if (((String)object2).equals("SR") && ((String)object).equals("SC")) {
                    this.haveSRandSC = true;
                }
            }
            object2 = mevParser.getDataMatrix();
            this.uidArray = new String[((String[][])object2).length];
            int n4 = 0;
            int n5 = 0;
            for (n = 0; n < ((Object)object2).length; ++n) {
                n4 = Math.max(n4, Integer.parseInt((String)object2[n][3]));
                n5 = Math.max(n5, Integer.parseInt((String)object2[n][4]));
            }
            slideData = new SlideData(n4, n5);
            this.setLinesCount(((Object)object2).length);
            for (n = 0; n < ((Object)object2).length; ++n) {
                int[] nArray = new int[3];
                int[] nArray2 = new int[3];
                float[] fArray = new float[2];
                this.uidArray[n] = object2[n][0];
                try {
                    fArray[0] = Float.parseFloat((String)object2[n][n2]);
                    fArray[1] = Float.parseFloat((String)object2[n][n3]);
                    nArray[0] = Integer.parseInt((String)object2[n][3]);
                    nArray2[0] = Integer.parseInt((String)object2[n][4]);
                    nArray[1] = Integer.parseInt((String)object2[n][5]);
                    nArray2[1] = Integer.parseInt((String)object2[n][6]);
                    if (this.haveSRandSC) {
                        nArray[2] = Integer.parseInt((String)object2[n][7]);
                        nArray2[2] = Integer.parseInt((String)object2[n][8]);
                    } else {
                        nArray[2] = 0;
                        nArray2[2] = 0;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    final String string = file.getName();
                    final int n6 = n;
                    Thread thread = new Thread(new Runnable(){

                        public void run() {
                            JOptionPane.showConfirmDialog(MevFileLoader.this.mflp, "The input file \"" + string + "\" was missing critical information on line # " + String.valueOf(n6 + 1) + "\n" + "MeV files require entries for UID, Intensities, and slide location information.", "Loading Aborted/Loading Error", 0);
                        }
                    });
                    thread.start();
                    return null;
                }
                object = new SlideDataElement((String)object2[n][0], nArray, nArray2, fArray, null);
                slideData.add(object);
                this.setFileProgress(n);
            }
            if (this.mflp.saveSpotInfoBox.isSelected() && !this.mflp.noAnnFileBox.isSelected()) {
                slideData.setSpotInformationData(mevParser.getSpotInformation());
            }
            slideData.setSlideDataName(file.getName());
            slideData.setSlideFileName(file.getPath());
        }
        return slideData;
    }

    private int getIntensityColumn(Vector vector, int n) {
        int n2 = -1;
        String string = this.loadMedianIntensities ? (n == 1 ? "MedA" : "MedB") : (n == 1 ? "IA" : "IB");
        for (int i = 0; i < vector.size(); ++i) {
            if (!((String)vector.elementAt(i)).equals(string)) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    public ISlideData loadFloatSlideData(File file, ISlideMetaData iSlideMetaData) throws IOException {
        MevParser mevParser = new MevParser();
        mevParser.loadFile(file);
        FloatSlideData floatSlideData = new FloatSlideData(iSlideMetaData);
        if (mevParser.isMevFileLoaded()) {
            Vector vector = mevParser.getColumnHeaders();
            int n = this.getIntensityColumn(vector, 1);
            int n2 = this.getIntensityColumn(vector, 2);
            if (n == -1 || n2 == -1) {
                if (this.loadMedianIntensities) {
                    JOptionPane.showMessageDialog(this.mflp, "Error loading " + file.getName() + "\n" + "The file was missing median intensity columns indicated by\n" + "the header names MedA and MedB", "Load Error", 0);
                } else {
                    JOptionPane.showMessageDialog(this.mflp, "Error loading " + file.getName() + "\n" + "The file was missing intensity columns indicated by\n" + "the header names IA and IB", "Load Error", 0);
                }
                return null;
            }
            String[][] stringArray = mevParser.getDataMatrix();
            this.setLinesCount(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                floatSlideData.setIntensities(i, Float.parseFloat(stringArray[i][n]), Float.parseFloat(stringArray[i][n2]));
                this.setFileProgress(i);
            }
            if (this.mflp.saveSpotInfoBox.isSelected() && !this.mflp.noAnnFileBox.isSelected()) {
                floatSlideData.setSpotInformationData(mevParser.getSpotInformation());
            }
        }
        floatSlideData.setSlideDataName(file.getName());
        floatSlideData.setSlideFileName(file.getPath());
        return floatSlideData;
    }

    public Vector loadAnnotationFile(SlideData slideData, File file) throws IOException {
        AnnFileParser annFileParser = new AnnFileParser();
        annFileParser.loadFile(file);
        if (annFileParser.isAnnFileLoaded()) {
            Vector vector = annFileParser.getColumnHeaders();
            int n = 1;
            if (vector.size() >= 3 && ((String)vector.get(1)).equalsIgnoreCase("R") && ((String)vector.get(2)).equalsIgnoreCase("C")) {
                n = 3;
            }
            Vector<String> vector2 = new Vector<String>();
            for (int i = n; i < vector.size(); ++i) {
                vector2.add((String)vector.elementAt(i));
            }
            this.setTMEVFieldNames(vector2);
            String[][] stringArray = this.mflp.cutQuotesBox.isSelected() ? annFileParser.getDataMatrixMinusQuotes() : annFileParser.getDataMatrix();
            Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
            int n2 = slideData.size();
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = new String[stringArray[i].length - n];
                System.arraycopy(stringArray[i], n, stringArray2, 0, stringArray[i].length - n);
                hashtable.put(stringArray[i][0], stringArray2);
            }
            for (int i = 0; i < n2; ++i) {
                String[] stringArray3 = (String[])hashtable.get(this.uidArray[i]);
                if (!this.haveAnnMatch && stringArray3 != null) {
                    this.haveAnnMatch = true;
                }
                ((SlideDataElement)slideData.getSlideDataElement(i)).setExtraFields(stringArray3);
            }
        }
        return new Vector();
    }

    public FileFilter getFileFilter() {
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().endsWith(".mev");
            }

            public String getDescription() {
                return "TIGR MeV Expression Files (*.mev)";
            }
        };
        return fileFilter;
    }

    public FileFilter getAnnotationFileFilter() {
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                if (file.getName().endsWith(".ann")) {
                    return true;
                }
                return file.getName().endsWith(".dat");
            }

            public String getDescription() {
                return "TIGR MeV Annotation Files (*.ann, *.dat)";
            }
        };
        return fileFilter;
    }

    public boolean checkLoadEnable() {
        this.setLoadEnabled(this.loadEnabled);
        return this.loadEnabled;
    }

    public void markLoadEnabled(boolean bl) {
        this.loadEnabled = bl;
        this.checkLoadEnable();
    }

    public JPanel getFileLoaderPanel() {
        return this.mflp;
    }

    public void processFileList(String string, Vector vector) {
        this.mflp.setPath(string);
        if (vector == null) {
            return;
        }
        FileFilter fileFilter = this.getFileFilter();
        FileFilter fileFilter2 = this.getAnnotationFileFilter();
        this.mflp.getMevAvailableListModel().clear();
        this.mflp.getAnnAvailableListModel().clear();
        for (int i = 0; i < vector.size(); ++i) {
            File file = new File((String)vector.elementAt(i));
            if (fileFilter.accept(file)) {
                this.mflp.getMevAvailableListModel().addElement(new File((String)vector.elementAt(i)));
                continue;
            }
            if (!fileFilter2.accept(file)) continue;
            this.mflp.getAnnAvailableListModel().addElement(new File((String)vector.elementAt(i)));
        }
    }

    public String getFilePath() {
        if (this.mflp.getMevSelectedListModel().getSize() < 1) {
            return null;
        }
        return ((File)this.mflp.getMevSelectedListModel().getElementAt(0)).getAbsolutePath();
    }

    public void openDataPath() {
        this.mflp.splitPane.setDividerLocation(0.3);
        this.mflp.openDataPath();
    }

    public class ProgressRunner
    implements Runnable {
        public void run() {
            MevFileLoader.this.progress = new SlideLoaderProgressBar(MevFileLoader.this.superLoader.getFrame());
        }
    }

    private class MevFileLoaderPanel
    extends JPanel {
        FileTreePane fileTreePane;
        JTextField pathTextField;
        JPanel mevSelectionPanel;
        JPanel mevListPanel;
        JLabel mevAvailableLabel;
        JLabel mevSelectedLabel;
        JList mevAvailableList;
        JList mevSelectedList;
        JScrollPane mevAvailableScrollPane;
        JScrollPane mevSelectedScrollPane;
        JButton mevAddButton;
        JButton mevAddAllButton;
        JButton mevRemoveButton;
        JButton mevRemoveAllButton;
        JPanel mevButtonPanel;
        JPanel annSelectionPanel;
        JPanel annListPanel;
        JLabel annAvailableLabel;
        JLabel annSelectedLabel;
        JList annAvailableList;
        JList annSelectedList;
        JScrollPane annAvailableScrollPane;
        JScrollPane annSelectedScrollPane;
        JButton annAddButton;
        JButton annAddAllButton;
        JButton annRemoveButton;
        JButton annRemoveAllButton;
        JPanel annButtonPanel;
        JTextField annFieldsTextField;
        JPanel selectionPanel;
        JSplitPane splitPane;
        JPanel fileLoaderPanel;
        JCheckBox noAnnFileBox;
        JCheckBox saveSpotInfoBox;
        JCheckBox cutQuotesBox;
        JRadioButton loadIButton;
        JRadioButton loadMedButton;

        public MevFileLoaderPanel() {
            this.setLayout(new GridBagLayout());
            this.fileTreePane = new FileTreePane(SuperExpressionFileLoader.DATA_PATH);
            this.fileTreePane.addFileTreePaneListener(new FileTreePaneEventHandler());
            this.fileTreePane.setPreferredSize(new Dimension(200, 50));
            this.pathTextField = new JTextField();
            this.pathTextField.setEditable(false);
            this.pathTextField.setBorder(new TitledBorder(new EtchedBorder(), "Selected Path"));
            this.pathTextField.setForeground(Color.black);
            this.pathTextField.setFont(new Font("monospaced", 1, 12));
            this.mevSelectionPanel = new JPanel();
            this.mevSelectionPanel.setLayout(new GridBagLayout());
            this.mevSelectionPanel.setBorder(new TitledBorder(new EtchedBorder(), MevFileLoader.this.getFileFilter().getDescription()));
            this.mevAvailableLabel = new JLabel("Available");
            this.mevSelectedLabel = new JLabel("Selected");
            this.mevAvailableList = new JList(new DefaultListModel());
            this.mevAvailableList.setCellRenderer(new ListRenderer());
            this.mevSelectedList = new JList(new DefaultListModel());
            this.mevSelectedList.setCellRenderer(new ListRenderer());
            this.mevAvailableScrollPane = new JScrollPane(this.mevAvailableList);
            this.mevSelectedScrollPane = new JScrollPane(this.mevSelectedList);
            this.mevAddButton = new JButton("Add");
            this.mevAddButton.setPreferredSize(new Dimension(100, 20));
            this.mevAddButton.addActionListener(new EventHandler());
            this.mevAddAllButton = new JButton("Add All");
            this.mevAddAllButton.setPreferredSize(new Dimension(100, 20));
            this.mevAddAllButton.addActionListener(new EventHandler());
            this.mevRemoveButton = new JButton("Remove");
            this.mevRemoveButton.setPreferredSize(new Dimension(100, 20));
            this.mevRemoveButton.addActionListener(new EventHandler());
            this.mevRemoveAllButton = new JButton("Remove All");
            this.mevRemoveAllButton.setPreferredSize(new Dimension(100, 20));
            this.mevRemoveAllButton.addActionListener(new EventHandler());
            this.mevButtonPanel = new JPanel();
            this.mevButtonPanel.setLayout(new GridBagLayout());
            MevFileLoader.this.gba.add(this.mevButtonPanel, this.mevAddButton, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            MevFileLoader.this.gba.add(this.mevButtonPanel, this.mevAddAllButton, 0, 1, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            MevFileLoader.this.gba.add(this.mevButtonPanel, this.mevRemoveButton, 0, 2, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            MevFileLoader.this.gba.add(this.mevButtonPanel, this.mevRemoveAllButton, 0, 3, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.loadIButton = new JRadioButton("Load Integrated Spot Intensities", true);
            this.loadIButton.setFocusPainted(false);
            this.loadMedButton = new JRadioButton("Load Median Spot Intensities");
            this.loadMedButton.setFocusPainted(false);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.loadIButton);
            buttonGroup.add(this.loadMedButton);
            this.noAnnFileBox = new JCheckBox("Use Annotation Contained in MeV File (no annotation file)", false);
            this.noAnnFileBox.setFocusPainted(false);
            this.noAnnFileBox.setActionCommand("use-annotation-in-mev-file");
            this.noAnnFileBox.addActionListener(new EventHandler());
            this.saveSpotInfoBox = new JCheckBox("Load Auxiliary Spot Information", false);
            this.saveSpotInfoBox.setFocusPainted(false);
            this.cutQuotesBox = new JCheckBox("Remove Annotation Quotes(\"...\")", false);
            this.cutQuotesBox.setHorizontalAlignment(0);
            this.cutQuotesBox.setFocusPainted(false);
            this.selectionPanel = new JPanel();
            this.selectionPanel.setLayout(new GridBagLayout());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            MevFileLoader.this.gba.add(jPanel, this.loadIButton, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(0, 20, 0, 5), 0, 0);
            MevFileLoader.this.gba.add(jPanel, this.saveSpotInfoBox, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(0, 20, 0, 5), 0, 0);
            MevFileLoader.this.gba.add(jPanel, this.loadMedButton, 0, 1, 1, 1, 1, 0, 2, 10, new Insets(0, 20, 0, 5), 0, 0);
            MevFileLoader.this.gba.add(jPanel, this.noAnnFileBox, 1, 1, 1, 1, 1, 0, 2, 10, new Insets(0, 20, 0, 5), 0, 0);
            MevFileLoader.this.gba.add(jPanel, this.cutQuotesBox, 0, 2, 2, 1, 1, 0, 2, 13, new Insets(0, 118, 0, 5), 0, 0);
            this.mevListPanel = new JPanel();
            this.mevListPanel.setLayout(new GridBagLayout());
            MevFileLoader.this.gba.add(this.mevListPanel, this.mevAvailableLabel, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            MevFileLoader.this.gba.add(this.mevListPanel, this.mevAvailableScrollPane, 0, 1, 1, 4, 5, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            MevFileLoader.this.gba.add(this.mevListPanel, new JPanel(), 1, 0, 1, 1, 0, 0, 1, 10, new Insets(0, 0, 0, 0), 0, 0);
            MevFileLoader.this.gba.add(this.mevListPanel, this.mevButtonPanel, 1, 1, 1, 4, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            MevFileLoader.this.gba.add(this.mevListPanel, this.mevSelectedLabel, 2, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            MevFileLoader.this.gba.add(this.mevListPanel, this.mevSelectedScrollPane, 2, 1, 1, 4, 5, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            MevFileLoader.this.gba.add(this.mevSelectionPanel, jPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            MevFileLoader.this.gba.add(this.mevSelectionPanel, this.mevListPanel, 0, 1, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            MevFileLoader.this.gba.add(this.selectionPanel, this.pathTextField, 0, 0, 2, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
            MevFileLoader.this.gba.add(this.selectionPanel, this.mevSelectionPanel, 0, 1, 2, 2, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.annSelectionPanel = new JPanel();
            this.annSelectionPanel.setLayout(new GridBagLayout());
            this.annSelectionPanel.setBorder(new TitledBorder(new EtchedBorder(), MevFileLoader.this.getAnnotationFileFilter().getDescription()));
            this.annAvailableLabel = new JLabel("Available");
            this.annSelectedLabel = new JLabel("Selected");
            this.annAvailableList = new JList(new DefaultListModel());
            this.annAvailableList.setCellRenderer(new ListRenderer());
            this.annSelectedList = new JList(new DefaultListModel());
            this.annSelectedList.setCellRenderer(new ListRenderer());
            this.annAvailableScrollPane = new JScrollPane(this.annAvailableList);
            this.annSelectedScrollPane = new JScrollPane(this.annSelectedList);
            this.annAddButton = new JButton("Add");
            this.annAddButton.addActionListener(new EventHandler());
            this.annAddAllButton = new JButton("Add All");
            this.annAddAllButton.addActionListener(new EventHandler());
            this.annRemoveButton = new JButton("Remove");
            this.annRemoveButton.addActionListener(new EventHandler());
            this.annRemoveAllButton = new JButton("Remove All");
            this.annRemoveAllButton.addActionListener(new EventHandler());
            Dimension dimension = new Dimension(100, 20);
            Dimension dimension2 = this.annRemoveAllButton.getPreferredSize();
            this.annAddButton.setPreferredSize(dimension);
            this.annAddAllButton.setPreferredSize(dimension);
            this.annRemoveButton.setPreferredSize(dimension);
            this.annRemoveAllButton.setPreferredSize(dimension);
            this.mevAddAllButton.setFocusPainted(false);
            this.mevAddButton.setFocusPainted(false);
            this.mevRemoveAllButton.setFocusPainted(false);
            this.mevRemoveButton.setFocusPainted(false);
            this.annAddAllButton.setFocusPainted(false);
            this.annAddButton.setFocusPainted(false);
            this.annRemoveAllButton.setFocusPainted(false);
            this.annRemoveButton.setFocusPainted(false);
            this.annButtonPanel = new JPanel();
            this.annButtonPanel.setLayout(new GridBagLayout());
            MevFileLoader.this.gba.add(this.annButtonPanel, this.annAddButton, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            MevFileLoader.this.gba.add(this.annButtonPanel, this.annAddAllButton, 0, 1, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            MevFileLoader.this.gba.add(this.annButtonPanel, this.annRemoveButton, 0, 2, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            MevFileLoader.this.gba.add(this.annButtonPanel, this.annRemoveAllButton, 0, 3, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.annListPanel = new JPanel();
            this.annListPanel.setLayout(new GridBagLayout());
            MevFileLoader.this.gba.add(this.annListPanel, this.annAvailableLabel, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            MevFileLoader.this.gba.add(this.annListPanel, this.annSelectedLabel, 2, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
            MevFileLoader.this.gba.add(this.annListPanel, this.annAvailableScrollPane, 0, 1, 1, 4, 5, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            MevFileLoader.this.gba.add(this.annListPanel, new JPanel(), 1, 0, 1, 1, 0, 0, 1, 10, new Insets(0, 0, 0, 0), 0, 0);
            MevFileLoader.this.gba.add(this.annListPanel, this.annButtonPanel, 1, 1, 1, 4, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            MevFileLoader.this.gba.add(this.annListPanel, this.annSelectedScrollPane, 2, 1, 1, 4, 5, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.annFieldsTextField = new JTextField();
            this.annFieldsTextField.setEditable(false);
            this.annFieldsTextField.setBorder(new TitledBorder(new EtchedBorder(), "Annotation Fields"));
            this.annFieldsTextField.setForeground(Color.black);
            this.annFieldsTextField.setFont(new Font("serif", 1, 12));
            MevFileLoader.this.gba.add(this.annSelectionPanel, this.annListPanel, 0, 0, 1, 2, 1, 1, 1, 10, new Insets(5, 5, 0, 5), 0, 0);
            MevFileLoader.this.gba.add(this.annSelectionPanel, this.annFieldsTextField, 0, 2, 1, 1, 1, 0, 2, 10, new Insets(0, 5, 0, 5), 0, 0);
            MevFileLoader.this.gba.add(this.selectionPanel, this.annSelectionPanel, 0, 3, 2, 2, 1, 1, 1, 10, new Insets(0, 5, 0, 5), 0, 0);
            this.splitPane = new JSplitPane(1, this.fileTreePane, this.selectionPanel);
            this.fileLoaderPanel = new JPanel();
            this.fileLoaderPanel.setLayout(new GridBagLayout());
            MevFileLoader.this.gba.add(this.fileLoaderPanel, this.splitPane, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            MevFileLoader.this.gba.add(this, this.fileLoaderPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
            this.splitPane.setDividerLocation(0.6);
        }

        public void setPath(String string) {
            this.pathTextField.setText(string);
        }

        public void openDataPath() {
            this.fileTreePane.openDataPath();
        }

        public void validateLists() {
            if (((DefaultListModel)this.mevSelectedList.getModel()).size() > 0) {
                MevFileLoader.this.markLoadEnabled(true);
            } else {
                MevFileLoader.this.markLoadEnabled(false);
            }
        }

        public void onMevAdd() {
            int n;
            int[] nArray = this.mevAvailableList.getSelectedIndices();
            Object[] objectArray = new Object[nArray.length];
            for (n = nArray.length - 1; n >= 0; --n) {
                Object e = ((DefaultListModel)this.mevAvailableList.getModel()).getElementAt(nArray[n]);
                objectArray[n] = e;
            }
            for (n = 0; n < nArray.length; ++n) {
                ((DefaultListModel)this.mevSelectedList.getModel()).addElement(objectArray[n]);
            }
            this.validateLists();
        }

        public void onMevAddAll() {
            int n = ((DefaultListModel)this.mevAvailableList.getModel()).size();
            for (int i = 0; i < n; ++i) {
                Object e = ((DefaultListModel)this.mevAvailableList.getModel()).getElementAt(i);
                ((DefaultListModel)this.mevSelectedList.getModel()).addElement(e);
            }
            this.validateLists();
        }

        public void onMevRemove() {
            int[] nArray = this.mevSelectedList.getSelectedIndices();
            for (int i = nArray.length - 1; i >= 0; --i) {
                ((DefaultListModel)this.mevSelectedList.getModel()).remove(nArray[i]);
            }
            this.validateLists();
        }

        public void onMevRemoveAll() {
            ((DefaultListModel)this.mevSelectedList.getModel()).removeAllElements();
            this.validateLists();
        }

        public void onAnnAdd() {
            int n;
            int[] nArray = this.annAvailableList.getSelectedIndices();
            Object[] objectArray = new Object[nArray.length];
            for (n = nArray.length - 1; n >= 0; --n) {
                Object e = ((DefaultListModel)this.annAvailableList.getModel()).getElementAt(nArray[n]);
                objectArray[n] = e;
            }
            for (n = 0; n < nArray.length; ++n) {
                ((DefaultListModel)this.annSelectedList.getModel()).addElement(objectArray[n]);
            }
            this.validateLists();
            this.updateAnnFieldTextField();
        }

        public void onAnnAddAll() {
            int n = ((DefaultListModel)this.annAvailableList.getModel()).size();
            for (int i = 0; i < n; ++i) {
                Object e = ((DefaultListModel)this.annAvailableList.getModel()).getElementAt(i);
                ((DefaultListModel)this.annSelectedList.getModel()).addElement(e);
            }
            this.validateLists();
            this.updateAnnFieldTextField();
        }

        public void onAnnRemove() {
            int[] nArray = this.annSelectedList.getSelectedIndices();
            for (int i = nArray.length - 1; i >= 0; --i) {
                ((DefaultListModel)this.annSelectedList.getModel()).remove(nArray[i]);
            }
            this.validateLists();
            this.updateAnnFieldTextField();
        }

        public void onAnnRemoveAll() {
            ((DefaultListModel)this.annSelectedList.getModel()).removeAllElements();
            this.validateLists();
            this.updateAnnFieldTextField();
        }

        public void updateAnnFieldTextField() {
            DefaultListModel defaultListModel = (DefaultListModel)this.annSelectedList.getModel();
            AnnFileParser annFileParser = new AnnFileParser();
            String string = "";
            for (int i = 0; i < defaultListModel.getSize(); ++i) {
                File file = (File)defaultListModel.get(i);
                annFileParser.loadFile(file);
                if (!annFileParser.isAnnFileLoaded()) continue;
                Vector vector = annFileParser.getColumnHeaders();
                if (i > 0 && vector.size() > 3) {
                    string = string + ", ";
                }
                for (int j = 3; j < vector.size() - 1; ++j) {
                    string = string + (String)vector.elementAt(j) + ", ";
                }
                string = string + (String)vector.elementAt(vector.size() - 1);
            }
            this.annFieldsTextField.setText(string);
        }

        public void onUseMevAnn() {
            if (this.noAnnFileBox.isSelected()) {
                this.enableAnnotationPanel(false);
            } else {
                this.enableAnnotationPanel(true);
            }
        }

        public void enableAnnotationPanel(boolean bl) {
            this.annAddAllButton.setEnabled(bl);
            this.annAddButton.setEnabled(bl);
            this.annRemoveAllButton.setEnabled(bl);
            this.annRemoveButton.setEnabled(bl);
            this.annAvailableLabel.setEnabled(bl);
            this.annSelectedLabel.setEnabled(bl);
            this.annAvailableList.setEnabled(bl);
            this.annSelectedList.setEnabled(bl);
            this.annFieldsTextField.setEnabled(bl);
            if (!bl) {
                this.annAvailableList.setBackground(Color.lightGray);
                this.annSelectedList.setBackground(Color.lightGray);
            } else {
                this.annAvailableList.setBackground(Color.white);
                this.annSelectedList.setBackground(Color.white);
            }
        }

        public DefaultListModel getMevAvailableListModel() {
            return (DefaultListModel)this.mevAvailableList.getModel();
        }

        public DefaultListModel getAnnAvailableListModel() {
            return (DefaultListModel)this.annAvailableList.getModel();
        }

        public DefaultListModel getMevSelectedListModel() {
            return (DefaultListModel)this.mevSelectedList.getModel();
        }

        public DefaultListModel getAnnSelectedListModel() {
            return (DefaultListModel)this.annSelectedList.getModel();
        }

        private class FileTreePaneEventHandler
        implements FileTreePaneListener {
            private FileTreePaneEventHandler() {
            }

            public void nodeSelected(FileTreePaneEvent fileTreePaneEvent) {
                String string = (String)fileTreePaneEvent.getValue("Path");
                Vector vector = (Vector)fileTreePaneEvent.getValue("Filenames");
                MevFileLoader.this.processFileList(string, vector);
            }

            public void nodeCollapsed(FileTreePaneEvent fileTreePaneEvent) {
            }

            public void nodeExpanded(FileTreePaneEvent fileTreePaneEvent) {
            }
        }

        private class EventHandler
        implements ActionListener {
            private EventHandler() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object == MevFileLoaderPanel.this.mevAddButton) {
                    MevFileLoaderPanel.this.onMevAdd();
                } else if (object == MevFileLoaderPanel.this.mevAddAllButton) {
                    MevFileLoaderPanel.this.onMevAddAll();
                } else if (object == MevFileLoaderPanel.this.mevRemoveButton) {
                    MevFileLoaderPanel.this.onMevRemove();
                } else if (object == MevFileLoaderPanel.this.mevRemoveAllButton) {
                    MevFileLoaderPanel.this.onMevRemoveAll();
                } else if (object == MevFileLoaderPanel.this.annAddButton) {
                    MevFileLoaderPanel.this.onAnnAdd();
                } else if (object == MevFileLoaderPanel.this.annAddAllButton) {
                    MevFileLoaderPanel.this.onAnnAddAll();
                } else if (object == MevFileLoaderPanel.this.annRemoveButton) {
                    MevFileLoaderPanel.this.onAnnRemove();
                } else if (object == MevFileLoaderPanel.this.annRemoveAllButton) {
                    MevFileLoaderPanel.this.onAnnRemoveAll();
                } else if (object == MevFileLoaderPanel.this.noAnnFileBox) {
                    MevFileLoaderPanel.this.onUseMevAnn();
                }
            }
        }

        private class ListRenderer
        extends DefaultListCellRenderer {
            private ListRenderer() {
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                File file = (File)object;
                this.setText(file.getName());
                return this;
            }
        }
    }
}

