/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.clusterUtil.submit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tigr.microarray.mev.cluster.clusterUtil.submit.RepositoryConfigParser;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class ClusterArchiveSelectionDialog
extends AlgorithmDialog {
    private RepositoryConfigParser parser;
    private RepositoryPane repPane;
    int result = 2;

    public ClusterArchiveSelectionDialog(RepositoryConfigParser repositoryConfigParser) {
        super(new JFrame(), "Cluster Archive Selection Dialog", true);
        this.parser = repositoryConfigParser;
        this.okButton.setText("Submit");
        this.okButton.setEnabled(false);
        this.validate();
        this.repPane = new RepositoryPane();
        this.addContent(this.repPane);
        this.setActionListeners((ActionListener)((Object)new Listener()));
    }

    public ClusterArchiveSelectionDialog() {
        super(new JFrame(), "Cluster Archive Selection Dialog", true);
        JPanel jPanel = new JPanel();
        this.repPane = new RepositoryPane();
        jPanel.add(this.repPane);
        this.pack();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(dimension.width / 2, (int)((double)dimension.height / 1.6));
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    private void resetControls() {
        this.repPane.setSelectedIndex(0);
    }

    public String getSelectedRepositoryName() {
        return this.repPane.getSelectedRepositoryName();
    }

    private JPanel constructIntroPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        JTextPane jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setMargin(new Insets(10, 15, 10, 15));
        jTextPane.setContentType("text/html");
        String string = new String();
        string = string + "<html><h2>External Cluster Repository Submission</h2><hr size=3>";
        string = string + "Welcome to MeV's cluster submission process.  Select a repository using the ";
        string = string + "tabbed panes in this dialog. ";
        string = string + "Information on each page will indicate the suitability of a repository for your gene list. ";
        string = string + "After selection of a repository, hit submit to be lead through the submission process. ";
        string = string + "<br><br>";
        string = string + "For first time submissions it might be required to register at the repostitory web site and ";
        string = string + "to use the user name and password during the cluster submission (See manual for details)</html>";
        jTextPane.setText(string);
        jPanel.add((Component)jTextPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private class Listener
    extends DialogListener
    implements ChangeListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                ClusterArchiveSelectionDialog.this.result = 0;
                ClusterArchiveSelectionDialog.this.dispose();
            } else if (string.equals("cancel-command")) {
                ClusterArchiveSelectionDialog.this.result = 2;
                ClusterArchiveSelectionDialog.this.dispose();
            } else {
                if (string.equals("reset-command")) {
                    ClusterArchiveSelectionDialog.this.resetControls();
                    ClusterArchiveSelectionDialog.this.result = 2;
                    return;
                }
                if (string.equals("info-command")) {
                    HelpWindow helpWindow = new HelpWindow((JDialog)((Object)ClusterArchiveSelectionDialog.this), "Cluster Archive Submission");
                    ClusterArchiveSelectionDialog.this.result = 2;
                    if (helpWindow.getWindowContent()) {
                        helpWindow.setSize(450, 600);
                        helpWindow.setLocation();
                        helpWindow.show();
                        return;
                    }
                    helpWindow.setVisible(false);
                    helpWindow.dispose();
                    return;
                }
            }
            ClusterArchiveSelectionDialog.this.dispose();
        }

        public void windowClosing(WindowEvent windowEvent) {
            ClusterArchiveSelectionDialog.this.result = -1;
            ClusterArchiveSelectionDialog.this.dispose();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ClusterArchiveSelectionDialog.this.okButton.setEnabled(ClusterArchiveSelectionDialog.this.repPane.getSelectedIndex() != 0);
        }
    }

    private class RepositoryPanel
    extends JPanel {
        private String repositoryName;

        public RepositoryPanel(String string) {
            super(new GridBagLayout());
            this.repositoryName = string;
            this.constructContent(string);
        }

        private void constructContent(String string) {
            String string2 = ClusterArchiveSelectionDialog.this.parser.getRepositoryPage(string);
            JTextPane jTextPane = new JTextPane();
            jTextPane.setEditable(false);
            jTextPane.setMargin(new Insets(10, 15, 10, 15));
            jTextPane.setContentType("text/html");
            jTextPane.setText(string2);
            JScrollPane jScrollPane = new JScrollPane(jTextPane);
            this.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            jTextPane.setCaretPosition(0);
        }
    }

    private class RepositoryPane
    extends JTabbedPane {
        String[] repNames;

        public RepositoryPane() {
            this.addTab("Introduction", ClusterArchiveSelectionDialog.this.constructIntroPanel());
            this.addChangeListener(new Listener());
            this.repNames = ClusterArchiveSelectionDialog.this.parser.getRepositoryNames();
            for (int i = 0; i < this.repNames.length; ++i) {
                this.addTab(this.repNames[i], new RepositoryPanel(this.repNames[i]));
            }
        }

        public String getSelectedRepositoryName() {
            return this.getTitleAt(this.getSelectedIndex());
        }
    }
}

