/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.clusterUtil;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class ListImportDialog
extends AlgorithmDialog {
    private Vector annFields = new Vector();
    private JComboBox listBox;
    private JTextPane pane;
    private int result = 2;

    public ListImportDialog(String[] stringArray, boolean bl) {
        super(new JFrame(), bl ? "Gene List Import Dialog" : "Sample List Import Dialog", true);
        for (int i = 0; i < stringArray.length; ++i) {
            this.annFields.addElement(stringArray[i]);
        }
        ParameterPanel parameterPanel = bl ? new ParameterPanel("Gene List Import Parameters") : new ParameterPanel("Sample List Import Parameters");
        parameterPanel.setLayout((LayoutManager)new GridBagLayout());
        JLabel jLabel = bl ? new JLabel("Gene ID Type:") : new JLabel("Sample ID Type:");
        this.listBox = new JComboBox(this.annFields);
        if (this.annFields.size() > 0) {
            this.listBox.setSelectedIndex(0);
        }
        JLabel jLabel2 = new JLabel("Paste List (ctrl-v):");
        this.pane = new JTextPane();
        this.pane.setPreferredSize(new Dimension(125, 200));
        JScrollPane jScrollPane = new JScrollPane(this.pane);
        jScrollPane.getViewport().setViewSize(new Dimension(125, 200));
        jScrollPane.setBorder(BorderFactory.createLineBorder(Color.black, 2));
        parameterPanel.add((Component)jLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(10, 0, 0, 20), 0, 0));
        parameterPanel.add((Component)this.listBox, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        parameterPanel.add((Component)jLabel2, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(20, 0, 0, 20), 0, 0));
        parameterPanel.add((Component)jScrollPane, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(20, 0, 10, 0), 0, 0));
        this.addContent((Component)parameterPanel);
        this.setActionListeners((ActionListener)((Object)new Listener()));
        this.pack();
    }

    public ListImportDialog(Frame frame, String[] stringArray, boolean bl) {
        super(frame, bl ? "Gene List Import Dialog" : "Sample List Import Dialog", true);
        for (int i = 0; i < stringArray.length; ++i) {
            this.annFields.addElement(stringArray[i]);
        }
        ParameterPanel parameterPanel = bl ? new ParameterPanel("Gene List Import Parameters") : new ParameterPanel("Sample List Import Parameters");
        parameterPanel.setLayout((LayoutManager)new GridBagLayout());
        JLabel jLabel = bl ? new JLabel("Gene ID Type:") : new JLabel("Sample ID Type:");
        this.listBox = new JComboBox(this.annFields);
        if (this.annFields.size() > 0) {
            this.listBox.setSelectedIndex(0);
        }
        JLabel jLabel2 = new JLabel("Paste List (ctrl-v):");
        this.pane = new JTextPane();
        this.pane.setPreferredSize(new Dimension(125, 200));
        JScrollPane jScrollPane = new JScrollPane(this.pane);
        jScrollPane.getViewport().setViewSize(new Dimension(125, 200));
        jScrollPane.setBorder(BorderFactory.createLineBorder(Color.black, 2));
        parameterPanel.add((Component)jLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(10, 0, 0, 20), 0, 0));
        parameterPanel.add((Component)this.listBox, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        parameterPanel.add((Component)jLabel2, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(20, 0, 0, 20), 0, 0));
        parameterPanel.add((Component)jScrollPane, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(20, 0, 10, 0), 0, 0));
        this.addContent((Component)parameterPanel);
        this.setActionListeners((ActionListener)((Object)new Listener()));
        this.pack();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    private void resetControls() {
        this.listBox.setSelectedIndex(0);
        this.pane.setText("");
    }

    public String getFieldName() {
        return (String)this.listBox.getSelectedItem();
    }

    public String[] getList() {
        String string = this.pane.getText();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken().trim();
            ++n;
        }
        return stringArray;
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                ListImportDialog.this.result = 0;
                ListImportDialog.this.dispose();
            } else if (string.equals("cancel-command")) {
                ListImportDialog.this.result = 2;
                ListImportDialog.this.dispose();
            } else {
                if (string.equals("reset-command")) {
                    ListImportDialog.this.resetControls();
                    ListImportDialog.this.result = 2;
                    return;
                }
                if (string.equals("info-command")) {
                    HelpWindow helpWindow = new HelpWindow((JDialog)((Object)ListImportDialog.this), "List Import Dialog");
                    ListImportDialog.this.result = 2;
                    if (helpWindow.getWindowContent()) {
                        helpWindow.setSize(450, 600);
                        helpWindow.setLocation();
                        helpWindow.show();
                        return;
                    }
                    helpWindow.setVisible(false);
                    helpWindow.dispose();
                    return;
                }
            }
            ListImportDialog.this.dispose();
        }

        public void windowClosing(WindowEvent windowEvent) {
            ListImportDialog.this.result = 2;
            ListImportDialog.this.dispose();
        }
    }
}

