/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;

public class Thumbnail
extends JFrame {
    private Canvas canvas;

    public Thumbnail(IFramework iFramework, WindowListener windowListener) {
        super("Thumbnail");
        this.addWindowListener(windowListener);
        Listener listener = new Listener();
        this.canvas = this.createCanvas(iFramework, listener);
        this.getContentPane().add((Component)this.canvas, "Center");
        this.setSize(100, 200);
    }

    public void onDataChanged(IData iData) {
        this.canvas.onDataChanged(iData);
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
        this.canvas.onMenuChanged(iDisplayMenu);
    }

    private Canvas createCanvas(IFramework iFramework, MouseListener mouseListener) {
        Canvas canvas = new Canvas(iFramework);
        canvas.setBackground(Color.white);
        canvas.addMouseListener(mouseListener);
        return canvas;
    }

    private class Listener
    extends MouseAdapter {
        private Listener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Thumbnail.this.canvas.setContentPosition(mouseEvent.getY());
        }
    }

    private class Canvas
    extends JPanel {
        private IFramework framework;
        private IData data;
        private int elementHeight = 5;
        private float maxRatio;
        private float minRatio;

        public Canvas(IFramework iFramework) {
            this.framework = iFramework;
            this.data = iFramework.getData();
            this.maxRatio = iFramework.getDisplayMenu().getMaxRatioScale();
            this.minRatio = iFramework.getDisplayMenu().getMinRatioScale();
        }

        public void onDataChanged(IData iData) {
            this.data = iData;
            this.repaint();
        }

        public void onMenuChanged(IDisplayMenu iDisplayMenu) {
            this.elementHeight = iDisplayMenu.getElementSize().height;
            this.maxRatio = iDisplayMenu.getMaxRatioScale();
            this.minRatio = iDisplayMenu.getMinRatioScale();
            this.repaint();
        }

        private void setContentPosition(int n) {
            this.framework.setContentLocation(0, this.elementHeight * this.data.getFeaturesSize() * n / this.getHeight());
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            int n = this.data.getFeaturesCount();
            int n2 = this.data.getFeaturesSize();
            float f = (float)this.getWidth() / (float)n;
            float f2 = (float)this.getHeight() / (float)n2;
            int n3 = (int)f2 > 0 ? (int)f2 : 1;
            for (int i = 0; i < n; ++i) {
                int[] nArray = this.data.getSortedIndices(i);
                for (int j = 0; j < n2; ++j) {
                    int n4 = Math.round(f * (float)i);
                    int n5 = Math.round(f2 * (float)j);
                    float f3 = this.data.getRatio(i, nArray[j], 1);
                    this.drawElement(graphics, n4, n5, Math.round(f), n3, f3);
                }
            }
        }

        private void drawElement(Graphics graphics, int n, int n2, int n3, int n4, float f) {
            Color color;
            if (f > 0.0f) {
                f = (f = Math.abs(f / this.maxRatio)) > 1.0f ? 1.0f : f;
                color = new Color(f, 0.0f, 0.0f);
            } else if (f < 0.0f) {
                f = (f = Math.abs(f / this.minRatio)) > 1.0f ? 1.0f : f;
                color = new Color(0.0f, f, 0.0f);
            } else {
                color = new Color(128, 128, 128);
            }
            graphics.setColor(color);
            graphics.fillRect(n, n2, n3, n4);
        }
    }
}

