/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.util.StringTokenizer;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmFactory;
import org.tigr.remote.RemoteAlgorithm;
import org.tigr.remote.communication.CommunicatorFactory;
import org.tigr.util.ConfMap;

public class TMEVAlgorithmFactory
implements AlgorithmFactory {
    private ConfMap cfg;
    private AlgorithmFactory localFactory;
    private boolean isRemoteEnabled = false;

    public TMEVAlgorithmFactory(ConfMap confMap) {
        this.cfg = confMap;
        String string = confMap.getString("algorithm.factory.class");
        if (string != null && !string.equals("null")) {
            try {
                Class<?> clazz = Class.forName(string);
                this.localFactory = (AlgorithmFactory)clazz.newInstance();
            }
            catch (Exception exception) {
                System.out.println("Local factory not available, check the 'algorithm.factory.class' key in cfg file.");
                exception.printStackTrace();
            }
        } else {
            System.out.println("Local factory not available, check the 'algorithm.factory.class' key in cfg file.");
        }
        try {
            CommunicatorFactory.init(confMap);
            this.isRemoteEnabled = true;
        }
        catch (Exception exception) {
            System.out.println("Failed to configure remote execution.");
            exception.printStackTrace();
        }
    }

    public Algorithm getAlgorithm(String string) throws AlgorithmException {
        if (string == null) {
            throw new AlgorithmException("Algorithm name expected.");
        }
        if (this.isRemote(string)) {
            if (this.isRemoteEnabled) {
                return new RemoteAlgorithm(string);
            }
            throw new AlgorithmException("Remote execution not available.");
        }
        if (this.localFactory == null) {
            throw new AlgorithmException("Local execution not available.");
        }
        return this.localFactory.getAlgorithm(string);
    }

    private boolean isRemote(String string) {
        String string2 = this.cfg.getString("algorithm.remote");
        if (string2 == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!string3.trim().toUpperCase().equals(string.toUpperCase())) continue;
            return true;
        }
        return false;
    }
}

