/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.tigr.util.awt.GBA;

public class SetUpperLimitsDialog
extends JDialog {
    private int result;
    private JTextField cy3TextField;
    private JTextField cy5TextField;

    public SetUpperLimitsDialog(JFrame jFrame, float f, float f2) {
        super(jFrame, "Set Upper Thresholds", true);
        EventListener eventListener = new EventListener();
        JLabel jLabel = new JLabel("Max Cy3 (" + f + "): ");
        jLabel.addKeyListener(eventListener);
        this.cy3TextField = new JTextField(10);
        this.cy3TextField.addKeyListener(eventListener);
        this.cy3TextField.setText("" + f);
        JLabel jLabel2 = new JLabel("Max Cy5 (" + f2 + "): ");
        jLabel2.addKeyListener(eventListener);
        this.cy5TextField = new JTextField(10);
        this.cy5TextField.addKeyListener(eventListener);
        this.cy5TextField.setText("" + f2);
        JButton jButton = new JButton("Ok");
        jButton.setActionCommand("ok-command");
        jButton.addActionListener(eventListener);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setActionCommand("cancel-command");
        jButton2.addActionListener(eventListener);
        this.getContentPane().setLayout(new GridBagLayout());
        GBA gBA = new GBA();
        gBA.add(this.getContentPane(), (Component)jLabel, 0, 0, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        gBA.add(this.getContentPane(), (Component)this.cy3TextField, 1, 0, 1, 1, 1, 1, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        gBA.add(this.getContentPane(), (Component)jLabel2, 0, 1, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        gBA.add(this.getContentPane(), (Component)this.cy5TextField, 1, 1, 1, 1, 1, 1, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        gBA.add(this.getContentPane(), (Component)jButton2, 0, 2, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        gBA.add(this.getContentPane(), (Component)jButton, 1, 2, 1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.addWindowListener(eventListener);
        this.pack();
        this.setResizable(false);
        this.cy3TextField.grabFocus();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public float getUpperCY3() {
        return Float.parseFloat(this.cy3TextField.getText());
    }

    public float getUpperCY5() {
        return Float.parseFloat(this.cy5TextField.getText());
    }

    private class EventListener
    extends WindowAdapter
    implements ActionListener,
    KeyListener {
        private EventListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                try {
                    Float.parseFloat(SetUpperLimitsDialog.this.cy3TextField.getText());
                    Float.parseFloat(SetUpperLimitsDialog.this.cy5TextField.getText());
                    SetUpperLimitsDialog.this.result = 0;
                }
                catch (Exception exception) {
                    SetUpperLimitsDialog.this.result = 2;
                }
                SetUpperLimitsDialog.this.dispose();
            } else if (string.equals("cancel-command")) {
                SetUpperLimitsDialog.this.result = 2;
                SetUpperLimitsDialog.this.dispose();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            SetUpperLimitsDialog.this.result = -1;
            SetUpperLimitsDialog.this.dispose();
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                try {
                    Float.parseFloat(SetUpperLimitsDialog.this.cy3TextField.getText());
                    Float.parseFloat(SetUpperLimitsDialog.this.cy5TextField.getText());
                    SetUpperLimitsDialog.this.result = 0;
                }
                catch (Exception exception) {
                    SetUpperLimitsDialog.this.result = 2;
                }
                SetUpperLimitsDialog.this.dispose();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

