/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.util.awt.GBA;

public class SetLowerCutoffsDialog
extends AlgorithmDialog {
    private int result;
    private float originalCy3;
    private float originalCy5;
    private JTextField cy3TextField;
    private JTextField cy5TextField;
    private JCheckBox enableCheckBox;
    private JLabel cy3Label;
    private JLabel cy5Label;

    public SetLowerCutoffsDialog(JFrame jFrame, float f, float f2) {
        super(jFrame, "Set Lower Cutoffs", true);
        this.originalCy3 = f;
        this.originalCy5 = f2;
        Listener listener = new Listener();
        GBA gBA = new GBA();
        this.enableCheckBox = new JCheckBox("Enable Lower Cutoff Filter", true);
        this.enableCheckBox.setActionCommand("enable-check-box-command");
        this.enableCheckBox.setOpaque(false);
        this.enableCheckBox.setFocusPainted(false);
        this.enableCheckBox.addActionListener(listener);
        this.cy3Label = new JLabel("Cy3 Lower Cutoff (" + f + "): ");
        this.cy3Label.setHorizontalAlignment(4);
        this.cy3TextField = new JTextField(10);
        this.cy3TextField.addKeyListener(listener);
        this.cy3TextField.setText("" + f);
        this.cy5Label = new JLabel("Cy5 Lower Cutoff (" + f2 + "): ");
        this.cy5TextField = new JTextField(10);
        this.cy5TextField.addKeyListener(listener);
        this.cy5TextField.setText("" + f2);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.white);
        jPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        gBA.add((Container)jPanel, (Component)this.enableCheckBox, 0, 0, 2, 1, 0, 0, 1, 10, new Insets(20, 0, 0, 0), 0, 0);
        gBA.add((Container)jPanel, (Component)this.cy3Label, 0, 1, 1, 1, 0, 0, 2, 13, new Insets(15, 5, 5, 5), 0, 0);
        gBA.add((Container)jPanel, (Component)this.cy3TextField, 1, 1, 1, 1, 0, 0, 0, 17, new Insets(15, 5, 5, 5), 0, 0);
        gBA.add((Container)jPanel, (Component)this.cy5Label, 0, 2, 1, 1, 0, 0, 2, 13, new Insets(5, 5, 25, 5), 0, 0);
        gBA.add((Container)jPanel, (Component)this.cy5TextField, 1, 2, 2, 1, 0, 0, 0, 17, new Insets(5, 5, 25, 5), 0, 0);
        this.addContent(jPanel);
        this.setActionListeners(listener);
        this.addWindowListener(listener);
        this.pack();
        this.setResizable(false);
        this.cy3TextField.grabFocus();
        this.cy3TextField.setCaretPosition(0);
        this.cy3TextField.selectAll();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public boolean isLowerCutoffEnabled() {
        return this.enableCheckBox.isSelected();
    }

    public float getLowerCY3Cutoff() {
        return Float.parseFloat(this.cy3TextField.getText());
    }

    public float getLowerCY5Cutoff() {
        return Float.parseFloat(this.cy5TextField.getText());
    }

    public static void main(String[] stringArray) {
        SetLowerCutoffsDialog setLowerCutoffsDialog = new SetLowerCutoffsDialog(new JFrame(), 0.0f, 0.0f);
        setLowerCutoffsDialog.showModal();
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener,
    KeyListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                this.onOk();
            } else if (string.equals("cancel-command")) {
                SetLowerCutoffsDialog.this.result = 2;
                SetLowerCutoffsDialog.this.dispose();
            } else if (string.equals("reset-command")) {
                SetLowerCutoffsDialog.this.cy5TextField.setText(String.valueOf(SetLowerCutoffsDialog.this.originalCy5));
                SetLowerCutoffsDialog.this.cy3TextField.setText(String.valueOf(SetLowerCutoffsDialog.this.originalCy3));
                SetLowerCutoffsDialog.this.cy3TextField.grabFocus();
                SetLowerCutoffsDialog.this.cy3TextField.setCaretPosition(0);
                SetLowerCutoffsDialog.this.cy3TextField.selectAll();
            } else {
                if (string.equals("info-command")) {
                    HelpWindow helpWindow = new HelpWindow((JDialog)((Object)SetLowerCutoffsDialog.this), "Set Lower Cutoffs");
                    SetLowerCutoffsDialog.this.result = 2;
                    if (helpWindow.getWindowContent()) {
                        helpWindow.setSize(450, 600);
                        helpWindow.setLocation();
                        helpWindow.show();
                        return;
                    }
                    helpWindow.setVisible(false);
                    helpWindow.dispose();
                    return;
                }
                if (string.equals("enable-check-box-command")) {
                    boolean bl = SetLowerCutoffsDialog.this.enableCheckBox.isSelected();
                    SetLowerCutoffsDialog.this.cy3Label.setEnabled(bl);
                    SetLowerCutoffsDialog.this.cy5Label.setEnabled(bl);
                    SetLowerCutoffsDialog.this.cy3TextField.setEnabled(bl);
                    SetLowerCutoffsDialog.this.cy5TextField.setEnabled(bl);
                }
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                this.onOk();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            SetLowerCutoffsDialog.this.result = -1;
            SetLowerCutoffsDialog.this.dispose();
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        private void onOk() {
            try {
                Float.parseFloat(SetLowerCutoffsDialog.this.cy3TextField.getText());
                Float.parseFloat(SetLowerCutoffsDialog.this.cy5TextField.getText());
                SetLowerCutoffsDialog.this.result = 0;
            }
            catch (Exception exception) {
                SetLowerCutoffsDialog.this.result = 2;
            }
            SetLowerCutoffsDialog.this.dispose();
        }
    }
}

