/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class SearchDialog
extends AlgorithmDialog {
    private int result = 2;
    private JPanel controlPanel;
    private JTextField termField;
    private JCheckBox caseSensBox;
    private JCheckBox entireWordBox;
    private JRadioButton geneSearchButton;
    private JRadioButton expSearchButton;
    private FieldsPanel fieldsPanel;
    private FieldsPanel sampleFieldsPanel;

    public SearchDialog(Frame frame, String[] stringArray, String[] stringArray2) {
        super(frame, "Global Search", true);
        Listener listener = new Listener();
        this.controlPanel = new JPanel(new GridBagLayout());
        this.controlPanel.setBackground(Color.white);
        ParameterPanel parameterPanel = new ParameterPanel("Search Mode");
        parameterPanel.setLayout((LayoutManager)new GridBagLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        this.geneSearchButton = new JRadioButton("Gene Search", true);
        this.geneSearchButton.setFocusPainted(false);
        this.geneSearchButton.setBackground(Color.white);
        this.geneSearchButton.setActionCommand("search-mode-change");
        this.geneSearchButton.addActionListener((ActionListener)((Object)listener));
        buttonGroup.add(this.geneSearchButton);
        this.expSearchButton = new JRadioButton("Sample Search", true);
        this.expSearchButton.setFocusPainted(false);
        this.expSearchButton.setBackground(Color.white);
        this.expSearchButton.setActionCommand("search-mode-change");
        this.expSearchButton.addActionListener((ActionListener)((Object)listener));
        buttonGroup.add(this.expSearchButton);
        parameterPanel.add((Component)this.geneSearchButton, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 0, 25), 0, 0));
        parameterPanel.add((Component)this.expSearchButton, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 40, 0, 0), 0, 0));
        ParameterPanel parameterPanel2 = new ParameterPanel("Search Term");
        parameterPanel2.setLayout((LayoutManager)new GridBagLayout());
        JLabel jLabel = new JLabel("Search Term:");
        jLabel.setOpaque(false);
        this.termField = new JTextField(25);
        this.caseSensBox = new JCheckBox("Case Sensitive", false);
        this.caseSensBox.setOpaque(false);
        this.caseSensBox.setFocusPainted(false);
        this.entireWordBox = new JCheckBox("Exact Match", false);
        this.entireWordBox.setOpaque(false);
        this.entireWordBox.setFocusPainted(false);
        parameterPanel2.add((Component)jLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(5, 20, 0, 0), 0, 0));
        parameterPanel2.add((Component)this.termField, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 10, 0, 20), 0, 0));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        jPanel.add((Component)this.caseSensBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 35), 0, 0));
        jPanel.add((Component)this.entireWordBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 0, 0), 0, 0));
        parameterPanel2.add((Component)jPanel, (Object)new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.fieldsPanel = new FieldsPanel(stringArray);
        this.sampleFieldsPanel = new FieldsPanel(stringArray2);
        this.controlPanel.add((Component)parameterPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.controlPanel.add((Component)parameterPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.controlPanel.add((Component)((Object)this.fieldsPanel), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.addContent(this.controlPanel);
        this.setActionListeners((ActionListener)((Object)listener));
        this.pack();
    }

    public int showModal() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    public Vector getSelectedFields() {
        FieldsPanel fieldsPanel = this.isGeneSearch() ? this.fieldsPanel : this.sampleFieldsPanel;
        Vector<String> vector = new Vector<String>();
        Vector vector2 = fieldsPanel.fieldBoxVector;
        for (int i = 0; i < vector2.size(); ++i) {
            JCheckBox jCheckBox = (JCheckBox)vector2.elementAt(i);
            if (!jCheckBox.isSelected()) continue;
            vector.add(jCheckBox.getText());
        }
        return vector;
    }

    public boolean isGeneSearch() {
        return this.geneSearchButton.isSelected();
    }

    public String getSearchTerm() {
        return this.termField.getText();
    }

    public boolean isCaseSensitive() {
        return this.caseSensBox.isSelected();
    }

    public boolean isWholeTermRequired() {
        return this.entireWordBox.isSelected();
    }

    public AlgorithmData getSearchCriteria() {
        AlgorithmData algorithmData = new AlgorithmData();
        algorithmData.addParam("search-term", this.getSearchTerm());
        algorithmData.addParam("case-sensitive", String.valueOf(this.isCaseSensitive()));
        algorithmData.addParam("full-term", String.valueOf(this.isWholeTermRequired()));
        algorithmData.addParam("gene-search", String.valueOf(this.isGeneSearch()));
        Vector vector = this.getSelectedFields();
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        algorithmData.addStringArray("field-names", stringArray);
        return algorithmData;
    }

    private void resetControls() {
        this.geneSearchButton.setSelected(true);
        this.caseSensBox.setSelected(false);
        this.entireWordBox.setSelected(false);
        for (int i = 0; i < this.fieldsPanel.fieldBoxVector.size(); ++i) {
            ((JCheckBox)this.fieldsPanel.fieldBoxVector.elementAt(i)).setSelected(i == 0);
        }
        this.termField.setText("");
        this.termField.grabFocus();
        this.termField.selectAll();
    }

    private void addBox(JPanel jPanel, Vector vector, String string, int n) {
        JCheckBox jCheckBox = new JCheckBox(string);
        jCheckBox.setOpaque(false);
        jCheckBox.setFocusPainted(false);
        jCheckBox.setSelected(n == 0);
        jPanel.add((Component)jCheckBox, new GridBagConstraints(0, n, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 10, 0, 0), 0, 0));
        vector.addElement(jCheckBox);
    }

    private void setFieldsPanel() {
        if (!this.isGeneSearch()) {
            this.controlPanel.remove((Component)((Object)this.fieldsPanel));
            this.controlPanel.add((Component)((Object)this.sampleFieldsPanel), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.controlPanel.validate();
            this.repaint();
        } else {
            this.controlPanel.remove((Component)((Object)this.sampleFieldsPanel));
            this.controlPanel.add((Component)((Object)this.fieldsPanel), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.controlPanel.validate();
            this.repaint();
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"UID", "TC#", "GenBank", "Locus Link Human gene Identifier this is a long field name", "Unigene", "UID", "TC#", "GenBank"};
        String[] stringArray3 = new String[]{"Default Sample Name", "Strain"};
        SearchDialog searchDialog = new SearchDialog(new Frame(), stringArray2, stringArray3);
        searchDialog.showModal();
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("ok-command")) {
                SearchDialog.this.result = 0;
                SearchDialog.this.dispose();
            } else if (string.equals("cancel-command")) {
                SearchDialog.this.result = 2;
                SearchDialog.this.dispose();
            } else {
                if (string.equals("reset-command")) {
                    SearchDialog.this.resetControls();
                    SearchDialog.this.result = 2;
                    return;
                }
                if (string.equals("info-command")) {
                    HelpWindow helpWindow = new HelpWindow((JDialog)((Object)SearchDialog.this), "Search Dialog");
                    SearchDialog.this.result = 2;
                    if (helpWindow.getWindowContent()) {
                        helpWindow.setSize(450, 600);
                        helpWindow.setLocation();
                        helpWindow.show();
                        return;
                    }
                    helpWindow.setVisible(false);
                    helpWindow.dispose();
                    return;
                }
                if (string.equals("search-mode-change")) {
                    SearchDialog.this.setFieldsPanel();
                    return;
                }
            }
            SearchDialog.this.dispose();
        }

        public void windowClosing(WindowEvent windowEvent) {
            SearchDialog.this.result = -1;
            SearchDialog.this.dispose();
        }
    }

    private class MyCellRenderer
    implements ListCellRenderer {
        private JCheckBox box = new JCheckBox();

        public MyCellRenderer() {
            this.box.setFocusPainted(false);
            this.box.setOpaque(false);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.box.setText((String)object);
            this.box.setSelected(bl);
            return this.box;
        }
    }

    private class FieldsPanel
    extends ParameterPanel {
        JScrollPane scrollPane;
        JList fieldList;
        Vector fieldBoxVector;
        JButton allButton;
        JButton resetSelButton;

        public FieldsPanel(String[] stringArray) {
            super("Searchable Fields");
            super.setLayout((LayoutManager)new GridBagLayout());
            this.setLayout(new GridBagLayout());
            this.allButton = new JButton("Select All Fields");
            this.allButton.setFocusPainted(false);
            this.allButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = 0; i < fieldBoxVector.size(); ++i) {
                        ((JCheckBox)fieldBoxVector.elementAt(i)).setSelected(true);
                    }
                }
            });
            this.resetSelButton = new JButton("Reset Selection");
            this.resetSelButton.setFocusPainted(false);
            this.resetSelButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ FieldsPanel this$1;
                {
                    this.this$1 = fieldsPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = 0; i < this.this$1.fieldBoxVector.size(); ++i) {
                        ((JCheckBox)this.this$1.fieldBoxVector.elementAt(i)).setSelected(i == 0);
                    }
                }
            });
            this.fieldBoxVector = new Vector();
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            jPanel.setBackground(Color.white);
            for (int i = 0; i < stringArray.length; ++i) {
                SearchDialog.this.addBox(jPanel, this.fieldBoxVector, stringArray[i], i);
            }
            this.fieldList = new JList(this.fieldBoxVector);
            this.fieldList.setSelectionMode(2);
            this.fieldList.setVisibleRowCount(5);
            this.fieldList.setCellRenderer(new MyCellRenderer());
            this.scrollPane = new JScrollPane(jPanel);
            this.scrollPane.setPreferredSize(new Dimension(350, Math.min(200, this.fieldBoxVector.size() * 30)));
            this.scrollPane.setSize(350, Math.min(200, this.fieldBoxVector.size() * 30));
            super.add((Component)this.allButton, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 10, 5), 0, 0));
            super.add((Component)this.resetSelButton, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 10, 0), 0, 0));
            JPanel jPanel2 = new JPanel();
            jPanel2.setBackground(Color.red);
            super.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 1, 2, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }
}

