/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import com.sun.media.jai.codec.ImageEncodeParam;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.media.jai.JAI;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.tigr.microarray.file.AnnFileParser;
import org.tigr.microarray.mev.AnalysisFileFilter;
import org.tigr.microarray.mev.AnalysisFileView;
import org.tigr.microarray.mev.AnalysisSaveDialog;
import org.tigr.microarray.mev.ArrayViewer;
import org.tigr.microarray.mev.ExperimentLabelEditor;
import org.tigr.microarray.mev.GeneAnnotationImportDialog;
import org.tigr.microarray.mev.HistoryViewer;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.InformationPanel;
import org.tigr.microarray.mev.Manager;
import org.tigr.microarray.mev.MultipleArrayCanvas;
import org.tigr.microarray.mev.MultipleArrayData;
import org.tigr.microarray.mev.MultipleArrayMenubar;
import org.tigr.microarray.mev.MultipleArrayToolbar;
import org.tigr.microarray.mev.ResultTree;
import org.tigr.microarray.mev.SearchDialog;
import org.tigr.microarray.mev.SearchResultDialog;
import org.tigr.microarray.mev.SetDatabaseDialog;
import org.tigr.microarray.mev.SetDetectionFilterDialog;
import org.tigr.microarray.mev.SetFoldFilterDialog;
import org.tigr.microarray.mev.SetLowerCutoffsDialog;
import org.tigr.microarray.mev.SetPercentageCutoffsDialog;
import org.tigr.microarray.mev.SetRatioScaleDialog;
import org.tigr.microarray.mev.ShowThrowableDialog;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.VarianceFilterDialog;
import org.tigr.microarray.mev.action.ActionManager;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmFactory;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterAttributesDialog;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterTable;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.TextViewer;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HTMLMessageFileChooser;
import org.tigr.microarray.mev.file.AnnFileFilter;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;
import org.tigr.microarray.mev.script.ScriptManager;
import org.tigr.microarray.util.awt.ColorSchemeSelectionDialog;
import org.tigr.microarray.util.awt.SetElementSizeDialog;
import org.tigr.microarray.util.awt.SetSlideFilenameDialog;
import org.tigr.util.FloatMatrix;
import org.tigr.util.swing.BMPFileFilter;
import org.tigr.util.swing.ImageFileFilter;
import org.tigr.util.swing.JPGFileFilter;
import org.tigr.util.swing.PNGFileFilter;
import org.tigr.util.swing.TIFFFileFilter;

public class MultipleArrayViewer
extends ArrayViewer
implements Printable {
    public static final long serialVersionUID = 100010201010001L;
    private MultipleArrayMenubar menubar;
    private MultipleArrayToolbar toolbar;
    private JSplitPane splitPane;
    private JScrollPane viewScrollPane;
    private JLabel statusLabel;
    private JScrollPane treeScrollPane;
    private ResultTree tree;
    private DefaultMutableTreeNode mainViewerNode;
    private DefaultMutableTreeNode clusterNode;
    private DefaultMutableTreeNode analysisNode;
    private DefaultMutableTreeNode scriptNode;
    private DefaultMutableTreeNode historyNode;
    private IViewer viewer;
    private IFramework framework = new FrameworkImpl();
    private MultipleArrayData data = new MultipleArrayData();
    private ActionManager manager;
    private int resultCount = 1;
    private ClusterRepository geneClusterRepository;
    private ClusterRepository experimentClusterRepository;
    private ClusterTable geneClusterManager;
    private ClusterTable experimentClusterManager;
    private ScriptManager scriptManager;
    private HistoryViewer historyLog;
    private File currentAnalysisFile;
    private boolean modifiedResult = false;

    public MultipleArrayViewer() {
        super(new JFrame("TIGR Multiple Array Viewer"));
        EventListener eventListener = new EventListener();
        this.mainframe.addWindowListener(eventListener);
        this.manager = new ActionManager(eventListener, TMEV.getFieldNames(), TMEV.getGUIFactory());
        this.menubar = new MultipleArrayMenubar(this.manager);
        this.mainframe.setJMenuBar(this.menubar);
        this.toolbar = new MultipleArrayToolbar(this.manager);
        this.mainframe.getContentPane().add((Component)this.toolbar, "North");
        this.viewScrollPane = this.createViewScrollPane(eventListener);
        this.viewScrollPane.setBackground(Color.white);
        this.treeScrollPane = this.createTreeScrollPane(eventListener);
        this.splitPane = new JSplitPane(1, this.treeScrollPane, this.viewScrollPane);
        this.splitPane.setOneTouchExpandable(true);
        this.mainframe.getContentPane().add((Component)this.splitPane, "Center");
        this.statusLabel = new JLabel("TIGR MultiExperiment Viewer");
        this.mainframe.getContentPane().add((Component)this.statusLabel, "South");
        this.mainframe.pack();
        this.splitPane.setDividerLocation(0.2);
        this.systemDisable(1001);
        this.systemDisable(1003);
    }

    public MultipleArrayViewer(MultipleArrayData multipleArrayData) {
        super(new JFrame("TIGR Multiple Array Viewer"));
        EventListener eventListener = new EventListener();
        this.mainframe.addWindowListener(eventListener);
        this.manager = new ActionManager(eventListener, multipleArrayData.getFieldNames(), TMEV.getGUIFactory());
        this.data = multipleArrayData;
        this.menubar = new MultipleArrayMenubar(this.manager);
        this.menubar.addLabelMenuItems(multipleArrayData.getFieldNames());
        this.menubar.addExperimentLabelMenuItems(multipleArrayData.getSlideNameKeyVectorUnion());
        this.mainframe.setJMenuBar(this.menubar);
        this.toolbar = new MultipleArrayToolbar(this.manager);
        this.mainframe.getContentPane().add((Component)this.toolbar, "North");
        this.viewScrollPane = this.createViewScrollPane(eventListener);
        this.viewScrollPane.setBackground(Color.white);
        this.treeScrollPane = this.createTreeScrollPane(eventListener);
        ((MultipleArrayCanvas)this.viewer).addSortMenuItems(multipleArrayData.getFieldNames());
        Date date = new Date(System.currentTimeMillis());
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        dateFormat.setTimeZone(TimeZone.getDefault());
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(dateFormat.format(date));
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        defaultTreeModel.insertNodeInto(defaultMutableTreeNode, this.analysisNode, this.analysisNode.getChildCount());
        this.setNormalizedState(multipleArrayData.getNormalizationState());
        this.splitPane = new JSplitPane(1, this.treeScrollPane, this.viewScrollPane);
        this.splitPane.setOneTouchExpandable(true);
        this.mainframe.getContentPane().add((Component)this.splitPane, "Center");
        this.statusLabel = new JLabel("TIGR MultiExperiment Viewer");
        this.mainframe.getContentPane().add((Component)this.statusLabel, "South");
        this.mainframe.pack();
        this.splitPane.setDividerLocation(0.2);
        if (this.data.getDataType() == 1 || this.data.getDataType() == 2) {
            this.menubar.enableNormalizationMenu(false);
        }
        this.systemEnable(1003);
        this.fireDataChanged();
    }

    public MultipleArrayViewer(MultipleArrayData multipleArrayData, MultipleArrayMenubar multipleArrayMenubar) {
        super(new JFrame("TIGR Multiple Array Viewer"));
        EventListener eventListener = new EventListener();
        this.mainframe.addWindowListener(eventListener);
        this.manager = new ActionManager(eventListener, multipleArrayData.getFieldNames(), TMEV.getGUIFactory());
        this.data = multipleArrayData;
        this.menubar = new MultipleArrayMenubar(multipleArrayMenubar, this.manager);
        this.menubar.addLabelMenuItems(multipleArrayData.getFieldNames());
        this.menubar.synchronizeSettings(multipleArrayMenubar);
        this.menubar.addExperimentLabelMenuItems(multipleArrayData.getSlideNameKeyVectorUnion());
        this.mainframe.setJMenuBar(this.menubar);
        this.toolbar = new MultipleArrayToolbar(this.manager);
        this.mainframe.getContentPane().add((Component)this.toolbar, "North");
        this.viewScrollPane = this.createViewScrollPane(eventListener);
        this.viewScrollPane.setBackground(Color.white);
        this.treeScrollPane = this.createTreeScrollPane(eventListener);
        ((MultipleArrayCanvas)this.viewer).addSortMenuItems(multipleArrayData.getFieldNames());
        Date date = new Date(System.currentTimeMillis());
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        dateFormat.setTimeZone(TimeZone.getDefault());
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(dateFormat.format(date));
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        defaultTreeModel.insertNodeInto(defaultMutableTreeNode, this.analysisNode, this.analysisNode.getChildCount());
        this.data.setUseMainData(true);
        ((LeafInfo)this.mainViewerNode.getUserObject()).setSelectedDataSource(true);
        this.createDataSelectionNode((DefaultMutableTreeNode)this.tree.getRoot().getChildAt(0), this.data.getExperiment(), this.data.getExperiment().getNumberOfGenes(), 0);
        this.tree.repaint();
        this.setNormalizedState(multipleArrayData.getNormalizationState());
        this.splitPane = new JSplitPane(1, this.treeScrollPane, this.viewScrollPane);
        this.splitPane.setOneTouchExpandable(true);
        this.mainframe.getContentPane().add((Component)this.splitPane, "Center");
        this.statusLabel = new JLabel("TIGR MultiExperiment Viewer");
        this.mainframe.getContentPane().add((Component)this.statusLabel, "South");
        this.mainframe.pack();
        this.splitPane.setDividerLocation(0.2);
        if (this.data.getDataType() == 1 || this.data.getDataType() == 2) {
            this.menubar.enableNormalizationMenu(false);
        }
        this.systemEnable(1003);
        this.fireDataChanged();
    }

    public void systemDisable(int n) {
        this.menubar.systemDisable(n);
        this.toolbar.systemDisable(n);
    }

    public void systemEnable(int n) {
        this.menubar.systemEnable(n);
        this.toolbar.systemEnable(n);
    }

    public AlgorithmFactory getAlgorithmFactory() {
        return TMEV.getAlgorithmFactory();
    }

    public IData getData() {
        return this.data;
    }

    private void displaySingleArrayViewer(int n) {
        Manager.createNewSingleArrayViewer(this.data.getFeature(n));
    }

    private void displaySlideElementInfo(int n, int n2) {
        Manager.displaySlideElementInfo(this.mainframe, this.data, n, n2);
    }

    public void saveAnalysisAs() {
        try {
            String string = TMEV.getDataPath();
            File file = TMEV.getFile("data/");
            if (string != null && !(file = new File(string)).exists()) {
                file = TMEV.getFile("data/");
            }
            final JFileChooser jFileChooser = new JFileChooser(file);
            jFileChooser.setFileView(new AnalysisFileView());
            jFileChooser.setFileFilter(new AnalysisFileFilter());
            jFileChooser.setApproveButtonText("Save");
            JPanel jPanel = new JPanel(new GridBagLayout());
            final JDialog jDialog = new JDialog(this.getFrame(), "Save Dialog", true);
            jFileChooser.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = actionEvent.getActionCommand();
                    if (string.equals("ApproveSelection")) {
                        File file = jFileChooser.getSelectedFile();
                        jDialog.dispose();
                        try {
                            AnalysisFileFilter analysisFileFilter = new AnalysisFileFilter();
                            String string2 = analysisFileFilter.getExtension(file);
                            if (string2 == null) {
                                file = new File(file.getPath() + ".anl");
                            }
                            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
                            MultipleArrayViewer.this.saveState(objectOutputStream, file);
                            TMEV.updateDataPath(MultipleArrayViewer.this.formatDataPath(file.getPath()));
                            TMEV.setDataPath(file.getParentFile().getPath());
                        }
                        catch (IOException iOException) {
                            JOptionPane.showMessageDialog(MultipleArrayViewer.this, "I/O Exception, Error saving analysis. File (" + (file != null ? file.getName() : "name unknown") + ")", "Save Analysis", 0);
                            iOException.printStackTrace();
                        }
                    } else {
                        jDialog.dispose();
                    }
                }
            });
            JTextPane jTextPane = new JTextPane();
            jTextPane.setContentType("text/html");
            jTextPane.setEditable(false);
            String string2 = "<html><body><font face=arial size=4><b><center>Analysis Save and Restoration Warning</center><b><hr size=3><br>";
            string2 = string2 + "<font face=arial size=4>Proper restoration of analysis files is dependent on the Java and Java Virtual Machine versions used to open the file. ";
            string2 = string2 + "Analysis files should be opened using Java and Java Virtual Machine versions that match the versions used to save the file.<br><br>";
            string2 = string2 + "If version inconsistencies are found when loading an analysis file the saved and current versions ";
            string2 = string2 + "will be reported at that time.  This problem only arises when moving analysis files between computers ";
            string2 = string2 + "running different versions of Java.<br><br></body></html>";
            jTextPane.setMargin(new Insets(10, 10, 10, 10));
            jTextPane.setFont(new Font("arial", 0, 4));
            jTextPane.setText(string2);
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            jPanel2.setBorder(BorderFactory.createLineBorder(Color.black));
            jPanel2.add((Component)jTextPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
            jPanel2.setPreferredSize(new Dimension(jFileChooser.getPreferredSize().width, (int)((double)jFileChooser.getPreferredSize().height / 1.4)));
            jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0));
            jPanel.add((Component)jFileChooser, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            jDialog.getContentPane().add(jPanel);
            jDialog.pack();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            jDialog.setLocation((dimension.width - jDialog.getSize().width) / 2, (dimension.height - jDialog.getSize().height) / 2);
            jDialog.show();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String formatDataPath(String string) {
        if (string == null) {
            return " ";
        }
        String string2 = "/";
        String string3 = new String();
        String string4 = System.getProperty("file.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string4);
        String string5 = new String();
        while (stringTokenizer.hasMoreTokens() && stringTokenizer.countTokens() > 1) {
            String string6 = stringTokenizer.nextToken();
            string3 = string3 + string6 + string2;
            string5 = string5 + string6 + string4;
        }
        return string3;
    }

    public void saveAnalysis() {
        if (this.currentAnalysisFile != null) {
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(this.currentAnalysisFile));
                this.saveState(objectOutputStream, this.currentAnalysisFile);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            JOptionPane.showMessageDialog(this, "State was not saved.  Error finding file to save. \nPlease use the \"Save As...\" menu item.", "Save Error", 2);
        }
    }

    private void saveState(ObjectOutputStream objectOutputStream, File file) throws IOException {
        final ObjectOutputStream objectOutputStream2 = objectOutputStream;
        final String string = file.getAbsolutePath();
        this.currentAnalysisFile = file;
        TMEV.activeSave = true;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    MultipleArrayViewer.this.setCursor(new Cursor(3));
                    objectOutputStream2.useProtocolVersion(2);
                    objectOutputStream2.writeObject("3.1");
                    String string3 = System.getProperty("java.version");
                    if (string3 != null) {
                        objectOutputStream2.writeObject(string3);
                    } else {
                        objectOutputStream2.writeObject("unknown");
                    }
                    String string2 = System.getProperty("java.vm.version");
                    if (string2 != null) {
                        objectOutputStream2.writeObject(string2);
                    } else {
                        objectOutputStream2.writeObject("unknown");
                    }
                    objectOutputStream2.writeLong(System.currentTimeMillis());
                    objectOutputStream2.writeObject(MultipleArrayViewer.this.data);
                    objectOutputStream2.writeInt(MultipleArrayViewer.this.resultCount);
                    MultipleArrayViewer.this.tree.writeResults(objectOutputStream2);
                    MultipleArrayViewer.this.saveClusterRepositories(objectOutputStream2);
                    MultipleArrayViewer.this.addHistory("Save Analysis: " + string);
                    MultipleArrayViewer.this.tree.writeHistory(objectOutputStream2, MultipleArrayViewer.this.historyNode);
                    MultipleArrayViewer.this.modifiedResult = false;
                    MultipleArrayViewer.this.menubar.systemEnable(101);
                    objectOutputStream2.flush();
                    objectOutputStream2.close();
                    MultipleArrayViewer.this.setCursor(0);
                    TMEV.activeSave = false;
                }
                catch (IOException iOException) {
                    MultipleArrayViewer.this.setCursor(0);
                    JOptionPane.showMessageDialog(MultipleArrayViewer.this, "Analysis was not saved.  Error writing output file.", "Save Error", 2);
                    iOException.printStackTrace();
                    TMEV.activeSave = false;
                }
            }
        });
        thread.setPriority(5);
        thread.start();
    }

    private void loadState(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        final ObjectInputStream objectInputStream2 = objectInputStream;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    Serializable serializable;
                    Serializable serializable2;
                    String string = (String)objectInputStream2.readObject();
                    String string2 = (String)objectInputStream2.readObject();
                    String string3 = (String)objectInputStream2.readObject();
                    String string4 = System.getProperty("java.version");
                    String string5 = System.getProperty("java.vm.version");
                    if (!(string.equals("3.1") && string2.equals(string4) && string3.equals(string5))) {
                        String string6 = "";
                        String string7 = "<b>";
                        int n = 0;
                        if (!string.equals("3.1")) {
                            ++n;
                            string7 = string7 + "<br>";
                            string7 = string7 + "Current MeV Version: 3.1<br>";
                            string7 = string7 + "Analysis File MeV Version: " + string + "<br>";
                        }
                        if (!string2.equals(string4)) {
                            ++n;
                            string7 = string7 + "<br>";
                            string7 = string7 + "Current Java Runtime Version: " + string4 + "<br>";
                            string7 = string7 + "Java Runtime Version During Save: " + string2 + "<br>";
                        }
                        if (!string3.equals(string5)) {
                            ++n;
                            string7 = string7 + "<br>";
                            string7 = string7 + "Current Java Virtual Machine Version: " + string5 + "<br>";
                            string7 = string7 + "Java Virtual Machine Version During Save: " + string3 + "<br>";
                        }
                        string6 = string6 + "<html><body><font face=arial size=4>The following inconsistenc" + (n == 1 ? "y was" : "ies were") + " detected during analysis file loading:<br>" + string7 + "</b><br>";
                        string6 = n > 1 ? string6 + "These differences " : string6 + "This difference ";
                        string6 = string6 + "could affect analysis file loading. <br><br>";
                        string6 = string6 + "Hit <b>\"OK\"</b> to continue loading. (Loading errors will be reported if they occur)<br>";
                        string6 = string6 + "Hit <b>\"Cancel\"</b> to abort the loading process.</body></html>";
                        serializable2 = new JPanel();
                        ((JComponent)serializable2).setBackground(Color.white);
                        ((JComponent)serializable2).setBorder(BorderFactory.createLineBorder(Color.black));
                        serializable = new JTextPane();
                        ((JTextComponent)serializable).setEditable(false);
                        ((JTextComponent)serializable).setMargin(new Insets(10, 10, 10, 10));
                        ((JComponent)serializable).setBackground(Color.white);
                        ((JEditorPane)serializable).setContentType("text/html");
                        ((JEditorPane)serializable).setText(string6);
                        ((Container)serializable2).add((Component)serializable);
                        int n2 = JOptionPane.showConfirmDialog(MultipleArrayViewer.this.getFrame(), serializable2, "Analysis Load Version Confirmations", 2);
                        if (n2 != 0) {
                            return;
                        }
                    }
                    long l = objectInputStream2.readLong();
                    MultipleArrayViewer.this.loadIData(objectInputStream2);
                    MultipleArrayViewer.this.resultCount = objectInputStream2.readInt();
                    MultipleArrayViewer.this.loadAnalysisNode(objectInputStream2);
                    MultipleArrayViewer.this.loadClusterRepositories(objectInputStream2);
                    MultipleArrayViewer.this.loadHistoryNode(objectInputStream2);
                    Date date = new Date(System.currentTimeMillis());
                    serializable2 = DateFormat.getDateTimeInstance();
                    ((DateFormat)serializable2).setTimeZone(TimeZone.getDefault());
                    serializable = new DefaultMutableTreeNode(((DateFormat)serializable2).format(date));
                    DefaultTreeModel defaultTreeModel = (DefaultTreeModel)MultipleArrayViewer.this.tree.getModel();
                    defaultTreeModel.insertNodeInto((MutableTreeNode)((Object)serializable), MultipleArrayViewer.this.analysisNode, MultipleArrayViewer.this.analysisNode.getChildCount());
                    TreePath treePath = new TreePath(((DefaultTreeModel)MultipleArrayViewer.this.tree.getModel()).getPathToRoot(MultipleArrayViewer.this.analysisNode));
                    MultipleArrayViewer.this.tree.expandPath(treePath);
                    treePath = new TreePath(((DefaultTreeModel)MultipleArrayViewer.this.tree.getModel()).getPathToRoot(MultipleArrayViewer.this.historyNode));
                    MultipleArrayViewer.this.tree.expandPath(treePath);
                    MultipleArrayViewer.this.menubar.systemEnable(101);
                    if (TMEV.getDataType() == 2) {
                        MultipleArrayViewer.this.menubar.addAffyFilterMenuItems();
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(MultipleArrayViewer.this, "Analysis was not loaded.  Error reading input file.", "Load Analysis Error", 2);
                    exception.printStackTrace();
                    System.out.println(exception.getMessage());
                }
            }
        });
        thread.setPriority(1);
        thread.start();
    }

    private void loadClusterRepositories(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (objectInputStream.readBoolean()) {
            this.geneClusterRepository = (ClusterRepository)objectInputStream.readObject();
            this.data.setGeneClusterRepository(this.geneClusterRepository);
            this.geneClusterRepository.setFramework(this.framework);
            this.geneClusterManager = new ClusterTable(this.geneClusterRepository, this.framework);
            defaultMutableTreeNode = new DefaultMutableTreeNode(new LeafInfo("Gene Clusters", (IViewer)this.geneClusterManager), false);
            this.addNode(this.clusterNode, defaultMutableTreeNode);
        }
        if (objectInputStream.readBoolean()) {
            this.experimentClusterRepository = (ClusterRepository)objectInputStream.readObject();
            this.data.setExperimentClusterRepository(this.experimentClusterRepository);
            this.experimentClusterRepository.setFramework(this.framework);
            this.experimentClusterManager = new ClusterTable(this.experimentClusterRepository, this.framework);
            defaultMutableTreeNode = new DefaultMutableTreeNode(new LeafInfo("Sample Clusters", (IViewer)this.experimentClusterManager), false);
            this.addNode(this.clusterNode, defaultMutableTreeNode);
        }
    }

    private void loadAnalysisNode(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        DefaultMutableTreeNode defaultMutableTreeNode = this.tree.loadResults(objectInputStream);
        if (defaultMutableTreeNode != null) {
            int n = this.tree.getModel().getIndexOfChild(this.tree.getRoot(), this.analysisNode);
            this.tree.removeNode(this.analysisNode);
            this.analysisNode = defaultMutableTreeNode;
            this.tree.insertNode(this.analysisNode, this.tree.getRoot(), n);
            this.tree.setAnalysisNode(this.analysisNode);
        }
    }

    private void loadHistoryNode(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        DefaultMutableTreeNode defaultMutableTreeNode = this.tree.loadResults(objectInputStream);
        if (defaultMutableTreeNode != null) {
            this.tree.removeNode(this.historyNode);
            this.historyNode = defaultMutableTreeNode;
            this.tree.insertNode(this.historyNode, this.tree.getRoot(), this.tree.getRoot().getChildCount());
            this.historyLog = (HistoryViewer)((LeafInfo)((DefaultMutableTreeNode)this.historyNode.getChildAt(0)).getUserObject()).getViewer();
        }
    }

    private void loadIData(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.data = (MultipleArrayData)objectInputStream.readObject();
        int n = this.data.getDataType();
        if (n != 0 || n != 1) {
            TMEV.setDataType(2);
        }
        this.data.setDataType(this.data.getDataType());
        this.menubar.replaceExperimentLabelMenuItems(this.data.getSlideNameKeyArray());
        this.menubar.replaceLabelMenuItems(this.data.getFieldNames());
        this.menubar.replaceSortMenuItems(this.data.getFieldNames());
        this.setMaxCY3AndCY5();
        this.systemEnable(1003);
        this.fireMenuChanged();
        this.fireDataChanged();
        this.fireHeaderChanged();
    }

    private void saveClusterRepositories(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.geneClusterRepository == null) {
            objectOutputStream.writeBoolean(false);
        } else {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeObject(this.geneClusterRepository);
        }
        if (this.experimentClusterRepository == null) {
            objectOutputStream.writeBoolean(false);
        } else {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeObject(this.experimentClusterRepository);
        }
    }

    private void loadAnalysis() {
        String string = TMEV.getDataPath();
        File file = TMEV.getFile("data/");
        if (string != null && !(file = new File(string)).exists()) {
            file = TMEV.getFile("data/");
        }
        try {
            JFileChooser jFileChooser = new JFileChooser(file);
            jFileChooser.setFileView(new AnalysisFileView());
            jFileChooser.setFileFilter(new AnalysisFileFilter());
            if (jFileChooser.showOpenDialog(this) == 0) {
                File file2 = jFileChooser.getSelectedFile();
                ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file2));
                this.loadState(objectInputStream);
                this.currentAnalysisFile = file2;
                TMEV.updateDataPath(this.formatDataPath(file2.getPath()));
                TMEV.setDataPath(file2.getParentFile().getPath());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void onNewScript() {
        if (this.scriptManager == null) {
            this.scriptManager = new ScriptManager(this.framework, this.scriptNode, this.manager);
        }
        this.scriptManager.addNewScript();
    }

    private void onLoadScript() {
        if (this.scriptManager == null) {
            this.scriptManager = new ScriptManager(this.framework, this.scriptNode, this.manager);
        }
        this.scriptManager.loadScript();
    }

    private String getStatusText() {
        return this.statusLabel.getText();
    }

    private void setStatusText(String string) {
        this.statusLabel.setText(string);
    }

    private Object getUserObject() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return null;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (!(object instanceof LeafInfo)) {
            return null;
        }
        return ((LeafInfo)object).getUserObject();
    }

    public JFrame getFrame() {
        return this.mainframe;
    }

    public void setContentLocation(int n, int n2) {
        Dimension dimension = this.viewScrollPane.getViewport().getViewSize();
        Dimension dimension2 = this.viewScrollPane.getViewport().getExtentSize();
        if (dimension2.height + n2 > dimension.height) {
            n2 = dimension.height - dimension2.height;
        }
        this.viewScrollPane.getViewport().setViewPosition(new Point(n, n2));
    }

    private JScrollPane createTreeScrollPane(EventListener eventListener) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("MultipleExperimentViewer");
        this.viewer = new MultipleArrayCanvas(this.framework, new Insets(0, 10, 0, 20));
        LeafInfo leafInfo = new LeafInfo("Main View", this.viewer);
        this.mainViewerNode = new DefaultMutableTreeNode(leafInfo, false);
        defaultMutableTreeNode.add(this.mainViewerNode);
        this.clusterNode = new DefaultMutableTreeNode(new LeafInfo("Cluster Manager"));
        defaultMutableTreeNode.add(this.clusterNode);
        this.analysisNode = new DefaultMutableTreeNode(new LeafInfo("Analysis Results"));
        defaultMutableTreeNode.add(this.analysisNode);
        this.scriptNode = new DefaultMutableTreeNode(new LeafInfo("Script Manager"));
        defaultMutableTreeNode.add(this.scriptNode);
        this.historyNode = new DefaultMutableTreeNode(new LeafInfo("History"));
        defaultMutableTreeNode.add(this.historyNode);
        this.historyLog = new HistoryViewer();
        this.historyNode.add(new DefaultMutableTreeNode(new LeafInfo("History Log", (IViewer)this.historyLog)));
        this.tree = new ResultTree(defaultMutableTreeNode);
        this.tree.setAnalysisNode(this.analysisNode);
        this.tree.addTreeSelectionListener(eventListener);
        this.tree.addMouseListener(eventListener);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setSelectionPath(new TreePath(this.mainViewerNode.getPath()));
        this.tree.setEditable(false);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        return new JScrollPane(this.tree);
    }

    private JScrollPane createViewScrollPane(EventListener eventListener) {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().setScrollMode(0);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(38, 0);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(40, 0);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(33, 0);
        KeyStroke keyStroke4 = KeyStroke.getKeyStroke(34, 0);
        jScrollPane.registerKeyboardAction(eventListener, "lineup", keyStroke, 2);
        jScrollPane.registerKeyboardAction(eventListener, "linedown", keyStroke2, 2);
        jScrollPane.registerKeyboardAction(eventListener, "pageup", keyStroke3, 2);
        jScrollPane.registerKeyboardAction(eventListener, "pagedown", keyStroke4, 2);
        return jScrollPane;
    }

    private void setCurrentViewer(IViewer iViewer) {
        if (iViewer == null) {
            return;
        }
        if (iViewer.getContentComponent() == null) {
            iViewer.onSelected(this.framework);
            return;
        }
        if (this.viewer != null) {
            this.viewer.onDeselected();
        }
        this.viewer = iViewer;
        this.viewScrollPane.setViewportView(this.viewer.getContentComponent());
        JComponent jComponent = iViewer.getHeaderComponent();
        if (jComponent != null) {
            this.viewScrollPane.setColumnHeaderView(jComponent);
        } else {
            this.viewScrollPane.setColumnHeader(null);
        }
        JComponent jComponent2 = iViewer.getRowHeaderComponent();
        if (jComponent2 != null) {
            this.viewScrollPane.setRowHeaderView(jComponent2);
        } else {
            this.viewScrollPane.setRowHeader(null);
        }
        JComponent jComponent3 = iViewer.getCornerComponent(0);
        if (jComponent3 != null) {
            this.viewScrollPane.setCorner("UPPER_LEFT_CORNER", jComponent3);
        }
        if ((jComponent3 = iViewer.getCornerComponent(1)) != null) {
            this.viewScrollPane.setCorner("UPPER_RIGHT_CORNER", jComponent3);
        }
        if ((jComponent3 = iViewer.getCornerComponent(2)) != null) {
            this.viewScrollPane.setCorner("LOWER_LEFT_CORNER", jComponent3);
        }
        this.viewer.onSelected(this.framework);
        this.doViewLayout();
    }

    private IViewer getCurrentViewer() {
        return this.viewer;
    }

    private void fireOnCloseEvent(DefaultMutableTreeNode defaultMutableTreeNode) {
        LeafInfo leafInfo;
        IViewer iViewer;
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof LeafInfo && (iViewer = (leafInfo = (LeafInfo)object).getViewer()) != null) {
            iViewer.onClosed();
        }
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            this.fireOnCloseEvent((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i));
        }
    }

    private void onClose() {
        this.onSaveCheck();
        this.addHistory("Close Viewer");
        TMEV.setDataType(1);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        this.fireOnCloseEvent((DefaultMutableTreeNode)defaultTreeModel.getRoot());
        this.mainframe.dispose();
        Manager.removeComponent(this);
    }

    private void onSaveCheck() {
        if (this.modifiedResult && this.data != null && TMEV.permitSavePrompt) {
            AnalysisSaveDialog analysisSaveDialog = new AnalysisSaveDialog(this.getFrame());
            int n = analysisSaveDialog.showModal();
            boolean bl = analysisSaveDialog.askAgain();
            if (n == 0) {
                this.saveAnalysisAs();
            }
            if (TMEV.permitSavePrompt != bl) {
                TMEV.setPermitPrompt(bl);
            }
        }
    }

    private BufferedImage createDefaultImage(IViewer iViewer) {
        JComponent jComponent = iViewer.getContentComponent();
        JComponent jComponent2 = iViewer.getHeaderComponent();
        int n = jComponent.getWidth();
        int n2 = jComponent.getHeight();
        if (jComponent2 != null) {
            n = Math.max(n, jComponent2.getWidth());
            n2 += jComponent2.getHeight();
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 5);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        if (jComponent2 != null) {
            int n3 = jComponent2.getHeight();
            graphics2D.setClip(0, 0, n, n3);
            jComponent2.paint(graphics2D);
            graphics2D.translate(0, n3);
            graphics2D.setClip(0, 0, n, n2 - n3);
        } else {
            graphics2D.setClip(0, 0, n, n2);
        }
        jComponent.paint(graphics2D);
        return bufferedImage;
    }

    private void onSaveImage() {
        JFileChooser jFileChooser = new JFileChooser(TMEV.getFile("data?"));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.addChoosableFileFilter((FileFilter)new BMPFileFilter());
        jFileChooser.addChoosableFileFilter((FileFilter)new JPGFileFilter());
        jFileChooser.addChoosableFileFilter((FileFilter)new PNGFileFilter());
        jFileChooser.addChoosableFileFilter((FileFilter)new TIFFFileFilter());
        int n = jFileChooser.showSaveDialog(this.getFrame());
        if (n == 0) {
            IViewer iViewer = this.getCurrentViewer();
            BufferedImage bufferedImage = iViewer.getImage();
            if (bufferedImage == null) {
                bufferedImage = this.createDefaultImage(iViewer);
            }
            final File file = jFileChooser.getSelectedFile();
            final BufferedImage bufferedImage2 = bufferedImage;
            final String string = ((ImageFileFilter)jFileChooser.getFileFilter()).getFileFormat();
            final ImageEncodeParam imageEncodeParam = ((ImageFileFilter)jFileChooser.getFileFilter()).getImageEncodeParam();
            try {
                Thread thread = new Thread(){

                    public void run() {
                        JAI.create((String)"filestore", (RenderedImage)bufferedImage2, (Object)file.getPath(), (Object)string, (Object)imageEncodeParam);
                        Manager.message(MultipleArrayViewer.this.getFrame(), "Image saved: " + file.getPath());
                    }
                };
                thread.setPriority(1);
                thread.start();
            }
            catch (Exception exception) {
                Manager.message(this.getFrame(), exception);
            }
        }
    }

    private void onLoadFile() {
        try {
            ISlideData iSlideData = this.loadSlideData(this.data.getSlideMetaData());
            if (iSlideData != null) {
                this.addFeature(iSlideData);
                this.setMaxCY3AndCY5();
            }
        }
        catch (Exception exception) {
            ShowThrowableDialog.show(this.mainframe, "Load File Error", exception);
        }
    }

    private void onLoadCluster() {
        this.loadFromStanfordFile("Select a Cluster File to Open");
    }

    private void onLoadStanford() {
        this.loadFromStanfordFile("Select a Stanford File to Open");
    }

    private void onLoadDatabase() {
        SetDatabaseDialog setDatabaseDialog = new SetDatabaseDialog(this.getFrame());
        if (setDatabaseDialog.showModal() != 0) {
            return;
        }
        String string = setDatabaseDialog.getDatabase();
        String[] stringArray = new String[]{"L4A1", "L4A2", "L4A3"};
        SetSlideFilenameDialog setSlideFilenameDialog = new SetSlideFilenameDialog((Frame)this.getFrame(), stringArray);
        if (setSlideFilenameDialog.showModal() != 0) {
            return;
        }
        String string2 = setSlideFilenameDialog.getFileName();
        System.out.println("db  : " + string);
        System.out.println("file: " + string2);
    }

    private void loadFromStanfordFile(String string) {
        try {
            ISlideData[] iSlideDataArray = super.loadStanfordFile(string);
            if (iSlideDataArray != null) {
                this.addFeatures(iSlideDataArray);
                this.setMaxCY3AndCY5();
            }
        }
        catch (Exception exception) {
            ShowThrowableDialog.show(this.mainframe, "Load Data Error", exception);
        }
    }

    private void onLoadDirectory() {
        try {
            ISlideData[] iSlideDataArray = this.loadDirectory(this.data.getSlideMetaData());
            if (iSlideDataArray != null) {
                this.addFeatures(iSlideDataArray);
                this.setMaxCY3AndCY5();
            }
        }
        catch (Exception exception) {
            ShowThrowableDialog.show(this.mainframe, "Load Directory Error", exception);
        }
    }

    private void setMaxCY3AndCY5() {
        this.menubar.setMaxCY3Scale(this.data.getMaxCY3());
        this.menubar.setMaxCY5Scale(this.data.getMaxCY5());
    }

    private void onLabelChanged(Action action) {
        String string = (String)action.getValue("command-parameter");
        this.menubar.setLabelIndex(Integer.parseInt(string));
        this.fireMenuChanged();
    }

    private void onExperimentLabelChanged(Action action) {
        String string = (String)action.getValue("command-parameter");
        this.data.setSampleLabelKey(string);
        this.fireMenuChanged();
    }

    private void onExperimentLabelAdded() {
        boolean bl = false;
        bl = this.resultCount < 2 && this.geneClusterRepository == null && this.experimentClusterRepository == null;
        Vector vector = this.data.getSlideNameKeyVectorUnion();
        ExperimentLabelEditor experimentLabelEditor = new ExperimentLabelEditor(this.getFrame(), vector, this.data, bl);
        if (experimentLabelEditor.showModal() != 0) {
            return;
        }
        String[][] stringArray = experimentLabelEditor.getLabelDataWithoutKeys();
        String[] stringArray2 = experimentLabelEditor.getLabelKeys();
        for (int i = 0; i < stringArray2.length; ++i) {
            this.data.addNewExperimentLabel(stringArray2[i], stringArray[i]);
        }
        this.menubar.replaceExperimentLabelMenuItems(stringArray2);
        if (bl && experimentLabelEditor.isReorderedSelected()) {
            int[] nArray = experimentLabelEditor.getNewOrderScheme();
            ArrayList<ISlideData> arrayList = new ArrayList<ISlideData>(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                arrayList.add(this.data.getFeature(nArray[i]));
            }
            this.data.setFeaturesList(arrayList);
        }
        this.fireDataChanged();
    }

    private void addFeature(ISlideData iSlideData) {
        this.data.addFeature(iSlideData);
        this.systemEnable(1003);
        this.fireDataChanged();
    }

    private void addFeatures(ISlideData[] iSlideDataArray) {
        this.data.addFeatures(iSlideDataArray);
        this.systemEnable(1003);
        this.fireDataChanged();
    }

    public void fireDataChanged() {
        IViewer iViewer = this.getCurrentViewer();
        if (iViewer == null) {
            return;
        }
        iViewer.onDataChanged((IData)this.data);
        this.doViewLayout();
    }

    private void fireMenuChanged() {
        IViewer iViewer = this.getCurrentViewer();
        if (iViewer == null) {
            return;
        }
        iViewer.onMenuChanged(this.menubar.getDisplayMenu());
        this.doViewLayout();
    }

    private void fireHeaderChanged() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (!(object instanceof LeafInfo)) {
            return;
        }
        this.setCurrentViewer(((LeafInfo)object).getViewer());
    }

    private void doViewLayout() {
        JViewport jViewport = this.viewScrollPane.getColumnHeader();
        if (jViewport != null) {
            jViewport.doLayout();
        }
        this.viewScrollPane.getViewport().doLayout();
        this.viewScrollPane.doLayout();
        this.viewScrollPane.repaint();
    }

    private void onNormalizeData(int n) {
        this.setCursor(3);
        this.data.normalize(n, this);
        this.addHistory("Normalization State: " + SlideData.normalizationString(n));
        this.setCursor(0);
    }

    private void onNormalizeDataList(int n) {
        this.setCursor(3);
        this.data.normalizeList(n);
        this.addHistory(SlideData.normalizationString(n));
        this.setCursor(0);
    }

    private void onNodeChanged(TreeSelectionEvent treeSelectionEvent) {
        JTree jTree = (JTree)treeSelectionEvent.getSource();
        TreePath treePath = treeSelectionEvent.getPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (!(object instanceof LeafInfo)) {
            return;
        }
        this.setCurrentViewer(((LeafInfo)object).getViewer());
    }

    private void onElementSizeChanged(int n, int n2) {
        this.menubar.setElementSize(n, n2);
        this.fireMenuChanged();
    }

    private void onElementSizeChanged() {
        SetElementSizeDialog setElementSizeDialog = new SetElementSizeDialog(this.getFrame(), this.menubar.getDisplayMenu().getElementSize());
        if (setElementSizeDialog.showModal() == 0) {
            Dimension dimension = setElementSizeDialog.getElementSize();
            this.onElementSizeChanged(dimension.width, dimension.height);
        }
    }

    private void onColorSchemeChange(int n) {
        int n2 = this.menubar.getColorScheme();
        if (n == 5 || n == 6 || n == 8) {
            this.menubar.setColorSchemeIndex(n);
            if (n == 8) {
                this.menubar.setUseDoubleGradient(false);
            } else {
                this.menubar.setUseDoubleGradient(true);
            }
        } else {
            ColorSchemeSelectionDialog colorSchemeSelectionDialog;
            boolean bl;
            boolean bl2 = bl = n2 == 8;
            if (bl) {
                this.menubar.setColorSchemeIndex(5);
                this.menubar.setUseDoubleGradient(true);
            }
            if ((colorSchemeSelectionDialog = new ColorSchemeSelectionDialog(this.getFrame(), true, this.menubar.getNegativeGradientImage(), this.menubar.getPositiveGradientImage(), this.menubar.getDisplayMenu().getUseDoubleGradient())).showModal() != 0) {
                if (bl) {
                    this.menubar.setColorSchemeIndex(8);
                    this.menubar.setUseDoubleGradient(false);
                }
                return;
            }
            this.menubar.setPositiveCustomGradient(colorSchemeSelectionDialog.getPositiveGradient());
            this.menubar.setNegativeCustomGradient(colorSchemeSelectionDialog.getNegativeGradient());
            this.menubar.setColorSchemeIndex(n);
            this.menubar.setUseDoubleGradient(colorSchemeSelectionDialog.getUseDoubleGradient());
        }
        this.fireMenuChanged();
    }

    private void onColorGradientChange(boolean bl) {
        this.menubar.setColorGradientState(bl);
        this.fireMenuChanged();
    }

    private void onDrawBorders() {
        this.menubar.setDrawBorders(!this.menubar.getDisplayMenu().isDrawingBorder());
        this.fireMenuChanged();
    }

    private void onSystemInfo() {
        int n = 640;
        int n2 = 550;
        InformationPanel informationPanel = new InformationPanel();
        JFrame jFrame = new JFrame("System Information");
        jFrame.getContentPane().add(informationPanel);
        jFrame.setSize(n, n2);
        Dimension dimension = this.getToolkit().getScreenSize();
        jFrame.setLocation(dimension.width / 2 - n / 2, dimension.height / 2 - n2 / 2);
        jFrame.setResizable(false);
        jFrame.setVisible(true);
        informationPanel.Start();
    }

    private void onDefaultDistance() {
        String string = "<html><font color=\"#000000\"><b><u>Default Distances</u></b></font><p><table border=20 cellspacing=10 cellpadding = 10 width= 380 height= 400><tr><th><u><center><width=200>Algorithm</center></u></th><th width = 150><u><center>Default Metric</center></u></th></tr><tr><td><center>HCL, ST, SOTA, KMC, KMS, SOM, CAST, GSH, FOM</center></td><td><center>Euclidean</center></td></tr><tr><td><center>PCA</center></td><td><center>Covariance</center></td></tr><tr><td><center>SVM</center></td><td><center>Dot Product</center></td></tr><tr><td><center>RN, QTC, PTM</center></td><td><center>Pearson Correlation</center></td></tr></center></table></html>";
        JOptionPane.showMessageDialog(this.getFrame(), new JLabel(string), "Default Distances", -1);
    }

    private void setNormalizedState(int n) {
        if (n == 0) {
            this.menubar.setNormalizedButtonState(5);
        } else {
            this.addHistory(SlideData.normalizationString(n));
            if (n == 1) {
                this.menubar.setNormalizedButtonState(0);
            } else if (n == 3) {
                this.menubar.setNormalizedButtonState(1);
            } else if (n == 4 || n == 5) {
                this.menubar.setNormalizedButtonState(2);
            } else if (n == 6) {
                this.menubar.setNormalizedButtonState(3);
            }
        }
    }

    private void onNormalize(int n) {
        final int n2 = this.data.getFeature(0).getNormalizedState();
        final int n3 = n;
        this.setCursor(3);
        try {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    String string = MultipleArrayViewer.this.data.normalize(n3, MultipleArrayViewer.this);
                    if (!string.equals("no_change")) {
                        if (string.equals("normalized")) {
                            MultipleArrayViewer.this.addHistory(SlideData.normalizationString(n3));
                        } else if (string.equals("process_abort_reset")) {
                            MultipleArrayViewer.this.addHistory("Norm. aborted, reset to raw state");
                            MultipleArrayViewer.this.menubar.setNormalizedButtonState(5);
                        }
                        MultipleArrayViewer.this.fireDataChanged();
                        MultipleArrayViewer.this.setCursor(0);
                    } else if (n2 == 0) {
                        MultipleArrayViewer.this.menubar.setNormalizedButtonState(5);
                    } else if (n2 == 1) {
                        MultipleArrayViewer.this.menubar.setNormalizedButtonState(0);
                    } else if (n2 == 3) {
                        MultipleArrayViewer.this.menubar.setNormalizedButtonState(1);
                    } else if (n2 == 4 || n2 == 5) {
                        MultipleArrayViewer.this.menubar.setNormalizedButtonState(2);
                    } else if (n2 == 6) {
                        MultipleArrayViewer.this.menubar.setNormalizedButtonState(3);
                    }
                }
            });
            thread.setPriority(1);
            thread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setCursor(0);
        this.fireDataChanged();
    }

    private void onNormalizeList(int n) {
        this.setCursor(3);
        this.data.normalizeList(n);
        this.addHistory(SlideData.normalizationString(n));
        this.fireDataChanged();
        this.setCursor(0);
    }

    private void onPrintImage() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this, printerJob.defaultPage());
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                printerException.printStackTrace();
            }
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= 1) {
            return 1;
        }
        IViewer iViewer = this.getCurrentViewer();
        BufferedImage bufferedImage = iViewer.getImage();
        if (bufferedImage == null) {
            bufferedImage = this.createDefaultImage(iViewer);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        double d = pageFormat.getImageableWidth() / (double)bufferedImage.getWidth();
        double d2 = pageFormat.getImageableHeight() / (double)bufferedImage.getHeight();
        double d3 = Math.min(d, d2);
        affineTransform.scale(d3, d3);
        try {
            graphics2D.drawImage(bufferedImage, affineTransform, this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 1;
        }
        return 0;
    }

    private synchronized void addAnalysisResult(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null) {
            return;
        }
        String string = (String)defaultMutableTreeNode.getUserObject();
        string = string + " (" + this.resultCount + ")";
        ++this.resultCount;
        this.modifiedResult = true;
        defaultMutableTreeNode.setUserObject(string);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        defaultTreeModel.insertNodeInto(defaultMutableTreeNode, this.analysisNode, this.analysisNode.getChildCount());
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        treeSelectionModel.setSelectionPath(treePath);
        this.tree.scrollPathToVisible(treePath);
        JScrollBar jScrollBar = this.treeScrollPane.getHorizontalScrollBar();
        if (jScrollBar != null) {
            jScrollBar.setValue(0);
        }
        this.addHistory("Analysis Result: " + string);
    }

    private void addHistory(String string) {
        this.historyLog.addHistory(string);
    }

    private void onAnalysis(Action action) {
        String string = (String)action.getValue("command-parameter");
        try {
            Class<?> clazz = Class.forName(string);
            final IClusterGUI iClusterGUI = (IClusterGUI)clazz.newInstance();
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        DefaultMutableTreeNode defaultMutableTreeNode = iClusterGUI.execute(MultipleArrayViewer.this.framework);
                        MultipleArrayViewer.this.addAnalysisResult(defaultMutableTreeNode);
                    }
                    catch (AbortException abortException) {
                    }
                    catch (Exception exception) {
                        ShowThrowableDialog.show(MultipleArrayViewer.this.mainframe, "Analysis Error", false, exception);
                    }
                }
            });
            thread.setPriority(1);
            thread.start();
        }
        catch (ClassCastException classCastException) {
            System.out.println("Error: org.tigr.microarray.mev.cluster.gui.IClusterGUI interface is expected.");
            ShowThrowableDialog.show(this.mainframe, "Analysis Error", false, classCastException);
        }
        catch (Exception exception) {
            ShowThrowableDialog.show(this.mainframe, "Analysis Error", false, exception);
        }
    }

    private void onDeleteNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null || defaultMutableTreeNode.getParent() == null) {
            return;
        }
        this.fireOnCloseEvent(defaultMutableTreeNode);
        TreePath treePath = new TreePath(((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getPath());
        ((DefaultTreeModel)this.tree.getModel()).removeNodeFromParent(defaultMutableTreeNode);
        this.tree.getSelectionModel().setSelectionPath(treePath);
        this.tree.scrollPathToVisible(treePath);
        String string = " ";
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof LeafInfo) {
            string = ((LeafInfo)object).toString();
        } else if (object instanceof String) {
            string = (String)object;
        }
        this.addHistory("Deleted Node: " + string);
    }

    private void onSetData(boolean bl) {
        LeafInfo leafInfo;
        IViewer iViewer;
        boolean bl2 = bl;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        int n = 0;
        if (defaultMutableTreeNode == null || defaultMutableTreeNode.getParent() == null) {
            return;
        }
        if (object instanceof LeafInfo && (iViewer = (leafInfo = (LeafInfo)object).getViewer()) != null) {
            Experiment experiment = iViewer.getExperiment();
            int[][] nArray = iViewer.getClusters();
            if (leafInfo.toString().equals("Main View")) {
                this.tree.clearDataSelection();
                leafInfo.setSelectedDataSource(bl);
                this.data.setUseMainData(true);
                this.createDataSelectionNode((DefaultMutableTreeNode)this.tree.getRoot().getChildAt(0), this.data.getExperiment(), this.data.getExperiment().getNumberOfGenes(), 0);
                this.tree.repaint();
                return;
            }
            if (experiment == null || nArray == null) {
                return;
            }
            Object object2 = leafInfo.getUserObject();
            if (object2 instanceof Integer) {
                n = (Integer)object2;
            } else if (object2 instanceof CentroidUserObject) {
                n = ((CentroidUserObject)object2).getClusterIndex();
            } else {
                return;
            }
            int n2 = iViewer.getViewerType();
            if (n2 == -1) {
                return;
            }
            this.tree.clearDataSelection();
            leafInfo.setSelectedDataSource(bl);
            if (bl) {
                this.data.constructAndSetAlternateExperiment(experiment, nArray[n], n2);
                this.createDataSelectionNode(defaultMutableTreeNode, experiment, nArray[n].length, n2);
            } else {
                this.data.setUseMainData(true);
                ((LeafInfo)((DefaultMutableTreeNode)this.tree.getRoot().getChildAt(0)).getUserObject()).setSelectedDataSource(true);
                this.createDataSelectionNode((DefaultMutableTreeNode)this.tree.getRoot().getChildAt(0), this.data.getExperiment(), this.data.getExperiment().getNumberOfGenes(), 0);
            }
        }
        this.tree.repaint();
    }

    private void createDataSelectionNode(DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment, int n, int n2) {
        int n3;
        int n4;
        String string = "";
        String string2 = "<html><body>";
        string2 = string2 + "<h1>Data Source Selection Information</h1>";
        string2 = string2 + "<table align=left>";
        TreeNode[] treeNodeArray = defaultMutableTreeNode.getPath();
        String string3 = "   ";
        string2 = string2 + "<tr><td><b>Data Source Path:</b></td><td>";
        string = string + "Data Source Path: ";
        for (int i = 1; i < treeNodeArray.length - 1; ++i) {
            string2 = string2 + treeNodeArray[i].toString();
            string2 = string2 + " : ";
            string = string + treeNodeArray[i].toString();
            string = string + " : ";
        }
        string2 = string2 + treeNodeArray[treeNodeArray.length - 1] + "</td></tr>";
        string = string + treeNodeArray[treeNodeArray.length - 1];
        if (n2 == 0) {
            n4 = n;
            n3 = experiment.getNumberOfSamples();
            string2 = string2 + "<tr><td><b>Number of Genes:</b></td><td>" + n + "</td></tr>";
            string2 = string2 + "<tr><td><b>Number of Samples:</b></td><td>" + experiment.getNumberOfSamples() + "</td></tr>";
        } else {
            n4 = experiment.getNumberOfGenes();
            n3 = n;
            string2 = string2 + "<tr><td><b>Number of Genes:</b></td><td>" + experiment.getNumberOfGenes() + "</td></tr>";
            string2 = string2 + "<tr><td><b>Number of Samples:</b></td><td>" + n + "</td></tr>";
        }
        string2 = string2 + "</table></body></html>";
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new LeafInfo("Data Source Selection", (IViewer)new TextViewer(string2)));
        this.addNode(this.analysisNode, defaultMutableTreeNode2);
        String string4 = "Data Source Selection\n";
        string4 = string4 + "=====================\n";
        string4 = string4 + string + "\n";
        string4 = string4 + "Number of Genes: " + String.valueOf(n4) + "\n";
        string4 = string4 + "Number of Samples: " + String.valueOf(n3);
        this.addHistory(string4);
    }

    private void onSetDetectionFilter() {
        SetDetectionFilterDialog setDetectionFilterDialog;
        int n = this.data.getFeaturesCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.data.getFullSampleName(i);
        }
        if (this.data.getdfSet()) {
            setDetectionFilterDialog = new SetDetectionFilterDialog(this.getFrame(), stringArray, this.data.getDetectionFilter());
        } else {
            setDetectionFilterDialog = new SetDetectionFilterDialog(this.getFrame(), stringArray);
            this.data.setdfSet(true);
        }
        if (setDetectionFilterDialog.showModal() == 0) {
            this.data.setDetectionFilter(setDetectionFilterDialog.getDetectionFilter());
            if (this.data.isDetectionFilter()) {
                this.addHistory("Detection Filter (" + this.data.getDetectionFilter() + ")");
                this.addHistory(this.data.getExperiment().getNumberOfGenes() + " genes will used in subsequent analyses");
            }
        }
    }

    private void onSetFoldFilter() {
        SetFoldFilterDialog setFoldFilterDialog;
        int n = this.data.getFeaturesCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.data.getFullSampleName(i);
        }
        if (this.data.getffSet()) {
            setFoldFilterDialog = new SetFoldFilterDialog(this.getFrame(), stringArray);
        } else {
            setFoldFilterDialog = new SetFoldFilterDialog(this.getFrame(), stringArray);
            this.data.setffSet(true);
        }
        if (setFoldFilterDialog.showModal() == 0) {
            this.data.setFoldFilter(setFoldFilterDialog.getFoldFilter());
            if (this.data.isFoldFilter()) {
                this.addHistory("Fold Filter (" + this.data.getFoldFilter().toString() + ")");
                this.addHistory(this.data.getExperiment().getNumberOfGenes() + " genes will used in subsequent analyses");
            }
        }
    }

    private void applyLowerCutoffs() {
        SetLowerCutoffsDialog setLowerCutoffsDialog = new SetLowerCutoffsDialog(this.getFrame(), this.data.getLowerCY3Cutoff(), this.data.getLowerCY5Cutoff());
        if (setLowerCutoffsDialog.showModal() == 0) {
            boolean bl = setLowerCutoffsDialog.isLowerCutoffEnabled();
            this.data.setUseLowerCutoffs(bl);
            this.data.setLowerCutoffs(setLowerCutoffsDialog.getLowerCY3Cutoff(), setLowerCutoffsDialog.getLowerCY5Cutoff());
            Properties properties = new Properties();
            properties.setProperty("CY3 Cutoff", Float.toString(setLowerCutoffsDialog.getLowerCY3Cutoff()));
            properties.setProperty("CY5 Cutoff", Float.toString(setLowerCutoffsDialog.getLowerCY5Cutoff()));
            if (this.data.isLowerCutoffs()) {
                this.addAdjustmentResultNodes("Data Filter - Low Intensity Cutoff Filter", this.data.getExperiment(), properties);
                this.addHistory("Low Intensity Cutoff Filter is ON ( percent = cy3= " + Float.toString(setLowerCutoffsDialog.getLowerCY3Cutoff()) + "  cy5 =" + Float.toString(setLowerCutoffsDialog.getLowerCY5Cutoff()) + " )");
            } else {
                this.addHistory("Low Intensity Filter is OFF");
            }
            this.addHistory(this.data.getExperiment().getNumberOfGenes() + " genes will be used in subsequent analyses");
        }
    }

    private void applyPercentageCutoffs() {
        SetPercentageCutoffsDialog setPercentageCutoffsDialog = new SetPercentageCutoffsDialog(this.getFrame(), this.data.getPercentageCutoff());
        if (setPercentageCutoffsDialog.showModal() == 0) {
            boolean bl = setPercentageCutoffsDialog.isCutoffFilterEnabled();
            float f = setPercentageCutoffsDialog.getPercentageCutoff();
            this.data.setUsePercentageCutoff(bl);
            this.data.setPercentageCutoff(f);
            Properties properties = new Properties();
            properties.setProperty("Percentage", Float.toString(f));
            if (this.data.isPercentageCutoff()) {
                this.addAdjustmentResultNodes("Data Filter - Percentage Cutoff Filter", this.data.getExperiment(), properties);
                this.addHistory("Percentage Cutoff Filter is ON ( percent = " + Float.toString(f) + " )");
            } else {
                this.addHistory("Percentage Cutoff Filter is OFF");
            }
            this.addHistory(this.data.getExperiment().getNumberOfGenes() + " genes will be used in subsequent analyses");
        }
    }

    private void applyVarianceFilter() {
        VarianceFilterDialog varianceFilterDialog = new VarianceFilterDialog(this.getFrame());
        if (varianceFilterDialog.showModal() == 0) {
            Properties properties = varianceFilterDialog.getProperties();
            this.data.setVarianceFilter(properties);
            if (this.data.isVarianceFilter()) {
                this.addAdjustmentResultNodes("Data Filter - Variance Filter", this.data.getExperiment(), properties);
                this.addHistory("Variance Filter is ON ( mode= " + properties.getProperty("Filter Mode") + " value= " + properties.getProperty("Value") + " )");
            } else {
                this.addHistory("Variance Filter is OFF");
            }
            this.addHistory(this.data.getExperiment().getNumberOfGenes() + " genes will be used in subsequent analyses");
        }
    }

    private void addAdjustmentResultNodes(String string, Experiment experiment, Properties properties) {
        Object[] objectArray;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        int[][] nArray = new int[1][experiment.getNumberOfGenes()];
        for (int i = 0; i < nArray[0].length; ++i) {
            nArray[0][i] = i;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new LeafInfo("Expression Image", (IViewer)new ExperimentViewer(experiment, nArray), (Object)new Integer(0)));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("Gene/Row Count: " + nArray[0].length));
        if (properties.size() > 0) {
            objectArray = "Parameter";
            if (properties.size() > 1) {
                objectArray = (String)objectArray + "s";
            }
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(objectArray);
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(string2 + ": " + (String)properties.get(string2)));
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode3);
        }
        this.addNode(this.analysisNode, defaultMutableTreeNode);
        objectArray = new Object[]{this.tree.getRoot(), this.analysisNode, defaultMutableTreeNode};
        this.tree.scrollPathToVisible(new TreePath(objectArray));
    }

    private void onUseDetectionFilter(AbstractButton abstractButton) {
        this.data.setUseDetectionFilter(abstractButton.isSelected());
        if (this.data.isDetectionFilter()) {
            this.addHistory("Detection Filter (" + this.data.getDetectionFilter() + ")");
            this.addAdjustmentResultNodes("Data Filter - Affy Detection Filter", this.data.getExperiment(), new Properties());
        } else {
            this.addHistory("Detection Filter not used.");
        }
        this.addHistory(this.data.getExperiment().getNumberOfGenes() + " genes will be used in subsequent analyses");
    }

    private void onUseFoldFilter(AbstractButton abstractButton) {
        this.data.setUseFoldFilter(abstractButton.isSelected());
        if (this.data.isFoldFilter()) {
            this.addHistory("Fold Filter (" + this.data.getDetectionFilter() + ")");
            this.addAdjustmentResultNodes("Data Filter - Affy Fold Filter", this.data.getExperiment(), new Properties());
        } else {
            this.addHistory("Fold Filter not used.");
        }
        this.addHistory(this.data.getExperiment().getNumberOfGenes() + " genes will be used in subsequent analyses");
    }

    private void onLog2Transform() {
        this.data.log2Transform();
        this.fireDataChanged();
        this.addHistory("Log2 Transform");
    }

    private void onNormalizeSpots() {
        this.data.normalizeSpots();
        this.fireDataChanged();
        this.addHistory("Normalize Gene/Row Vectors");
    }

    private void onDivideSpotsRMS() {
        this.data.divideSpotsRMS();
        this.fireDataChanged();
        this.addHistory("Divide by Gene/Row RMS");
    }

    private void onDivideSpotsSD() {
        this.data.divideSpotsSD();
        this.fireDataChanged();
        this.addHistory("Divide by Gene/Row SD");
    }

    private void onDivideGenesMedian() {
        this.data.divideGenesMedian();
        this.fireDataChanged();
        this.addHistory("Divide by Gene/Row Median");
    }

    private void onDivideGenesMean() {
        this.data.divideGenesMean();
        this.fireDataChanged();
        this.addHistory("Divide by Gene/Row Mean");
    }

    private void onMeanCenterSpots() {
        this.data.meanCenterSpots();
        this.fireDataChanged();
        this.addHistory("Mean Center by Gene/Row Mean");
    }

    private void onMedianCenterSpots() {
        this.data.medianCenterSpots();
        this.fireDataChanged();
        this.addHistory("Median Center by Gene/Row Median");
    }

    private void onDigitalSpots() {
        this.data.digitalSpots();
        this.fireDataChanged();
        this.addHistory("Digital Rows");
    }

    private void onNormalizeExperiments() {
        this.data.normalizeExperiments();
        this.fireDataChanged();
        this.addHistory("Normalize Sample/Column Vectors");
    }

    private void onDivideExperimentsRMS() {
        this.data.divideExperimentsRMS();
        this.fireDataChanged();
        this.addHistory("Divide by Sample/Column RMS");
    }

    private void onDivideExperimentsSD() {
        this.data.divideExperimentsSD();
        this.fireDataChanged();
        this.addHistory("Divide by Sample/Column SD");
    }

    private void onMeanCenterExperiments() {
        this.data.meanCenterExperiments();
        this.fireDataChanged();
        this.addHistory("Mean Center by Column/Sample Mean");
    }

    private void onMedianCenterExperiments() {
        this.data.medianCenterExperiments();
        this.fireDataChanged();
        this.addHistory("Median Center by Sample/Column Median");
    }

    private void onDigitalExperiments() {
        this.data.digitalExperiments();
        this.fireDataChanged();
        this.addHistory("Digital Samples");
    }

    private void onLog10toLog2() {
        this.data.log10toLog2();
        this.fireDataChanged();
        this.addHistory("Log10 to Log2");
    }

    private void onAdjustIntensities(AbstractButton abstractButton) {
        this.data.setNonZero(abstractButton.isSelected());
        this.fireDataChanged();
    }

    private void onSaveMatrix() {
        try {
            ExperimentUtil.saveExperiment((Frame)this.mainframe, (Experiment)this.data.getExperiment(), (IData)this.data);
            this.addHistory("Save Data Matrix to File");
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.mainframe, "Can not save matrix!", exception.toString(), 0);
            exception.printStackTrace();
        }
    }

    private void onSetRatioScale() {
        IDisplayMenu iDisplayMenu = this.menubar.getDisplayMenu();
        SetRatioScaleDialog setRatioScaleDialog = new SetRatioScaleDialog(this.mainframe, this.framework, this.menubar, iDisplayMenu.getMaxRatioScale(), iDisplayMenu.getMinRatioScale(), iDisplayMenu.getMidRatioValue(), iDisplayMenu.getUseDoubleGradient());
        if (setRatioScaleDialog.showModal() == 0) {
            this.menubar.setMaxRatioScale(setRatioScaleDialog.getUpperLimit());
            this.menubar.setMinRatioScale(setRatioScaleDialog.getLowerLimit());
            this.menubar.setMidRatioValue(setRatioScaleDialog.getMidValue());
            this.menubar.setUseDoubleGradient(setRatioScaleDialog.getUseDoubleGradient());
            if (setRatioScaleDialog.isGradientStyleAltered() && setRatioScaleDialog.getUseDoubleGradient()) {
                this.menubar.setPositiveCustomGradient(setRatioScaleDialog.getPosImage());
            }
            this.fireMenuChanged();
        }
        this.addHistory("Color Sat. Limits Set: Lower = " + setRatioScaleDialog.getLowerLimit() + " Upper = " + setRatioScaleDialog.getUpperLimit());
    }

    private void onDeleteAll() {
        this.data.deleteColors();
        if (this.geneClusterManager != null) {
            this.geneClusterManager.deleteAllClusters();
        }
        this.fireDataChanged();
        this.fireMenuChanged();
        this.addHistory("Deleted All Gene Clusters");
    }

    private void onDeleteAllExperimentClusters() {
        this.data.deleteExperimentColors();
        if (this.experimentClusterManager != null) {
            this.experimentClusterManager.deleteAllClusters();
        }
        this.fireDataChanged();
        this.fireMenuChanged();
        this.addHistory("Deleted All Sample Clusters");
    }

    private void selectNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.tree.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
    }

    private void addNode(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        defaultTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        this.treeScrollPane.getHorizontalScrollBar().setValue(0);
        this.fireDataChanged();
    }

    private Color storeCluster(int[] nArray, Experiment experiment, int n) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Cluster cluster;
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        TreePath treePath = this.tree.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object object = defaultMutableTreeNode2.getUserObject();
        if (!(object instanceof LeafInfo)) {
            return null;
        }
        if (treePath.getPathCount() < 3) {
            return null;
        }
        Color color = null;
        String string = ((LeafInfo)defaultMutableTreeNode2.getUserObject()).toString();
        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)treePath.getPathComponent(2);
        String string2 = (String)defaultMutableTreeNode3.getUserObject();
        if (n == 0) {
            if (this.geneClusterRepository == null) {
                this.geneClusterRepository = new ClusterRepository(this.data.getFeaturesSize(), this.framework, true);
                this.data.setGeneClusterRepository(this.geneClusterRepository);
            }
            if ((cluster = this.geneClusterRepository.storeCluster(this.resultCount - 1, string2, string, nArray, defaultMutableTreeNode2, experiment)) != null) {
                color = cluster.getClusterColor();
                if (this.geneClusterManager == null) {
                    this.geneClusterManager = new ClusterTable(this.geneClusterRepository, this.framework);
                    defaultMutableTreeNode = new DefaultMutableTreeNode(new LeafInfo("Gene Clusters", (IViewer)this.geneClusterManager), false);
                    this.addNode(this.clusterNode, defaultMutableTreeNode);
                } else {
                    this.geneClusterManager.onRepositoryChanged(this.geneClusterRepository);
                }
            }
            this.geneClusterRepository.printRepository();
        } else {
            if (this.experimentClusterRepository == null) {
                this.experimentClusterRepository = new ClusterRepository(this.data.getFeaturesCount(), this.framework);
                this.data.setExperimentClusterRepository(this.experimentClusterRepository);
            }
            if ((cluster = this.experimentClusterRepository.storeCluster(this.resultCount - 1, string2, string, nArray, defaultMutableTreeNode2, experiment)) != null) {
                color = cluster.getClusterColor();
                if (this.experimentClusterManager == null) {
                    this.experimentClusterManager = new ClusterTable(this.experimentClusterRepository, this.framework);
                    defaultMutableTreeNode = new DefaultMutableTreeNode(new LeafInfo("Sample Clusters", (IViewer)this.experimentClusterManager), false);
                    this.addNode(this.clusterNode, defaultMutableTreeNode);
                } else {
                    this.experimentClusterManager.onRepositoryChanged(this.experimentClusterRepository);
                }
            }
            this.experimentClusterRepository.printRepository();
        }
        if (cluster != null) {
            int n2 = cluster.getSerialNumber();
            String string3 = cluster.getAlgorithmName();
            if (n == 0) {
                this.addHistory("Save Gene Cluster: Serial #: " + String.valueOf(n2) + ", Algorithm: " + string3 + ", Cluster: " + string);
            } else {
                this.addHistory("Save Experiment Cluster: Serial #: " + String.valueOf(n2) + ", Algorithm: " + string3 + ", Cluster: " + string);
            }
        }
        this.fireDataChanged();
        this.tree.repaint();
        return color;
    }

    private Color storeSubCluster(int[] nArray, Experiment experiment, int n) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Cluster cluster;
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        TreePath treePath = this.tree.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object object = defaultMutableTreeNode2.getUserObject();
        if (!(object instanceof LeafInfo)) {
            return null;
        }
        if (treePath.getPathCount() < 3) {
            return null;
        }
        Color color = null;
        String string = ((LeafInfo)defaultMutableTreeNode2.getUserObject()).toString();
        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)treePath.getPathComponent(2);
        String string2 = (String)defaultMutableTreeNode3.getUserObject();
        if (n == 0) {
            if (this.geneClusterRepository == null) {
                this.geneClusterRepository = new ClusterRepository(this.data.getFeaturesSize(), this.framework, true);
                this.data.setGeneClusterRepository(this.geneClusterRepository);
            }
            if ((cluster = this.geneClusterRepository.storeSubCluster(this.resultCount - 1, string2, string, nArray, defaultMutableTreeNode2, experiment)) != null) {
                color = cluster.getClusterColor();
                if (this.geneClusterManager == null) {
                    this.geneClusterManager = new ClusterTable(this.geneClusterRepository, this.framework);
                    defaultMutableTreeNode = new DefaultMutableTreeNode(new LeafInfo("Gene Clusters", (IViewer)this.geneClusterManager), false);
                    this.addNode(this.clusterNode, defaultMutableTreeNode);
                } else {
                    this.geneClusterManager.onRepositoryChanged(this.geneClusterRepository);
                }
            }
            this.geneClusterRepository.printRepository();
        } else {
            if (this.experimentClusterRepository == null) {
                this.experimentClusterRepository = new ClusterRepository(this.data.getFeaturesCount(), this.framework);
                this.data.setExperimentClusterRepository(this.experimentClusterRepository);
            }
            if ((cluster = this.experimentClusterRepository.storeSubCluster(this.resultCount - 1, string2, string, nArray, defaultMutableTreeNode2, experiment)) != null) {
                color = cluster.getClusterColor();
                if (this.experimentClusterManager == null) {
                    this.experimentClusterManager = new ClusterTable(this.experimentClusterRepository, this.framework);
                    defaultMutableTreeNode = new DefaultMutableTreeNode(new LeafInfo("Sample Clusters", (IViewer)this.experimentClusterManager), false);
                    this.addNode(this.clusterNode, defaultMutableTreeNode);
                } else {
                    this.experimentClusterManager.onRepositoryChanged(this.experimentClusterRepository);
                }
            }
            this.experimentClusterRepository.printRepository();
        }
        if (cluster != null) {
            int n2 = cluster.getSerialNumber();
            String string3 = cluster.getAlgorithmName();
            if (n == 0) {
                this.addHistory("Save Gene Cluster: Serial #: " + String.valueOf(n2) + ", Algorithm: " + string3 + ", Cluster: " + string);
            } else {
                this.addHistory("Save Experiment Cluster: Serial #: " + String.valueOf(n2) + ", Algorithm: " + string3 + ", Cluster: " + string);
            }
        }
        this.fireDataChanged();
        this.tree.repaint();
        return color;
    }

    public void storeOperationCluster(String string, String string2, int[] nArray, boolean bl) {
        ClusterAttributesDialog clusterAttributesDialog = new ClusterAttributesDialog("Store Cluster Attributes", string, string2);
        if (clusterAttributesDialog.showModal() == 0) {
            Cluster cluster;
            if (bl) {
                FloatMatrix floatMatrix = this.data.getFullExperiment().getMatrix();
                Experiment experiment = new Experiment(floatMatrix, nArray);
                ClusterRepository clusterRepository = this.getClusterRepository(0);
                cluster = new Cluster(nArray, string, clusterAttributesDialog.getLabel(), string2, "", clusterAttributesDialog.getDescription(), -1, clusterRepository.takeNextClusterSerialNumber(), clusterAttributesDialog.getColor(), experiment);
                clusterRepository.addCluster(clusterRepository.getClusterOperationsList(), cluster);
                this.geneClusterManager.addCluster(cluster);
            } else {
                Experiment experiment = this.data.getFullExperiment();
                ClusterRepository clusterRepository = this.getClusterRepository(1);
                cluster = new Cluster(nArray, "Search Result", clusterAttributesDialog.getLabel(), "Selected Samples", "", clusterAttributesDialog.getDescription(), -1, clusterRepository.takeNextClusterSerialNumber(), clusterAttributesDialog.getColor(), experiment);
                clusterRepository.addCluster(clusterRepository.getClusterOperationsList(), cluster);
                this.experimentClusterManager.addCluster(cluster);
            }
            if (cluster != null) {
                int n = cluster.getSerialNumber();
                String string3 = cluster.getAlgorithmName();
                if (bl) {
                    this.addHistory("Save Gene Cluster: Serial #: " + String.valueOf(n) + ", Algorithm: " + string3 + ", Cluster: " + string2);
                } else {
                    this.addHistory("Save Experiment Cluster: Serial #: " + String.valueOf(n) + ", Algorithm: " + string3 + ", Cluster: " + string2);
                }
            }
        }
        this.refreshCurrentViewer();
    }

    public boolean removeCluster(int[] nArray, Experiment experiment, int n) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        TreePath treePath = this.tree.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        boolean bl = false;
        if (!(object instanceof LeafInfo)) {
            return bl;
        }
        if (treePath.getPathCount() < 3) {
            return bl;
        }
        String string = ((LeafInfo)defaultMutableTreeNode.getUserObject()).toString();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getPathComponent(2);
        String string2 = (String)defaultMutableTreeNode2.getUserObject();
        if (n == 0) {
            if (this.geneClusterRepository == null) {
                return bl;
            }
            bl = this.geneClusterRepository.removeCluster(nArray, string2, string);
            this.geneClusterManager.onRepositoryChanged(this.geneClusterRepository);
        } else {
            if (this.experimentClusterRepository == null) {
                return bl;
            }
            bl = this.experimentClusterRepository.removeCluster(nArray, string2, string);
            this.experimentClusterManager.onRepositoryChanged(this.experimentClusterRepository);
        }
        if (bl) {
            this.fireDataChanged();
        }
        return bl;
    }

    public boolean removeSubCluster(int[] nArray, Experiment experiment, int n) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        TreePath treePath = this.tree.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        boolean bl = false;
        if (!(object instanceof LeafInfo)) {
            return bl;
        }
        if (treePath.getPathCount() < 3) {
            return bl;
        }
        String string = ((LeafInfo)defaultMutableTreeNode.getUserObject()).toString();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getPathComponent(2);
        String string2 = (String)defaultMutableTreeNode2.getUserObject();
        if (n == 0) {
            if (this.geneClusterRepository == null) {
                return bl;
            }
            bl = this.geneClusterRepository.removeSubCluster(nArray, string2, string);
            this.geneClusterManager.onRepositoryChanged(this.geneClusterRepository);
        } else {
            if (this.experimentClusterRepository == null) {
                return bl;
            }
            bl = this.experimentClusterRepository.removeSubCluster(nArray, string2, string);
            this.experimentClusterManager.onRepositoryChanged(this.experimentClusterRepository);
        }
        if (bl) {
            this.fireDataChanged();
        }
        return bl;
    }

    private void launchNewMAV(int[] nArray, Experiment experiment, String string, int n) {
        if (nArray.length < 1) {
            JOptionPane.showMessageDialog(this.getFrame(), "The selected cluster does not contain any members. The new viewer session has been aborted.", "New Session Abort", 2);
            return;
        }
        MultipleArrayData multipleArrayData = n == 0 ? this.data.getDataSubset(nArray) : this.data.getDataSubset(nArray, experiment.getRowMappingArrayCopy());
        Manager.createNewMultipleArrayViewer(this.menubar, multipleArrayData, string);
        this.addHistory("Launch New MAV: " + string);
    }

    private void openClusterNode(String string, String string2) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.findNode(string, string2);
        if (defaultMutableTreeNode == null) {
            return;
        }
        this.selectNode(defaultMutableTreeNode);
    }

    private DefaultMutableTreeNode findNode(String string, String string2) {
        Object object;
        int n;
        int n2 = this.analysisNode.getChildCount();
        DefaultMutableTreeNode defaultMutableTreeNode = this.analysisNode;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        for (n = 0; n < n2; ++n) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.analysisNode.getChildAt(n);
            object = defaultMutableTreeNode.getUserObject();
            if (object instanceof String && ((String)object).equals(string)) {
                defaultMutableTreeNode2 = defaultMutableTreeNode;
                break;
            }
            if (!(object instanceof LeafInfo) || !((LeafInfo)object).toString().equals(string)) continue;
            defaultMutableTreeNode2 = defaultMutableTreeNode;
            break;
        }
        if (defaultMutableTreeNode2 == null) {
            return null;
        }
        n2 = defaultMutableTreeNode2.getChildCount();
        for (n = 0; n < n2; ++n) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(n);
            object = defaultMutableTreeNode.getUserObject();
            if (object instanceof String && ((String)object).equals(string2)) {
                defaultMutableTreeNode2 = defaultMutableTreeNode;
                break;
            }
            if (!(object instanceof LeafInfo) || !((LeafInfo)object).toString().equals(string)) continue;
            defaultMutableTreeNode2 = defaultMutableTreeNode;
            break;
        }
        if (defaultMutableTreeNode2 != defaultMutableTreeNode) {
            return null;
        }
        return defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getCurrentNode() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        return (DefaultMutableTreeNode)treePath.getLastPathComponent();
    }

    public DefaultMutableTreeNode getNode(Object object) {
        return this.tree.getNode(object);
    }

    public void fireDataLoaded(ISlideData[] iSlideDataArray, int n) {
        if (iSlideDataArray == null || iSlideDataArray.length < 1) {
            return;
        }
        if (this.data.getFieldNames() != null && this.data.getFeaturesCount() < 1) {
            this.menubar.addLabelMenuItems(this.data.getFieldNames());
            this.menubar.addExperimentLabelMenuItems(this.getSlideNameKeyVectorUnion(iSlideDataArray));
            ((MultipleArrayCanvas)this.viewer).addSortMenuItems(this.data.getFieldNames());
            this.menubar.setLabelIndex(0);
            if (TMEV.getDataType() == 2) {
                this.menubar.addAffyFilterMenuItems();
            }
        }
        this.data.addFeatures(iSlideDataArray);
        this.data.setDataType(n);
        if (TMEV.getDataType() == 2 && this.data.getDataType() == 2 && !this.menubar.get_affyNormAdded()) {
            this.menubar.addAffyNormMenuItems();
        }
        if (this.data.getDataType() == 1 || this.data.getDataType() == 2) {
            this.menubar.enableNormalizationMenu(false);
        }
        this.data.setUseMainData(true);
        ((LeafInfo)this.mainViewerNode.getUserObject()).setSelectedDataSource(true);
        this.createDataSelectionNode((DefaultMutableTreeNode)this.tree.getRoot().getChildAt(0), this.data.getExperiment(), this.data.getExperiment().getNumberOfGenes(), 0);
        this.tree.repaint();
        this.setMaxCY3AndCY5();
        this.systemEnable(1003);
        this.viewer.onSelected(this.framework);
        this.fireMenuChanged();
        this.fireDataChanged();
        this.fireHeaderChanged();
        String[] stringArray = new String[iSlideDataArray.length];
        for (int i = 0; i < iSlideDataArray.length; ++i) {
            stringArray[i] = iSlideDataArray[i].getSlideFileName();
            if (i == 0) {
                this.addHistory("Load Data File: " + stringArray[i]);
                continue;
            }
            if (stringArray[i].equals(stringArray[i - 1])) break;
            this.addHistory("Load Data File: " + stringArray[i]);
        }
        if (iSlideDataArray.length > 1) {
            this.addHistory(iSlideDataArray.length + " samples loaded.");
        } else {
            this.addHistory("1 sample loaded.");
        }
        if (iSlideDataArray.length > 0) {
            this.addHistory(iSlideDataArray[0].getSize() + " genes loaded.");
        }
    }

    private Vector getSlideNameKeyVectorUnion(ISlideData[] iSlideDataArray) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < iSlideDataArray.length; ++i) {
            Vector vector2 = iSlideDataArray[i].getSlideDataKeys();
            for (int j = 0; j < vector2.size(); ++j) {
                String string = (String)vector2.elementAt(j);
                if (vector.contains(string)) continue;
                vector.addElement(string);
            }
        }
        return vector;
    }

    private void loadData() {
        SuperExpressionFileLoader superExpressionFileLoader = new SuperExpressionFileLoader(this);
        Date date = new Date(System.currentTimeMillis());
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        dateFormat.setTimeZone(TimeZone.getDefault());
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(dateFormat.format(date));
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        defaultTreeModel.insertNodeInto(defaultMutableTreeNode, this.analysisNode, this.analysisNode.getChildCount());
    }

    protected ClusterRepository getClusterRepository(int n) {
        if (n == 0) {
            if (this.geneClusterRepository == null) {
                this.geneClusterRepository = new ClusterRepository(this.data.getFeaturesSize(), this.framework, true);
                this.data.setGeneClusterRepository(this.geneClusterRepository);
            }
            if (this.geneClusterManager == null) {
                this.geneClusterManager = new ClusterTable(this.geneClusterRepository, this.framework);
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new LeafInfo("Gene Clusters", (IViewer)this.geneClusterManager), false);
                this.addNode(this.clusterNode, defaultMutableTreeNode);
            }
            return this.geneClusterRepository;
        }
        if (this.experimentClusterRepository == null) {
            this.experimentClusterRepository = new ClusterRepository(this.data.getFeaturesCount(), this.framework);
            this.data.setExperimentClusterRepository(this.experimentClusterRepository);
        }
        if (this.experimentClusterManager == null) {
            this.experimentClusterManager = new ClusterTable(this.experimentClusterRepository, this.framework);
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new LeafInfo("Sample Clusters", (IViewer)this.experimentClusterManager), false);
            this.addNode(this.clusterNode, defaultMutableTreeNode);
        }
        return this.experimentClusterRepository;
    }

    protected ResultTree getResultTree() {
        return this.tree;
    }

    private void search() {
        SearchDialog searchDialog = new SearchDialog(this.getFrame(), this.data.getFieldNames(), this.data.getSlideNameKeyArray());
        if (searchDialog.showModal() == 0) {
            AlgorithmData algorithmData = searchDialog.getSearchCriteria();
            AlgorithmParameters algorithmParameters = algorithmData.getParams();
            boolean bl = algorithmParameters.getBoolean("gene-search");
            boolean bl2 = algorithmParameters.getBoolean("case-sensitive");
            boolean bl3 = algorithmParameters.getBoolean("full-term");
            String string = algorithmParameters.getString("search-term");
            String[] stringArray = algorithmData.getStringArray("field-names");
            ResultTree resultTree = this.framework.getResultTree();
            int[] nArray = this.data.search(algorithmData);
            if (nArray.length > 0) {
                Vector vector = resultTree.findViewerCollection(nArray, algorithmData.getParams().getBoolean("gene-search"));
                if (vector != null) {
                    Vector vector2 = (Vector)vector.elementAt(0);
                    Hashtable hashtable = (Hashtable)vector.elementAt(1);
                    Hashtable hashtable2 = (Hashtable)vector.elementAt(2);
                    DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Search Result Shortcuts");
                    for (int i = 0; i < vector2.size(); ++i) {
                        defaultMutableTreeNode.add((DefaultMutableTreeNode)vector2.elementAt(i));
                    }
                    JTree jTree = new JTree(defaultMutableTreeNode);
                    jTree.setCellRenderer(resultTree.getCellRenderer());
                    SearchResultDialog searchResultDialog = new SearchResultDialog(this.framework, algorithmData, jTree, hashtable, hashtable2, nArray);
                    searchResultDialog.showModal();
                } else {
                    SearchResultDialog searchResultDialog = new SearchResultDialog(this.framework, algorithmData, nArray);
                    searchResultDialog.showModal();
                }
            } else {
                if (bl) {
                    JOptionPane.showMessageDialog(this.framework.getFrame(), "No genes matching the search criteria were found.", "Empty Search Result", 1);
                } else {
                    JOptionPane.showMessageDialog(this.framework.getFrame(), "No samples matching the search criteria were found.", "Empty Search Result", 1);
                }
                return;
            }
        }
    }

    private void refreshCurrentViewer() {
        IViewer iViewer;
        TreePath treePath = this.tree.getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof LeafInfo && (iViewer = ((LeafInfo)object).getViewer()) != null) {
            iViewer.onSelected(this.framework);
        }
    }

    private void onImportList(int n) {
        ClusterRepository clusterRepository = this.getClusterRepository(n);
        Cluster cluster = clusterRepository.createClusterFromList();
        if (cluster != null) {
            if (n == 0) {
                this.geneClusterManager.onRepositoryChanged(clusterRepository);
                this.addHistory("Save Gene Cluster: Serial #: " + cluster.getSerialNumber() + ", Source: List Import");
            } else {
                this.experimentClusterManager.onRepositoryChanged(clusterRepository);
                this.addHistory("Save Sample Cluster: Serial #: " + cluster.getSerialNumber() + ", Source: List Import");
            }
            this.refreshCurrentViewer();
        }
    }

    private void appendSampleAnnotation() {
        String string = "<html><center><h1>Import Sample Annotation</h1></center>";
        string = string + "The sample annotation file should be a tab-delimited text file containing one header row for annotation labels (field names).";
        string = string + "The file may contain multiple columns of annotation with each column containing a header entry that indicates the nature of the annotation.";
        string = string + "The annotation for each sample is organized in rows corresponding to the order of the loaded samples.";
        string = string + "If annotation is missing for a sample the entry in that sample row may be left blank.  Please see the manual appendix on file formats for more information. </html>";
        HTMLMessageFileChooser hTMLMessageFileChooser = new HTMLMessageFileChooser((Frame)this.getFrame(), "Sample Annotation File Selection", string, TMEV.getFile("data"), true);
        hTMLMessageFileChooser.setApproveButtonText("Load");
        hTMLMessageFileChooser.setSize(500, 600);
        if (hTMLMessageFileChooser.showModal() == 0) {
            File file = hTMLMessageFileChooser.getSelectedFile();
            try {
                if (this.data.addNewSampleLabels(this.getFrame(), file)) {
                    this.menubar.replaceExperimentLabelMenuItems(this.data.getSlideNameKeyArray());
                }
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this.getFrame(), "Error processing sample annotation file. Check file format.", "Sample Annotation Input Error", 0);
            }
        }
    }

    private void appendGeneAnnotation() {
        String string = "<html><center><h1>Import Gene Annotation</h1></center>";
        string = string + "Please select an annotation file to import.  The file should contain a column that can be used ";
        string = string + "to map annotation in the file to the proper genes.  After file selection you will be asked to identify ";
        string = string + "a key from the data and from the input file to be used to insure proper mapping of annotation. ";
        string = string + "Note that this file format should conform the MeV annotation file format conventions (.ann) file ";
        string = string + "described in the appendix of the manual</html>";
        HTMLMessageFileChooser hTMLMessageFileChooser = new HTMLMessageFileChooser((Frame)this.getFrame(), "Gene Annotation File Selection", string, TMEV.getFile("data"), true);
        hTMLMessageFileChooser.setFileFilter((FileFilter)new AnnFileFilter());
        hTMLMessageFileChooser.setApproveButtonText("Load");
        hTMLMessageFileChooser.setSize(500, 600);
        if (hTMLMessageFileChooser.showModal() == 0) {
            File file = hTMLMessageFileChooser.getSelectedFile();
            try {
                AnnFileParser annFileParser = new AnnFileParser();
                annFileParser.loadFile(file);
                String[][] stringArray = null;
                if (!annFileParser.isAnnFileLoaded()) {
                    JOptionPane.showMessageDialog(this.getFrame(), "Error processing gene annotation file. Please check file format.", "Sample Annotation Input Error", 0);
                    return;
                }
                Vector vector = annFileParser.getColumnHeaders();
                stringArray = annFileParser.getDataMatrix(true);
                String[] stringArray2 = this.data.getFieldNames();
                String[] stringArray3 = new String[stringArray2.length + 1];
                stringArray3[0] = "UID";
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray3[i + 1] = stringArray2[i];
                }
                GeneAnnotationImportDialog geneAnnotationImportDialog = new GeneAnnotationImportDialog(this.getFrame(), stringArray3, stringArray[0]);
                if (geneAnnotationImportDialog.showModal() == 0) {
                    String[] stringArray4 = geneAnnotationImportDialog.getSelectedAnnotationFields();
                    int n = this.data.addNewGeneAnnotation(stringArray, geneAnnotationImportDialog.getDataAnnotationKey(), geneAnnotationImportDialog.getFileAnnotationKey(), stringArray4);
                    if (n > 0) {
                        TMEV.appendFieldNames(stringArray4);
                        this.menubar.replaceLabelMenuItems(this.data.getFieldNames());
                        String string2 = "New Gene Annotation\n";
                        string2 = string2 + "Annotation File = " + file.getAbsolutePath() + "\n";
                        string2 = string2 + "New Annotation Fields: ";
                        for (int i = 0; i < stringArray4.length; ++i) {
                            string2 = string2 + stringArray4[i];
                            if (i >= stringArray4.length - 1) continue;
                            string2 = string2 + ", ";
                        }
                        this.addHistory(string2);
                        JOptionPane.showMessageDialog(this.getFrame(), "<html>Gene annotation has been successfully added.<br>Check the history node for field information.</html>", "Append Gene Annotation", 1);
                    } else {
                        String string3 = "<html>Gene annotation addition has failed.  The identifying keys in the loaded data (" + geneAnnotationImportDialog.getDataAnnotationKey() + ")<br>";
                        string3 = string3 + "and the keys in the file (" + geneAnnotationImportDialog.getFileAnnotationKey() + ") did not have any matches.<br<br>The new annotation could not be mapped to the data.</html>";
                        JOptionPane.showMessageDialog(this.getFrame(), string3, "Append Gene Annotation", 1);
                    }
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.getFrame(), "Error processing gene annotation file. Please check file format.", "Sample Annotation Input Error", 0);
                exception.printStackTrace();
            }
        }
    }

    private class FrameworkImpl
    implements IFramework,
    Serializable {
        public static final long serialVersionUID = 10201020001L;

        private FrameworkImpl() {
        }

        public IData getData() {
            return MultipleArrayViewer.this.getData();
        }

        public AlgorithmFactory getAlgorithmFactory() {
            return MultipleArrayViewer.this.getAlgorithmFactory();
        }

        public IDisplayMenu getDisplayMenu() {
            return MultipleArrayViewer.this.menubar.getDisplayMenu();
        }

        public IDistanceMenu getDistanceMenu() {
            return MultipleArrayViewer.this.menubar.getDistanceMenu();
        }

        public Frame getFrame() {
            return MultipleArrayViewer.this.getFrame();
        }

        public void setContentLocation(int n, int n2) {
            MultipleArrayViewer.this.setContentLocation(n, n2);
        }

        public void displaySingleArrayViewer(int n) {
            MultipleArrayViewer.this.displaySingleArrayViewer(n);
        }

        public void displaySlideElementInfo(int n, int n2) {
            MultipleArrayViewer.this.displaySlideElementInfo(n, n2);
        }

        public String getStatusText() {
            return MultipleArrayViewer.this.getStatusText();
        }

        public void setStatusText(String string) {
            MultipleArrayViewer.this.setStatusText(string);
        }

        public Object getUserObject() {
            return MultipleArrayViewer.this.getUserObject();
        }

        public void setTreeNode(DefaultMutableTreeNode defaultMutableTreeNode) {
            MultipleArrayViewer.this.selectNode(defaultMutableTreeNode);
        }

        public void addNode(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
            MultipleArrayViewer.this.addNode(defaultMutableTreeNode, defaultMutableTreeNode2);
        }

        public Color storeCluster(int[] nArray, Experiment experiment, int n) {
            return MultipleArrayViewer.this.storeCluster(nArray, experiment, n);
        }

        public Color storeSubCluster(int[] nArray, Experiment experiment, int n) {
            return MultipleArrayViewer.this.storeSubCluster(nArray, experiment, n);
        }

        public boolean removeSubCluster(int[] nArray, Experiment experiment, int n) {
            return MultipleArrayViewer.this.removeSubCluster(nArray, experiment, n);
        }

        public boolean removeCluster(int[] nArray, Experiment experiment, int n) {
            return MultipleArrayViewer.this.removeCluster(nArray, experiment, n);
        }

        public void launchNewMAV(int[] nArray, Experiment experiment, String string, int n) {
            MultipleArrayViewer.this.launchNewMAV(nArray, experiment, string, n);
        }

        public void openClusterNode(String string, String string2) {
            MultipleArrayViewer.this.openClusterNode(string, string2);
        }

        public ClusterRepository getClusterRepository(int n) {
            return MultipleArrayViewer.this.getClusterRepository(n);
        }

        public DefaultMutableTreeNode getCurrentNode() {
            return MultipleArrayViewer.this.getCurrentNode();
        }

        public DefaultMutableTreeNode getNode(Object object) {
            return MultipleArrayViewer.this.getNode(object);
        }

        public void addHistory(String string) {
            MultipleArrayViewer.this.addHistory(string);
        }

        public ResultTree getResultTree() {
            return MultipleArrayViewer.this.getResultTree();
        }

        public void addAnalysisResult(DefaultMutableTreeNode defaultMutableTreeNode) {
            MultipleArrayViewer.this.addAnalysisResult(defaultMutableTreeNode);
        }

        public void refreshCurrentViewer() {
            MultipleArrayViewer.this.refreshCurrentViewer();
        }

        public void storeOperationCluster(String string, String string2, int[] nArray, boolean bl) {
            MultipleArrayViewer.this.storeOperationCluster(string, string2, nArray, bl);
        }
    }

    private class EventListener
    extends MouseAdapter
    implements ActionListener,
    TreeSelectionListener,
    KeyListener,
    WindowListener,
    Serializable {
        private EventListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("command-close")) {
                MultipleArrayViewer.this.onClose();
            } else if (string.equals("command-load-file")) {
                MultipleArrayViewer.this.onLoadFile();
            } else if (!string.equals("command-load-expression")) {
                if (string.equals("command-load-directory")) {
                    MultipleArrayViewer.this.onLoadDirectory();
                } else if (string.equals("command-load")) {
                    MultipleArrayViewer.this.loadData();
                } else if (string.equals("command-load-cluster")) {
                    MultipleArrayViewer.this.onLoadCluster();
                } else if (string.equals("command-load-stanford")) {
                    MultipleArrayViewer.this.onLoadStanford();
                } else if (string.equals("command-load-db")) {
                    MultipleArrayViewer.this.onLoadDatabase();
                } else if (string.equals("toggle-abbr-expt-names-cmd")) {
                    MultipleArrayViewer.this.data.toggleExptNameLength();
                    MultipleArrayViewer.this.fireDataChanged();
                    MultipleArrayViewer.this.fireMenuChanged();
                    MultipleArrayViewer.this.fireHeaderChanged();
                    MultipleArrayViewer.this.doViewLayout();
                } else if (string.equals("display-label-cmd")) {
                    MultipleArrayViewer.this.onLabelChanged((Action)actionEvent.getSource());
                } else if (string.equals("display-experiment-label-cmd")) {
                    MultipleArrayViewer.this.onExperimentLabelChanged((Action)actionEvent.getSource());
                } else if (string.equals("add-new-experiment-label")) {
                    MultipleArrayViewer.this.onExperimentLabelAdded();
                } else if (string.equals("display-10x10-cmd")) {
                    MultipleArrayViewer.this.onElementSizeChanged(10, 10);
                } else if (string.equals("display-20x5-cmd")) {
                    MultipleArrayViewer.this.onElementSizeChanged(20, 5);
                } else if (string.equals("display-50x10-cmd")) {
                    MultipleArrayViewer.this.onElementSizeChanged(50, 10);
                } else if (string.equals("display-5x2-cmd")) {
                    MultipleArrayViewer.this.onElementSizeChanged(5, 2);
                } else if (string.equals("display-other-cmd")) {
                    MultipleArrayViewer.this.onElementSizeChanged();
                } else if (string.equals("display-green-red-scheme-cmd")) {
                    MultipleArrayViewer.this.onColorSchemeChange(5);
                } else if (string.equals("display-blue-yellow-scheme-cmd")) {
                    MultipleArrayViewer.this.onColorSchemeChange(6);
                } else if (string.equals("display-rainbow-scheme-cmd")) {
                    MultipleArrayViewer.this.onColorSchemeChange(8);
                } else if (string.equals("display-custom-color-scheme-cmd")) {
                    MultipleArrayViewer.this.onColorSchemeChange(7);
                } else if (string.equals("display-color-gradient-cmd")) {
                    MultipleArrayViewer.this.onColorGradientChange(((JCheckBoxMenuItem)actionEvent.getSource()).isSelected());
                } else if (string.equals("display-draw-borders-cmd")) {
                    MultipleArrayViewer.this.onDrawBorders();
                } else if (string.equals("system-info-cmd")) {
                    MultipleArrayViewer.this.onSystemInfo();
                } else if (string.equals("default-distances-cmd")) {
                    MultipleArrayViewer.this.onDefaultDistance();
                } else if (string.equals("total-intensity-cmd")) {
                    MultipleArrayViewer.this.onNormalize(1);
                } else if (string.equals("linear-regression-cmd")) {
                    MultipleArrayViewer.this.onNormalize(3);
                } else if (string.equals("ratio-statistics-cmd")) {
                    MultipleArrayViewer.this.onNormalize(5);
                } else if (string.equals("iterative-log-cmd")) {
                    MultipleArrayViewer.this.onNormalize(6);
                } else if (string.equals("total-intensity-list-cmd")) {
                    MultipleArrayViewer.this.onNormalizeList(101);
                } else if (string.equals("linear-regression-list-cmd")) {
                    MultipleArrayViewer.this.onNormalizeList(103);
                } else if (string.equals("ratio-statistics-list-cmd")) {
                    MultipleArrayViewer.this.onNormalizeList(105);
                } else if (string.equals("iterative-log-list-cmd")) {
                    MultipleArrayViewer.this.onNormalizeList(106);
                } else if (string.equals("no-normalization-cmd")) {
                    MultipleArrayViewer.this.onNormalize(0);
                } else if (string.equals("command-save-image")) {
                    MultipleArrayViewer.this.onSaveImage();
                } else if (string.equals("command-print-image")) {
                    MultipleArrayViewer.this.onPrintImage();
                } else if (string.equals("analysis-command")) {
                    MultipleArrayViewer.this.onAnalysis((Action)actionEvent.getSource());
                } else if (string.equals("default-distance-cmd")) {
                    MultipleArrayViewer.this.menubar.setDistanceFunction(0);
                } else if (string.equals("pearson-correlation-cmd")) {
                    MultipleArrayViewer.this.menubar.setDistanceFunction(1);
                } else if (string.equals("pearson-uncentered-cmd")) {
                    MultipleArrayViewer.this.menubar.setDistanceFunction(6);
                } else if (string.equals("pearson-squared-cmd")) {
                    MultipleArrayViewer.this.menubar.setDistanceFunction(7);
                } else if (string.equals("cosine-correlation-cmd")) {
                    MultipleArrayViewer.this.menubar.setDistanceFunction(2);
                } else if (string.equals("covariance-value-cmd")) {
                    MultipleArrayViewer.this.menubar.setDistanceFunction(3);
                } else if (string.equals("euclidean-distance-cmd")) {
                    MultipleArrayViewer.this.menubar.setDistanceFunction(4);
                } else if (string.equals("average-dot-product-cmd")) {
                    MultipleArrayViewer.this.menubar.setDistanceFunction(5);
                } else if (string.equals("manhattan-distance-cmd")) {
                    MultipleArrayViewer.this.menubar.setDistanceFunction(8);
                } else if (string.equals("mutual-information-cmd")) {
                    MultipleArrayViewer.this.menubar.setDistanceFunction(11);
                } else if (string.equals("spearman-rank-correlation-cmd")) {
                    MultipleArrayViewer.this.menubar.setDistanceFunction(9);
                } else if (string.equals("kendalls-tau-cmd")) {
                    MultipleArrayViewer.this.menubar.setDistanceFunction(10);
                } else if (string.equals("absolute-distance-cmd")) {
                    MultipleArrayViewer.this.menubar.setDistanceAbsolute(((AbstractButton)actionEvent.getSource()).isSelected());
                } else if (string.equals("delete-node-cmd")) {
                    MultipleArrayViewer.this.onDeleteNode();
                } else if (string.equals("set-data-source-command")) {
                    Object object = actionEvent.getSource();
                    if (object instanceof JCheckBoxMenuItem) {
                        MultipleArrayViewer.this.onSetData(((JCheckBoxMenuItem)actionEvent.getSource()).isSelected());
                    } else {
                        MultipleArrayViewer.this.onSetData(true);
                    }
                } else if (string.equals("use-percentage-cutoffs-cmd")) {
                    MultipleArrayViewer.this.applyPercentageCutoffs();
                } else if (string.equals("use-lower-cutoffs-cmd")) {
                    MultipleArrayViewer.this.applyLowerCutoffs();
                } else if (string.equals("use-variance-filter-cmd")) {
                    MultipleArrayViewer.this.applyVarianceFilter();
                } else if (string.equals("import-gene-list-command")) {
                    MultipleArrayViewer.this.onImportList(0);
                } else if (string.equals("import-sample-list-command")) {
                    MultipleArrayViewer.this.onImportList(1);
                } else if (string.equals("set-detection-filter-cmd")) {
                    MultipleArrayViewer.this.onSetDetectionFilter();
                } else if (string.equals("set-fold-filter-cmd")) {
                    MultipleArrayViewer.this.onSetFoldFilter();
                } else if (string.equals("use-detection-filter-cmd")) {
                    MultipleArrayViewer.this.onUseDetectionFilter((AbstractButton)actionEvent.getSource());
                } else if (string.equals("use-fold-filter-cmd")) {
                    MultipleArrayViewer.this.onUseFoldFilter((AbstractButton)actionEvent.getSource());
                } else if (string.equals("divide-genes-median-cmd")) {
                    MultipleArrayViewer.this.onDivideGenesMedian();
                } else if (string.equals("divide-genes-mean-cmd")) {
                    MultipleArrayViewer.this.onDivideGenesMean();
                } else if (string.equals("log2-transform-cmd")) {
                    MultipleArrayViewer.this.onLog2Transform();
                } else if (string.equals("normalize-spots-cmd")) {
                    MultipleArrayViewer.this.onNormalizeSpots();
                } else if (string.equals("divide-spots-rms-cmd")) {
                    MultipleArrayViewer.this.onDivideSpotsRMS();
                } else if (string.equals("divide-spots-sd-cmd")) {
                    MultipleArrayViewer.this.onDivideSpotsSD();
                } else if (string.equals("mean-center-spots-cmd")) {
                    MultipleArrayViewer.this.onMeanCenterSpots();
                } else if (string.equals("median-center-spots-cmd")) {
                    MultipleArrayViewer.this.onMedianCenterSpots();
                } else if (string.equals("digital-spots-cmd")) {
                    MultipleArrayViewer.this.onDigitalSpots();
                } else if (string.equals("normalize-experiments-cmd")) {
                    MultipleArrayViewer.this.onNormalizeExperiments();
                } else if (string.equals("divide-experiments-rms-cmd")) {
                    MultipleArrayViewer.this.onDivideExperimentsRMS();
                } else if (string.equals("divide-experiments-sd-cmd")) {
                    MultipleArrayViewer.this.onDivideExperimentsSD();
                } else if (string.equals("mean-center-experiments-cmd")) {
                    MultipleArrayViewer.this.onMeanCenterExperiments();
                } else if (string.equals("median-center-experiments-cmd")) {
                    MultipleArrayViewer.this.onMedianCenterExperiments();
                } else if (string.equals("digital-experiments-cmd")) {
                    MultipleArrayViewer.this.onDigitalExperiments();
                } else if (string.equals("log10-to-log2-cmd")) {
                    MultipleArrayViewer.this.onLog10toLog2();
                } else if (string.equals("adjust-intensities-0-cmd")) {
                    MultipleArrayViewer.this.onAdjustIntensities((AbstractButton)actionEvent.getSource());
                } else if (string.equals("command-save-matrix")) {
                    MultipleArrayViewer.this.onSaveMatrix();
                } else if (string.equals("display-set-ratio-scale-cmd")) {
                    MultipleArrayViewer.this.onSetRatioScale();
                } else if (string.equals("delete-all-experiments-cmd")) {
                    MultipleArrayViewer.this.onDeleteAllExperimentClusters();
                } else if (string.equals("delete-all-cmd")) {
                    MultipleArrayViewer.this.onDeleteAll();
                } else if (string.equals("command-load-analysis")) {
                    MultipleArrayViewer.this.loadAnalysis();
                } else if (string.equals("command-save-analysis")) {
                    MultipleArrayViewer.this.saveAnalysis();
                } else if (string.equals("command-save-analysis-as")) {
                    MultipleArrayViewer.this.saveAnalysisAs();
                } else if (string.equals("command-new-script")) {
                    MultipleArrayViewer.this.onNewScript();
                } else if (string.equals("command-load-script")) {
                    MultipleArrayViewer.this.onLoadScript();
                } else if (string.equals("search-cmd")) {
                    MultipleArrayViewer.this.search();
                } else if (string.equals("append-sample-annotation-command")) {
                    MultipleArrayViewer.this.appendSampleAnnotation();
                } else if (string.equals("append-gene-annotation-command")) {
                    MultipleArrayViewer.this.appendGeneAnnotation();
                } else {
                    System.out.println("unhandled command = " + string);
                }
            }
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            MultipleArrayViewer.this.onNodeChanged(treeSelectionEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                return;
            }
            TreePath treePath = MultipleArrayViewer.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            MultipleArrayViewer.this.tree.setSelectionPaths(new TreePath[]{treePath});
            JPopupMenu jPopupMenu = null;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof LeafInfo) {
                jPopupMenu = ((LeafInfo)object).getJPopupMenu();
            }
            if (treePath.getPathCount() > 2) {
                if (defaultMutableTreeNode.getParent() == MultipleArrayViewer.this.clusterNode) {
                    return;
                }
                if (jPopupMenu == null) {
                    jPopupMenu = new JPopupMenu();
                    if (object instanceof LeafInfo) {
                        IViewer iViewer = ((LeafInfo)object).getViewer();
                        if (iViewer == null) {
                            jPopupMenu.add(this.createDeleteMenuItem());
                        } else if (iViewer instanceof IViewer && iViewer.getClusters() != null && iViewer.getExperiment() != null && iViewer.getViewerType() != -1) {
                            jPopupMenu.add(this.createDeleteMenuItem());
                            jPopupMenu.addSeparator();
                            jPopupMenu.add(this.createSetDataMenuItem(((LeafInfo)object).isSelectedDataSource()));
                        }
                    } else {
                        jPopupMenu.add(this.createDeleteMenuItem());
                    }
                } else if (!this.isContainsDeleteItem(jPopupMenu)) {
                    jPopupMenu.addSeparator();
                    jPopupMenu.add(this.createDeleteMenuItem());
                }
            } else if (((LeafInfo)object).toString().equals("Main View") && MultipleArrayViewer.this.data.getFeaturesCount() != 0) {
                jPopupMenu = new JPopupMenu();
                JMenuItem jMenuItem = new JMenuItem("Set as Data Source");
                jMenuItem.setActionCommand("set-data-source-command");
                jMenuItem.addActionListener(this);
                jPopupMenu.add(jMenuItem);
            }
            if (jPopupMenu != null) {
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private JMenuItem createDeleteMenuItem() {
            JMenuItem jMenuItem = new JMenuItem("Delete");
            jMenuItem.setActionCommand("delete-node-cmd");
            jMenuItem.addActionListener(this);
            return jMenuItem;
        }

        private JCheckBoxMenuItem createSetDataMenuItem(boolean bl) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Set as Data Source", bl);
            jCheckBoxMenuItem.setActionCommand("set-data-source-command");
            jCheckBoxMenuItem.addActionListener(this);
            return jCheckBoxMenuItem;
        }

        private boolean isContainsDeleteItem(JPopupMenu jPopupMenu) {
            Component[] componentArray = jPopupMenu.getComponents();
            int n = componentArray.length;
            while (--n >= 0) {
                if (!(componentArray[n] instanceof JMenuItem) || !((JMenuItem)componentArray[n]).getActionCommand().equals("delete-node-cmd")) continue;
                return true;
            }
            return false;
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            MultipleArrayViewer.this.onClose();
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }
    }
}

