/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import org.tigr.microarray.mev.action.ActionManager;

public class MultipleArrayToolbar
extends JToolBar {
    public MultipleArrayToolbar(ActionManager actionManager) {
        this.addAlgorithmActions(actionManager);
    }

    private void addAlgorithmActions(ActionManager actionManager) {
        Action action;
        int n = 0;
        while ((action = actionManager.getAction("analysis-action" + String.valueOf(n))) != null) {
            this.add(action);
            if (n == 3 || n == 10 || n == 15 || n == 18 || n == 22) {
                this.addSeparator();
            }
            ++n;
        }
    }

    public JButton add(Action action) {
        JButton jButton = super.add(action);
        jButton.setActionCommand((String)action.getValue("ActionCommandKey"));
        jButton.setIcon((Icon)action.getValue("LargeIcon"));
        jButton.setFocusPainted(false);
        return jButton;
    }

    private AbstractButton[] getButtons(String string) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof AbstractButton) || !((AbstractButton)componentArray[i]).getActionCommand().equals(string)) continue;
            arrayList.add(componentArray[i]);
        }
        return arrayList.toArray(new AbstractButton[arrayList.size()]);
    }

    private void setEnable(String string, boolean bl) {
        AbstractButton[] abstractButtonArray = this.getButtons(string);
        if (abstractButtonArray == null || abstractButtonArray.length < 1) {
            return;
        }
        for (int i = 0; i < abstractButtonArray.length; ++i) {
            abstractButtonArray[i].setEnabled(bl);
        }
    }

    public void systemDisable(int n) {
        switch (n) {
            case 1000: {
                this.setEnable("command-load-db", false);
                this.setEnable("command-load-file", false);
                this.setEnable("command-load-expression", false);
                this.setEnable("command-load-directory", false);
                break;
            }
            case 1003: {
                this.setEnable("command-load-db", false);
                this.setEnable("command-save-image", false);
                this.setEnable("command-print-image", false);
                this.setEnable("analysis-command", false);
                break;
            }
            case 1001: {
                this.setEnable("command-load-db", false);
                break;
            }
            case 1002: {
                this.setEnable("command-load-db", false);
            }
        }
    }

    public void systemEnable(int n) {
        switch (n) {
            case 1000: {
                this.setEnable("command-load-file", true);
                this.setEnable("command-load-directory", true);
                this.setEnable("command-load-expression", true);
                break;
            }
            case 1003: {
                this.setEnable("command-save-image", true);
                this.setEnable("command-print-image", true);
                this.setEnable("analysis-command", true);
                break;
            }
            case 1001: {
                break;
            }
            case 1002: {
                this.setEnable("command-load-db", true);
            }
        }
    }
}

