/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.IData;

public class MultipleArrayHeader
extends JPanel {
    private IData data;
    private Insets insets;
    private int contentWidth;
    private int elementWidth = 20;
    private boolean isAntiAliasing = true;
    private boolean isTracing = false;
    private int tracespace;
    private final int RECT_HEIGHT = 15;
    BufferedImage negColorImage;
    BufferedImage posColorImage;
    private float maxValue;
    private float minValue;
    private float midValue;
    private boolean useDoubleGradient = true;

    public MultipleArrayHeader(Insets insets, int n) {
        this.setBackground(Color.white);
        this.insets = insets;
        this.tracespace = n;
        this.maxValue = 3.0f;
        this.minValue = -3.0f;
        this.midValue = 0.0f;
    }

    public void setData(IData iData) {
        this.data = iData;
        this.updateSize();
        this.repaint();
    }

    public void setAntiAliasing(boolean bl) {
        this.isAntiAliasing = bl;
    }

    void setElementWidth(int n) {
        this.elementWidth = n;
        this.setFontSize(n);
        this.updateSize();
        this.repaint();
    }

    void setContentWidth(int n) {
        this.contentWidth = n;
        this.repaint();
    }

    public void setUseDoubleGradient(boolean bl) {
        this.useDoubleGradient = bl;
    }

    public void setMinAndMaxRatios(float f, float f2) {
        this.minValue = f;
        this.maxValue = f2;
        this.repaint();
    }

    public void setMinAndMaxAndMidRatios(float f, float f2, float f3) {
        this.minValue = f;
        this.midValue = f2;
        this.maxValue = f3;
        this.repaint();
    }

    public void setNegativeAndPositiveColorImages(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.negColorImage = bufferedImage;
        this.posColorImage = bufferedImage2;
    }

    void setTracing(boolean bl) {
        this.isTracing = bl;
    }

    private int getSpacing() {
        if (this.isTracing) {
            return this.tracespace;
        }
        return 0;
    }

    private void setFontSize(int n) {
        if (n > 12) {
            n = 12;
        }
        this.setFont(new Font("monospaced", 0, n));
    }

    void updateSize() {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        if (graphics2D == null) {
            return;
        }
        if (this.isAntiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = 0;
        int n2 = this.data.getFeaturesCount();
        for (int i = 0; i < n2; ++i) {
            String string = this.data.getSampleName(i);
            n = Math.max(n, fontMetrics.stringWidth(string));
        }
        this.setSize(this.contentWidth, n + 10 + this.RECT_HEIGHT + fontMetrics.getHeight());
        this.setPreferredSize(new Dimension(this.contentWidth, n + 10 + this.RECT_HEIGHT + fontMetrics.getHeight()));
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.data == null || this.data.getFeaturesCount() == 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = !this.isTracing ? this.data.getFeaturesCount() * this.elementWidth : (this.data.getFeaturesCount() - 1) * (this.elementWidth + this.getSpacing()) + this.elementWidth;
        if (this.useDoubleGradient) {
            graphics2D.drawImage(this.negColorImage, this.insets.left, 0, (int)((float)n / 2.0f), 15, null);
            graphics2D.drawImage(this.posColorImage, (int)((float)n / 2.0f) + this.insets.left, 0, (int)((double)n / 2.0), 15, null);
        } else {
            graphics2D.drawImage(this.posColorImage, this.insets.left, 0, n, 15, null);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n2 = fontMetrics.getDescent();
        int n3 = fontMetrics.getHeight();
        graphics2D.setColor(Color.black);
        if (this.isAntiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        graphics2D.drawString(String.valueOf(this.minValue), this.insets.left, 15 + n3);
        int n4 = fontMetrics.stringWidth(String.valueOf(this.midValue));
        if (this.useDoubleGradient) {
            graphics2D.drawString(String.valueOf(this.midValue), (int)((float)n / 2.0f) - n4 / 2 + this.insets.left, 15 + n3);
        }
        n4 = fontMetrics.stringWidth(String.valueOf(this.maxValue));
        graphics2D.drawString(String.valueOf(this.maxValue), n - n4 + this.insets.left, 15 + n3);
        this.drawColumnHeaders(graphics2D);
    }

    private void drawColumnHeaders(Graphics2D graphics2D) {
        int n = this.data.getFeaturesCount();
        if (n == 0) {
            return;
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n2 = fontMetrics.getDescent();
        graphics2D.rotate(-1.5707963267948966);
        for (int i = 0; i < n; ++i) {
            String string = this.data.getSampleName(i);
            graphics2D.drawString(string, this.insets.bottom - this.getSize().height + 5, this.insets.left + n2 + (this.elementWidth + this.getSpacing()) * i + this.elementWidth / 2);
        }
        graphics2D.rotate(1.5707963267948966);
    }
}

