/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.tigr.microarray.mev.DetectionFilter;
import org.tigr.microarray.mev.FloatSlideData;
import org.tigr.microarray.mev.FoldFilter;
import org.tigr.microarray.mev.ISlideData;
import org.tigr.microarray.mev.ISlideDataElement;
import org.tigr.microarray.mev.ISlideMetaData;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.microarray.mev.SlideData;
import org.tigr.microarray.mev.SlideDataElement;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.normalization.IterativeLogMCNormInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.normalization.LinRegNormInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.normalization.RatioStatsNormInitDialog;
import org.tigr.microarray.util.Adjustment;
import org.tigr.microarray.util.SlideDataSorter;
import org.tigr.midas.engine.Parameter;
import org.tigr.util.FloatMatrix;
import org.tigr.util.QSort;

public class MultipleArrayData
implements IData,
Serializable {
    public static final long serialVersionUID = 100010201040002L;
    private ArrayList featuresList = new ArrayList();
    private ArrayList indicesList = new ArrayList();
    private ArrayList spotColors = new ArrayList();
    private int[] colorIndices;
    private ArrayList experimentColors = new ArrayList();
    private int[] experimentColorIndices;
    private Experiment experiment = null;
    private int dataType;
    private float maxCy3 = 0.0f;
    private float maxCy5 = 0.0f;
    private float maxRatio = 0.0f;
    private float minRatio = 0.0f;
    private float percentageCutoff = 0.0f;
    private boolean usePercentageCutoff = false;
    private boolean useVarianceFilter = false;
    private Properties varianceFilterProps;
    private float lowerCY3Cutoff = 0.0f;
    private float lowerCY5Cutoff = 0.0f;
    private boolean useLowerCutoffs = false;
    private Progress progressBar;
    private boolean normalizationAbort = false;
    private DetectionFilter detectionFilter;
    private FoldFilter foldFilter;
    private boolean useDetectionFilter = false;
    private boolean dfSet = false;
    private boolean ffSet = false;
    private boolean useFoldFilter = false;
    private ClusterRepository geneClusterRepository;
    private ClusterRepository expClusterRepository;
    private int logState = 1;
    private boolean isMedianIntensities = false;
    private boolean useMainData = true;
    private Experiment alternateExperiment = null;

    public void setFeaturesList(ArrayList arrayList) {
        this.featuresList = arrayList;
        this.experiment = this.createExperiment();
    }

    public void setGeneClusterRepository(ClusterRepository clusterRepository) {
        this.geneClusterRepository = clusterRepository;
    }

    public void setExperimentClusterRepository(ClusterRepository clusterRepository) {
        this.expClusterRepository = clusterRepository;
    }

    public void setUseMainData(boolean bl) {
        this.useMainData = bl;
        if (this.useMainData) {
            this.alternateExperiment = null;
        }
    }

    public void setAlternateExperiment(Experiment experiment) {
        this.alternateExperiment = experiment;
    }

    public void constructAndSetAlternateExperiment(Experiment experiment, int[] nArray, int n) {
        int[] nArray2 = experiment.getRowMappingArrayCopy();
        int[] nArray3 = experiment.getColumnIndicesCopy();
        FloatMatrix floatMatrix = experiment.getMatrix();
        if (n == 0) {
            FloatMatrix floatMatrix2 = new FloatMatrix(nArray.length, nArray3.length);
            int[] nArray4 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = 0; j < nArray3.length; ++j) {
                    floatMatrix2.set(i, j, floatMatrix.get(nArray[i], j));
                }
                nArray4[i] = nArray2[nArray[i]];
            }
            this.alternateExperiment = new Experiment(floatMatrix2, nArray3, nArray4);
            this.useMainData = false;
        } else {
            FloatMatrix floatMatrix3 = new FloatMatrix(nArray2.length, nArray.length);
            int[] nArray5 = new int[nArray.length];
            boolean bl = false;
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = 0; j < nArray2.length; ++j) {
                    floatMatrix3.set(j, i, floatMatrix.get(j, nArray[i]));
                }
                nArray5[i] = nArray3[nArray[i]];
            }
            this.alternateExperiment = new Experiment(floatMatrix3, nArray5, nArray2);
            this.useMainData = false;
        }
    }

    public int getFeaturesCount() {
        return this.featuresList.size();
    }

    public int getFeaturesSize() {
        if (this.featuresList.size() == 0) {
            return 0;
        }
        return ((ISlideData)this.featuresList.get(0)).getSize();
    }

    public float getPercentageCutoff() {
        return this.percentageCutoff;
    }

    public void setPercentageCutoff(float f) {
        this.percentageCutoff = f;
        if (this.isPercentageCutoff()) {
            this.experiment = this.createExperiment();
        }
    }

    public void setVarianceFilter(Properties properties) {
        this.varianceFilterProps = properties;
        this.useVarianceFilter = properties.getProperty("Filter Enabled").equals("true");
        this.experiment = this.createExperiment();
    }

    public void setUsePercentageCutoff(boolean bl) {
        if (this.usePercentageCutoff == bl) {
            return;
        }
        this.usePercentageCutoff = bl;
        this.experiment = this.createExperiment();
    }

    public void setUseDetectionFilter(boolean bl) {
        if (this.useDetectionFilter == bl) {
            return;
        }
        this.useDetectionFilter = bl;
        this.experiment = this.createExperiment();
    }

    public void setUseFoldFilter(boolean bl) {
        if (this.useFoldFilter == bl) {
            return;
        }
        this.useFoldFilter = bl;
        this.experiment = this.createExperiment();
    }

    public void setdfSet(boolean bl) {
        this.dfSet = bl;
    }

    public boolean getdfSet() {
        return this.dfSet;
    }

    public void setffSet(boolean bl) {
        this.ffSet = bl;
    }

    public boolean getffSet() {
        return this.ffSet;
    }

    public boolean isDetectionFilter() {
        return this.useDetectionFilter;
    }

    public boolean isFoldFilter() {
        return this.useFoldFilter;
    }

    public DetectionFilter getDetectionFilter() {
        return this.detectionFilter;
    }

    public FoldFilter getFoldFilter() {
        return this.foldFilter;
    }

    public void setDetectionFilter(DetectionFilter detectionFilter) {
        this.detectionFilter = detectionFilter;
        if (this.isDetectionFilter()) {
            this.experiment = this.createExperiment();
        }
    }

    public void setFoldFilter(FoldFilter foldFilter) {
        this.foldFilter = foldFilter;
        if (this.isFoldFilter()) {
            this.experiment = this.createExperiment();
        }
    }

    public String getDetection(int n, int n2) {
        if (this.featuresList.size() == 0) {
            return "";
        }
        return ((ISlideData)this.featuresList.get(n)).getDetection(n2);
    }

    public boolean isPercentageCutoff() {
        return this.usePercentageCutoff;
    }

    public boolean isVarianceFilter() {
        return this.useVarianceFilter;
    }

    public float getLowerCY3Cutoff() {
        return this.lowerCY3Cutoff;
    }

    public void setMedianIntensities(boolean bl) {
        this.isMedianIntensities = bl;
    }

    public boolean areMedianIntensities() {
        return this.isMedianIntensities;
    }

    public void setLowerCutoffs(float f, float f2) {
        this.lowerCY3Cutoff = f;
        this.lowerCY5Cutoff = f2;
        if (this.isLowerCutoffs()) {
            this.experiment = this.createExperiment();
        }
    }

    public float getLowerCY5Cutoff() {
        return this.lowerCY5Cutoff;
    }

    public void setUseLowerCutoffs(boolean bl) {
        if (this.useLowerCutoffs == bl) {
            return;
        }
        this.useLowerCutoffs = bl;
        this.experiment = this.createExperiment();
    }

    public boolean isLowerCutoffs() {
        return this.useLowerCutoffs;
    }

    public float getCY3(int n, int n2) {
        ISlideData iSlideData = (ISlideData)this.featuresList.get(n);
        return iSlideData.getCY3(n2);
    }

    public float getCY5(int n, int n2) {
        ISlideData iSlideData = (ISlideData)this.featuresList.get(n);
        return iSlideData.getCY5(n2);
    }

    public float getRatio(int n, int n2, int n3) {
        ISlideData iSlideData = (ISlideData)this.featuresList.get(n);
        n3 = this.logState;
        return iSlideData.getRatio(n2, n3);
    }

    public String getSampleName(int n) {
        return ((ISlideData)this.featuresList.get(n)).getSlideDataName();
    }

    public void setSampleLabelKey(String string) {
        for (int i = 0; i < this.featuresList.size(); ++i) {
            ((ISlideData)this.featuresList.get(i)).setDataLabelKey(string);
        }
    }

    public String getFullSampleName(int n) {
        return ((ISlideData)this.featuresList.get(n)).getFullSlideDataName();
    }

    public Vector getSlideDataNameKeys(int n) {
        return ((ISlideData)this.featuresList.get(n)).getSlideDataKeys();
    }

    public Vector getSlideNameKeyVectorUnion() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.featuresList.size(); ++i) {
            Vector vector2 = ((ISlideData)this.featuresList.get(i)).getSlideDataKeys();
            for (int j = 0; j < vector2.size(); ++j) {
                String string = (String)vector2.elementAt(j);
                if (vector.contains(string)) continue;
                vector.addElement(string);
            }
        }
        return vector;
    }

    public Vector getSampleAnnotationFieldNames() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.featuresList.size(); ++i) {
            Vector vector2 = ((ISlideData)this.featuresList.get(i)).getSlideDataKeys();
            for (int j = 0; j < vector2.size(); ++j) {
                String string = (String)vector2.elementAt(j);
                if (vector.contains(string)) continue;
                vector.addElement(string);
            }
        }
        return vector;
    }

    public String[] getSlideNameKeyArray() {
        int n;
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.featuresList.size(); ++i) {
            Vector vector2 = ((ISlideData)this.featuresList.get(i)).getSlideDataKeys();
            for (n = 0; n < vector2.size(); ++n) {
                String string = (String)vector2.elementAt(n);
                if (vector.contains(string)) continue;
                vector.addElement(string);
            }
        }
        String[] stringArray = new String[vector.size()];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = (String)vector.elementAt(n);
        }
        return stringArray;
    }

    public void addNewExperimentLabel(String string, String[] stringArray) {
        for (int i = 0; i < this.featuresList.size(); ++i) {
            this.getFeature(i).addNewSampleLabel(string, stringArray[i]);
        }
    }

    public boolean addNewSampleLabels(Frame frame, File file) throws IOException {
        int n;
        String string;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        int n2 = 0;
        int n3 = this.getFeaturesCount();
        while ((string = bufferedReader.readLine()) != null) {
            ++n2;
        }
        if (--n2 != n3) {
            JOptionPane.showMessageDialog(frame, "<html>The selected file size (number of rows) does not correspond to the<br>number of loaded samples.  The file should have a single header line and row for each loaded sample containing the samples<br>additional annotation.", "File Format Error", 0);
            return false;
        }
        bufferedReader = new BufferedReader(new FileReader(file));
        boolean bl = true;
        String[] stringArray = null;
        String[][] stringArray2 = null;
        int n4 = 0;
        int n5 = 0;
        while ((string = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
            if (bl) {
                stringArray = new String[stringTokenizer.countTokens()];
                for (n = 0; n < stringArray.length; ++n) {
                    stringArray[n] = stringTokenizer.nextToken();
                }
                int n6 = stringArray.length;
                stringArray2 = new String[n6][n3];
                bl = false;
                continue;
            }
            n4 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray2[n4][n5] = stringTokenizer.nextToken();
                ++n4;
            }
            ++n5;
        }
        for (n = 0; n < stringArray.length; ++n) {
            this.addNewExperimentLabel((String)stringArray[n], stringArray2[n]);
        }
        return true;
    }

    public int addNewGeneAnnotation(String[][] stringArray, String string, String string2, String[] stringArray2) {
        int n;
        Object object;
        int n2;
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < stringArray[0].length && !stringArray[0][n3].equals(string2); ++n3) {
        }
        if (n3 > stringArray[0].length) {
            return n4;
        }
        String[] stringArray3 = this.getFieldNames();
        int n5 = -1;
        if (!string.equals("UID")) {
            for (n5 = 0; n5 < stringArray3.length && !string.equals(stringArray3[n5]); ++n5) {
            }
        }
        if (n5 > stringArray3.length) {
            return n4;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (stringArray2.length == stringArray[0].length) {
            for (int i = 1; i < stringArray.length; ++i) {
                hashtable.put(stringArray[i][n3], stringArray[i]);
            }
        } else {
            Vector<String> vector = new Vector<String>();
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                vector.add(stringArray2[n2]);
            }
            n2 = 0;
            for (int i = 1; i < stringArray.length; ++i) {
                n2 = 0;
                object = new String[stringArray2.length];
                for (int j = 0; j < stringArray[0].length; ++j) {
                    if (!vector.contains(stringArray[0][j])) continue;
                    object[n2] = stringArray[i][j];
                    ++n2;
                }
                hashtable.put(stringArray[i][n3], object);
            }
        }
        ISlideData iSlideData = (ISlideData)((Object)this.getSlideMetaData());
        n2 = this.getFeaturesSize();
        String string3 = "";
        for (n = 0; n < n2; ++n) {
            object = iSlideData.getSlideDataElement(n);
            string3 = n5 == -1 ? object.getUID() : object.getFieldAt(n5);
            if (!hashtable.containsKey(string3)) continue;
            ++n4;
        }
        if (n4 > 0) {
            for (n = 0; n < n2; ++n) {
                object = iSlideData.getSlideDataElement(n);
                string3 = n5 == -1 ? object.getUID() : object.getFieldAt(n5);
                String[] stringArray4 = (String[])hashtable.get(string3);
                if (stringArray4 != null) {
                    object.setExtraFields(stringArray4);
                    ++n4;
                    continue;
                }
                object.setExtraFields(new String[stringArray[0].length]);
            }
        }
        return n4;
    }

    public String getElementAttribute(int n, int n2) {
        if (this.featuresList.size() == 0) {
            return "";
        }
        ISlideData iSlideData = (ISlideData)this.featuresList.get(0);
        ISlideDataElement iSlideDataElement = iSlideData.getSlideDataElement(n);
        return iSlideDataElement.getFieldAt(n2);
    }

    public String getUniqueId(int n) {
        return this.getElementAttribute(n, TMEV.getUniqueIDIndex());
    }

    public String getGeneName(int n) {
        return this.getElementAttribute(n, TMEV.getNameIndex());
    }

    public String[] getFieldNames() {
        return TMEV.getFieldNames();
    }

    public int getProbeRow(int n, int n2) {
        ISlideMetaData iSlideMetaData = this.getFeature(n).getSlideMetaData();
        return iSlideMetaData.getRow(n2);
    }

    public int getProbeColumn(int n, int n2) {
        ISlideMetaData iSlideMetaData = this.getFeature(n).getSlideMetaData();
        return iSlideMetaData.getColumn(n2);
    }

    public Color[] getColors() {
        this.updateSpotColors();
        Color[] colorArray = new Color[this.spotColors.size()];
        return this.spotColors.toArray(colorArray);
    }

    public Color getProbeColor(int n) {
        if (this.geneClusterRepository == null) {
            return null;
        }
        return this.geneClusterRepository.getColor(n);
    }

    public void updateSpotColors() {
        this.colorIndices = new int[this.getFeaturesSize()];
        this.spotColors = new ArrayList();
        int n = 0;
        for (int i = 0; i < this.colorIndices.length; ++i) {
            Color color = this.geneClusterRepository == null ? null : this.geneClusterRepository.getColor(i);
            if (color == null) {
                this.colorIndices[i] = -1;
                continue;
            }
            int n2 = this.spotColors.indexOf(color);
            if (n2 < 0) {
                this.spotColors.add(color);
                this.colorIndices[i] = n++;
                continue;
            }
            this.colorIndices[i] = n2;
        }
    }

    public void updateExperimentColors() {
        this.experimentColorIndices = new int[this.getFeaturesCount()];
        this.experimentColors = new ArrayList();
        int n = 0;
        for (int i = 0; i < this.experimentColorIndices.length; ++i) {
            Color color = this.expClusterRepository == null ? null : this.expClusterRepository.getColor(i);
            if (color == null) {
                this.experimentColorIndices[i] = -1;
                continue;
            }
            int n2 = this.experimentColors.indexOf(color);
            if (n2 < 0) {
                this.experimentColors.add(color);
                this.experimentColorIndices[i] = n++;
                continue;
            }
            this.experimentColorIndices[i] = n2;
        }
    }

    public int[] getColorIndices() {
        this.updateSpotColors();
        return this.colorIndices;
    }

    public int[] getExperimentColorIndices() {
        this.updateExperimentColors();
        return this.experimentColorIndices;
    }

    public void setProbesColor(int[] nArray, Color color) {
        int n;
        if (color == null) {
            n = -1;
        } else {
            n = this.spotColors.indexOf(color);
            if (n < 0) {
                n = this.spotColors.size();
                this.spotColors.add(color);
            }
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.colorIndices[nArray[i]] = n;
        }
        this.removeUnusedColors();
    }

    public int getProbeColorIndex(int n) {
        return this.colorIndices[n];
    }

    public int getColoredProbesCount(int n) {
        int n2 = 0;
        for (int i = 0; i < this.colorIndices.length; ++i) {
            if (this.colorIndices[i] != n) continue;
            ++n2;
        }
        return n2;
    }

    public Color getExperimentColor(int n) {
        if (this.expClusterRepository == null) {
            return null;
        }
        return this.expClusterRepository.getColor(n);
    }

    public void setExperimentColor(int[] nArray, Color color) {
        int n;
        if (this.experimentColorIndices == null) {
            this.experimentColorIndices = this.createExperimentColorIndices();
        }
        if (color == null) {
            n = -1;
        } else {
            n = this.experimentColors.indexOf(color);
            if (n < 0) {
                n = this.experimentColors.size();
                this.experimentColors.add(color);
            }
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.experimentColorIndices[nArray[i]] = n;
        }
        this.removeUnusedExperimentColors();
    }

    public int getColoredExperimentsCount(int n) {
        int n2 = 0;
        if (this.experimentColorIndices == null) {
            this.experimentColorIndices = this.createExperimentColorIndices();
        }
        for (int i = 0; i < this.experimentColorIndices.length; ++i) {
            if (this.experimentColorIndices[i] != n) continue;
            ++n2;
        }
        return n2;
    }

    public Color[] getExperimentColors() {
        this.updateExperimentColors();
        Color[] colorArray = new Color[this.experimentColors.size()];
        return this.experimentColors.toArray(colorArray);
    }

    public int getExperimentColorIndex(int n) {
        if (this.experimentColorIndices == null) {
            this.experimentColorIndices = this.createExperimentColorIndices();
        }
        return this.experimentColorIndices[n];
    }

    public void clearExperimentColor(int n) {
        if (n > this.experimentColorIndices.length) {
            return;
        }
        this.experimentColors.remove(this.experimentColorIndices[n]);
        this.experimentColorIndices[n] = -1;
    }

    public void clearExperimentColors(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.clearExperimentColor(nArray[i]);
        }
    }

    public void deleteExperimentColors() {
        this.experimentColors.clear();
        this.experimentColorIndices = this.createExperimentColorIndices();
    }

    private int[] createExperimentColorIndices() {
        int[] nArray = new int[this.featuresList.size()];
        for (int i = 0; i < this.featuresList.size(); ++i) {
            nArray[i] = -1;
        }
        return nArray;
    }

    private void removeUnusedColors() {
        int n;
        int n2 = n = this.spotColors.size();
        while (--n2 >= 0) {
            boolean bl = true;
            int n3 = this.colorIndices.length;
            while (--n3 >= 0) {
                if (this.colorIndices[n3] != n2) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            this.spotColors.remove(n2);
            n3 = this.colorIndices.length;
            while (--n3 >= 0) {
                if (this.colorIndices[n3] <= n2) continue;
                int n4 = n3;
                this.colorIndices[n4] = this.colorIndices[n4] - 1;
            }
        }
    }

    private void removeUnusedExperimentColors() {
        int n;
        int n2 = n = this.experimentColors.size();
        while (--n2 >= 0) {
            boolean bl = true;
            int n3 = this.experimentColorIndices.length;
            while (--n3 >= 0) {
                if (this.experimentColorIndices[n3] != n2) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            this.experimentColors.remove(n2);
            n3 = this.experimentColorIndices.length;
            while (--n3 >= 0) {
                if (this.experimentColorIndices[n3] <= n2) continue;
                int n4 = n3;
                this.experimentColorIndices[n4] = this.experimentColorIndices[n4] - 1;
            }
        }
    }

    public void deleteColors() {
        this.spotColors.clear();
        if (this.colorIndices != null) {
            this.colorIndices = this.createColorIndices(this.colorIndices.length);
        }
    }

    private int[] createIndices(ISlideData iSlideData) {
        int[] nArray = new int[iSlideData.getSize()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    void addFeature(ISlideData iSlideData) {
        this.featuresList.add(iSlideData);
        iSlideData.setDataType(this.dataType);
        this.indicesList.add(this.createIndices(iSlideData));
        this.experiment = this.createExperiment();
        if (this.colorIndices == null) {
            this.colorIndices = this.createColorIndices(iSlideData.getSize());
        }
        this.updateMaxValues(iSlideData);
    }

    void addFeatures(ISlideData[] iSlideDataArray) {
        for (int i = 0; i < iSlideDataArray.length; ++i) {
            this.featuresList.add(iSlideDataArray[i]);
            iSlideDataArray[i].setDataType(this.dataType);
            this.indicesList.add(this.createIndices(iSlideDataArray[i]));
            this.updateMaxValues(iSlideDataArray[i]);
        }
        this.experiment = this.createExperiment();
        if (this.colorIndices == null) {
            this.colorIndices = this.createColorIndices(iSlideDataArray[0].getSize());
        }
    }

    private int[] createColorIndices(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = -1;
        }
        return nArray;
    }

    private void updateMaxValues(ISlideData iSlideData) {
        float f = iSlideData.getMaxCY3();
        if (f > this.maxCy3) {
            this.setMaxCY3(f);
        }
        if ((f = iSlideData.getMaxCY5()) > this.maxCy5) {
            this.setMaxCY5(f);
        }
        this.updateMaxMinRatios(iSlideData);
    }

    ISlideMetaData getSlideMetaData() {
        if (this.featuresList.size() > 0) {
            return ((ISlideData)this.featuresList.get(0)).getSlideMetaData();
        }
        return null;
    }

    public ISlideData getFeature(int n) {
        return (ISlideData)this.featuresList.get(n);
    }

    public ISlideDataElement getSlideDataElement(int n, int n2) {
        ISlideData iSlideData = this.getFeature(n);
        return iSlideData.getSlideDataElement(n2);
    }

    void setNonZero(boolean bl) {
        this.resetMaxValues();
        int n = this.getFeaturesCount();
        for (int i = 0; i < n; ++i) {
            ISlideData iSlideData = this.getFeature(i);
            iSlideData.setNonZero(bl);
            this.updateMaxValues(iSlideData);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String normalize(int n, MultipleArrayViewer multipleArrayViewer) {
        Object object;
        this.resetMaxValues();
        int n2 = this.getFeaturesCount();
        Properties properties = new Properties();
        new Parameter();
        if (n == 0) {
            for (int i = 0; i < n2; ++i) {
                ISlideData iSlideData = this.getFeature(i);
                iSlideData.applyNormalization(0, properties);
                this.updateMaxValues(iSlideData);
            }
            this.experiment = this.createExperiment();
            return "normalized";
        }
        if (n == 3) {
            object = new LinRegNormInitDialog();
            if (object.showModal() != 0) return "no_change";
            properties.setProperty("standard-deviation", Float.toString(object.getSD()));
            properties.setProperty("mode", object.getMode());
            object.dispose();
        } else if (n == 4 || n == 5) {
            object = new RatioStatsNormInitDialog();
            if (object.showModal() != 0) return "no_change";
            properties.setProperty("confidence-interval", Integer.toString(object.getCI()));
            object.dispose();
        } else if (n == 6) {
            object = new IterativeLogMCNormInitDialog();
            if (object.showModal() != 0) return "no_change";
            properties.setProperty("standard-deviation", Float.toString(object.getSD()));
            object.dispose();
        }
        object = new Normalizer(n, properties, n2, multipleArrayViewer);
        ((Normalizer)object).runNormalization();
        this.experiment = this.createExperiment();
        if (this.normalizationAbort) return "process_abort_reset";
        return "normalized";
    }

    void normalizeList(int n) {
        this.resetMaxValues();
        int n2 = this.getFeaturesCount();
        for (int i = 0; i < n2; ++i) {
            ISlideData iSlideData = this.getFeature(i);
            iSlideData.applyNormalizationList(n);
            this.updateMaxValues(iSlideData);
        }
        this.experiment = this.createExperiment();
    }

    public int[] getSortedIndices(int n) {
        return (int[])this.indicesList.get(n);
    }

    private Experiment createExperiment() {
        int n = this.featuresList.size();
        if (n < 1) {
            return null;
        }
        int n2 = this.getFeature(0).getSize();
        Experiment experiment = null;
        int[] nArray = null;
        int[] nArray2 = null;
        if (this.isLowerCutoffs() || this.isPercentageCutoff() || this.isVarianceFilter() || TMEV.getDataType() == 2 && (this.isDetectionFilter() || this.isFoldFilter())) {
            nArray2 = this.createCutoffGeneList(n, n2);
            experiment = this.createExperiment(n, nArray2);
        } else {
            nArray = this.createDefaultFeatures(n, n2);
            experiment = this.createExperiment(nArray, n2);
        }
        return experiment;
    }

    private int[] createDefaultFeatures(int n, int n2) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    private int[] createCutoffFeatures(int n, int n2) {
        int n3;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        boolean bl = true;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            ISlideData iSlideData = this.getFeature(i);
            for (n3 = 0; n3 < n2; ++n3) {
                float f = iSlideData.getCY3(n3);
                float f2 = iSlideData.getCY5(n3);
                if (this.isLowerCutoffs() && (f < this.lowerCY3Cutoff || f2 < this.lowerCY5Cutoff)) {
                    bl = false;
                    break;
                }
                if (!this.isPercentageCutoff() || !(f > 0.0f) || !(f2 > 0.0f)) continue;
                ++n4;
            }
            if (bl && this.isPercentageCutoff() && (float)n4 / (float)n2 * 100.0f < this.percentageCutoff) {
                bl = false;
            }
            if (!bl) continue;
            arrayList.add(new Integer(i));
        }
        int[] nArray = new int[arrayList.size()];
        for (n3 = 0; n3 < nArray.length; ++n3) {
            nArray[n3] = (Integer)arrayList.get(n3);
        }
        return nArray;
    }

    private int[] createCutoffGeneList(int n, int n2) {
        Object[] objectArray;
        int n3;
        ISlideData[] iSlideDataArray = new ISlideData[n];
        ArrayList arrayList = new ArrayList();
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = true;
        int n4 = 0;
        boolean bl6 = false;
        for (n3 = 0; n3 < iSlideDataArray.length; ++n3) {
            iSlideDataArray[n3] = this.getFeature(n3);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            int n5;
            objectArray = new float[n];
            float[] fArray = new float[n];
            String[] stringArray = new String[n];
            n4 = 0;
            bl6 = false;
            bl = true;
            bl2 = true;
            bl4 = true;
            bl5 = true;
            for (n5 = 0; n5 < objectArray.length; ++n5) {
                objectArray[n5] = iSlideDataArray[n5].getCY3(n3);
                fArray[n5] = iSlideDataArray[n5].getCY5(n3);
                stringArray[n5] = this.getDetection(n5, n3);
            }
            if (this.isLowerCutoffs()) {
                for (n5 = 0; n5 < objectArray.length; ++n5) {
                    if (!(objectArray[n5] < this.lowerCY3Cutoff) && !(fArray[n5] < this.lowerCY5Cutoff)) continue;
                    bl = false;
                    break;
                }
            }
            if (this.isPercentageCutoff()) {
                for (n5 = 0; n5 < objectArray.length; ++n5) {
                    if (!(objectArray[n5] > 0.0f && fArray[n5] > 0.0f) && (this.dataType != 1 || Float.isNaN(fArray[n5]))) continue;
                    ++n4;
                }
                if ((float)n4 / (float)n * 100.0f < this.percentageCutoff) {
                    bl2 = false;
                }
            }
            if (this.isDetectionFilter()) {
                bl4 = this.detectionFilter.keep_gene(stringArray);
            }
            if (this.isFoldFilter()) {
                bl5 = this.foldFilter.keep_gene(fArray);
            }
            if (!bl || !bl2 || !bl4 || !bl5) continue;
            arrayList.add(new Integer(n3));
        }
        Object var12_13 = null;
        if (this.isVarianceFilter()) {
            arrayList = this.imposeVarianceFilter(arrayList);
        }
        objectArray = new int[arrayList.size()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = ((Integer)arrayList.get(i)).intValue();
        }
        return objectArray;
    }

    private float[] getStandardDeviations() {
        int n = this.getFeaturesSize();
        int n2 = this.getFeaturesCount();
        float[] fArray = new float[n];
        float[] fArray2 = new float[n];
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            float f;
            int n3;
            int n4 = 0;
            float f2 = 0.0f;
            float f3 = 0.0f;
            for (n3 = 0; n3 < n2; ++n3) {
                f = this.getRatio(n3, i, this.logState);
                if (Float.isNaN(f)) continue;
                f2 += f;
                ++n4;
            }
            if (n4 <= 0) {
                fArray2[i] = -1.0f;
                continue;
            }
            float f4 = f2 / (float)n4++;
            for (n3 = 0; n3 < n2; ++n3) {
                f = this.getRatio(n3, i, this.logState);
                if (Float.isNaN(f)) continue;
                f3 = (float)((double)f3 + Math.pow(f - f4, 2.0));
            }
            fArray2[i] = n4 > 0 ? (float)Math.sqrt(f3 / (float)n4) : 0.0f;
        }
        return fArray2;
    }

    public ArrayList imposeVarianceFilter(ArrayList arrayList) {
        String string = this.varianceFilterProps.getProperty("Filter Mode");
        float[] fArray = this.getStandardDeviations();
        boolean[] blArray = new boolean[fArray.length];
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        if (string.equals("sd value mode")) {
            float f = Float.parseFloat(this.varianceFilterProps.getProperty("Value"));
            for (int i = 0; i < fArray.length; ++i) {
                if (!(fArray[i] >= f) || !arrayList.contains(new Integer(i))) continue;
                arrayList2.add(new Integer(i));
            }
        } else if (string.equals("percent mode")) {
            float f = Float.parseFloat(this.varianceFilterProps.getProperty("Value"));
            QSort qSort = new QSort(fArray);
            float[] fArray2 = qSort.getSorted();
            int[] nArray = qSort.getOrigIndx();
            int n = (int)((float)arrayList.size() * (f / 100.0f));
            for (int i = nArray.length - 1; i >= 0 && arrayList2.size() < n; --i) {
                if (!arrayList.contains(new Integer(nArray[i]))) continue;
                arrayList2.add(new Integer(nArray[i]));
            }
        } else {
            int n = Integer.parseInt(this.varianceFilterProps.getProperty("Value"));
            QSort qSort = new QSort(fArray);
            float[] fArray3 = qSort.getSorted();
            int[] nArray = qSort.getOrigIndx();
            for (int i = nArray.length - 1; i >= 0 && arrayList2.size() < n; --i) {
                if (!arrayList.contains(new Integer(nArray[i]))) continue;
                arrayList2.add(new Integer(nArray[i]));
            }
        }
        return arrayList2;
    }

    private Experiment createExperiment(int[] nArray, int n) {
        FloatMatrix floatMatrix = new FloatMatrix(n, nArray.length);
        float[][] fArray = floatMatrix.A;
        for (int i = 0; i < nArray.length; ++i) {
            ISlideData iSlideData = (ISlideData)this.featuresList.get(nArray[i]);
            int n2 = n;
            while (--n2 >= 0) {
                floatMatrix.A[n2][nArray[i]] = iSlideData.getRatio(n2, this.logState);
            }
        }
        return new Experiment(floatMatrix, nArray);
    }

    private Experiment createExperiment(int n, int[] nArray) {
        FloatMatrix floatMatrix = new FloatMatrix(nArray.length, n);
        int[] nArray2 = new int[n];
        float[][] fArray = floatMatrix.A;
        for (int i = 0; i < n; ++i) {
            nArray2[i] = i;
            ISlideData iSlideData = (ISlideData)this.featuresList.get(i);
            for (int j = 0; j < nArray.length; ++j) {
                floatMatrix.A[j][i] = iSlideData.getRatio(nArray[j], this.logState);
            }
        }
        return new Experiment(floatMatrix, nArray2, nArray);
    }

    public int getNormalizationState() {
        if (this.featuresList == null || this.featuresList.size() < 1) {
            return 0;
        }
        return ((ISlideData)this.featuresList.get(0)).getNormalizedState();
    }

    public MultipleArrayData getDataSubset(int[] nArray) {
        ISlideMetaData iSlideMetaData = null;
        MultipleArrayData multipleArrayData = new MultipleArrayData();
        multipleArrayData.setDataType(this.dataType);
        int n = this.getNormalizationState();
        if (nArray.length < 1) {
            return null;
        }
        for (int i = 0; i < this.getFeaturesCount(); ++i) {
            ISlideDataElement iSlideDataElement;
            int n2;
            int n3;
            String string;
            ISlideData iSlideData;
            if (i == 0) {
                iSlideData = new SlideData();
                string = this.getSampleName(i);
                if (string.endsWith("...")) {
                    this.toggleExptNameLength();
                    iSlideData.setSlideDataLabels(this.getFeature(i).getSlideDataKeys(), this.getFeature(i).getSlideDataLabels());
                    ((SlideData)iSlideData).setSlideFileName(this.getSampleName(i));
                    this.toggleExptNameLength();
                } else {
                    iSlideData.setSlideDataLabels(this.getFeature(i).getSlideDataKeys(), this.getFeature(i).getSlideDataLabels());
                    ((SlideData)iSlideData).setSlideFileName(this.getSampleName(i));
                }
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    n2 = nArray[n3];
                    iSlideDataElement = new SlideDataElement(this.getSlideDataElement(i, n2));
                    iSlideData.addSlideDataElement(iSlideDataElement);
                }
                iSlideMetaData = (ISlideMetaData)((Object)iSlideData);
            } else {
                iSlideData = new FloatSlideData(iSlideMetaData);
                ((FloatSlideData)iSlideData).createCurrentIntensityArrays();
                string = this.getSampleName(i);
                if (string.endsWith("...")) {
                    this.toggleExptNameLength();
                    iSlideData.setSlideDataLabels(this.getFeature(i).getSlideDataKeys(), this.getFeature(i).getSlideDataLabels());
                    ((FloatSlideData)iSlideData).setSlideFileName(this.getSampleName(i));
                    this.toggleExptNameLength();
                } else {
                    iSlideData.setSlideDataLabels(this.getFeature(i).getSlideDataKeys(), this.getFeature(i).getSlideDataLabels());
                    ((FloatSlideData)iSlideData).setSlideFileName(this.getSampleName(i));
                }
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    n2 = nArray[n3];
                    iSlideDataElement = this.getSlideDataElement(i, n2);
                    ((FloatSlideData)iSlideData).setIntensities(n3, iSlideDataElement.getTrueIntensity(0), iSlideDataElement.getTrueIntensity(1));
                    ((FloatSlideData)iSlideData).setCurrentIntensities(n3, iSlideDataElement.getCurrentIntensity()[0], iSlideDataElement.getCurrentIntensity()[1]);
                }
            }
            iSlideData.setNormalizedState(n);
            multipleArrayData.addFeature(iSlideData);
        }
        return multipleArrayData;
    }

    public MultipleArrayData getDataSubset(int[] nArray, int[] nArray2) {
        ISlideMetaData iSlideMetaData = (ISlideMetaData)this.featuresList.get(0);
        MultipleArrayData multipleArrayData = new MultipleArrayData();
        multipleArrayData.setDataType(this.dataType);
        int n = this.getNormalizationState();
        if (nArray.length < 1 || nArray2.length < 1) {
            return null;
        }
        for (int i = 0; i < nArray.length; ++i) {
            ISlideDataElement iSlideDataElement;
            int n2;
            String string;
            ISlideData iSlideData;
            int n3 = nArray[i];
            if (n3 == 0) {
                iSlideData = new SlideData();
                string = this.getSampleName(n3);
                if (string.endsWith("...")) {
                    this.toggleExptNameLength();
                    iSlideData.setSlideDataLabels(this.getFeature(n3).getSlideDataKeys(), this.getFeature(n3).getSlideDataLabels());
                    ((SlideData)iSlideData).setSlideFileName(this.getSampleName(n3));
                    this.toggleExptNameLength();
                } else {
                    iSlideData.setSlideDataLabels(this.getFeature(n3).getSlideDataKeys(), this.getFeature(n3).getSlideDataLabels());
                    ((SlideData)iSlideData).setSlideFileName(this.getSampleName(n3));
                }
                for (n2 = 0; n2 < nArray2.length; ++n2) {
                    iSlideDataElement = new SlideDataElement(this.getSlideDataElement(n3, nArray2[n2]));
                    iSlideData.addSlideDataElement(iSlideDataElement);
                }
                iSlideMetaData = (ISlideMetaData)((Object)iSlideData);
            } else {
                iSlideData = new FloatSlideData(iSlideMetaData);
                ((FloatSlideData)iSlideData).createCurrentIntensityArrays();
                string = this.getSampleName(n3);
                if (string.endsWith("...")) {
                    this.toggleExptNameLength();
                    iSlideData.setSlideDataLabels(this.getFeature(n3).getSlideDataKeys(), this.getFeature(n3).getSlideDataLabels());
                    ((FloatSlideData)iSlideData).setSlideFileName(this.getSampleName(n3));
                    this.toggleExptNameLength();
                } else {
                    iSlideData.setSlideDataLabels(this.getFeature(n3).getSlideDataKeys(), this.getFeature(n3).getSlideDataLabels());
                    ((FloatSlideData)iSlideData).setSlideFileName(this.getSampleName(n3));
                }
                for (n2 = 0; n2 < nArray2.length; ++n2) {
                    iSlideDataElement = this.getSlideDataElement(n3, nArray2[n2]);
                    ((FloatSlideData)iSlideData).setIntensities(n2, iSlideDataElement.getTrueIntensity(0), iSlideDataElement.getTrueIntensity(1));
                    ((FloatSlideData)iSlideData).setCurrentIntensities(n2, iSlideDataElement.getCurrentIntensity()[0], iSlideDataElement.getCurrentIntensity()[1]);
                }
            }
            iSlideData.setNormalizedState(n);
            multipleArrayData.addFeature(iSlideData);
        }
        return multipleArrayData;
    }

    private void resetMaxValues() {
        this.setMaxCY3(0.0f);
        this.setMaxCY5(0.0f);
        this.setMaxRatio(0.0f);
        this.setMinRatio(0.0f);
    }

    private void updateMaxMinRatios(ISlideData iSlideData) {
        float f = this.minRatio;
        float f2 = this.maxRatio;
        int n = this.featuresList.size();
        int n2 = ((ISlideData)this.featuresList.get(0)).getSize();
        for (int i = 0; i < n2; ++i) {
            float f3 = iSlideData.getRatio(i, this.logState);
            f2 = Math.max(f2, f3);
            f = Math.min(f, f3);
        }
        this.setMaxRatio(f2);
        this.setMinRatio(f2);
    }

    public void toggleExptNameLength() {
        if (this.getFeaturesCount() < 1) {
            return;
        }
        for (int i = 0; i < this.getFeaturesCount(); ++i) {
            this.getFeature(i).toggleNameLength();
        }
    }

    void sort(int n) {
        SlideDataSorter slideDataSorter = new SlideDataSorter();
        if (n == 9001) {
            for (int i = 0; i < this.featuresList.size(); ++i) {
                slideDataSorter.setSlideData((ISlideData)this.featuresList.get(i));
                slideDataSorter.sort((int[])this.indicesList.get(i), n);
            }
        } else {
            if (this.featuresList.size() < 1) {
                return;
            }
            slideDataSorter.setSlideData((ISlideData)this.featuresList.get(0));
            int[] nArray = (int[])this.indicesList.get(0);
            slideDataSorter.sort(nArray, n);
            for (int i = 1; i < this.featuresList.size(); ++i) {
                int[] nArray2 = (int[])this.indicesList.get(i);
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            }
        }
    }

    public Experiment getFullExperiment() {
        int n = this.getFeaturesCount();
        int n2 = this.getFeaturesSize();
        int[] nArray = this.createDefaultFeatures(n, n2);
        Experiment experiment = this.createExperiment(nArray, n2);
        return experiment;
    }

    public Experiment getExperiment() {
        if (this.useMainData) {
            return this.experiment;
        }
        return this.alternateExperiment;
    }

    private void setMaxCY3(float f) {
        this.maxCy3 = f;
    }

    private void setMaxCY5(float f) {
        this.maxCy5 = f;
    }

    public float getMaxCY3() {
        return this.maxCy3;
    }

    public float getMaxCY5() {
        return this.maxCy5;
    }

    private void setMaxRatio(float f) {
        this.maxRatio = f;
    }

    private void setMinRatio(float f) {
        this.minRatio = f;
    }

    public float getMaxRatio() {
        return this.maxRatio;
    }

    public float getMinRatio() {
        return this.minRatio;
    }

    void log2Transform() {
        Adjustment.log2Transform(this.experiment.getMatrix());
    }

    void normalizeSpots() {
        Adjustment.normalizeSpots(this.experiment.getMatrix());
    }

    void divideSpotsRMS() {
        Adjustment.divideSpotsRMS(this.experiment.getMatrix());
    }

    void divideSpotsSD() {
        Adjustment.divideSpotsSD(this.experiment.getMatrix());
    }

    void divideGenesMedian() {
        Adjustment.divideGenesMedian(this.experiment.getMatrix());
    }

    void divideGenesMean() {
        Adjustment.divideGenesMean(this.experiment.getMatrix());
    }

    void meanCenterSpots() {
        Adjustment.meanCenterSpots(this.experiment.getMatrix());
    }

    void medianCenterSpots() {
        Adjustment.medianCenterSpots(this.experiment.getMatrix());
    }

    void digitalSpots() {
        Adjustment.digitalSpots(this.experiment.getMatrix());
    }

    void normalizeExperiments() {
        Adjustment.normalizeExperiments(this.experiment.getMatrix());
    }

    void divideExperimentsRMS() {
        Adjustment.divideExperimentsRMS(this.experiment.getMatrix());
    }

    void divideExperimentsSD() {
        Adjustment.divideExperimentsSD(this.experiment.getMatrix());
    }

    void meanCenterExperiments() {
        Adjustment.meanCenterExperiments(this.experiment.getMatrix());
    }

    void medianCenterExperiments() {
        Adjustment.medianCenterExperiments(this.experiment.getMatrix());
    }

    void digitalExperiments() {
        Adjustment.digitalExperiments(this.experiment.getMatrix());
    }

    void log10toLog2() {
        Adjustment.log10toLog2(this.experiment.getMatrix());
    }

    private static float getGeneMean(float[] fArray) {
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            f += fArray[i];
        }
        return f / (float)fArray.length;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int n) {
        this.dataType = n;
        for (int i = 0; i < this.getFeaturesCount(); ++i) {
            ISlideData iSlideData = this.getFeature(i);
            iSlideData.setDataType(n);
        }
        this.logState = this.dataType == 1 || this.dataType == 2 ? 0 : 1;
        if (this.getFeaturesCount() > 0) {
            this.experiment = this.createExperiment();
        }
    }

    public int[] search(AlgorithmData algorithmData) {
        int[] nArray;
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        boolean bl = algorithmParameters.getBoolean("gene-search");
        boolean bl2 = algorithmParameters.getBoolean("case-sensitive");
        boolean bl3 = algorithmParameters.getBoolean("full-term");
        String string = algorithmParameters.getString("search-term");
        String string2 = string.toUpperCase();
        String[] stringArray = algorithmData.getStringArray("field-names");
        boolean bl4 = false;
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        Hashtable hashtable = new Hashtable();
        if (this.getFeaturesCount() < 1 || this.getFeaturesSize() < 1) {
            return new int[0];
        }
        if (bl) {
            int n;
            String[] stringArray2 = this.getFieldNames();
            block0: for (int i = 0; i < stringArray.length; ++i) {
                for (int j = 0; j < stringArray2.length; ++j) {
                    if (!stringArray[i].equals(stringArray2[j])) continue;
                    vector.addElement(new Integer(j));
                    continue block0;
                }
            }
            int n2 = this.getFeaturesSize();
            ISlideData iSlideData = this.getFeature(0);
            for (n = 0; n < n2; ++n) {
                bl4 = false;
                for (int i = 0; i < vector.size(); ++i) {
                    int n3 = (Integer)vector.elementAt(i);
                    String string3 = this.getElementAttribute(n, n3);
                    if (bl3) {
                        if (bl2) {
                            if (!string3.equals(string)) continue;
                            bl4 = true;
                            continue;
                        }
                        if (!string3.equalsIgnoreCase(string)) continue;
                        bl4 = true;
                        break;
                    }
                    if (bl2) {
                        if (string3.indexOf(string) == -1) continue;
                        bl4 = true;
                        break;
                    }
                    if (string3.toUpperCase().indexOf(string2) == -1) continue;
                    bl4 = true;
                    break;
                }
                if (!bl4) continue;
                vector2.addElement(new Integer(n));
            }
            nArray = new int[vector2.size()];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = (Integer)vector2.elementAt(n);
            }
        } else {
            int n;
            int n4 = this.getFeaturesCount();
            for (n = 0; n < n4; ++n) {
                bl4 = false;
                Hashtable hashtable2 = this.getFeature(n).getSlideDataLabels();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string4 = (String)hashtable2.get(stringArray[i]);
                    if (string4 == null) continue;
                    if (bl3) {
                        if (bl2) {
                            if (!string4.equals(string)) continue;
                            bl4 = true;
                            break;
                        }
                        if (!string4.equalsIgnoreCase(string)) continue;
                        bl4 = true;
                        break;
                    }
                    if (bl2) {
                        if (string4.indexOf(string) == -1) continue;
                        bl4 = true;
                        break;
                    }
                    if (string4.toUpperCase().indexOf(string2) == -1) continue;
                    bl4 = true;
                    break;
                }
                if (!bl4) continue;
                vector2.addElement(new Integer(n));
            }
            nArray = new int[vector2.size()];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = (Integer)vector2.elementAt(n);
            }
        }
        return nArray;
    }

    public String[] getAnnotationList(String string, int[] nArray) {
        int n;
        String[] stringArray = this.getFieldNames();
        for (n = 0; n < stringArray.length && !string.equals(stringArray[n]); ++n) {
        }
        if (n >= stringArray.length) {
            return null;
        }
        String[] stringArray2 = new String[nArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = this.getElementAttribute(nArray[i], n);
        }
        return stringArray2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
        objectOutputStream.writeObject(TMEV.getFieldNames());
        objectOutputStream.writeObject(this.featuresList);
        objectOutputStream.writeObject(this.indicesList);
        objectOutputStream.writeObject(this.spotColors);
        objectOutputStream.writeObject(this.colorIndices);
        objectOutputStream.writeObject(this.experimentColors);
        objectOutputStream.writeObject(this.experimentColorIndices);
        objectOutputStream.writeObject(this.experiment);
        objectOutputStream.writeInt(this.dataType);
        objectOutputStream.writeFloat(this.maxCy3);
        objectOutputStream.writeFloat(this.maxCy5);
        objectOutputStream.writeFloat(this.maxRatio);
        objectOutputStream.writeFloat(this.minRatio);
        objectOutputStream.writeFloat(this.percentageCutoff);
        objectOutputStream.writeBoolean(this.usePercentageCutoff);
        objectOutputStream.writeFloat(this.lowerCY3Cutoff);
        objectOutputStream.writeFloat(this.lowerCY5Cutoff);
        objectOutputStream.writeBoolean(this.useLowerCutoffs);
        objectOutputStream.writeBoolean(this.isMedianIntensities);
        objectOutputStream.writeBoolean(this.useMainData);
        if (!this.useMainData) {
            objectOutputStream.writeObject(this.alternateExperiment);
        }
        if (this.dataType != 0) {
            objectOutputStream.writeBoolean(this.getdfSet());
            objectOutputStream.writeBoolean(this.getffSet());
            if (this.getdfSet()) {
                objectOutputStream.writeBoolean(this.useDetectionFilter);
                objectOutputStream.writeObject(this.detectionFilter);
            }
            if (this.getffSet()) {
                objectOutputStream.writeBoolean(this.useFoldFilter);
                objectOutputStream.writeObject(this.foldFilter);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        TMEV.setFieldNames((String[])objectInputStream.readObject());
        this.featuresList = (ArrayList)objectInputStream.readObject();
        this.indicesList = (ArrayList)objectInputStream.readObject();
        this.spotColors = (ArrayList)objectInputStream.readObject();
        this.colorIndices = (int[])objectInputStream.readObject();
        this.experimentColors = (ArrayList)objectInputStream.readObject();
        this.experimentColorIndices = (int[])objectInputStream.readObject();
        this.experiment = (Experiment)objectInputStream.readObject();
        this.dataType = objectInputStream.readInt();
        this.maxCy3 = objectInputStream.readFloat();
        this.maxCy5 = objectInputStream.readFloat();
        this.maxRatio = objectInputStream.readFloat();
        this.minRatio = objectInputStream.readFloat();
        this.percentageCutoff = objectInputStream.readFloat();
        this.usePercentageCutoff = objectInputStream.readBoolean();
        this.lowerCY3Cutoff = objectInputStream.readFloat();
        this.lowerCY5Cutoff = objectInputStream.readFloat();
        this.useLowerCutoffs = objectInputStream.readBoolean();
        this.isMedianIntensities = objectInputStream.readBoolean();
        this.useMainData = objectInputStream.readBoolean();
        if (!this.useMainData) {
            this.alternateExperiment = (Experiment)objectInputStream.readObject();
        }
        if (this.dataType != 0) {
            this.dfSet = objectInputStream.readBoolean();
            this.ffSet = objectInputStream.readBoolean();
            if (this.dfSet) {
                this.useDetectionFilter = objectInputStream.readBoolean();
                this.detectionFilter = (DetectionFilter)objectInputStream.readObject();
            }
            if (this.ffSet) {
                this.useFoldFilter = objectInputStream.readBoolean();
                this.foldFilter = (FoldFilter)objectInputStream.readObject();
            }
        }
    }

    public String getSampleAnnotation(int n, String string) {
        return (String)this.getFeature(n).getSlideDataLabels().get(string);
    }

    private class NormalizationListener
    extends DialogListener {
        private NormalizationListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("cancel-command")) {
                MultipleArrayData.this.normalizationAbort = true;
                MultipleArrayData.this.progressBar.dispose();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            MultipleArrayData.this.normalizationAbort = true;
            MultipleArrayData.this.progressBar.dispose();
        }
    }

    private class Normalizer {
        Properties properties;
        int mode;
        int size;
        MultipleArrayViewer viewer;

        public Normalizer(int n, Properties properties, int n2, MultipleArrayViewer multipleArrayViewer) {
            this.mode = n;
            this.properties = properties;
            this.size = n2;
            this.viewer = multipleArrayViewer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runNormalization() {
            try {
                ISlideData iSlideData;
                int n;
                MultipleArrayData.this.normalizationAbort = false;
                MultipleArrayData.this.progressBar = new Progress(new Frame(), "Normalization Progress", (DialogListener)new NormalizationListener());
                MultipleArrayData.this.progressBar.show();
                MultipleArrayData.this.progressBar.setUnits(this.size);
                MultipleArrayData.this.progressBar.setValue(0);
                for (n = 0; n < this.size; ++n) {
                    MultipleArrayData.this.progressBar.setValue(n);
                    MultipleArrayData.this.progressBar.setDescription("Normalizing Experiment " + Integer.toString(n));
                    MultipleArrayData.this.progressBar.repaint();
                    iSlideData = MultipleArrayData.this.getFeature(n);
                    if (MultipleArrayData.this.normalizationAbort) break;
                    iSlideData.applyNormalization(this.mode, this.properties);
                    this.viewer.fireDataChanged();
                    MultipleArrayData.this.updateMaxValues(iSlideData);
                }
                if (MultipleArrayData.this.normalizationAbort) {
                    System.out.println("Abort");
                    MultipleArrayData.this.progressBar.setVisible(false);
                    MultipleArrayData.this.progressBar.dispose();
                    for (n = 0; n < this.size; ++n) {
                        iSlideData = MultipleArrayData.this.getFeature(n);
                        iSlideData.applyNormalization(0, this.properties);
                        MultipleArrayData.this.updateMaxValues(iSlideData);
                    }
                }
                MultipleArrayData.this.progressBar.dispose();
            }
            catch (Exception exception) {}
        }
    }
}

