/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Rectangle2D;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.tigr.util.awt.GBA;

public class MevCitationDialog
extends JDialog
implements Printable {
    private String text;
    private JEditorPane ed;

    public MevCitationDialog(Frame frame) {
        this(frame, "");
    }

    public MevCitationDialog(Frame frame, String string) {
        super(frame, "Contribution Acknowledgement :)", false);
        EventListener eventListener = new EventListener();
        this.text = string;
        GBA gBA = new GBA();
        Font font = new Font("serif", 0, 12);
        this.ed = new JEditorPane("text/html", string);
        this.ed.setEditable(false);
        this.ed.setMargin(new Insets(10, 10, 10, 10));
        this.ed.setBackground(new Color(234, 233, 191));
        this.ed.setCaretPosition(0);
        JScrollPane jScrollPane = new JScrollPane(this.ed, 20, 31);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(new Color(234, 233, 191));
        gBA.add((Container)jPanel, (Component)jScrollPane, 0, 0, 1, 1, 1, 1, 1, 10);
        JButton jButton = new JButton("Print");
        jButton.setBorder(BorderFactory.createBevelBorder(0));
        jButton.setFocusPainted(false);
        jButton.setActionCommand("print-command");
        jButton.addActionListener(eventListener);
        JButton jButton2 = new JButton("  Close  ");
        jButton2.setBorder(BorderFactory.createBevelBorder(0));
        jButton2.setFocusPainted(false);
        jButton2.setActionCommand("close-command");
        jButton2.addActionListener(eventListener);
        jButton2.setSize(120, 30);
        jButton2.setPreferredSize(new Dimension(120, 30));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        gBA.add((Container)jPanel2, (Component)jButton2, 0, 0, 1, 1, 1, 1, 0, 10);
        this.getContentPane().setLayout(new GridBagLayout());
        gBA.add(this.getContentPane(), (Component)jPanel, 0, 0, 1, 2, 1, 1, 1, 10);
        gBA.add(this.getContentPane(), (Component)jPanel2, 0, 2, 1, 1, 0, 0, 0, 10);
        this.setSize(500, 300);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
    }

    public static String createCitationText() {
        String string = "";
        string = string + "<html><body>";
        string = string + "<h2>Referencing MeV</h2>";
        string = string + "<h3>Users of this program should cite:</h3>";
        string = string + "Saeed AI, Sharov V, White J, Li J, Liang W, Bhagabati N, Braisted J, Klapa M, Currier T, Thiagarajan M, Sturn A, Snuffin M, Rezantsev A, Popov D, Ryltsov A, Kostukovich E, Borisovsky I, Liu Z, Vinsavich A, Trush V, Quackenbush J. TM4: a free, open-source system for microarray data management and analysis. Biotechniques. 2003 Feb;34(2):374-8.";
        string = string + "</body></html>";
        return string;
    }

    public static void main(String[] stringArray) {
        MevCitationDialog mevCitationDialog = new MevCitationDialog(new Frame(), MevCitationDialog.createCitationText());
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n > 2) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.clip(new Rectangle2D.Double(0.0, 0.0, pageFormat.getImageableWidth(), pageFormat.getImageableHeight()));
        graphics2D.translate(pageFormat.getImageableX(), (double)(-n) * pageFormat.getImageableHeight());
        graphics2D.scale(1.0, 1.0);
        graphics2D.drawString("Test String", 0, 20);
        this.ed.paint(graphics);
        return 0;
    }

    private Book makeBook(PageFormat pageFormat, int n) {
        Book book = new Book();
        book.append(this, pageFormat, n);
        return book;
    }

    private class EventListener
    implements ActionListener,
    KeyListener {
        private EventListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("close-command")) {
                MevCitationDialog.this.dispose();
            } else if (string.equals("print-command")) {
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                printerJob.setPrintable(MevCitationDialog.this, printerJob.defaultPage());
                int n = MevCitationDialog.this.ed.getHeight();
                n = (int)((double)n / printerJob.defaultPage().getImageableY());
                printerJob.setPageable(MevCitationDialog.this.makeBook(printerJob.defaultPage(), n));
                if (printerJob.printDialog()) {
                    try {
                        printerJob.print();
                    }
                    catch (PrinterException printerException) {
                        System.out.println(printerException);
                    }
                }
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                MevCitationDialog.this.dispose();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

