/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.tigr.util.awt.GBA;

public class AcknowlegementDialog
extends JDialog
implements Printable {
    private String text;
    private JEditorPane ed;

    public AcknowlegementDialog(Frame frame) {
        this(frame, "");
    }

    public AcknowlegementDialog(Frame frame, String string) {
        super(frame, "Contribution Acknowledgement :)", false);
        EventListener eventListener = new EventListener();
        this.addWindowListener(eventListener);
        this.text = string;
        GBA gBA = new GBA();
        Font font = new Font("serif", 0, 12);
        this.ed = new JEditorPane("text/html", string);
        this.ed.setEditable(false);
        this.ed.setMargin(new Insets(10, 10, 10, 10));
        this.ed.setBackground(new Color(234, 233, 191));
        this.ed.setCaretPosition(0);
        JScrollPane jScrollPane = new JScrollPane(this.ed, 20, 31);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(new Color(234, 233, 191));
        gBA.add((Container)jPanel, (Component)jScrollPane, 0, 0, 1, 1, 1, 1, 1, 10);
        JButton jButton = new JButton("Print");
        jButton.setBorder(BorderFactory.createBevelBorder(0));
        jButton.setFocusPainted(false);
        jButton.setActionCommand("print-command");
        jButton.addActionListener(eventListener);
        JButton jButton2 = new JButton("  Close  ");
        jButton2.setBorder(BorderFactory.createBevelBorder(0));
        jButton2.setFocusPainted(false);
        jButton2.setActionCommand("close-command");
        jButton2.addActionListener(eventListener);
        jButton2.setSize(120, 30);
        jButton2.setPreferredSize(new Dimension(120, 30));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        gBA.add((Container)jPanel2, (Component)jButton2, 0, 0, 1, 1, 1, 1, 0, 10);
        this.getContentPane().setLayout(new GridBagLayout());
        gBA.add(this.getContentPane(), (Component)jPanel, 0, 0, 1, 2, 1, 1, 1, 10);
        gBA.add(this.getContentPane(), (Component)jPanel2, 0, 2, 1, 1, 0, 0, 0, 10);
        this.setSize(750, 500);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.show();
    }

    public static String createAcknowlegementText() {
        String string = "";
        string = string + "<html><body><center>";
        string = string + "<br><i><font size=5><b>The Institute for Genomic Research Microarray Software Team expresses sincere thanks for the contributions of those listed below.</font></b></i><br>";
        string = string + "<table border=2 >";
        string = string + "<font size=3><tr><th><b>Contributor</th><th><b>Affiliation</th><th><b>Contribution</th></tr></font>";
        string = string + "<tr valign=top><td>Alexander I. Saeed, Nirmal Bhagabati, John Braisted, Eleanor Howe, John Quackenbush</td><td>The Institute for Genomic Research</td><td>System design, core and module development and implementation, project coordination, documentation, optimization, and usability assurance</td></tr>";
        string = string + "<tr valign=top><td>Alexander Sturn, Zlatko Trajanoski</td><td>Institute of Biomedical Engineering, Graz University of Technology</td><td>Initial system architecture and viewer design, initial module development (HCL, KMC, SOM, PCA, SVM)</td></tr>";
        string = string + "<tr valign=top><td>Mark Snuffin, Aleksey Rezantsev, Dennis Popov, Alex Ryltsov, Edward Kostukovich, Igor Borisovsky</td><td>DataNaut, Inc.</td><td>System architecture, module architecture, parallel processing system, primary module development (RN, TRN)</td></tr>";
        string = string + "<tr valign=top><td>Stu Golub, Zaigang Liu, Jane Ruan, Minhas Siddiqui</td><td>Syntek Systems Corporation, Inc.</td><td>Primary module development (CAST, FOM, GSH, GDM)</td></tr>";
        string = string + "<tr valign=top><td>Wei Liang</td><td>The Institute for Genomic Research</td><td>Normalization algorithm development, TM4 website maintenance</td></tr>";
        string = string + "<tr valign=top><td>Jerry Li, Vasily Sharov, Joe White, Mathangi Thiagarajan, Tracey Currier, Eleanor Howe</td><td>The Institute for Genomic Research</td><td>Additional development, software testing, documentation, support</td></tr>";
        string = string + "<tr valign=top><td>Patrick Cahan, Tim McCaffrey</td><td>The George Washington University</td><td>Affymetrix data loader and filters, Affymetrix loader rework, gene submission capability for the LOLA cluster repository</td></tr>";
        string = string + "<tr valign=top><td>Todd Peterson</td><td>National Center for Genome Resources</td><td>GeneX-Lite to MeV connectivity</td></tr>";
        string = string + "<tr valign=top><td>Luke Somers</td><td>Fox Chase Cancer Center</td><td>QTC algorithm optimization and bug fix</td></tr>";
        string = string + "<tr valign=top><td>Jim Johnson, Ernest Retzel</td><td>Center for Computational Genomics and Bioinformatics, University of Minnesota</td><td>Java WebStart configuration, scripts and consultation to support using ANT technologies for MeV development</td></tr>";
        string = string + "<tr valign=top><td>Glynn Dennis, Douglas Hosack, Richard Lempicki, Wei Gao</td><td>National Institute of Allergy and Infectious Disease, NIH, Laboratory of Immunopathogenesis and Bioinformatics.</td><td>EASEOpenSource Java package to support EASE development and helpful consultation during EASE integration and development.</td></tr>";
        string = string + "<tr valign=top><td>Eric Albert</td><td>Independent Development</td><td>Implementation of BrowserLauncher.java, utility to launch default web browser from within MeV</td></tr>";
        string = string + "<tr valign=top><td>Sally Gaddis</td><td>University of Texas, MD Anderson Cancer Center</td><td>Report and basic testing of Java3D support for mev 3D viewers on the Mac platform.</td></tr>";
        string = string + "<tr valign=top><td>Vu T. Chu</td><td>University of Washington - Microbiology</td><td>Design and implementation of Agilent File loading capabilities.</td></tr>";
        string = string + "<tr valign=top><td>Stephen C. Harris</td><td>FDA, National Center for Toxicological Research</td><td>T-test bug identification, and suggestion for improvement of adjusted Bonferroni correction.</td></tr>";
        string = string + "</table>";
        string = string + "</center></body></html>";
        return string;
    }

    public static void main(String[] stringArray) {
        AcknowlegementDialog acknowlegementDialog = new AcknowlegementDialog(new Frame(), AcknowlegementDialog.createAcknowlegementText());
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n > 2) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.clip(new Rectangle2D.Double(0.0, 0.0, pageFormat.getImageableWidth(), pageFormat.getImageableHeight()));
        graphics2D.translate(pageFormat.getImageableX(), (double)(-n) * pageFormat.getImageableHeight());
        graphics2D.scale(1.0, 1.0);
        graphics2D.drawString("Test String", 0, 20);
        this.ed.paint(graphics);
        return 0;
    }

    private Book makeBook(PageFormat pageFormat, int n) {
        Book book = new Book();
        book.append(this, pageFormat, n);
        return book;
    }

    private class EventListener
    extends WindowAdapter
    implements ActionListener,
    KeyListener {
        private EventListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("close-command")) {
                AcknowlegementDialog.this.dispose();
            } else if (string.equals("print-command")) {
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                printerJob.setPrintable(AcknowlegementDialog.this, printerJob.defaultPage());
                int n = AcknowlegementDialog.this.ed.getHeight();
                n = (int)((double)n / printerJob.defaultPage().getImageableY());
                printerJob.setPageable(AcknowlegementDialog.this.makeBook(printerJob.defaultPage(), n));
                if (printerJob.printDialog()) {
                    try {
                        printerJob.print();
                    }
                    catch (PrinterException printerException) {
                        System.out.println(printerException);
                    }
                }
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            AcknowlegementDialog.this.dispose();
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                AcknowlegementDialog.this.dispose();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

