/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.svm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileFilter;
import org.tigr.microarray.mev.cluster.gui.helpers.ExpressionFileView;
import org.tigr.microarray.mev.cluster.gui.impl.svm.GeneralInfo;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMData;
import org.tigr.microarray.mev.cluster.gui.impl.svm.SVMResultViewer;
import org.tigr.util.FloatMatrix;

public class SVMOneOutViewer
extends SVMResultViewer
implements Serializable {
    public static final long serialVersionUID = 202018060001L;
    private IData experiment;
    private FloatMatrix discriminant;
    private SVMData data;
    private GeneralInfo info;
    private boolean classifyGenes;
    float[] classes;
    float[] discr;
    int[] initClasses;
    float[] classMatch;
    int[] elementScores;
    int[] iterationScores;
    int nonNeuts;

    public SVMOneOutViewer(IFramework iFramework, IData iData, SVMData sVMData, FloatMatrix floatMatrix, GeneralInfo generalInfo, boolean bl, int[] nArray, int[] nArray2, int[] nArray3, int n) {
        super(iFramework);
        this.experiment = iData;
        this.discriminant = floatMatrix;
        this.data = sVMData;
        this.info = generalInfo;
        this.classifyGenes = bl;
        this.initClasses = nArray;
        this.elementScores = nArray2;
        this.iterationScores = nArray3;
        this.nonNeuts = n;
        FloatMatrix floatMatrix2 = floatMatrix.transpose();
        this.classes = floatMatrix2.A[0];
        this.discr = floatMatrix2.A[1];
        this.resultPanel = new ClassifyResultPanel();
        this.displayData();
        this.add((Component)this.resultPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.discr = (float[])objectInputStream.readObject();
        this.classes = (float[])objectInputStream.readObject();
        this.initClasses = (int[])objectInputStream.readObject();
        this.classMatch = (float[])objectInputStream.readObject();
        this.elementScores = (int[])objectInputStream.readObject();
        this.iterationScores = (int[])objectInputStream.readObject();
        this.nonNeuts = objectInputStream.readInt();
        this.classifyGenes = objectInputStream.readBoolean();
        this.data = (SVMData)objectInputStream.readObject();
        this.info = (GeneralInfo)objectInputStream.readObject();
        SVMResultViewer.MyListener myListener = new SVMResultViewer.MyListener(this);
        this.getContentComponent().addMouseListener(myListener);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.discr);
        objectOutputStream.writeObject(this.classes);
        objectOutputStream.writeObject(this.initClasses);
        objectOutputStream.writeObject(this.classMatch);
        objectOutputStream.writeObject(this.elementScores);
        objectOutputStream.writeObject(this.iterationScores);
        objectOutputStream.writeInt(this.nonNeuts);
        objectOutputStream.writeBoolean(this.classifyGenes);
        objectOutputStream.writeObject(this.data);
        objectOutputStream.writeObject(this.info);
    }

    public void onSelected(IFramework iFramework) {
        this.framework = iFramework;
        this.experiment = iFramework.getData();
        this.onMenuChanged(iFramework.getDisplayMenu());
    }

    protected void displayData() {
        this.displayResult(this.classifyGenes);
    }

    private void displayResult(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        DecimalFormat decimalFormat = new DecimalFormat();
        DecimalFormat decimalFormat2 = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(4);
        decimalFormat.setMinimumFractionDigits(4);
        decimalFormat.setGroupingUsed(false);
        stringBuffer.append("Constant : " + Float.toString(this.data.constant) + "\n");
        stringBuffer.append("Coefficient : " + Float.toString(this.data.coefficient) + "\n");
        stringBuffer.append("Power : " + Float.toString(this.data.power) + "\n");
        stringBuffer.append("Diagonal factor : " + Float.toString(this.data.diagonalFactor) + "\n");
        stringBuffer.append("Convergence threshold : " + Float.toString(this.data.convergenceThreshold) + "\n");
        stringBuffer.append("Radial : " + this.data.radial + "\n");
        stringBuffer.append("Width factor : " + Float.toString(this.data.widthFactor) + "\n");
        stringBuffer.append("Use Constraint : " + this.data.constrainWeights + "\n");
        stringBuffer.append("Positive Constraint : " + Float.toString(this.data.positiveConstraint) + "\n");
        stringBuffer.append("Negative Constraint : " + Float.toString(this.data.negativeConstraint) + "\n");
        stringBuffer.append("Seed : " + Float.toString(this.data.seed) + "\n");
        stringBuffer.append("Calculation time : " + Float.toString(this.info.time) + " ms\n");
        stringBuffer.append("Objective : " + Float.toString(this.data.objective1) + "\n\n");
        stringBuffer.append("                                  Element           Iteration\n");
        if (bl) {
            if (this.labelIndex >= 0 && this.labelIndex < this.fieldNames.length) {
                stringBuffer.append(" Index  Init. Class.  Discr.     Score      %      Score     %    " + this.fieldNames[this.labelIndex]);
            } else {
                stringBuffer.append(" Index  Init. Class.  Discr.     Score      %      Score     %");
            }
        } else {
            stringBuffer.append(" Index  Init. Class.  Discr.     Score     %      Score     %       Experiment");
        }
        this.Log.setText(stringBuffer.toString());
        this.Log.setCaretPosition(0);
    }

    protected void onSaveResult() {
        JFileChooser jFileChooser = new JFileChooser(TMEV.getFile((String)"data/"));
        jFileChooser.addChoosableFileFilter((FileFilter)new ExpressionFileFilter());
        jFileChooser.setFileView((FileView)new ExpressionFileView());
        int n = jFileChooser.showSaveDialog(JOptionPane.getFrameForComponent(this));
        if (n != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            int n2 = this.discriminant.getRowDimension();
            String string = this.Log.getText();
            string = string.substring(0, string.lastIndexOf("Element"));
            bufferedWriter.write(string);
            if (this.classifyGenes) {
                if (this.labelIndex >= 0 && this.labelIndex < this.fieldNames.length) {
                    bufferedWriter.write("Index\tInitClass\tClass.\tDiscr.\tElementScore\tElement %\tIterationScore\tIteration %\t" + this.fieldNames[this.labelIndex] + "\t\n");
                } else {
                    bufferedWriter.write("Index\tInitClass\tClass.\tDiscr.\tElementScore\tElement %\tIterationScore\tIteration %\t\n");
                }
            } else {
                bufferedWriter.write("Index\tInitClass\tClass.\tDiscr.\tElementScore\tElement %\tIterationScore\tIteration %\tExperiment\t\n");
            }
            for (int i = 0; i < n2; ++i) {
                bufferedWriter.write(((ClassifyResultPanel)this.resultPanel).getTabbedLine(i) + "\n");
            }
            bufferedWriter.flush();
            bufferedWriter.close();
            bufferedWriter = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error writing to file " + file.getPath() + "!", "Error", 0);
        }
    }

    protected Dimension updateSize() {
        return ((ClassifyResultPanel)this.resultPanel).updateSize();
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int n) {
        return null;
    }

    public class ClassifyResultPanel
    extends JPanel {
        int lineHeight = 20;
        int indexLength = 1;
        DecimalFormat floatFormat = new DecimalFormat();
        DecimalFormat intFormat;
        DecimalFormat indexFormat;
        DecimalFormat singleFloatFormat;
        String[] spacerStrings;

        public ClassifyResultPanel() {
            this.floatFormat.setMaximumFractionDigits(4);
            this.floatFormat.setMinimumFractionDigits(4);
            this.floatFormat.setPositivePrefix("+");
            this.floatFormat.setGroupingUsed(false);
            this.singleFloatFormat = new DecimalFormat();
            this.singleFloatFormat.setMaximumFractionDigits(1);
            this.singleFloatFormat.setMinimumFractionDigits(1);
            this.singleFloatFormat.setGroupingUsed(false);
            this.intFormat = new DecimalFormat();
            this.intFormat.setMinimumFractionDigits(0);
            this.intFormat.setMaximumFractionDigits(0);
            this.intFormat.setPositivePrefix("+");
            this.intFormat.setGroupingUsed(false);
            this.indexFormat = new DecimalFormat();
            this.indexFormat = new DecimalFormat();
            this.indexFormat.setMinimumFractionDigits(0);
            this.indexFormat.setMaximumFractionDigits(0);
            this.indexLength = String.valueOf(SVMOneOutViewer.this.classes.length).length();
            this.indexFormat.setMinimumIntegerDigits(this.indexLength);
            this.indexFormat.setGroupingUsed(false);
            this.setBackground(Color.white);
            Dimension dimension = this.updateSize();
            this.setSize(dimension.width, SVMOneOutViewer.this.classes.length * this.lineHeight + 10);
            this.setPreferredSize(new Dimension(dimension.width, SVMOneOutViewer.this.classes.length * this.lineHeight + 5));
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            graphics.setFont(new Font("monospaced", 0, 14));
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Rectangle rectangle = graphics.getClipBounds();
            int n = this.getTopIndex(rectangle.y);
            int n2 = this.getBottomIndex(rectangle.y + rectangle.height, SVMOneOutViewer.this.classes.length + 1);
            for (int i = n; i < n2; ++i) {
                if (!this.isLegalIndex(i)) continue;
                graphics.drawString(this.getLine(i), 10, (i + 1) * this.lineHeight);
            }
        }

        private boolean isLegalIndex(int n) {
            return n >= 0 && n < SVMOneOutViewer.this.classes.length;
        }

        private int getTopIndex(int n) {
            if (n < 0) {
                return 0;
            }
            return n / this.lineHeight;
        }

        private int getBottomIndex(int n, int n2) {
            if (n < 0) {
                return 0;
            }
            int n3 = n / this.lineHeight + 1;
            return n3 > n2 ? n2 : n3;
        }

        private String getLine(int n) {
            int n2;
            String string = " ";
            int n3 = this.indexFormat.format(n + 1).length();
            int n4 = this.floatFormat.format(SVMOneOutViewer.this.discr[n]).length();
            int n5 = (String.valueOf(SVMOneOutViewer.this.elementScores[n]) + "/" + String.valueOf(SVMOneOutViewer.this.iterationScores.length)).length();
            int n6 = this.singleFloatFormat.format((double)SVMOneOutViewer.this.elementScores[n] / (double)SVMOneOutViewer.this.iterationScores.length * 100.0).length();
            int n7 = (String.valueOf(SVMOneOutViewer.this.iterationScores[n]) + "/" + String.valueOf(SVMOneOutViewer.this.nonNeuts)).length();
            int n8 = this.singleFloatFormat.format((double)SVMOneOutViewer.this.iterationScores[n] / (double)SVMOneOutViewer.this.nonNeuts * 100.0).length();
            string = string + this.indexFormat.format(n + 1);
            for (n2 = n3; n2 < 8; ++n2) {
                string = string + " ";
            }
            if (SVMOneOutViewer.this.initClasses[n] >= 0) {
                string = string + " ";
            }
            string = string + this.intFormat.format(SVMOneOutViewer.this.initClasses[n]);
            string = string + "    ";
            if (SVMOneOutViewer.this.classes[n] >= 0.0f) {
                string = string + " ";
            }
            string = string + this.intFormat.format(SVMOneOutViewer.this.classes[n]);
            string = string + "    ";
            if (SVMOneOutViewer.this.discr[n] >= 0.0f) {
                string = string + " ";
            }
            string = string + this.floatFormat.format(SVMOneOutViewer.this.discr[n]);
            for (n2 = 0; n2 < 9 - n5; ++n2) {
                string = string + " ";
            }
            string = string + String.valueOf(SVMOneOutViewer.this.elementScores[n]) + "/" + String.valueOf(SVMOneOutViewer.this.iterationScores.length);
            for (n2 = 0; n2 < 8 - n6; ++n2) {
                string = string + " ";
            }
            string = string + this.singleFloatFormat.format((double)SVMOneOutViewer.this.elementScores[n] / (double)SVMOneOutViewer.this.iterationScores.length * 100.0);
            for (n2 = 0; n2 < 9 - n7; ++n2) {
                string = string + " ";
            }
            string = string + String.valueOf(SVMOneOutViewer.this.iterationScores[n]) + "/" + String.valueOf(SVMOneOutViewer.this.nonNeuts);
            for (n2 = 0; n2 < 8 - n8; ++n2) {
                string = string + " ";
            }
            string = string + this.singleFloatFormat.format((double)SVMOneOutViewer.this.iterationScores[n] / (double)SVMOneOutViewer.this.nonNeuts * 100.0);
            string = string + "      ";
            string = SVMOneOutViewer.this.classifyGenes ? string + SVMOneOutViewer.this.experiment.getElementAttribute(SVMOneOutViewer.this.getMultipleArrayDataRow(n), SVMOneOutViewer.this.labelIndex) : string + SVMOneOutViewer.this.experiment.getSampleName(n);
            return string;
        }

        private String getTabbedLine(int n) {
            String string = new String();
            string = string + this.indexFormat.format(n + 1);
            string = string + "\t ";
            string = string + this.intFormat.format(SVMOneOutViewer.this.initClasses[n]);
            string = string + "\t";
            string = string + this.intFormat.format(SVMOneOutViewer.this.classes[n]);
            string = string + "\t";
            string = string + this.floatFormat.format(SVMOneOutViewer.this.discr[n]);
            string = string + "\t";
            string = string + "( " + String.valueOf(SVMOneOutViewer.this.elementScores[n]) + " / " + String.valueOf(SVMOneOutViewer.this.iterationScores.length) + " )";
            string = string + "\t";
            string = string + this.singleFloatFormat.format((double)SVMOneOutViewer.this.elementScores[n] / (double)SVMOneOutViewer.this.iterationScores.length * 100.0);
            string = string + "\t";
            string = string + "( " + String.valueOf(SVMOneOutViewer.this.iterationScores[n]) + " / " + String.valueOf(SVMOneOutViewer.this.nonNeuts) + " )";
            string = string + "\t";
            string = string + this.singleFloatFormat.format((double)SVMOneOutViewer.this.iterationScores[n] / (double)SVMOneOutViewer.this.nonNeuts * 100.0);
            string = string + "\t";
            string = SVMOneOutViewer.this.classifyGenes ? string + SVMOneOutViewer.this.experiment.getElementAttribute(SVMOneOutViewer.this.getMultipleArrayDataRow(n), SVMOneOutViewer.this.labelIndex) : string + SVMOneOutViewer.this.experiment.getSampleName(n);
            return string;
        }

        protected String[] getSpacerStrings(int n, String string, String string2) {
            int n2;
            String[] stringArray = new String[3];
            stringArray[2] = "";
            stringArray[1] = "";
            stringArray[0] = "";
            for (n2 = n; n2 < 10; ++n2) {
                stringArray[0] = stringArray[0] + " ";
            }
            if (string.length() == 1) {
                stringArray[0] = stringArray[0] + " ";
            }
            stringArray[1] = "     ";
            int n3 = 13 - string2.length();
            for (n2 = 0; n2 < n3; ++n2) {
                stringArray[2] = stringArray[2] + " ";
            }
            return stringArray;
        }

        protected Dimension updateSize() {
            FontMetrics fontMetrics = this.getFontMetrics(new Font("monospaced", 0, 14));
            int n = 0;
            this.indexLength = String.valueOf(SVMOneOutViewer.this.classes.length).length();
            this.floatFormat = new DecimalFormat();
            this.floatFormat.setMaximumFractionDigits(4);
            this.floatFormat.setMinimumFractionDigits(4);
            this.floatFormat.setGroupingUsed(false);
            this.intFormat = new DecimalFormat();
            this.intFormat.setMinimumFractionDigits(0);
            this.intFormat.setMaximumFractionDigits(0);
            this.intFormat.setGroupingUsed(false);
            this.indexFormat = new DecimalFormat();
            this.indexFormat = new DecimalFormat();
            this.indexFormat.setMinimumFractionDigits(0);
            this.indexFormat.setMaximumFractionDigits(0);
            this.indexFormat.setMinimumIntegerDigits(this.indexLength);
            this.indexFormat.setGroupingUsed(false);
            int n2 = SVMOneOutViewer.this.classifyGenes ? SVMOneOutViewer.this.experiment.getFeaturesSize() : SVMOneOutViewer.this.experiment.getFeaturesCount();
            for (int i = 0; i < n2; ++i) {
                String string = this.getLine(i);
                n = Math.max(n, fontMetrics.stringWidth(string));
            }
            this.setSize(n + 10, this.getHeight());
            this.setPreferredSize(new Dimension(n + 10, this.getHeight()));
            return new Dimension(n + 10, this.getHeight());
        }
    }
}

