/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sota;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLCluster;
import org.tigr.util.FloatMatrix;

public class SOTAExpCentroidExpressionViewer
extends JPanel
implements IViewer,
Serializable {
    public static final long serialVersionUID = 202017020001L;
    private int numberOfCentroids;
    private int[] clusterPopulation;
    private FloatMatrix clusterDiversity;
    private int TEXT_LEFT_MARGIN = 20;
    private int CLUSTER_POP_SPACER = 20;
    private int POP_DIV_SPACER = 20;
    private static final float INITIAL_MAX_VALUE = 3.0f;
    private static final float INITIAL_MIN_VALUE = -3.0f;
    private static final String NO_GENES_STR = "No Experiments in Cluster!";
    private static final Font ERROR_FONT = new Font("monospaced", 1, 20);
    private ColorBarHeader header;
    private Experiment experiment;
    private Experiment experimentMap;
    private IFramework framework;
    private IData data;
    private int clusterIndex;
    private int labelIndex;
    private int[][] clusters;
    private int[] samplesOrder;
    private Dimension elementSize = new Dimension(40, 20);
    private boolean isAntiAliasing = true;
    private boolean isDrawBorders = true;
    public static Color missingColor = new Color(128, 128, 128);
    public static Color maskColor = new Color(255, 255, 255, 128);
    private float maxValue = 3.0f;
    private float minValue = -3.0f;
    private float midValue = 0.0f;
    private int firstSelectedRow = -1;
    private int lastSelectedRow = -1;
    private ArrayList selectedClusterList;
    public BufferedImage posColorImage = this.createGradientImage(Color.black, Color.red);
    public BufferedImage negColorImage = this.createGradientImage(Color.green, Color.black);
    private int maxUniqueIDWidth;
    private int maxGeneNameWidth;
    private Listener listener;
    private Insets insets = new Insets(0, 10, 0, 0);
    private int numberOfGenes;
    private boolean haveColorBar = false;
    private boolean useDoubleGradient = true;

    public SOTAExpCentroidExpressionViewer(Experiment experiment, Experiment experiment2, int[][] nArray, int[] nArray2, int[] nArray3, FloatMatrix floatMatrix, ArrayList arrayList) {
        if (experiment == null) {
            throw new IllegalArgumentException("experiment == null");
        }
        this.experiment = experiment;
        this.experimentMap = experiment2;
        this.numberOfGenes = this.experiment.getNumberOfGenes();
        this.clusterPopulation = nArray3;
        this.clusterDiversity = floatMatrix;
        this.numberOfCentroids = this.clusterPopulation.length;
        this.selectedClusterList = arrayList;
        this.clusters = nArray == null ? SOTAExpCentroidExpressionViewer.defGenesOrder(this.experiment.getNumberOfGenes()) : nArray;
        this.samplesOrder = nArray2 == null ? SOTAExpCentroidExpressionViewer.defSamplesOrder(this.experiment.getNumberOfSamples()) : nArray2;
        this.header = new ColorBarHeader(this.numberOfCentroids);
        this.header.setNegAndPosColorImages(this.negColorImage, this.posColorImage);
        this.setBackground(Color.white);
        this.listener = new Listener();
        this.addMouseMotionListener(this.listener);
        this.addMouseListener(this.listener);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.header);
        objectOutputStream.writeObject(this.experiment);
        objectOutputStream.writeObject(this.experimentMap);
        objectOutputStream.writeObject(this.clusters);
        objectOutputStream.writeInt(this.numberOfCentroids);
        objectOutputStream.writeObject(this.clusterPopulation);
        objectOutputStream.writeObject(this.clusterDiversity);
        objectOutputStream.writeObject(this.selectedClusterList);
        objectOutputStream.writeObject(this.samplesOrder);
        objectOutputStream.writeObject(this.elementSize);
        objectOutputStream.writeObject(this.insets);
        objectOutputStream.writeBoolean(this.useDoubleGradient);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.header = (ColorBarHeader)objectInputStream.readObject();
        this.experiment = (Experiment)objectInputStream.readObject();
        this.experimentMap = (Experiment)objectInputStream.readObject();
        this.clusters = (int[][])objectInputStream.readObject();
        this.numberOfCentroids = objectInputStream.readInt();
        this.clusterPopulation = (int[])objectInputStream.readObject();
        this.clusterDiversity = (FloatMatrix)objectInputStream.readObject();
        this.selectedClusterList = (ArrayList)objectInputStream.readObject();
        this.samplesOrder = (int[])objectInputStream.readObject();
        this.elementSize = (Dimension)objectInputStream.readObject();
        this.insets = (Insets)objectInputStream.readObject();
        this.useDoubleGradient = objectInputStream.readBoolean();
        this.TEXT_LEFT_MARGIN = 20;
        this.CLUSTER_POP_SPACER = 20;
        this.POP_DIV_SPACER = 20;
        this.firstSelectedRow = -1;
        this.lastSelectedRow = -1;
        this.listener = new Listener();
        this.addMouseListener(this.listener);
        this.addMouseMotionListener(this.listener);
    }

    private static int[] defSamplesOrder(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    private static int[][] defGenesOrder(int n) {
        int[][] nArray = new int[1][n];
        for (int i = 0; i < nArray[0].length; ++i) {
            nArray[0][i] = i;
        }
        return nArray;
    }

    public JComponent getHeaderComponent() {
        return this.header;
    }

    public JComponent getContentComponent() {
        return this;
    }

    public BufferedImage getImage() {
        return null;
    }

    public BufferedImage getPosColorImage() {
        return this.posColorImage;
    }

    public BufferedImage getNegColorImage() {
        return this.negColorImage;
    }

    public Color getMissingColor() {
        return missingColor;
    }

    protected boolean areProbesColored() {
        int[] nArray = this.getCluster();
        for (int i = 0; i < nArray.length; ++i) {
            if (this.data.getProbeColor(this.getMultipleArrayDataRow(i)) == null) continue;
            return true;
        }
        return false;
    }

    public void selectRows(int n, int n2) {
        this.firstSelectedRow = n;
        this.lastSelectedRow = n2;
        this.repaint();
    }

    public void onSelected(IFramework iFramework) {
        this.framework = iFramework;
        this.data = iFramework.getData();
        Integer n = (Integer)iFramework.getUserObject();
        this.setClusterIndex(n == null ? 0 : n);
        IDisplayMenu iDisplayMenu = iFramework.getDisplayMenu();
        this.useDoubleGradient = iDisplayMenu.getUseDoubleGradient();
        this.labelIndex = iDisplayMenu.getLabelIndex();
        this.maxValue = Math.abs(iDisplayMenu.getMaxRatioScale());
        this.minValue = -Math.abs(iDisplayMenu.getMinRatioScale());
        this.setElementSize(iDisplayMenu.getElementSize());
        this.setAntialiasing(iDisplayMenu.isAntiAliasing());
        this.setDrawBorders(iDisplayMenu.isDrawingBorder());
        this.updateSize();
        this.posColorImage = iDisplayMenu.getPositiveGradientImage();
        this.negColorImage = iDisplayMenu.getNegativeGradientImage();
        this.insets.top = this.selectedClusterList.size() > 0 ? this.elementSize.height + 1 : 0;
        this.header.setNegAndPosColorImages(this.negColorImage, this.posColorImage);
        this.header.setValues(this.minValue, this.maxValue);
        this.header.setAntiAliasing(iDisplayMenu.isAntiAliasing());
        this.header.updateSizes(this.getSize().width, this.elementSize.width);
    }

    public void onMenuChanged(IDisplayMenu iDisplayMenu) {
        this.useDoubleGradient = iDisplayMenu.getUseDoubleGradient();
        this.setDrawBorders(iDisplayMenu.isDrawingBorder());
        this.labelIndex = iDisplayMenu.getLabelIndex();
        this.maxValue = Math.abs(iDisplayMenu.getMaxRatioScale());
        this.minValue = -Math.abs(iDisplayMenu.getMinRatioScale());
        this.header.setValues(this.minValue, this.maxValue);
        this.posColorImage = iDisplayMenu.getPositiveGradientImage();
        this.negColorImage = iDisplayMenu.getNegativeGradientImage();
        this.header.setNegAndPosColorImages(this.negColorImage, this.posColorImage);
        this.setElementSize(iDisplayMenu.getElementSize());
        if (this.selectedClusterList.size() > 0) {
            this.insets.top = this.elementSize.height + 1;
        }
        this.setAntialiasing(iDisplayMenu.isAntiAliasing());
        this.haveColorBar = this.areProbesColored();
        this.updateSize();
        this.header.setAntiAliasing(iDisplayMenu.isAntiAliasing());
        this.header.updateSizes(this.getSize().width, this.elementSize.width);
    }

    public void onDataChanged(IData iData) {
        this.data = iData;
        this.insets.top = this.selectedClusterList.size() > 0 ? this.elementSize.height + 1 : 0;
    }

    public void onDeselected() {
    }

    public void onClosed() {
    }

    public void setClusterIndex(int n) {
        this.clusterIndex = n;
    }

    public int getClusterIndex() {
        return this.clusterIndex;
    }

    public int[] getCluster() {
        return this.clusters[this.clusterIndex];
    }

    public int[][] getClusters() {
        return this.clusters;
    }

    private int getRow(int n) {
        return this.clusters[this.clusterIndex][n];
    }

    private int getColumn(int n) {
        return this.samplesOrder[n];
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    private int getMultipleArrayDataRow(int n) {
        return this.experimentMap.getGeneIndexMappedToData(n);
    }

    private int[] getIDataRowIndices(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = this.experimentMap.getGeneIndexMappedToData(nArray[i]);
        }
        return nArray2;
    }

    protected IData getData() {
        return this.data;
    }

    public void setClusterColor(Color color) {
        this.data.setExperimentColor(this.getIDataRowIndices(this.getCluster()), color);
        this.insets.top = this.elementSize.height + 1;
    }

    public void saveClusters(Frame frame) throws Exception {
        frame = frame == null ? JOptionPane.getFrameForComponent(this) : frame;
        ExperimentUtil.saveAllExperimentClusters((Frame)frame, (Experiment)this.getExperiment(), (IData)this.getData(), (int[][])this.getClusters());
    }

    public void saveCluster(Frame frame) throws Exception {
        frame = frame == null ? JOptionPane.getFrameForComponent(this) : frame;
        ExperimentUtil.saveExperimentCluster((Frame)frame, (Experiment)this.getExperiment(), (IData)this.getData(), (int[])this.getCluster());
    }

    private void setElementSize(Dimension dimension) {
        this.elementSize = new Dimension(dimension);
    }

    private void setAntialiasing(boolean bl) {
        this.isAntiAliasing = bl;
    }

    private void setDrawBorders(boolean bl) {
        this.isDrawBorders = bl;
    }

    public BufferedImage createGradientImage(Color color, Color color2) {
        BufferedImage bufferedImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(256, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, 255.0f, 0.0f, color2);
        graphics2D.setPaint(gradientPaint);
        graphics2D.drawRect(0, 0, 255, 1);
        return bufferedImage;
    }

    private void updateSize() {
        if (this.clusters == null || this.getCluster().length == 0) {
            this.setFont(ERROR_FONT);
            Graphics2D graphics2D = (Graphics2D)this.getGraphics();
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n = fontMetrics.stringWidth(NO_GENES_STR) + 10;
            int n2 = fontMetrics.getHeight() + 30;
            this.setSize(n, n2);
            this.setPreferredSize(new Dimension(n, n2));
            return;
        }
        this.setFont(new Font("monospaced", 0, this.elementSize.height));
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        int n = this.elementSize.width * this.numberOfCentroids + this.insets.left + 1;
        int n3 = this.elementSize.height * this.experiment.getNumberOfGenes() + this.insets.top + 1;
        this.setSize(n += this.getAnnotationWidth(graphics2D) + 30, n3);
        this.setPreferredSize(new Dimension(n, n3));
    }

    private int getAnnotationWidth(Graphics graphics) {
        int n = 0;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        for (int i = 0; i < this.numberOfGenes; ++i) {
            n = Math.max(n, fontMetrics.stringWidth(this.data.getElementAttribute(this.getMultipleArrayDataRow(i), this.labelIndex)));
        }
        return n;
    }

    private int getClusterTextWidth(Graphics2D graphics2D) {
        return this.getPopulationTextWidth(graphics2D) + this.getDiversityTextWidth(graphics2D) + this.getClusterNumberTextWidth(graphics2D);
    }

    private int getPopulationTextWidth(Graphics2D graphics2D) {
        int n = 0;
        int n2 = 0;
        if (this.clusterPopulation == null) {
            return 0;
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        for (int i = 0; i < this.clusterPopulation.length; ++i) {
            n2 = fontMetrics.stringWidth(String.valueOf(this.clusterPopulation[i]));
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private int getDiversityTextWidth(Graphics2D graphics2D) {
        int n = 0;
        int n2 = 0;
        if (this.clusterDiversity == null) {
            return 0;
        }
        int n3 = this.clusterDiversity.getRowDimension();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        for (int i = 0; i < n3; ++i) {
            n2 = fontMetrics.stringWidth(String.valueOf(this.clusterDiversity.get(i, 0)));
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private int getClusterNumberTextWidth(Graphics2D graphics2D) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        return fontMetrics.stringWidth(String.valueOf(this.numberOfCentroids));
    }

    private Color getColor(float f) {
        int n;
        if (Float.isNaN(f)) {
            return missingColor;
        }
        if (this.useDoubleGradient) {
            float f2 = f < this.midValue ? this.minValue : this.maxValue;
            int n2 = (int)(255.0f * (f - this.midValue) / (f2 - this.midValue));
            n2 = n2 > 255 ? 255 : n2;
            n = f < this.midValue ? this.negColorImage.getRGB(255 - n2, 0) : this.posColorImage.getRGB(n2, 0);
        } else {
            float f3 = this.maxValue - this.minValue;
            int n3 = f <= this.minValue ? 0 : (f >= this.maxValue ? 255 : (int)((f - this.minValue) / f3 * 255.0f));
            n = this.posColorImage.getRGB(n3, 0);
        }
        return new Color(n);
    }

    public void paint(Graphics graphics) {
        int n;
        super.paint(graphics);
        if (this.isAntiAliasing) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        if (this.clusters == null || this.getCluster().length == 0) {
            graphics.setColor(new Color(0, 0, 128));
            graphics.setFont(ERROR_FONT);
            graphics.drawString(NO_GENES_STR, 10, 30);
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        int n2 = this.getTopIndex(rectangle.y);
        int n3 = this.getBottomIndex(rectangle.y + rectangle.height, this.getCluster().length);
        int n4 = this.getLeftIndex(rectangle.x);
        int n5 = this.getRightIndex(rectangle.x + rectangle.width, this.numberOfCentroids);
        for (int i = n4; i < n5; ++i) {
            for (int j = n2; j < n3; ++j) {
                this.fillRectAt(graphics, j, i);
            }
        }
        graphics.setColor(Color.black);
        if (!this.selectedClusterList.isEmpty()) {
            Color color = graphics.getColor();
            for (n = 0; n < this.selectedClusterList.size(); ++n) {
                HCLCluster hCLCluster = (HCLCluster)this.selectedClusterList.get(n);
                graphics.setColor(hCLCluster.color);
                graphics.fillRect(this.elementSize.width * hCLCluster.root + this.insets.left, 0, this.elementSize.width, this.elementSize.height);
            }
        }
        if (n5 >= this.numberOfCentroids) {
            String string = "";
            graphics.setColor(Color.black);
            int n6 = this.elementSize.width * this.numberOfCentroids + 10;
            for (int i = n2; i < n3; ++i) {
                if (this.labelIndex >= 0) {
                    string = this.data.getElementAttribute(this.getMultipleArrayDataRow(i), this.labelIndex);
                }
                n = (i + 1) * this.elementSize.height + this.insets.top;
                graphics.drawString(string, n6 + this.insets.left, n);
            }
        }
    }

    private void fillRectAt(Graphics graphics, int n, int n2) {
        boolean bl;
        int n3 = n2 * this.elementSize.width + this.insets.left;
        int n4 = n * this.elementSize.height + this.insets.top;
        boolean bl2 = bl = this.firstSelectedRow >= 0 && this.lastSelectedRow >= 0 && (n < this.firstSelectedRow || n > this.lastSelectedRow);
        if (this.clusterPopulation[n2] > 0) {
            graphics.setColor(this.getColor(this.experiment.get(this.getRow(n), this.getColumn(n2))));
        } else {
            graphics.setColor(missingColor);
        }
        graphics.fillRect(n3, n4, this.elementSize.width, this.elementSize.height);
        if (bl) {
            graphics.setColor(maskColor);
            graphics.fillRect(n3, n4, this.elementSize.width, this.elementSize.height);
        }
        if (this.isDrawBorders) {
            graphics.setColor(Color.black);
            graphics.drawRect(n3, n4, this.elementSize.width - 1, this.elementSize.height - 1);
        }
    }

    private void drawRectAt(Graphics graphics, int n, int n2, Color color) {
        graphics.setColor(color);
        graphics.drawRect(n2 * this.elementSize.width + this.insets.left, n * this.elementSize.height + this.insets.top, this.elementSize.width - 1, this.elementSize.height - 1);
    }

    private void drawCentroidRectangle(Graphics graphics, int n, Color color) {
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        graphics.drawRect(n * this.elementSize.width + this.insets.left, this.insets.top, this.elementSize.width - 1, this.numberOfGenes * this.elementSize.height - 1);
        graphics.setColor(color2);
    }

    private void fillCentroid(Graphics graphics, int n) {
        for (int i = 0; i < this.numberOfGenes; ++i) {
            this.fillRectAt(graphics, i, n);
        }
    }

    private int getTopIndex(int n) {
        if (n < this.insets.top) {
            return 0;
        }
        return (n - this.insets.top) / this.elementSize.height;
    }

    private int getLeftIndex(int n) {
        if (n < this.insets.left) {
            return 0;
        }
        return (n - this.insets.left) / this.elementSize.width;
    }

    private int getRightIndex(int n, int n2) {
        if (n < 0) {
            return 0;
        }
        int n3 = n / this.elementSize.width + 1;
        return n3 > n2 ? n2 : n3;
    }

    private int getBottomIndex(int n, int n2) {
        if (n < 0) {
            return 0;
        }
        int n3 = (n - this.insets.top) / this.elementSize.height + 1;
        return n3 > n2 ? n2 : n3;
    }

    private int findColumn(int n) {
        int n2 = this.experiment.getNumberOfSamples() * this.elementSize.width;
        if (n >= n2 || n < 0) {
            return -1;
        }
        return n / this.elementSize.width;
    }

    private int findRow(int n) {
        int n2 = this.getCluster().length * this.elementSize.height + this.insets.top;
        if (n >= n2 || n < this.insets.top) {
            return -1;
        }
        return (n - this.insets.top) / this.elementSize.height;
    }

    private boolean isLegalPosition(int n, int n2) {
        return this.isLegalRow(n) && this.isLegalColumn(n2);
    }

    private boolean isLegalColumn(int n) {
        return n >= 0 && n <= this.experiment.getNumberOfSamples() - 1;
    }

    private boolean isLegalRow(int n) {
        return n >= 0 && n <= this.getCluster().length - 1;
    }

    public int getCurrentCentroidNumber() {
        return this.listener.getCurrCentroidNumber();
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public JComponent getCornerComponent(int n) {
        return null;
    }

    public int getViewerType() {
        return -1;
    }

    public class ColorBarHeader
    extends JPanel {
        private static final int RECT_HEIGHT = 15;
        private int elementWidth;
        private boolean isAntiAliasing = true;
        private float maxValue = 3.0f;
        private float minValue = -3.0f;
        private Insets insets = new Insets(0, 10, 0, 0);
        private int numberOfElements;
        private BufferedImage negColorImage;
        private BufferedImage posColorImage;

        public ColorBarHeader(int n) {
            this.numberOfElements = n;
            this.setBackground(Color.white);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeInt(this.elementWidth);
            objectOutputStream.writeBoolean(this.isAntiAliasing);
            objectOutputStream.writeFloat(this.maxValue);
            objectOutputStream.writeFloat(this.minValue);
            objectOutputStream.writeObject(this.insets);
            objectOutputStream.writeInt(this.numberOfElements);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.elementWidth = objectInputStream.readInt();
            this.isAntiAliasing = objectInputStream.readBoolean();
            this.maxValue = objectInputStream.readFloat();
            this.minValue = objectInputStream.readFloat();
            this.insets = (Insets)objectInputStream.readObject();
            this.numberOfElements = objectInputStream.readInt();
        }

        public void setValues(float f, float f2) {
            this.maxValue = f2;
            this.minValue = f;
        }

        public void setNegAndPosColorImages(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
            this.negColorImage = bufferedImage;
            this.posColorImage = bufferedImage2;
        }

        public void setAntiAliasing(boolean bl) {
            this.isAntiAliasing = bl;
        }

        public void setLeftInset(int n) {
            this.insets.left = n;
        }

        private void setElementWidth(int n) {
            this.elementWidth = n;
            if (n > 12) {
                n = 12;
            }
            this.setFont(new Font("monospaced", 0, n));
        }

        public void updateSizes(int n, int n2) {
            this.setElementWidth(n2);
            Graphics2D graphics2D = (Graphics2D)this.getGraphics();
            if (graphics2D == null) {
                return;
            }
            if (this.isAntiAliasing) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n3 = 25 + fontMetrics.getHeight();
            int n4 = this.numberOfElements * n2;
            this.setSize(n4, n3);
            this.setPreferredSize(new Dimension(n4, n3));
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.isAntiAliasing) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            this.drawHeader(graphics2D);
        }

        private void drawHeader(Graphics2D graphics2D) {
            int n = this.numberOfElements * this.elementWidth;
            if (SOTAExpCentroidExpressionViewer.this.useDoubleGradient) {
                graphics2D.drawImage(this.negColorImage, this.insets.left, 0, (int)((float)n / 2.0f), 15, null);
                graphics2D.drawImage(this.posColorImage, (int)((float)n / 2.0f + (float)this.insets.left), 0, (int)((double)n / 2.0), 15, null);
            } else {
                graphics2D.drawImage(this.posColorImage, this.insets.left, 0, n, 15, null);
            }
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n2 = fontMetrics.getDescent();
            int n3 = fontMetrics.getHeight();
            graphics2D.setColor(Color.black);
            graphics2D.drawString(String.valueOf(this.minValue), this.insets.left, 15 + n3);
            int n4 = fontMetrics.stringWidth("0.0");
            if (SOTAExpCentroidExpressionViewer.this.useDoubleGradient) {
                graphics2D.drawString("0.0", (int)((float)n / 2.0f) - n4 / 2 + this.insets.left, 15 + n3);
            }
            n4 = fontMetrics.stringWidth(String.valueOf(this.maxValue));
            graphics2D.drawString(String.valueOf(this.maxValue), n - n4 + this.insets.left, 15 + n3);
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    MouseMotionListener {
        int x = 0;
        int y = 0;
        int currCentroidNumber;
        int oldCentroidNumber;
        Point origin;
        int originX;
        int originY;
        Rectangle expBounds;
        float xDim;
        float yDim;
        Graphics g;
        Color rectangleColor = Color.white;

        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.x = mouseEvent.getX();
            this.y = mouseEvent.getY();
            this.currCentroidNumber = this.cursorOverCentroid(this.x, this.y);
            if (this.currCentroidNumber != this.oldCentroidNumber) {
                int n;
                this.g = SOTAExpCentroidExpressionViewer.this.getGraphics();
                if (this.currCentroidNumber != -1) {
                    if (this.oldCentroidNumber != -1) {
                        for (n = 0; n < SOTAExpCentroidExpressionViewer.this.numberOfGenes; ++n) {
                            SOTAExpCentroidExpressionViewer.this.fillRectAt(this.g, n, this.oldCentroidNumber);
                        }
                    }
                    SOTAExpCentroidExpressionViewer.this.drawCentroidRectangle(this.g, this.currCentroidNumber, this.rectangleColor);
                    SOTAExpCentroidExpressionViewer.this.framework.setStatusText("Cluster # " + (this.currCentroidNumber + 1) + ",  Population: " + SOTAExpCentroidExpressionViewer.this.clusterPopulation[this.currCentroidNumber] + ",  Diversity: " + SOTAExpCentroidExpressionViewer.this.clusterDiversity.get(this.currCentroidNumber, 0));
                }
                if (this.currCentroidNumber == -1 && this.oldCentroidNumber != -1) {
                    for (n = 0; n < SOTAExpCentroidExpressionViewer.this.numberOfGenes; ++n) {
                        SOTAExpCentroidExpressionViewer.this.fillRectAt(this.g, n, this.oldCentroidNumber);
                    }
                    SOTAExpCentroidExpressionViewer.this.framework.setStatusText(" ");
                }
                this.oldCentroidNumber = this.currCentroidNumber;
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            Graphics graphics = SOTAExpCentroidExpressionViewer.this.getGraphics();
            if (this.currCentroidNumber != -1) {
                SOTAExpCentroidExpressionViewer.this.fillCentroid(graphics, this.currCentroidNumber);
            }
            if (this.oldCentroidNumber != -1) {
                SOTAExpCentroidExpressionViewer.this.fillCentroid(graphics, this.oldCentroidNumber);
            }
            this.currCentroidNumber = -1;
        }

        private int cursorOverCentroid(int n, int n2) {
            this.currCentroidNumber = -1;
            this.originX = 0;
            this.originY = 0;
            this.xDim = (float)SOTAExpCentroidExpressionViewer.this.numberOfCentroids * (float)((SOTAExpCentroidExpressionViewer)SOTAExpCentroidExpressionViewer.this).elementSize.width;
            this.yDim = (float)SOTAExpCentroidExpressionViewer.this.numberOfGenes * (float)((SOTAExpCentroidExpressionViewer)SOTAExpCentroidExpressionViewer.this).elementSize.height;
            if (((SOTAExpCentroidExpressionViewer)SOTAExpCentroidExpressionViewer.this).insets.left < n && (float)n < (float)((SOTAExpCentroidExpressionViewer)SOTAExpCentroidExpressionViewer.this).insets.left + this.xDim && this.originY < n2 && (float)n2 < (float)this.originY + this.yDim) {
                this.currCentroidNumber = (int)((float)(SOTAExpCentroidExpressionViewer.this.numberOfCentroids * (n - ((SOTAExpCentroidExpressionViewer)SOTAExpCentroidExpressionViewer.this).insets.left)) / this.xDim);
            }
            return this.currCentroidNumber;
        }

        public int getCurrCentroidNumber() {
            return this.currCentroidNumber;
        }
    }
}

