/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sam;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.tigr.util.awt.ActionInfoDialog;

public class SAMPreDialog
extends ActionInfoDialog {
    JRadioButton previousButton;
    JRadioButton newButton;
    JButton okButton;
    JButton cancelButton;
    JCheckBox drawTreesBox;
    private JRadioButton sigOnly;
    private JRadioButton allClusters;
    boolean okPressed = false;

    public SAMPreDialog(JFrame jFrame, boolean bl) {
        super(jFrame, "SAM Initialization", bl);
        this.setBounds(0, 0, 350, 150);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 17;
        this.previousButton = new JRadioButton("Use SAM Graph and input parameters from last run", true);
        this.newButton = new JRadioButton("Start new analysis", false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.previousButton);
        buttonGroup.add(this.newButton);
        this.sigOnly = new JRadioButton("Significant genes only", true);
        this.allClusters = new JRadioButton("All clusters", false);
        this.sigOnly.setEnabled(false);
        this.allClusters.setEnabled(false);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.sigOnly);
        buttonGroup2.add(this.allClusters);
        this.buildConstraints(gridBagConstraints, 0, 0, 2, 1, 0, 30);
        gridBagLayout.setConstraints(this.previousButton, gridBagConstraints);
        jPanel.add(this.previousButton);
        this.buildConstraints(gridBagConstraints, 0, 1, 2, 1, 0, 30);
        gridBagLayout.setConstraints(this.newButton, gridBagConstraints);
        jPanel.add(this.newButton);
        this.drawTreesBox = new JCheckBox("Draw Hierarchichal Trees for: ", false);
        this.drawTreesBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 2) {
                    SAMPreDialog.this.sigOnly.setEnabled(false);
                    SAMPreDialog.this.allClusters.setEnabled(false);
                } else {
                    SAMPreDialog.this.sigOnly.setEnabled(true);
                    SAMPreDialog.this.allClusters.setEnabled(true);
                }
            }
        });
        this.buildConstraints(gridBagConstraints, 0, 2, 2, 1, 0, 30);
        gridBagLayout.setConstraints(this.drawTreesBox, gridBagConstraints);
        jPanel.add(this.drawTreesBox);
        gridBagConstraints.anchor = 10;
        this.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 50, 10);
        gridBagLayout.setConstraints(this.sigOnly, gridBagConstraints);
        jPanel.add(this.sigOnly);
        this.buildConstraints(gridBagConstraints, 1, 3, 1, 1, 50, 10);
        gridBagLayout.setConstraints(this.allClusters, gridBagConstraints);
        jPanel.add(this.allClusters);
        this.okButton = new JButton("OK");
        this.buildConstraints(gridBagConstraints, 0, 4, 1, 1, 50, 10);
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAMPreDialog.this.okPressed = true;
                SAMPreDialog.this.dispose();
            }
        });
        jPanel.add(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.buildConstraints(gridBagConstraints, 1, 4, 1, 1, 50, 0);
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SAMPreDialog.this.okPressed = false;
                SAMPreDialog.this.dispose();
            }
        });
        jPanel.add(this.cancelButton);
        this.setContentPane(jPanel);
    }

    public void setVisible(boolean bl) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        super.setVisible(bl);
        if (bl) {
            // empty if block
        }
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public boolean usePrevious() {
        return this.previousButton.isSelected();
    }

    public boolean drawTrees() {
        return this.drawTreesBox.isSelected();
    }

    public boolean drawSigTreesOnly() {
        return this.sigOnly.isSelected();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        SAMPreDialog sAMPreDialog = new SAMPreDialog(jFrame, true);
        sAMPreDialog.setVisible(true);
    }
}

