/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.sam;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HCLSigOnlyPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.cluster.gui.impl.sam.SAMAllPermsDialog;
import org.tigr.microarray.mev.cluster.gui.impl.sam.SAMGUI;
import org.tigr.util.StringSplitter;

public class SAMInitDialog
extends AlgorithmDialog {
    ImageIcon forwardImage;
    ImageIcon backImage;
    JTabbedPane tabPane;
    GroupExperimentsPanel gPanel;
    TwoClassPairedMainPanel tcpmPanel;
    MultiClassPanel mPanel;
    CensoredSurvivalPanel csPanel;
    OneClassPanel oneCPanel;
    S0AndQValueCalcPanel sqPanel;
    PermutationsPanel pPanel;
    ImputationPanel iPanel;
    OKCancelPanel oPanel;
    boolean okPressed = false;
    boolean allUniquePermsUsed = false;
    Vector exptNames;
    int numGenes;
    int numUniquePerms;
    HCLSigOnlyPanel hclOpsPanel;
    public static final int GROUP_A = 1;
    public static final int GROUP_B = 2;
    public static final int NEITHER_GROUP = 3;
    public static final int TWO_CLASS_UNPAIRED = 4;
    public static final int TWO_CLASS_PAIRED = 5;
    public static final int MULTI_CLASS = 6;
    public static final int CENSORED_SURVIVAL = 7;
    public static final int ONE_CLASS = 8;

    public SAMInitDialog(JFrame jFrame, boolean bl, Vector vector, int n) {
        super(jFrame, "SAM Initialization", bl);
        this.exptNames = vector;
        this.numGenes = n;
        this.numUniquePerms = 0;
        this.setBounds(0, 0, 700, 800);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        this.forwardImage = new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("org/tigr/images/Forward24.gif")));
        this.backImage = new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource("org/tigr/images/Back24.gif")));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        UIManager.put("TabbedPane.selected", Color.white);
        this.tabPane = new JTabbedPane();
        this.gPanel = new GroupExperimentsPanel(vector);
        this.tabPane.add("Two-class unpaired", this.gPanel);
        this.tcpmPanel = new TwoClassPairedMainPanel();
        this.tabPane.add("Two-class paired", this.tcpmPanel);
        this.mPanel = new MultiClassPanel();
        this.tabPane.add("Multi-class", this.mPanel);
        this.csPanel = new CensoredSurvivalPanel(vector);
        this.tabPane.add("Censored survival", this.csPanel);
        this.oneCPanel = new OneClassPanel();
        this.tabPane.add("One-Class", this.oneCPanel);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 75);
        gridBagLayout.setConstraints(this.tabPane, gridBagConstraints);
        jPanel.add(this.tabPane);
        this.pPanel = new PermutationsPanel();
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 5);
        gridBagLayout.setConstraints(this.pPanel, gridBagConstraints);
        jPanel.add(this.pPanel);
        this.sqPanel = new S0AndQValueCalcPanel();
        this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 0, 10);
        gridBagLayout.setConstraints(this.sqPanel, gridBagConstraints);
        jPanel.add(this.sqPanel);
        this.iPanel = new ImputationPanel();
        this.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 0, 5);
        gridBagLayout.setConstraints(this.iPanel, gridBagConstraints);
        jPanel.add(this.iPanel);
        this.hclOpsPanel = new HCLSigOnlyPanel();
        this.buildConstraints(gridBagConstraints, 0, 4, 1, 1, 0, 5);
        gridBagLayout.setConstraints(this.hclOpsPanel, gridBagConstraints);
        jPanel.add(this.hclOpsPanel);
        this.addContent(jPanel);
        EventListener eventListener = new EventListener();
        this.setActionListeners(eventListener);
        this.addWindowListener(eventListener);
    }

    public void setVisible(boolean bl) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        super.setVisible(bl);
        if (bl) {
            // empty if block
        }
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public boolean isSaveMatrix() {
        return this.iPanel.saveMatrixChkBox.isSelected();
    }

    public int getStudyDesign() {
        int n = 4;
        if (this.tabPane.getSelectedIndex() == 0) {
            n = 4;
        } else if (this.tabPane.getSelectedIndex() == 1) {
            n = 5;
        } else if (this.tabPane.getSelectedIndex() == 2) {
            n = 6;
        } else if (this.tabPane.getSelectedIndex() == 3) {
            n = 7;
        } else if (this.tabPane.getSelectedIndex() == 4) {
            n = 8;
        }
        return n;
    }

    public int[] getGroupAssignments() {
        int[] nArray = new int[this.exptNames.size()];
        if (this.getStudyDesign() == 4) {
            for (int i = 0; i < this.exptNames.size(); ++i) {
                nArray[i] = this.gPanel.groupARadioButtons[i].isSelected() ? 1 : (this.gPanel.groupBRadioButtons[i].isSelected() ? 2 : 3);
            }
        } else if (this.getStudyDesign() == 6) {
            block1: for (int i = 0; i < this.exptNames.size(); ++i) {
                if (this.mPanel.mulgPanel.notInGroupRadioButtons[i].isSelected()) {
                    nArray[i] = 0;
                    continue;
                }
                for (int j = 0; j < this.mPanel.mulgPanel.exptGroupRadioButtons.length; ++j) {
                    if (!this.mPanel.mulgPanel.exptGroupRadioButtons[j][i].isSelected()) continue;
                    nArray[i] = j + 1;
                    continue block1;
                }
            }
        } else if (this.getStudyDesign() == 8) {
            return this.getOneClassAssignments();
        }
        return nArray;
    }

    public int[] getOneClassAssignments() {
        int[] nArray = new int[this.oneCPanel.includeExpts.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.oneCPanel.includeExpts[i].isSelected() ? 1 : 0;
        }
        return nArray;
    }

    public double getOneClassMean() {
        return Double.parseDouble(this.oneCPanel.meanField.getText());
    }

    public int getMultiClassNumGroups() {
        return Integer.parseInt(this.mPanel.ngPanel.numGroupsField.getText());
    }

    public int getNumValidOneClassExpts() {
        int n = 0;
        int[] nArray = this.getOneClassAssignments();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != 1) continue;
            ++n;
        }
        return n;
    }

    public int[] getGroupCount() {
        int[] nArray = this.getGroupAssignments();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 1) {
                ++n;
                continue;
            }
            if (nArray[i] != 2) continue;
            ++n2;
        }
        int[] nArray2 = new int[]{n, n2};
        return nArray2;
    }

    public boolean[] isInSurvivalAnalysis() {
        boolean[] blArray = new boolean[this.csPanel.fields.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = this.csPanel.fields[i].inAnalysisCheckBox.isSelected();
        }
        return blArray;
    }

    public double[] getSurvivalTimes() {
        double[] dArray = new double[this.exptNames.size()];
        for (int i = 0; i < dArray.length; ++i) {
            try {
                double d;
                String string = this.csPanel.fields[i].timeInputField.getText();
                dArray[i] = d = new Double(string).doubleValue();
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                dArray[i] = 0.0;
            }
        }
        return dArray;
    }

    public boolean[] isCensored() {
        boolean[] blArray = new boolean[this.exptNames.size()];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = this.csPanel.fields[i].censoredRadioButton.isSelected();
        }
        return blArray;
    }

    public Vector getPairedAExpts() {
        return this.tcpmPanel.tcpPanel.pairedAExpts;
    }

    public Vector getPairedBExpts() {
        return this.tcpmPanel.tcpPanel.pairedBExpts;
    }

    private long factorial(int n) {
        if (n == 1 || n == 0) {
            return 1L;
        }
        return this.factorial(n - 1) * (long)n;
    }

    private int getNumCombs(int n, int n2) {
        return Math.round(this.factorial(n) / (this.factorial(n2) * this.factorial(n - n2)));
    }

    public int getNumNeighbors() {
        String string = this.iPanel.numNeighborsField.getText();
        return Integer.parseInt(string);
    }

    public int getUserNumCombs() {
        String string = this.pPanel.numPermsInputField.getText();
        return Integer.parseInt(string);
    }

    public boolean useKNearest() {
        return this.iPanel.kNearestButton.isSelected();
    }

    public boolean drawTrees() {
        return this.hclOpsPanel.isHCLSelected();
    }

    public boolean drawSigTreesOnly() {
        return this.hclOpsPanel.drawSigTreesOnly();
    }

    public boolean useTusherEtAlS0() {
        return this.sqPanel.s0SelectBox.getSelectedIndex() == 0;
    }

    public double getPercentile() {
        if (this.sqPanel.s0SelectButton.isSelected()) {
            int n = this.sqPanel.s0SelectBox.getSelectedIndex();
            if (n == 0) {
                return -1.0;
            }
            if (n == 1) {
                return 5.0;
            }
            if (n == 2) {
                return 50.0;
            }
            if (n == 3) {
                return 90.0;
            }
            if (n == 4) {
                return 0.0;
            }
        } else {
            return Double.parseDouble(this.sqPanel.s0EntryField.getText());
        }
        return 0.0;
    }

    public boolean calculateQLowestFDR() {
        return this.sqPanel.qYesButton.isSelected();
    }

    public int getNumUniquePerms() {
        return this.numUniquePerms;
    }

    public boolean useAllUniquePerms() {
        return this.allUniquePermsUsed;
    }

    private int getNumUnique2ClassUnpairedPerms(int n, int n2) {
        return Math.round(this.factorial(n) / (this.factorial(n2) * this.factorial(n - n2)));
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < 100; ++i) {
            vector.add("Expt " + i);
        }
        SAMInitDialog sAMInitDialog = new SAMInitDialog(jFrame, true, vector, 5);
        sAMInitDialog.setVisible(true);
        System.exit(0);
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            block57: {
                HelpWindow helpWindow;
                String string = actionEvent.getActionCommand();
                if (string.equals("ok-command")) {
                    int n;
                    int n2;
                    try {
                        double d;
                        if (SAMInitDialog.this.sqPanel.s0EntryButton.isSelected() && ((d = Double.parseDouble(SAMInitDialog.this.sqPanel.s0EntryField.getText())) < 0.0 || d > 100.0)) {
                            JOptionPane.showMessageDialog(null, "Enter a valid percentile between 0 and 100!", "Error!", 0);
                            return;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        JOptionPane.showMessageDialog(null, "Enter a valid percentile between 0 and 100!", "Error!", 0);
                        return;
                    }
                    try {
                        n2 = 0;
                        n2 = SAMInitDialog.this.getUserNumCombs();
                        n = 0;
                        if (SAMInitDialog.this.useKNearest()) {
                            n = SAMInitDialog.this.getNumNeighbors();
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        JOptionPane.showMessageDialog(null, "Invalid parameter value(s)!", "Error", 0);
                        return;
                    }
                    if (SAMInitDialog.this.getStudyDesign() == 4) {
                        int n3;
                        int[] nArray = SAMInitDialog.this.getGroupAssignments();
                        n = 0;
                        int n4 = 0;
                        for (n3 = 0; n3 < nArray.length; ++n3) {
                            if (nArray[n3] == 1) {
                                ++n;
                                continue;
                            }
                            if (nArray[n3] != 2) continue;
                            ++n4;
                        }
                        if (n < 2 || n4 < 2) {
                            JOptionPane.showMessageDialog(null, "Group A and Group B must contain more than one sample.", "Error", 2);
                        } else {
                            try {
                                n3 = 0;
                                n3 = SAMInitDialog.this.getUserNumCombs();
                                int n5 = 0;
                                if (SAMInitDialog.this.useKNearest()) {
                                    n5 = SAMInitDialog.this.getNumNeighbors();
                                }
                                if (n + n4 <= 20) {
                                    SAMInitDialog.this.numUniquePerms = SAMInitDialog.this.getNumUnique2ClassUnpairedPerms(n + n4, n);
                                    SAMAllPermsDialog sAMAllPermsDialog = new SAMAllPermsDialog(SAMGUI.SAMFrame, true, SAMInitDialog.this.numUniquePerms, n3);
                                    sAMAllPermsDialog.setVisible(true);
                                    SAMInitDialog.this.allUniquePermsUsed = sAMAllPermsDialog.useAllPerms();
                                }
                                SAMInitDialog.this.okPressed = true;
                                UIManager.put("TabbedPane.selected", Color.lightGray);
                                SAMInitDialog.this.dispose();
                            }
                            catch (NumberFormatException numberFormatException) {
                                JOptionPane.showMessageDialog(null, "Invalid parameter value(s)!", "Error", 0);
                            }
                        }
                    } else if (SAMInitDialog.this.getStudyDesign() == 5) {
                        if (SAMInitDialog.this.tcpmPanel.tcpPanel.pairedListModel.size() < 2) {
                            JOptionPane.showMessageDialog(null, "Need at least two pairs of samples!", "Error", 0);
                        } else {
                            if (SAMInitDialog.this.tcpmPanel.tcpPanel.pairedListModel.size() <= 29) {
                                n2 = SAMInitDialog.this.getUserNumCombs();
                                SAMInitDialog.this.numUniquePerms = (int)Math.pow(2.0, SAMInitDialog.this.tcpmPanel.tcpPanel.pairedListModel.size());
                                SAMAllPermsDialog sAMAllPermsDialog = new SAMAllPermsDialog(SAMGUI.SAMFrame, true, SAMInitDialog.this.numUniquePerms, n2);
                                sAMAllPermsDialog.setVisible(true);
                                SAMInitDialog.this.allUniquePermsUsed = sAMAllPermsDialog.useAllPerms();
                            }
                            SAMInitDialog.this.okPressed = true;
                            UIManager.put("TabbedPane.selected", Color.lightGray);
                            SAMInitDialog.this.dispose();
                        }
                    } else if (SAMInitDialog.this.getStudyDesign() == 6) {
                        int n6;
                        int n7;
                        n2 = 0;
                        int[] nArray = SAMInitDialog.this.getGroupAssignments();
                        int n8 = SAMInitDialog.this.getMultiClassNumGroups();
                        int[] nArray2 = new int[n8];
                        for (n7 = 0; n7 < nArray2.length; ++n7) {
                            nArray2[n7] = 0;
                        }
                        for (n7 = 0; n7 < nArray.length; ++n7) {
                            n6 = nArray[n7];
                            if (n6 == 0) continue;
                            int n9 = n6 - 1;
                            nArray2[n9] = nArray2[n9] + 1;
                        }
                        for (n7 = 0; n7 < nArray2.length; ++n7) {
                            if (nArray2[n7] > 1) continue;
                            JOptionPane.showMessageDialog(null, "Each group must contain more than one sample.", "Error", 2);
                            n2 = 1;
                            break;
                        }
                        if (n2 == 0) {
                            try {
                                n7 = 0;
                                n7 = SAMInitDialog.this.getUserNumCombs();
                                n6 = 0;
                                if (SAMInitDialog.this.useKNearest()) {
                                    n6 = SAMInitDialog.this.getNumNeighbors();
                                }
                                SAMInitDialog.this.okPressed = true;
                                UIManager.put("TabbedPane.selected", Color.lightGray);
                                SAMInitDialog.this.dispose();
                            }
                            catch (NumberFormatException numberFormatException) {
                                JOptionPane.showMessageDialog(null, "Invalid parameter value(s)!", "Error", 0);
                            }
                        }
                    } else if (SAMInitDialog.this.getStudyDesign() == 7) {
                        try {
                            int n10;
                            n2 = 1;
                            n = 0;
                            double d = 0.0;
                            for (n10 = 0; n10 < SAMInitDialog.this.exptNames.size(); ++n10) {
                                if (!SAMInitDialog.this.csPanel.fields[n10].inAnalysisCheckBox.isSelected()) continue;
                                ++n;
                                double d2 = new Double(SAMInitDialog.this.csPanel.fields[n10].timeInputField.getText());
                                if (n10 > 0 && d != d2) {
                                    n2 = 0;
                                }
                                d = d2;
                            }
                            n10 = 0;
                            n10 = SAMInitDialog.this.getUserNumCombs();
                            int n11 = 0;
                            if (SAMInitDialog.this.useKNearest()) {
                                n11 = SAMInitDialog.this.getNumNeighbors();
                            }
                            if (n < 2) {
                                JOptionPane.showMessageDialog(null, "At least 2 samples must be selected!", "Error", 0);
                                break block57;
                            }
                            if (n2 != 0) {
                                JOptionPane.showMessageDialog(null, "At least one of the survival time values must be different from the rest!", "Error", 0);
                                break block57;
                            }
                            if (n <= 10) {
                                SAMInitDialog.this.numUniquePerms = (int)SAMInitDialog.this.factorial(n);
                                SAMAllPermsDialog sAMAllPermsDialog = new SAMAllPermsDialog(SAMGUI.SAMFrame, true, SAMInitDialog.this.numUniquePerms, n10);
                                sAMAllPermsDialog.setVisible(true);
                                SAMInitDialog.this.allUniquePermsUsed = sAMAllPermsDialog.useAllPerms();
                            }
                            SAMInitDialog.this.okPressed = true;
                            UIManager.put("TabbedPane.selected", Color.lightGray);
                            SAMInitDialog.this.dispose();
                        }
                        catch (NumberFormatException numberFormatException) {
                            JOptionPane.showMessageDialog(null, "Invalid parameter value(s)!", "Error", 0);
                        }
                    } else if (SAMInitDialog.this.getStudyDesign() == 8) {
                        try {
                            double d = SAMInitDialog.this.getOneClassMean();
                            if (SAMInitDialog.this.getNumValidOneClassExpts() < 2) {
                                JOptionPane.showMessageDialog(null, "At least 2 samples must be selected for one-class test!", "Error", 0);
                                break block57;
                            }
                            if (SAMInitDialog.this.getNumValidOneClassExpts() <= 29) {
                                int n12 = SAMInitDialog.this.getUserNumCombs();
                                SAMInitDialog.this.numUniquePerms = (int)Math.pow(2.0, SAMInitDialog.this.getNumValidOneClassExpts());
                                SAMAllPermsDialog sAMAllPermsDialog = new SAMAllPermsDialog(SAMGUI.SAMFrame, true, SAMInitDialog.this.numUniquePerms, n12);
                                sAMAllPermsDialog.setVisible(true);
                                SAMInitDialog.this.allUniquePermsUsed = sAMAllPermsDialog.useAllPerms();
                            }
                            SAMInitDialog.this.okPressed = true;
                            UIManager.put("TabbedPane.selected", Color.lightGray);
                            SAMInitDialog.this.dispose();
                        }
                        catch (NumberFormatException numberFormatException) {
                            JOptionPane.showMessageDialog(null, "Invalid value for one-class mean!", "Error", 0);
                        }
                    }
                } else if (string.equals("reset-command")) {
                    if (SAMInitDialog.this.getStudyDesign() == 4) {
                        SAMInitDialog.this.gPanel.reset();
                    } else if (SAMInitDialog.this.getStudyDesign() == 6 && SAMInitDialog.this.mPanel.mulgPanel != null) {
                        SAMInitDialog.this.mPanel.reset();
                    } else if (SAMInitDialog.this.getStudyDesign() == 7) {
                        SAMInitDialog.this.csPanel.reset();
                    }
                    SAMInitDialog.this.sqPanel.reset();
                    SAMInitDialog.this.pPanel.reset();
                    SAMInitDialog.this.iPanel.reset();
                    SAMInitDialog.this.tcpmPanel.tcpPanel.reset();
                    SAMInitDialog.this.hclOpsPanel.setHCLSelected(false);
                } else if (string.equals("cancel-command")) {
                    SAMInitDialog.this.okPressed = false;
                    UIManager.put("TabbedPane.selected", Color.lightGray);
                    SAMInitDialog.this.dispose();
                } else if (string.equals("info-command") && (helpWindow = new HelpWindow(SAMInitDialog.this, "SAM Initialization Dialog")).getWindowContent()) {
                    helpWindow.setSize(500, 650);
                    helpWindow.setLocation();
                    helpWindow.show();
                    return;
                }
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            UIManager.put("TabbedPane.selected", Color.lightGray);
        }
    }

    class OKCancelPanel
    extends JPanel {
        JButton okButton = new JButton("OK");
        JButton cancelButton = new JButton("Cancel");
        JCheckBox drawTreesBox = new JCheckBox("Draw Hierarchical Trees");

        OKCancelPanel() {
            this.okButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ OKCancelPanel this$1;
                {
                    this.this$1 = oKCancelPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (OKCancelPanel.access$1000(this.this$1).getStudyDesign() == 4) {
                        int n;
                        int[] nArray = OKCancelPanel.access$1000(this.this$1).getGroupAssignments();
                        int n2 = 0;
                        int n3 = 0;
                        for (n = 0; n < nArray.length; ++n) {
                            if (nArray[n] == 1) {
                                ++n2;
                                continue;
                            }
                            if (nArray[n] != 2) continue;
                            ++n3;
                        }
                        if (n2 < 2 || n3 < 2) {
                            JOptionPane.showMessageDialog(null, "Group A and Group B must contain more than one sample", "Error", 2);
                        } else {
                            try {
                                n = 0;
                                n = OKCancelPanel.access$1000(this.this$1).getUserNumCombs();
                                int n4 = 0;
                                if (OKCancelPanel.access$1000(this.this$1).useKNearest()) {
                                    n4 = OKCancelPanel.access$1000(this.this$1).getNumNeighbors();
                                }
                                OKCancelPanel.access$1000((OKCancelPanel)this.this$1).okPressed = true;
                                OKCancelPanel.access$1000(this.this$1).dispose();
                            }
                            catch (NumberFormatException numberFormatException) {
                                JOptionPane.showMessageDialog(null, "Invalid parameter value(s)!", "Error", 0);
                            }
                        }
                    } else if (OKCancelPanel.access$1000(this.this$1).getStudyDesign() == 6) {
                        int n;
                        int n5;
                        boolean bl = false;
                        int[] nArray = OKCancelPanel.access$1000(this.this$1).getGroupAssignments();
                        int n6 = OKCancelPanel.access$1000(this.this$1).getMultiClassNumGroups();
                        int[] nArray2 = new int[n6];
                        for (n5 = 0; n5 < nArray2.length; ++n5) {
                            nArray2[n5] = 0;
                        }
                        for (n5 = 0; n5 < nArray.length; ++n5) {
                            n = nArray[n5];
                            if (n == 0) continue;
                            int n7 = n - 1;
                            nArray2[n7] = nArray2[n7] + 1;
                        }
                        for (n5 = 0; n5 < nArray2.length; ++n5) {
                            if (nArray2[n5] > 1) continue;
                            JOptionPane.showMessageDialog(null, "Each group must contain more than one sample.", "Error", 2);
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            try {
                                n5 = 0;
                                n5 = OKCancelPanel.access$1000(this.this$1).getUserNumCombs();
                                n = 0;
                                if (OKCancelPanel.access$1000(this.this$1).useKNearest()) {
                                    n = OKCancelPanel.access$1000(this.this$1).getNumNeighbors();
                                }
                                OKCancelPanel.access$1000((OKCancelPanel)this.this$1).okPressed = true;
                                OKCancelPanel.access$1000(this.this$1).dispose();
                            }
                            catch (NumberFormatException numberFormatException) {
                                JOptionPane.showMessageDialog(null, "Invalid parameter value(s)!", "Error", 0);
                            }
                        }
                    } else if (OKCancelPanel.access$1000(this.this$1).getStudyDesign() == 7) {
                        try {
                            int n;
                            boolean bl = true;
                            int n8 = 0;
                            double d = 0.0;
                            for (n = 0; n < OKCancelPanel.access$1000((OKCancelPanel)this.this$1).exptNames.size(); ++n) {
                                if (!OKCancelPanel.access$1000((OKCancelPanel)this.this$1).csPanel.fields[n].inAnalysisCheckBox.isSelected()) continue;
                                ++n8;
                                double d2 = new Double(OKCancelPanel.access$1000((OKCancelPanel)this.this$1).csPanel.fields[n].timeInputField.getText());
                                if (n > 0 && d != d2) {
                                    bl = false;
                                }
                                d = d2;
                            }
                            n = 0;
                            n = OKCancelPanel.access$1000(this.this$1).getUserNumCombs();
                            int n9 = 0;
                            if (OKCancelPanel.access$1000(this.this$1).useKNearest()) {
                                n9 = OKCancelPanel.access$1000(this.this$1).getNumNeighbors();
                            }
                            if (n8 < 2) {
                                JOptionPane.showMessageDialog(null, "At least 2 samples must be selected!", "Error", 0);
                            } else if (bl) {
                                JOptionPane.showMessageDialog(null, "At least one of the survival time values must be different from the rest!", "Error", 0);
                            } else {
                                OKCancelPanel.access$1000((OKCancelPanel)this.this$1).okPressed = true;
                                OKCancelPanel.access$1000(this.this$1).dispose();
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            JOptionPane.showMessageDialog(null, "Invalid parameter value(s)!", "Error", 0);
                        }
                    }
                }
            });
            this.cancelButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ OKCancelPanel this$1;
                {
                    this.this$1 = oKCancelPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    OKCancelPanel.access$1000((OKCancelPanel)this.this$1).okPressed = false;
                    OKCancelPanel.access$1000(this.this$1).dispose();
                }
            });
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 2, 1, 0, 50);
            gridBagLayout.setConstraints(this.drawTreesBox, gridBagConstraints);
            this.add(this.drawTreesBox);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 50, 50);
            gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
            this.add(this.okButton);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 50, 0);
            gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
            this.add(this.cancelButton);
        }

        static /* synthetic */ SAMInitDialog access$1000(OKCancelPanel oKCancelPanel) {
            return oKCancelPanel.SAMInitDialog.this;
        }
    }

    class ImputationPanel
    extends JPanel {
        JRadioButton kNearestButton;
        JRadioButton rowAverageButton;
        JTextField numNeighborsField;
        JLabel numNeighborsLabel;
        String numNeighborsText;
        JCheckBox saveMatrixChkBox;

        ImputationPanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "Imputation Engine", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            this.numNeighborsText = "10";
            if (SAMInitDialog.this.numGenes < 10) {
                this.numNeighborsText = Integer.toString(SAMInitDialog.this.numGenes);
            }
            this.numNeighborsField = new JTextField(this.numNeighborsText, 7);
            this.numNeighborsLabel = new JLabel("Number of neighbors:       ");
            this.kNearestButton = new JRadioButton("K-nearest neighbors imputer", true);
            this.kNearestButton.setBackground(Color.white);
            this.kNearestButton.setFocusPainted(false);
            this.kNearestButton.setForeground(UIManager.getColor("Label.foreground"));
            this.rowAverageButton = new JRadioButton("Row average imputer              ", false);
            this.rowAverageButton.setBackground(Color.white);
            this.rowAverageButton.setFocusPainted(false);
            this.rowAverageButton.setForeground(UIManager.getColor("Label.foreground"));
            this.kNearestButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ ImputationPanel this$1;
                {
                    this.this$1 = imputationPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.numNeighborsLabel.setEnabled(true);
                    this.this$1.numNeighborsField.setEnabled(true);
                    this.this$1.numNeighborsField.setBackground(Color.white);
                    this.this$1.numNeighborsField.setText(this.this$1.numNeighborsText);
                }
            });
            this.rowAverageButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ ImputationPanel this$1;
                {
                    this.this$1 = imputationPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.numNeighborsLabel.setEnabled(false);
                    this.this$1.numNeighborsField.setEnabled(false);
                    this.this$1.numNeighborsField.setBackground(Color.gray);
                    this.this$1.numNeighborsField.setText("");
                }
            });
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.kNearestButton);
            buttonGroup.add(this.rowAverageButton);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 40, 50);
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.kNearestButton, gridBagConstraints);
            this.add(this.kNearestButton);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 30, 0);
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.numNeighborsLabel, gridBagConstraints);
            this.add(this.numNeighborsLabel);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 30, 0);
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.numNeighborsField, gridBagConstraints);
            this.add(this.numNeighborsField);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 50);
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.rowAverageButton, gridBagConstraints);
            this.add(this.rowAverageButton);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 0, 50);
            JPanel jPanel = new JPanel();
            jPanel.setBackground(Color.white);
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            this.add(jPanel);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 2, 1, 1, 1, 0, 50);
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            this.add(jPanel);
            gridBagConstraints.anchor = 10;
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 0, 2, 3, 1, 0, 50);
            this.saveMatrixChkBox = new JCheckBox("Save Imputed Matrix", false);
            this.saveMatrixChkBox.setBackground(Color.white);
            this.saveMatrixChkBox.setFocusPainted(false);
            this.saveMatrixChkBox.setForeground(UIManager.getColor("Label.foreground"));
            gridBagLayout.setConstraints(this.saveMatrixChkBox, gridBagConstraints);
            this.add(this.saveMatrixChkBox);
        }

        private void reset() {
            this.numNeighborsField.setText(this.numNeighborsText);
            this.numNeighborsField.setBackground(Color.white);
            this.numNeighborsField.setEnabled(true);
            this.kNearestButton.setSelected(true);
            this.saveMatrixChkBox.setSelected(false);
        }
    }

    class S0AndQValueCalcPanel
    extends JPanel {
        JComboBox s0SelectBox;
        JTextField s0EntryField;
        JRadioButton s0SelectButton;
        JRadioButton s0EntryButton;
        JRadioButton qYesButton;
        JRadioButton qNoButton;

        S0AndQValueCalcPanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "S0 and Q Value parameters", 0, 0, new Font("Dialog", 1, 12), Color.black));
            String[] stringArray = new String[]{"Tusher et al. method", "5th percentile", "50th percentile", "90th percentile", "Minimum S Value"};
            this.setBackground(Color.white);
            this.s0SelectBox = new JComboBox<String>(stringArray);
            this.s0SelectButton = new JRadioButton("Select S0 using", true);
            this.s0SelectButton.setBackground(Color.white);
            this.s0EntryButton = new JRadioButton(" OR Enter s0 percentile (0-100)", false);
            this.s0EntryButton.setBackground(Color.white);
            this.s0EntryField = new JTextField("", 7);
            this.s0EntryField.setEnabled(false);
            this.s0EntryField.setBackground(Color.darkGray);
            ButtonGroup buttonGroup = new ButtonGroup();
            this.s0SelectButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ S0AndQValueCalcPanel this$1;
                {
                    this.this$1 = s0AndQValueCalcPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.s0SelectBox.setEnabled(true);
                    this.this$1.s0EntryField.setText("");
                    this.this$1.s0EntryField.setEnabled(false);
                    this.this$1.s0EntryField.setBackground(Color.darkGray);
                }
            });
            this.s0EntryButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ S0AndQValueCalcPanel this$1;
                {
                    this.this$1 = s0AndQValueCalcPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.s0EntryField.setText("10");
                    this.this$1.s0EntryField.setEnabled(true);
                    this.this$1.s0EntryField.setBackground(Color.white);
                    this.this$1.s0SelectBox.setEnabled(false);
                }
            });
            buttonGroup.add(this.s0SelectButton);
            buttonGroup.add(this.s0EntryButton);
            this.qYesButton = new JRadioButton("Yes (slow!)", false);
            this.qYesButton.setBackground(Color.white);
            this.qNoButton = new JRadioButton("No (quick)", true);
            this.qNoButton.setBackground(Color.white);
            ButtonGroup buttonGroup2 = new ButtonGroup();
            buttonGroup2.add(this.qYesButton);
            buttonGroup2.add(this.qNoButton);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 25, 50);
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.s0SelectButton, gridBagConstraints);
            this.add(this.s0SelectButton);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 25, 0);
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.s0SelectBox, gridBagConstraints);
            this.add(this.s0SelectBox);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 25, 0);
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.s0EntryButton, gridBagConstraints);
            this.add(this.s0EntryButton);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 3, 0, 1, 1, 25, 0);
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.s0EntryField, gridBagConstraints);
            this.add(this.s0EntryField);
            JLabel jLabel = new JLabel("Calculate q-values?  ");
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 10, 50);
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 10, 0);
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.qNoButton, gridBagConstraints);
            this.add(this.qNoButton);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 2, 1, 2, 1, 80, 0);
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.qYesButton, gridBagConstraints);
            this.add(this.qYesButton);
        }

        public void reset() {
            this.s0SelectButton.setSelected(true);
            this.s0SelectBox.setEnabled(true);
            this.s0SelectBox.setSelectedIndex(0);
            this.s0EntryField.setText("");
            this.s0EntryField.setBackground(Color.darkGray);
            this.s0EntryField.setEnabled(false);
            this.qNoButton.setSelected(true);
        }
    }

    class PermutationsPanel
    extends JPanel {
        JLabel numPermsLabel;
        JTextField numPermsInputField;

        PermutationsPanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "Number of permutations", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            this.numPermsLabel = new JLabel("Enter number of permutations:   ");
            this.numPermsInputField = new JTextField("100", 7);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 50, 100);
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.numPermsLabel, gridBagConstraints);
            this.add(this.numPermsLabel);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 50, 0);
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.numPermsInputField, gridBagConstraints);
            this.add(this.numPermsInputField);
        }

        public void reset() {
            this.numPermsInputField.setText("100");
        }
    }

    class MultiClassPanel
    extends JPanel {
        NumGroupsPanel ngPanel;
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        JPanel dummyPanel;
        MultiGroupExperimentsPanel mulgPanel;
        int numGroups;

        public MultiClassPanel() {
            this.setBackground(Color.white);
            this.setLayout(this.gridbag);
            this.ngPanel = new NumGroupsPanel();
            SAMInitDialog.this.buildConstraints(this.constraints, 0, 0, 1, 1, 100, 10);
            this.constraints.fill = 1;
            this.gridbag.setConstraints(this.ngPanel, this.constraints);
            this.ngPanel.okButton.addActionListener(new ActionListener(this, SAMInitDialog.this){
                private final /* synthetic */ SAMInitDialog val$this$0;
                private final /* synthetic */ MultiClassPanel this$1;
                {
                    this.this$1 = multiClassPanel;
                    this.val$this$0 = sAMInitDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.ngPanel.okPressed = true;
                    try {
                        this.this$1.numGroups = Integer.parseInt(this.this$1.ngPanel.numGroupsField.getText());
                        if (this.this$1.numGroups <= 2) {
                            JOptionPane.showMessageDialog(null, "Please enter a positive integer >= 2!", "Error", 0);
                        } else {
                            this.this$1.mulgPanel = this.this$1.new MultiGroupExperimentsPanel(MultiClassPanel.access$700((MultiClassPanel)this.this$1).exptNames, this.this$1.numGroups);
                            MultiClassPanel.access$700(this.this$1).buildConstraints(this.this$1.constraints, 0, 1, 1, 1, 0, 90);
                            this.this$1.constraints.fill = 1;
                            this.this$1.gridbag.setConstraints(this.this$1.mulgPanel, this.this$1.constraints);
                            this.this$1.remove(this.this$1.dummyPanel);
                            this.this$1.add(this.this$1.mulgPanel);
                            this.this$1.validate();
                            this.this$1.ngPanel.okButton.setEnabled(false);
                            this.this$1.ngPanel.numGroupsField.setEnabled(false);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        JOptionPane.showMessageDialog(null, "Please enter a positive integer >= 2!", "Error", 0);
                    }
                }
            });
            this.add(this.ngPanel);
            SAMInitDialog.this.buildConstraints(this.constraints, 0, 1, 1, 1, 0, 90);
            this.dummyPanel = new JPanel();
            this.dummyPanel.setBackground(Color.white);
            this.gridbag.setConstraints(this.dummyPanel, this.constraints);
            this.add(this.dummyPanel);
        }

        private void reset() {
            this.mulgPanel.reset();
        }

        class MultiGroupExperimentsPanel
        extends JPanel {
            JLabel[] expLabels;
            JRadioButton[][] exptGroupRadioButtons;
            JRadioButton[] notInGroupRadioButtons;

            MultiGroupExperimentsPanel(Vector vector, int n) {
                int n2;
                this.setBorder(new TitledBorder(new EtchedBorder(), "Group Assignments"));
                this.setBackground(Color.white);
                JPanel jPanel = new JPanel();
                this.expLabels = new JLabel[vector.size()];
                this.exptGroupRadioButtons = new JRadioButton[n][vector.size()];
                this.notInGroupRadioButtons = new JRadioButton[vector.size()];
                ButtonGroup[] buttonGroupArray = new ButtonGroup[vector.size()];
                GridBagLayout gridBagLayout = new GridBagLayout();
                GridBagLayout gridBagLayout2 = new GridBagLayout();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                this.setLayout(gridBagLayout2);
                jPanel.setLayout(gridBagLayout);
                for (n2 = 0; n2 < vector.size(); ++n2) {
                    int n3;
                    String string = (String)vector.get(n2);
                    this.expLabels[n2] = new JLabel(string);
                    buttonGroupArray[n2] = new ButtonGroup();
                    for (n3 = 0; n3 < n; ++n3) {
                        this.exptGroupRadioButtons[n3][n2] = new JRadioButton("Group " + (n3 + 1) + "     ", n3 == 0);
                        buttonGroupArray[n2].add(this.exptGroupRadioButtons[n3][n2]);
                    }
                    this.notInGroupRadioButtons[n2] = new JRadioButton("Not in groups", false);
                    buttonGroupArray[n2].add(this.notInGroupRadioButtons[n2]);
                    for (n3 = 0; n3 < n; ++n3) {
                        SAMInitDialog.this.buildConstraints(gridBagConstraints, n3, n2, 1, 1, 100, 100);
                        gridBagLayout.setConstraints(this.exptGroupRadioButtons[n3][n2], gridBagConstraints);
                        jPanel.add(this.exptGroupRadioButtons[n3][n2]);
                    }
                    SAMInitDialog.this.buildConstraints(gridBagConstraints, n + 1, n2, 1, 1, 100, 100);
                    gridBagLayout.setConstraints(this.notInGroupRadioButtons[n2], gridBagConstraints);
                    jPanel.add(this.notInGroupRadioButtons[n2]);
                }
                n2 = 0;
                for (int i = 0; i < this.expLabels.length; ++i) {
                    if (!(this.expLabels[i].getPreferredSize().getWidth() > (double)n2)) continue;
                    n2 = (int)Math.ceil(this.expLabels[i].getPreferredSize().getWidth());
                }
                JScrollPane jScrollPane = new JScrollPane(jPanel);
                jScrollPane.setHorizontalScrollBarPolicy(32);
                jScrollPane.setVerticalScrollBarPolicy(22);
                JPanel jPanel2 = new JPanel();
                GridBagLayout gridBagLayout3 = new GridBagLayout();
                jPanel2.setSize(50, jPanel.getPreferredSize().height);
                jPanel2.setPreferredSize(new Dimension(n2 + 10, jPanel.getPreferredSize().height));
                jPanel2.setLayout(gridBagLayout3);
                for (int i = 0; i < this.expLabels.length; ++i) {
                    SAMInitDialog.this.buildConstraints(gridBagConstraints, 0, i, 1, 1, 100, 100);
                    gridBagConstraints.fill = 1;
                    gridBagLayout3.setConstraints(this.expLabels[i], gridBagConstraints);
                    jPanel2.add(this.expLabels[i]);
                }
                jScrollPane.setRowHeaderView(jPanel2);
                SAMInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 90);
                gridBagConstraints.fill = 1;
                gridBagLayout2.setConstraints(jScrollPane, gridBagConstraints);
                this.add(jScrollPane);
                JLabel jLabel = new JLabel("Note: Each group MUST each contain more than one sample.");
                jLabel.setHorizontalAlignment(0);
                SAMInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 5);
                gridBagConstraints.anchor = 13;
                gridBagLayout2.setConstraints(jLabel, gridBagConstraints);
                this.add(jLabel);
                JPanel jPanel3 = new JPanel();
                GridBagLayout gridBagLayout4 = new GridBagLayout();
                jPanel3.setLayout(gridBagLayout4);
                jPanel3.setBackground(Color.white);
                JButton jButton = new JButton("  Save settings  ");
                jButton.setFocusPainted(false);
                jButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
                JButton jButton2 = new JButton("  Load settings  ");
                jButton2.setFocusPainted(false);
                jButton2.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
                JButton jButton3 = new JButton("  Reset  ");
                jButton3.setFocusPainted(false);
                jButton3.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
                int n4 = vector.size();
                jButton3.addActionListener(new ActionListener(this, n4){
                    private final /* synthetic */ int val$finNum;
                    private final /* synthetic */ MultiGroupExperimentsPanel this$2;
                    {
                        this.this$2 = multiGroupExperimentsPanel;
                        this.val$finNum = n;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        for (int i = 0; i < this.val$finNum; ++i) {
                            this.this$2.exptGroupRadioButtons[0][i].setSelected(true);
                        }
                    }
                });
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setCurrentDirectory(new File("Data"));
                jButton.addActionListener(new ActionListener(this, jFileChooser, MultiClassPanel.this){
                    private final /* synthetic */ JFileChooser val$fc;
                    private final /* synthetic */ MultiClassPanel val$this$1;
                    private final /* synthetic */ MultiGroupExperimentsPanel this$2;
                    {
                        this.this$2 = multiGroupExperimentsPanel;
                        this.val$fc = jFileChooser;
                        this.val$this$1 = multiClassPanel;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = this.val$fc.showSaveDialog(this.this$2);
                        if (n == 0) {
                            File file = this.val$fc.getSelectedFile();
                            try {
                                PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                                int[] nArray = MultiClassPanel.access$700(MultiGroupExperimentsPanel.access$800(this.this$2)).getGroupAssignments();
                                for (int i = 0; i < nArray.length; ++i) {
                                    printWriter.print(nArray[i]);
                                    if (i >= nArray.length - 1) continue;
                                    printWriter.print("\t");
                                }
                                printWriter.println();
                                printWriter.flush();
                                printWriter.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                });
                jButton2.addActionListener(new ActionListener(this, jFileChooser, MultiClassPanel.this, n4){
                    private final /* synthetic */ JFileChooser val$fc;
                    private final /* synthetic */ MultiClassPanel val$this$1;
                    private final /* synthetic */ int val$finNum;
                    private final /* synthetic */ MultiGroupExperimentsPanel this$2;
                    {
                        this.this$2 = multiGroupExperimentsPanel;
                        this.val$fc = jFileChooser;
                        this.val$this$1 = multiClassPanel;
                        this.val$finNum = n;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = this.val$fc.showOpenDialog(this.this$2);
                        if (n == 0) {
                            try {
                                Object object;
                                FileReader fileReader = new FileReader(this.val$fc.getSelectedFile());
                                BufferedReader bufferedReader = new BufferedReader(fileReader);
                                String string = bufferedReader.readLine();
                                StringSplitter stringSplitter = new StringSplitter('\t');
                                stringSplitter.init(string);
                                Vector<Integer> vector = new Vector<Integer>();
                                while (stringSplitter.hasMoreTokens()) {
                                    object = stringSplitter.nextToken();
                                    vector.add(new Integer((String)object));
                                }
                                bufferedReader.close();
                                object = MultiClassPanel.access$700(MultiGroupExperimentsPanel.access$800(this.this$2)).getGroupAssignments();
                                if (vector.size() != ((Object)object).length) {
                                    JOptionPane.showMessageDialog(MultiClassPanel.access$700((MultiClassPanel)MultiGroupExperimentsPanel.access$800((MultiGroupExperimentsPanel)this.this$2)).gPanel, "Incompatible file!", "Error", 2);
                                } else {
                                    for (int i = 0; i < vector.size(); ++i) {
                                        int n2 = (Integer)vector.get(i);
                                        if (n2 != 0) {
                                            this.this$2.exptGroupRadioButtons[n2 - 1][i].setSelected(true);
                                            continue;
                                        }
                                        this.this$2.notInGroupRadioButtons[i].setSelected(true);
                                    }
                                }
                            }
                            catch (Exception exception) {
                                JOptionPane.showMessageDialog(MultiClassPanel.access$700((MultiClassPanel)MultiGroupExperimentsPanel.access$800((MultiGroupExperimentsPanel)this.this$2)).gPanel, "Incompatible file!", "Error", 2);
                                for (int i = 0; i < this.val$finNum; ++i) {
                                    this.this$2.exptGroupRadioButtons[0][i].setSelected(true);
                                }
                            }
                        }
                    }
                });
                gridBagConstraints.anchor = 10;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                SAMInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 33, 100);
                gridBagLayout4.setConstraints(jButton, gridBagConstraints);
                jPanel3.add(jButton);
                SAMInitDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 33, 0);
                gridBagLayout4.setConstraints(jButton2, gridBagConstraints);
                jPanel3.add(jButton2);
                SAMInitDialog.this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 34, 0);
                gridBagLayout4.setConstraints(jButton3, gridBagConstraints);
                jPanel3.add(jButton3);
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                SAMInitDialog.this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 0, 5);
                gridBagConstraints.anchor = 10;
                gridBagLayout2.setConstraints(jPanel3, gridBagConstraints);
                this.add(jPanel3);
            }

            private void reset() {
                for (int i = 0; i < ((MultiClassPanel)MultiClassPanel.this).SAMInitDialog.this.exptNames.size(); ++i) {
                    this.exptGroupRadioButtons[0][i].setSelected(true);
                }
            }

            static /* synthetic */ MultiClassPanel access$800(MultiGroupExperimentsPanel multiGroupExperimentsPanel) {
                return multiGroupExperimentsPanel.MultiClassPanel.this;
            }
        }

        class NumGroupsPanel
        extends JPanel {
            JTextField numGroupsField;
            JButton okButton;
            boolean okPressed = false;

            public NumGroupsPanel() {
                this.setBackground(Color.white);
                GridBagLayout gridBagLayout = new GridBagLayout();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                this.setLayout(gridBagLayout);
                JLabel jLabel = new JLabel("Number of groups ");
                SAMInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 30, 100);
                gridBagConstraints.anchor = 13;
                gridBagLayout.setConstraints(jLabel, gridBagConstraints);
                this.add(jLabel);
                this.numGroupsField = new JTextField("", 7);
                gridBagConstraints.anchor = 17;
                SAMInitDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 30, 0);
                gridBagLayout.setConstraints(this.numGroupsField, gridBagConstraints);
                this.add(this.numGroupsField);
                this.okButton = new JButton("OK");
                SAMInitDialog.this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 40, 0);
                gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
                this.add(this.okButton);
            }

            public void setVisible(boolean bl) {
                this.setLocation((MultiClassPanel.this.getWidth() - this.getSize().width) / 2, (MultiClassPanel.this.getHeight() - this.getSize().height) / 2);
                super.setVisible(bl);
                if (bl) {
                    // empty if block
                }
            }

            public boolean isOkPressed() {
                return this.okPressed;
            }
        }
    }

    class TwoClassPairedPanel
    extends JPanel {
        ExperimentButton[] exptButtons;
        GridBagConstraints constraints;
        GridBagLayout gridbag;
        JTextField currentATextField;
        JTextField currentBTextField;
        JButton removeCurrentAButton;
        JButton removeCurrentBButton;
        JButton loadABPairButton;
        JButton removeABPairButton;
        PairedExperimentsPanel pairPanel;
        JList pairedExptsList;
        DefaultListModel pairedListModel;
        boolean currentAFilled = false;
        boolean currentBFilled = false;
        int currentAExpt = -1;
        int currentBExpt = -1;
        Vector pairedAExpts = new Vector();
        Vector pairedBExpts = new Vector();

        public TwoClassPairedPanel() {
            Object object;
            this.constraints = new GridBagConstraints();
            this.gridbag = new GridBagLayout();
            this.setLayout(this.gridbag);
            this.pairedListModel = new DefaultListModel();
            this.pairedExptsList = new JList(this.pairedListModel);
            JPanel jPanel = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            jPanel.setLayout(gridBagLayout);
            this.exptButtons = new ExperimentButton[SAMInitDialog.this.exptNames.size()];
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < SAMInitDialog.this.exptNames.size(); ++i) {
                int n3;
                this.exptButtons[i] = new ExperimentButton(i);
                if (this.exptButtons[i].getPreferredSize().getWidth() > (double)n) {
                    n = (int)Math.ceil(this.exptButtons[i].getPreferredSize().getWidth());
                }
                if ((n3 = ((String)(object = (String)SAMInitDialog.this.exptNames.get(i))).length()) > n2) {
                    n2 = n3;
                }
                SAMInitDialog.this.buildConstraints(this.constraints, 0, i, 1, 1, 100, 100);
                gridBagLayout.setConstraints(this.exptButtons[i], this.constraints);
                jPanel.add(this.exptButtons[i]);
            }
            this.currentATextField = new JTextField("", n2 + 2);
            this.currentBTextField = new JTextField("", n2 + 2);
            this.currentATextField.setBackground(Color.white);
            this.currentBTextField.setBackground(Color.white);
            this.currentATextField.setEditable(false);
            this.currentBTextField.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setHorizontalScrollBarPolicy(32);
            jScrollPane.setVerticalScrollBarPolicy(22);
            SAMInitDialog.this.buildConstraints(this.constraints, 0, 0, 1, 1, 40, 100);
            this.constraints.fill = 1;
            this.gridbag.setConstraints(jScrollPane, this.constraints);
            this.add(jScrollPane);
            this.constraints.fill = 0;
            object = new JPanel();
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            ((Container)object).setLayout(gridBagLayout2);
            this.removeCurrentAButton = new JButton("< Remove A");
            this.removeCurrentBButton = new JButton("< Remove B");
            this.loadABPairButton = new JButton("   Load Pair >>   ");
            this.removeABPairButton = new JButton("<< Remove Pair");
            this.removeCurrentAButton.setEnabled(false);
            this.removeCurrentBButton.setEnabled(false);
            this.loadABPairButton.setEnabled(false);
            this.removeABPairButton.setEnabled(false);
            this.removeCurrentAButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ TwoClassPairedPanel this$1;
                {
                    this.this$1 = twoClassPairedPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.exptButtons[this.this$1.currentAExpt].setEnabled(true);
                    this.this$1.currentAExpt = -1;
                    this.this$1.currentATextField.setText("");
                    this.this$1.currentAFilled = false;
                    this.this$1.removeCurrentAButton.setEnabled(false);
                    this.this$1.loadABPairButton.setEnabled(false);
                }
            });
            this.removeCurrentBButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ TwoClassPairedPanel this$1;
                {
                    this.this$1 = twoClassPairedPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.exptButtons[this.this$1.currentBExpt].setEnabled(true);
                    this.this$1.currentBExpt = -1;
                    this.this$1.currentBTextField.setText("");
                    this.this$1.currentBFilled = false;
                    this.this$1.removeCurrentBButton.setEnabled(false);
                    this.this$1.loadABPairButton.setEnabled(false);
                }
            });
            this.loadABPairButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ TwoClassPairedPanel this$1;
                {
                    this.this$1 = twoClassPairedPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = "A: " + (String)TwoClassPairedPanel.access$500((TwoClassPairedPanel)this.this$1).exptNames.get(this.this$1.currentAExpt) + " - B: " + (String)TwoClassPairedPanel.access$500((TwoClassPairedPanel)this.this$1).exptNames.get(this.this$1.currentBExpt);
                    this.this$1.pairedListModel.addElement(string);
                    this.this$1.pairedAExpts.add(new Integer(this.this$1.currentAExpt));
                    this.this$1.pairedBExpts.add(new Integer(this.this$1.currentBExpt));
                    this.this$1.currentAExpt = -1;
                    this.this$1.currentBExpt = -1;
                    this.this$1.currentATextField.setText("");
                    this.this$1.currentBTextField.setText("");
                    this.this$1.currentAFilled = false;
                    this.this$1.currentBFilled = false;
                    this.this$1.removeCurrentAButton.setEnabled(false);
                    this.this$1.removeCurrentBButton.setEnabled(false);
                    this.this$1.loadABPairButton.setEnabled(false);
                    this.this$1.removeABPairButton.setEnabled(true);
                    this.this$1.pairedExptsList.setSelectedIndex(this.this$1.pairedListModel.size() - 1);
                }
            });
            this.removeABPairButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ TwoClassPairedPanel this$1;
                {
                    this.this$1 = twoClassPairedPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = this.this$1.pairedExptsList.getSelectedIndex();
                    this.this$1.pairedListModel.removeElementAt(n);
                    int n2 = (Integer)this.this$1.pairedAExpts.remove(n);
                    int n3 = (Integer)this.this$1.pairedBExpts.remove(n);
                    this.this$1.exptButtons[n2].setEnabled(true);
                    this.this$1.exptButtons[n3].setEnabled(true);
                    if (this.this$1.pairedListModel.isEmpty()) {
                        this.this$1.removeABPairButton.setEnabled(false);
                    } else {
                        this.this$1.pairedExptsList.setSelectedIndex(this.this$1.pairedListModel.size() - 1);
                    }
                }
            });
            JScrollPane jScrollPane2 = new JScrollPane(this.currentATextField);
            jScrollPane2.setMinimumSize(new Dimension(90, 50));
            JScrollPane jScrollPane3 = new JScrollPane(this.currentBTextField);
            jScrollPane3.setMinimumSize(new Dimension(90, 50));
            jScrollPane2.setHorizontalScrollBarPolicy(32);
            jScrollPane2.setVerticalScrollBarPolicy(21);
            jScrollPane3.setHorizontalScrollBarPolicy(32);
            jScrollPane3.setVerticalScrollBarPolicy(21);
            SAMInitDialog.this.buildConstraints(this.constraints, 0, 0, 1, 1, 20, 50);
            gridBagLayout2.setConstraints(this.removeCurrentAButton, this.constraints);
            ((Container)object).add(this.removeCurrentAButton);
            JLabel jLabel = new JLabel(" Current A: ");
            SAMInitDialog.this.buildConstraints(this.constraints, 1, 0, 1, 1, 20, 0);
            gridBagLayout2.setConstraints(jLabel, this.constraints);
            ((Container)object).add(jLabel);
            SAMInitDialog.this.buildConstraints(this.constraints, 2, 0, 1, 1, 60, 0);
            this.constraints.fill = 1;
            gridBagLayout2.setConstraints(jScrollPane2, this.constraints);
            ((Container)object).add(jScrollPane2);
            this.constraints.fill = 0;
            SAMInitDialog.this.buildConstraints(this.constraints, 0, 1, 1, 1, 20, 50);
            gridBagLayout2.setConstraints(this.removeCurrentBButton, this.constraints);
            ((Container)object).add(this.removeCurrentBButton);
            JLabel jLabel2 = new JLabel("Current B: ");
            SAMInitDialog.this.buildConstraints(this.constraints, 1, 1, 1, 1, 20, 0);
            gridBagLayout2.setConstraints(jLabel2, this.constraints);
            ((Container)object).add(jLabel2);
            SAMInitDialog.this.buildConstraints(this.constraints, 2, 1, 1, 1, 60, 0);
            this.constraints.fill = 1;
            gridBagLayout2.setConstraints(jScrollPane3, this.constraints);
            ((Container)object).add(jScrollPane3);
            this.constraints.fill = 0;
            SAMInitDialog.this.buildConstraints(this.constraints, 1, 0, 1, 1, 10, 0);
            this.gridbag.setConstraints((Component)object, this.constraints);
            this.add((Component)object);
            this.constraints.fill = 0;
            JPanel jPanel2 = new JPanel();
            GridBagLayout gridBagLayout3 = new GridBagLayout();
            jPanel2.setLayout(gridBagLayout3);
            SAMInitDialog.this.buildConstraints(this.constraints, 0, 0, 1, 1, 100, 50);
            gridBagLayout3.setConstraints(this.loadABPairButton, this.constraints);
            jPanel2.add(this.loadABPairButton);
            SAMInitDialog.this.buildConstraints(this.constraints, 0, 1, 1, 1, 0, 50);
            gridBagLayout3.setConstraints(this.removeABPairButton, this.constraints);
            jPanel2.add(this.removeABPairButton);
            SAMInitDialog.this.buildConstraints(this.constraints, 2, 0, 1, 1, 5, 0);
            this.gridbag.setConstraints(jPanel2, this.constraints);
            this.add(jPanel2);
            SAMInitDialog.this.buildConstraints(this.constraints, 3, 0, 1, 1, 45, 0);
            this.constraints.fill = 1;
            JScrollPane jScrollPane4 = new JScrollPane(this.pairedExptsList);
            jScrollPane4.setBorder(new TitledBorder("Paired Samples"));
            this.gridbag.setConstraints(jScrollPane4, this.constraints);
            this.add(jScrollPane4);
        }

        public void reset() {
            for (int i = 0; i < this.exptButtons.length; ++i) {
                this.exptButtons[i].setEnabled(true);
                this.currentATextField.setText("");
                this.currentBTextField.setText("");
                this.removeCurrentAButton.setEnabled(false);
                this.removeCurrentBButton.setEnabled(false);
                this.loadABPairButton.setEnabled(false);
                this.removeABPairButton.setEnabled(false);
                this.pairedListModel.clear();
                this.currentAFilled = false;
                this.currentBFilled = false;
                this.currentAExpt = -1;
                this.currentBExpt = -1;
                this.pairedAExpts.clear();
                this.pairedBExpts.clear();
            }
        }

        class PairedExperimentsPanel
        extends JPanel {
        }

        class ExperimentButton
        extends JButton {
            String s;
            int index;

            public ExperimentButton(int n) {
                this.index = n;
                this.s = (String)((TwoClassPairedPanel)TwoClassPairedPanel.this).SAMInitDialog.this.exptNames.get(n);
                this.setText(this.s);
                this.addActionListener(new ActionListener(this, TwoClassPairedPanel.this){
                    private final /* synthetic */ TwoClassPairedPanel val$this$1;
                    private final /* synthetic */ ExperimentButton this$2;
                    {
                        this.this$2 = experimentButton;
                        this.val$this$1 = twoClassPairedPanel;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (ExperimentButton.access$600((ExperimentButton)this.this$2).currentAFilled && ExperimentButton.access$600((ExperimentButton)this.this$2).currentBFilled) {
                            JOptionPane.showMessageDialog(null, "Clear at least one current field first!", "Error", 0);
                        } else if (!ExperimentButton.access$600((ExperimentButton)this.this$2).currentAFilled) {
                            ExperimentButton.access$600((ExperimentButton)this.this$2).currentAExpt = this.this$2.index;
                            ExperimentButton.access$600((ExperimentButton)this.this$2).currentATextField.setText(this.this$2.s);
                            ExperimentButton.access$600((ExperimentButton)this.this$2).currentAFilled = true;
                            this.this$2.setEnabled(false);
                            ExperimentButton.access$600((ExperimentButton)this.this$2).removeCurrentAButton.setEnabled(true);
                        } else if (!ExperimentButton.access$600((ExperimentButton)this.this$2).currentBFilled) {
                            ExperimentButton.access$600((ExperimentButton)this.this$2).currentBExpt = this.this$2.index;
                            ExperimentButton.access$600((ExperimentButton)this.this$2).currentBTextField.setText(this.this$2.s);
                            ExperimentButton.access$600((ExperimentButton)this.this$2).currentBFilled = true;
                            this.this$2.setEnabled(false);
                            ExperimentButton.access$600((ExperimentButton)this.this$2).removeCurrentBButton.setEnabled(true);
                        }
                        if (ExperimentButton.access$600((ExperimentButton)this.this$2).currentAFilled && ExperimentButton.access$600((ExperimentButton)this.this$2).currentBFilled) {
                            ExperimentButton.access$600((ExperimentButton)this.this$2).loadABPairButton.setEnabled(true);
                        } else {
                            ExperimentButton.access$600((ExperimentButton)this.this$2).loadABPairButton.setEnabled(false);
                        }
                    }
                });
            }

            static /* synthetic */ TwoClassPairedPanel access$600(ExperimentButton experimentButton) {
                return experimentButton.TwoClassPairedPanel.this;
            }
        }
    }

    class TwoClassPairedMainPanel
    extends JPanel {
        TwoClassPairedPanel tcpPanel;
        JButton saveButton;
        JButton resetButton;
        JButton loadButton;
        GridBagConstraints constraints;
        GridBagLayout gridbag;

        public TwoClassPairedMainPanel() {
            this.tcpPanel = new TwoClassPairedPanel();
            JPanel jPanel = new JPanel();
            jPanel.setBackground(Color.white);
            this.constraints = new GridBagConstraints();
            this.gridbag = new GridBagLayout();
            this.setLayout(this.gridbag);
            SAMInitDialog.this.buildConstraints(this.constraints, 0, 0, 1, 1, 100, 90);
            this.constraints.fill = 1;
            this.gridbag.setConstraints(this.tcpPanel, this.constraints);
            this.add(this.tcpPanel);
            GridBagLayout gridBagLayout = new GridBagLayout();
            jPanel.setLayout(gridBagLayout);
            this.saveButton = new JButton("Save pairings");
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(new File("Data"));
            this.saveButton.addActionListener(new ActionListener(this, jFileChooser, SAMInitDialog.this){
                private final /* synthetic */ JFileChooser val$fc;
                private final /* synthetic */ SAMInitDialog val$this$0;
                private final /* synthetic */ TwoClassPairedMainPanel this$1;
                {
                    this.this$1 = twoClassPairedMainPanel;
                    this.val$fc = jFileChooser;
                    this.val$this$0 = sAMInitDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = this.val$fc.showSaveDialog(this.this$1);
                    if (n == 0) {
                        File file = this.val$fc.getSelectedFile();
                        try {
                            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                            for (int i = 0; i < this.this$1.tcpPanel.pairedAExpts.size(); ++i) {
                                int n2 = (Integer)this.this$1.tcpPanel.pairedAExpts.get(i);
                                int n3 = (Integer)this.this$1.tcpPanel.pairedBExpts.get(i);
                                printWriter.print(n2);
                                printWriter.print("\t");
                                printWriter.print(n3);
                                printWriter.print("\t");
                                printWriter.println();
                            }
                            printWriter.flush();
                            printWriter.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            this.constraints.fill = 0;
            SAMInitDialog.this.buildConstraints(this.constraints, 0, 0, 1, 1, 33, 100);
            gridBagLayout.setConstraints(this.saveButton, this.constraints);
            jPanel.add(this.saveButton);
            this.loadButton = new JButton("Load pairings");
            this.loadButton.addActionListener(new ActionListener(this, jFileChooser, SAMInitDialog.this){
                private final /* synthetic */ JFileChooser val$fc;
                private final /* synthetic */ SAMInitDialog val$this$0;
                private final /* synthetic */ TwoClassPairedMainPanel this$1;
                {
                    this.this$1 = twoClassPairedMainPanel;
                    this.val$fc = jFileChooser;
                    this.val$this$0 = sAMInitDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.tcpPanel.reset();
                    int n = this.val$fc.showOpenDialog(this.this$1);
                    if (n == 0) {
                        try {
                            int n2;
                            String string;
                            FileReader fileReader = new FileReader(this.val$fc.getSelectedFile());
                            BufferedReader bufferedReader = new BufferedReader(fileReader);
                            while ((string = bufferedReader.readLine()) != null) {
                                StringSplitter stringSplitter = new StringSplitter('\t');
                                stringSplitter.init(string);
                                for (n2 = 0; n2 < 2; ++n2) {
                                    String string2 = stringSplitter.nextToken();
                                    if (n2 == 0) {
                                        this.this$1.tcpPanel.pairedAExpts.add(new Integer(string2));
                                        continue;
                                    }
                                    if (n2 != 1) continue;
                                    this.this$1.tcpPanel.pairedBExpts.add(new Integer(string2));
                                }
                            }
                            bufferedReader.close();
                            for (int i = 0; i < this.this$1.tcpPanel.pairedAExpts.size(); ++i) {
                                n2 = (Integer)this.this$1.tcpPanel.pairedAExpts.get(i);
                                int n3 = (Integer)this.this$1.tcpPanel.pairedBExpts.get(i);
                                String string3 = "A: " + (String)TwoClassPairedMainPanel.access$400((TwoClassPairedMainPanel)this.this$1).exptNames.get(n2) + " - B: " + (String)TwoClassPairedMainPanel.access$400((TwoClassPairedMainPanel)this.this$1).exptNames.get(n3);
                                this.this$1.tcpPanel.exptButtons[n2].setEnabled(false);
                                this.this$1.tcpPanel.exptButtons[n3].setEnabled(false);
                                this.this$1.tcpPanel.pairedListModel.addElement(string3);
                            }
                            if (this.this$1.tcpPanel.pairedAExpts.size() > 0) {
                                this.this$1.tcpPanel.removeABPairButton.setEnabled(true);
                                this.this$1.tcpPanel.pairedExptsList.setSelectedIndex(this.this$1.tcpPanel.pairedListModel.size() - 1);
                            }
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(this.this$1.tcpPanel, "Incompatible file!", "Error", 2);
                        }
                    }
                }
            });
            SAMInitDialog.this.buildConstraints(this.constraints, 1, 0, 1, 1, 33, 100);
            gridBagLayout.setConstraints(this.loadButton, this.constraints);
            jPanel.add(this.loadButton);
            this.resetButton = new JButton("Reset");
            this.resetButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ TwoClassPairedMainPanel this$1;
                {
                    this.this$1 = twoClassPairedMainPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.tcpPanel.reset();
                }
            });
            SAMInitDialog.this.buildConstraints(this.constraints, 2, 0, 1, 1, 34, 100);
            gridBagLayout.setConstraints(this.resetButton, this.constraints);
            jPanel.add(this.resetButton);
            SAMInitDialog.this.buildConstraints(this.constraints, 0, 1, 1, 1, 0, 10);
            this.gridbag.setConstraints(jPanel, this.constraints);
            this.add(jPanel);
        }

        static /* synthetic */ SAMInitDialog access$400(TwoClassPairedMainPanel twoClassPairedMainPanel) {
            return twoClassPairedMainPanel.SAMInitDialog.this;
        }
    }

    class OneClassPanel
    extends JPanel {
        JTextField meanField;
        JCheckBox[] includeExpts;
        JButton saveButton;
        JButton loadButton;
        JButton resetButton;

        OneClassPanel() {
            this.setBackground(Color.white);
            JLabel jLabel = new JLabel("Enter the mean value to be tested against: ");
            this.meanField = new JTextField("0", 7);
            this.includeExpts = new JCheckBox[SAMInitDialog.this.exptNames.size()];
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            JPanel jPanel = new JPanel();
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            jPanel.setLayout(gridBagLayout2);
            for (int i = 0; i < SAMInitDialog.this.exptNames.size(); ++i) {
                this.includeExpts[i] = new JCheckBox((String)SAMInitDialog.this.exptNames.get(i), true);
                SAMInitDialog.this.buildConstraints(gridBagConstraints, 0, i, 1, 1, 100, 100);
                gridBagLayout2.setConstraints(this.includeExpts[i], gridBagConstraints);
                jPanel.add(this.includeExpts[i]);
            }
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setVerticalScrollBarPolicy(22);
            JPanel jPanel2 = new JPanel();
            GridBagLayout gridBagLayout3 = new GridBagLayout();
            jPanel2.setLayout(gridBagLayout3);
            gridBagConstraints.fill = 0;
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 50, 100);
            gridBagConstraints.anchor = 13;
            gridBagLayout3.setConstraints(jLabel, gridBagConstraints);
            jPanel2.add(jLabel);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 50, 0);
            gridBagConstraints.anchor = 17;
            gridBagLayout3.setConstraints(this.meanField, gridBagConstraints);
            jPanel2.add(this.meanField);
            JScrollPane jScrollPane2 = new JScrollPane(jPanel2);
            JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, jScrollPane2);
            jSplitPane.setOneTouchExpandable(true);
            jSplitPane.setDividerLocation(150);
            gridBagConstraints.fill = 1;
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 80);
            gridBagLayout.setConstraints(jSplitPane, gridBagConstraints);
            this.add(jSplitPane);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 10;
            JPanel jPanel3 = new JPanel();
            this.loadButton = new JButton("Load settings");
            this.saveButton = new JButton("Save settings");
            this.resetButton = new JButton("Reset");
            this.resetButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ OneClassPanel this$1;
                {
                    this.this$1 = oneClassPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = 0; i < this.this$1.includeExpts.length; ++i) {
                        this.this$1.includeExpts[i].setSelected(true);
                    }
                }
            });
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(new File("Data"));
            this.saveButton.addActionListener(new ActionListener(this, jFileChooser, SAMInitDialog.this){
                private final /* synthetic */ JFileChooser val$fc;
                private final /* synthetic */ SAMInitDialog val$this$0;
                private final /* synthetic */ OneClassPanel this$1;
                {
                    this.this$1 = oneClassPanel;
                    this.val$fc = jFileChooser;
                    this.val$this$0 = sAMInitDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = this.val$fc.showSaveDialog(this.this$1);
                    if (n == 0) {
                        File file = this.val$fc.getSelectedFile();
                        try {
                            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                            for (int i = 0; i < this.this$1.includeExpts.length; ++i) {
                                if (this.this$1.includeExpts[i].isSelected()) {
                                    printWriter.print(1);
                                } else {
                                    printWriter.print(0);
                                }
                                if (i >= this.this$1.includeExpts.length - 1) continue;
                                printWriter.print("\t");
                            }
                            printWriter.println();
                            printWriter.flush();
                            printWriter.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            this.loadButton.addActionListener(new ActionListener(this, jFileChooser, SAMInitDialog.this){
                private final /* synthetic */ JFileChooser val$fc;
                private final /* synthetic */ SAMInitDialog val$this$0;
                private final /* synthetic */ OneClassPanel this$1;
                {
                    this.this$1 = oneClassPanel;
                    this.val$fc = jFileChooser;
                    this.val$this$0 = sAMInitDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    block9: {
                        int n = this.val$fc.showOpenDialog(this.this$1);
                        if (n == 0) {
                            try {
                                FileReader fileReader = new FileReader(this.val$fc.getSelectedFile());
                                BufferedReader bufferedReader = new BufferedReader(fileReader);
                                String string = bufferedReader.readLine();
                                StringSplitter stringSplitter = new StringSplitter('\t');
                                stringSplitter.init(string);
                                Vector<Integer> vector = new Vector<Integer>();
                                while (stringSplitter.hasMoreTokens()) {
                                    String string2 = stringSplitter.nextToken();
                                    vector.add(new Integer(string2));
                                }
                                bufferedReader.close();
                                if (vector.size() != this.this$1.includeExpts.length) {
                                    JOptionPane.showMessageDialog(OneClassPanel.access$300((OneClassPanel)this.this$1).gPanel, "Incompatible file!", "Error", 2);
                                    break block9;
                                }
                                for (int i = 0; i < this.this$1.includeExpts.length; ++i) {
                                    int n2 = (Integer)vector.get(i);
                                    if (n2 == 0) {
                                        this.this$1.includeExpts[i].setSelected(false);
                                        continue;
                                    }
                                    if (n2 == 1) {
                                        this.this$1.includeExpts[i].setSelected(true);
                                        continue;
                                    }
                                    for (int j = 0; j < this.this$1.includeExpts.length; ++j) {
                                        this.this$1.includeExpts[j].setSelected(true);
                                    }
                                    JOptionPane.showMessageDialog(OneClassPanel.access$300((OneClassPanel)this.this$1).gPanel, "Incompatible file!", "Error", 2);
                                    break;
                                }
                            }
                            catch (Exception exception) {
                                JOptionPane.showMessageDialog(OneClassPanel.access$300((OneClassPanel)this.this$1).gPanel, "Incompatible file!", "Error", 2);
                            }
                        }
                    }
                }
            });
            GridBagLayout gridBagLayout4 = new GridBagLayout();
            jPanel3.setLayout(gridBagLayout4);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 33, 100);
            gridBagLayout4.setConstraints(this.saveButton, gridBagConstraints);
            jPanel3.add(this.saveButton);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 33, 0);
            gridBagLayout4.setConstraints(this.loadButton, gridBagConstraints);
            jPanel3.add(this.loadButton);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 33, 0);
            gridBagLayout4.setConstraints(this.resetButton, gridBagConstraints);
            jPanel3.add(this.resetButton);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 20);
            gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
            this.add(jPanel3);
        }

        public void reset() {
            for (int i = 0; i < this.includeExpts.length; ++i) {
                this.includeExpts[i].setSelected(true);
            }
            this.meanField.setText("0");
        }

        static /* synthetic */ SAMInitDialog access$300(OneClassPanel oneClassPanel) {
            return oneClassPanel.SAMInitDialog.this;
        }
    }

    class CensoredSurvivalPanel
    extends JPanel {
        ExptTimeField[] fields;

        CensoredSurvivalPanel(Vector vector) {
            Object object;
            this.setBorder(new TitledBorder(new EtchedBorder(), "Time / State Assignments", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            JPanel jPanel = new JPanel();
            this.fields = new ExptTimeField[vector.size()];
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout2);
            jPanel.setLayout(gridBagLayout);
            for (int i = 0; i < vector.size(); ++i) {
                object = (String)vector.get(i);
                this.fields[i] = new ExptTimeField((String)object);
                SAMInitDialog.this.buildConstraints(gridBagConstraints, 0, i, 1, 1, 20, 100);
                gridBagLayout.setConstraints(this.fields[i].inAnalysisCheckBox, gridBagConstraints);
                jPanel.add(this.fields[i].inAnalysisCheckBox);
                SAMInitDialog.this.buildConstraints(gridBagConstraints, 1, i, 1, 1, 20, 100);
                gridBagLayout.setConstraints(this.fields[i].expLabel, gridBagConstraints);
                jPanel.add(this.fields[i].expLabel);
                SAMInitDialog.this.buildConstraints(gridBagConstraints, 2, i, 1, 1, 20, 100);
                gridBagConstraints.anchor = 13;
                gridBagLayout.setConstraints(this.fields[i].timeLabel, gridBagConstraints);
                jPanel.add(this.fields[i].timeLabel);
                SAMInitDialog.this.buildConstraints(gridBagConstraints, 3, i, 1, 1, 20, 100);
                gridBagConstraints.anchor = 17;
                gridBagLayout.setConstraints(this.fields[i].timeInputField, gridBagConstraints);
                jPanel.add(this.fields[i].timeInputField);
                gridBagConstraints.anchor = 10;
                SAMInitDialog.this.buildConstraints(gridBagConstraints, 4, i, 1, 1, 20, 100);
                gridBagLayout.setConstraints(this.fields[i].censoredRadioButton, gridBagConstraints);
                jPanel.add(this.fields[i].censoredRadioButton);
                SAMInitDialog.this.buildConstraints(gridBagConstraints, 5, i, 1, 1, 20, 100);
                gridBagLayout.setConstraints(this.fields[i].deadRadioButton, gridBagConstraints);
                jPanel.add(this.fields[i].deadRadioButton);
            }
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setHorizontalScrollBarPolicy(32);
            jScrollPane.setVerticalScrollBarPolicy(22);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 90);
            gridBagConstraints.fill = 1;
            gridBagLayout2.setConstraints(jScrollPane, gridBagConstraints);
            this.add(jScrollPane);
            object = new JPanel();
            GridBagLayout gridBagLayout3 = new GridBagLayout();
            ((Container)object).setLayout(gridBagLayout3);
            ((JComponent)object).setBackground(Color.white);
            JButton jButton = new JButton("  Save settings  ");
            jButton.setFocusPainted(false);
            jButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
            JButton jButton2 = new JButton("  Load settings  ");
            jButton2.setFocusPainted(false);
            jButton2.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
            JButton jButton3 = new JButton("  Reset  ");
            jButton3.setFocusPainted(false);
            jButton3.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
            int n = vector.size();
            jButton3.addActionListener(new ActionListener(this, n){
                private final /* synthetic */ int val$finNum;
                private final /* synthetic */ CensoredSurvivalPanel this$1;
                {
                    this.this$1 = censoredSurvivalPanel;
                    this.val$finNum = n;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = 0; i < this.val$finNum; ++i) {
                        this.this$1.fields[i].inAnalysisCheckBox.setSelected(true);
                        this.this$1.fields[i].timeInputField.setText("0.0");
                        this.this$1.fields[i].censoredRadioButton.setSelected(true);
                    }
                }
            });
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(new File("Data"));
            jButton.addActionListener(new ActionListener(this, jFileChooser, SAMInitDialog.this, n){
                private final /* synthetic */ JFileChooser val$fc;
                private final /* synthetic */ SAMInitDialog val$this$0;
                private final /* synthetic */ int val$finNum;
                private final /* synthetic */ CensoredSurvivalPanel this$1;
                {
                    this.this$1 = censoredSurvivalPanel;
                    this.val$fc = jFileChooser;
                    this.val$this$0 = sAMInitDialog;
                    this.val$finNum = n;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = this.val$fc.showSaveDialog(this.this$1);
                    if (n == 0) {
                        File file = this.val$fc.getSelectedFile();
                        try {
                            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                            for (int i = 0; i < this.val$finNum; ++i) {
                                if (this.this$1.fields[i].inAnalysisCheckBox.isSelected()) {
                                    printWriter.print(1);
                                    printWriter.print("\t");
                                    if (this.this$1.fields[i].timeInputField.getText() == "") {
                                        printWriter.print("0.0");
                                    } else {
                                        printWriter.print(this.this$1.fields[i].timeInputField.getText());
                                    }
                                    printWriter.print("\t");
                                    if (this.this$1.fields[i].censoredRadioButton.isSelected()) {
                                        printWriter.print(1);
                                    } else {
                                        printWriter.print(0);
                                    }
                                } else {
                                    printWriter.print(0);
                                }
                                printWriter.println();
                            }
                            printWriter.flush();
                            printWriter.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            jButton2.addActionListener(new ActionListener(this, jFileChooser, SAMInitDialog.this, n){
                private final /* synthetic */ JFileChooser val$fc;
                private final /* synthetic */ SAMInitDialog val$this$0;
                private final /* synthetic */ int val$finNum;
                private final /* synthetic */ CensoredSurvivalPanel this$1;
                {
                    this.this$1 = censoredSurvivalPanel;
                    this.val$fc = jFileChooser;
                    this.val$this$0 = sAMInitDialog;
                    this.val$finNum = n;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = this.val$fc.showOpenDialog(this.this$1);
                    if (n == 0) {
                        try {
                            String string;
                            FileReader fileReader = new FileReader(this.val$fc.getSelectedFile());
                            BufferedReader bufferedReader = new BufferedReader(fileReader);
                            Vector<String> vector = new Vector<String>();
                            while ((string = bufferedReader.readLine()) != null) {
                                vector.add(string);
                            }
                            bufferedReader.close();
                            for (int i = 0; i < vector.size(); ++i) {
                                double[] dArray = CensoredSurvivalPanel.access$100(this.this$1, (String)vector.get(i));
                                if (dArray[0] == 0.0) {
                                    this.this$1.fields[i].inAnalysisCheckBox.setSelected(false);
                                    continue;
                                }
                                if (dArray[0] == 1.0) {
                                    this.this$1.fields[i].inAnalysisCheckBox.setSelected(true);
                                    this.this$1.fields[i].timeInputField.setText("" + dArray[1]);
                                    if (dArray[2] == 0.0) {
                                        this.this$1.fields[i].deadRadioButton.setSelected(true);
                                        continue;
                                    }
                                    if (dArray[2] == 1.0) {
                                        this.this$1.fields[i].censoredRadioButton.setSelected(true);
                                        continue;
                                    }
                                    for (int j = 0; j < this.val$finNum; ++j) {
                                        this.this$1.fields[j].inAnalysisCheckBox.setSelected(false);
                                    }
                                    JOptionPane.showMessageDialog(CensoredSurvivalPanel.access$200((CensoredSurvivalPanel)this.this$1).gPanel, "Incompatible file!", "Error", 2);
                                } else {
                                    for (int j = 0; j < this.val$finNum; ++j) {
                                        this.this$1.fields[j].inAnalysisCheckBox.setSelected(false);
                                    }
                                    JOptionPane.showMessageDialog(CensoredSurvivalPanel.access$200((CensoredSurvivalPanel)this.this$1).gPanel, "Incompatible file!", "Error", 2);
                                }
                                break;
                            }
                        }
                        catch (Exception exception) {
                            for (int i = 0; i < this.val$finNum; ++i) {
                                this.this$1.fields[i].inAnalysisCheckBox.setSelected(false);
                            }
                            JOptionPane.showMessageDialog(CensoredSurvivalPanel.access$200((CensoredSurvivalPanel)this.this$1).gPanel, "Incompatible file!", "Error", 2);
                        }
                    }
                }
            });
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 33, 100);
            gridBagLayout3.setConstraints(jButton, gridBagConstraints);
            ((Container)object).add(jButton);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 33, 0);
            gridBagLayout3.setConstraints(jButton2, gridBagConstraints);
            ((Container)object).add(jButton2);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 34, 0);
            gridBagLayout3.setConstraints(jButton3, gridBagConstraints);
            ((Container)object).add(jButton3);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 10);
            gridBagConstraints.anchor = 10;
            gridBagLayout2.setConstraints((Component)object, gridBagConstraints);
            this.add((Component)object);
        }

        private void reset() {
            for (int i = 0; i < SAMInitDialog.this.exptNames.size(); ++i) {
                this.fields[i].inAnalysisCheckBox.setSelected(true);
                this.fields[i].timeInputField.setText("0.0");
                this.fields[i].censoredRadioButton.setSelected(true);
            }
        }

        private double[] getCurrentSettings(String string) {
            Vector<Double> vector = new Vector<Double>();
            StringSplitter stringSplitter = new StringSplitter('\t');
            stringSplitter.init(string);
            while (stringSplitter.hasMoreTokens()) {
                String string2 = stringSplitter.nextToken();
                vector.add(new Double(string2));
            }
            double[] dArray = new double[vector.size()];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = (Double)vector.get(i);
            }
            return dArray;
        }

        static /* synthetic */ double[] access$100(CensoredSurvivalPanel censoredSurvivalPanel, String string) {
            return censoredSurvivalPanel.getCurrentSettings(string);
        }

        static /* synthetic */ SAMInitDialog access$200(CensoredSurvivalPanel censoredSurvivalPanel) {
            return censoredSurvivalPanel.SAMInitDialog.this;
        }

        private class ExptTimeField {
            JCheckBox inAnalysisCheckBox = new JCheckBox("", true);
            JLabel expLabel;
            JLabel timeLabel;
            JTextField timeInputField;
            JRadioButton censoredRadioButton;
            JRadioButton deadRadioButton;

            public ExptTimeField(String string) {
                this.expLabel = new JLabel(string);
                this.timeLabel = new JLabel("Time: ");
                this.timeInputField = new JTextField("0.0", 7);
                this.censoredRadioButton = new JRadioButton("Censored", true);
                this.deadRadioButton = new JRadioButton("Dead", false);
                ButtonGroup buttonGroup = new ButtonGroup();
                buttonGroup.add(this.censoredRadioButton);
                buttonGroup.add(this.deadRadioButton);
                this.inAnalysisCheckBox.addItemListener(new ItemListener(this){
                    private final /* synthetic */ ExptTimeField this$2;
                    {
                        this.this$2 = exptTimeField;
                    }

                    public void itemStateChanged(ItemEvent itemEvent) {
                        if (itemEvent.getStateChange() == 2) {
                            this.this$2.expLabel.setEnabled(false);
                            this.this$2.timeLabel.setEnabled(false);
                            this.this$2.timeInputField.setText("");
                            this.this$2.timeInputField.setBackground(Color.darkGray);
                            this.this$2.timeInputField.setEnabled(false);
                            this.this$2.censoredRadioButton.setEnabled(false);
                            this.this$2.deadRadioButton.setEnabled(false);
                        }
                        if (itemEvent.getStateChange() == 1) {
                            this.this$2.expLabel.setEnabled(true);
                            this.this$2.timeLabel.setEnabled(true);
                            this.this$2.timeInputField.setText("0.0");
                            this.this$2.timeInputField.setBackground(Color.white);
                            this.this$2.timeInputField.setEnabled(true);
                            this.this$2.censoredRadioButton.setEnabled(true);
                            this.this$2.deadRadioButton.setEnabled(true);
                        }
                    }
                });
            }
        }
    }

    class GroupExperimentsPanel
    extends JPanel {
        JLabel[] expLabels;
        JRadioButton[] groupARadioButtons;
        JRadioButton[] groupBRadioButtons;
        JRadioButton[] neitherGroupRadioButtons;

        GroupExperimentsPanel(Vector vector) {
            Object object;
            this.setBorder(new TitledBorder(new EtchedBorder(), "Group Assignments", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            JPanel jPanel = new JPanel();
            this.expLabels = new JLabel[vector.size()];
            this.groupARadioButtons = new JRadioButton[vector.size()];
            this.groupBRadioButtons = new JRadioButton[vector.size()];
            this.neitherGroupRadioButtons = new JRadioButton[vector.size()];
            ButtonGroup[] buttonGroupArray = new ButtonGroup[vector.size()];
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout2);
            jPanel.setLayout(gridBagLayout);
            for (int i = 0; i < vector.size(); ++i) {
                object = (String)vector.get(i);
                this.expLabels[i] = new JLabel((String)object);
                buttonGroupArray[i] = new ButtonGroup();
                this.groupARadioButtons[i] = new JRadioButton("Group A", true);
                buttonGroupArray[i].add(this.groupARadioButtons[i]);
                this.groupBRadioButtons[i] = new JRadioButton("Group B", false);
                buttonGroupArray[i].add(this.groupBRadioButtons[i]);
                this.neitherGroupRadioButtons[i] = new JRadioButton("Neither group", false);
                buttonGroupArray[i].add(this.neitherGroupRadioButtons[i]);
                SAMInitDialog.this.buildConstraints(gridBagConstraints, 0, i, 1, 1, 25, 100);
                gridBagLayout.setConstraints(this.expLabels[i], gridBagConstraints);
                jPanel.add(this.expLabels[i]);
                SAMInitDialog.this.buildConstraints(gridBagConstraints, 1, i, 1, 1, 25, 100);
                gridBagLayout.setConstraints(this.groupARadioButtons[i], gridBagConstraints);
                jPanel.add(this.groupARadioButtons[i]);
                SAMInitDialog.this.buildConstraints(gridBagConstraints, 2, i, 1, 1, 25, 100);
                gridBagLayout.setConstraints(this.groupBRadioButtons[i], gridBagConstraints);
                jPanel.add(this.groupBRadioButtons[i]);
                SAMInitDialog.this.buildConstraints(gridBagConstraints, 3, i, 1, 1, 25, 100);
                gridBagLayout.setConstraints(this.neitherGroupRadioButtons[i], gridBagConstraints);
                jPanel.add(this.neitherGroupRadioButtons[i]);
            }
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setHorizontalScrollBarPolicy(32);
            jScrollPane.setVerticalScrollBarPolicy(22);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 90);
            gridBagConstraints.fill = 1;
            gridBagLayout2.setConstraints(jScrollPane, gridBagConstraints);
            this.add(jScrollPane);
            object = new JLabel("Note: Group A and Group B  MUST each contain more than one sample.");
            ((JLabel)object).setHorizontalAlignment(0);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0, 5);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 1;
            gridBagLayout2.setConstraints((Component)object, gridBagConstraints);
            this.add((Component)object);
            JPanel jPanel2 = new JPanel();
            jPanel2.setBackground(Color.white);
            GridBagLayout gridBagLayout3 = new GridBagLayout();
            jPanel2.setLayout(gridBagLayout3);
            JButton jButton = new JButton("  Save grouping  ");
            jButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
            jButton.setSize(180, 30);
            jButton.setPreferredSize(new Dimension(180, 30));
            JButton jButton2 = new JButton("  Load grouping  ");
            jButton2.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
            jButton2.setPreferredSize(new Dimension(180, 30));
            jButton2.setSize(180, 30);
            JButton jButton3 = new JButton("  Reset  ");
            jButton3.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
            jButton3.setSize(180, 30);
            jButton3.setPreferredSize(new Dimension(180, 30));
            int n = vector.size();
            jButton3.addActionListener(new ActionListener(this, n){
                private final /* synthetic */ int val$finNum;
                private final /* synthetic */ GroupExperimentsPanel this$1;
                {
                    this.this$1 = groupExperimentsPanel;
                    this.val$finNum = n;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = 0; i < this.val$finNum; ++i) {
                        this.this$1.groupARadioButtons[i].setSelected(true);
                    }
                }
            });
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(new File("Data"));
            jButton.addActionListener(new ActionListener(this, jFileChooser, SAMInitDialog.this){
                private final /* synthetic */ JFileChooser val$fc;
                private final /* synthetic */ SAMInitDialog val$this$0;
                private final /* synthetic */ GroupExperimentsPanel this$1;
                {
                    this.this$1 = groupExperimentsPanel;
                    this.val$fc = jFileChooser;
                    this.val$this$0 = sAMInitDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = this.val$fc.showSaveDialog(this.this$1);
                    if (n == 0) {
                        File file = this.val$fc.getSelectedFile();
                        try {
                            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
                            int[] nArray = GroupExperimentsPanel.access$000(this.this$1).getGroupAssignments();
                            for (int i = 0; i < nArray.length; ++i) {
                                printWriter.print(nArray[i]);
                                if (i >= nArray.length - 1) continue;
                                printWriter.print("\t");
                            }
                            printWriter.println();
                            printWriter.flush();
                            printWriter.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            jButton2.addActionListener(new ActionListener(this, jFileChooser, SAMInitDialog.this, n){
                private final /* synthetic */ JFileChooser val$fc;
                private final /* synthetic */ SAMInitDialog val$this$0;
                private final /* synthetic */ int val$finNum;
                private final /* synthetic */ GroupExperimentsPanel this$1;
                {
                    this.this$1 = groupExperimentsPanel;
                    this.val$fc = jFileChooser;
                    this.val$this$0 = sAMInitDialog;
                    this.val$finNum = n;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    block10: {
                        int n = this.val$fc.showOpenDialog(this.this$1);
                        if (n == 0) {
                            try {
                                Object object;
                                FileReader fileReader = new FileReader(this.val$fc.getSelectedFile());
                                BufferedReader bufferedReader = new BufferedReader(fileReader);
                                String string = bufferedReader.readLine();
                                StringSplitter stringSplitter = new StringSplitter('\t');
                                stringSplitter.init(string);
                                Vector<Integer> vector = new Vector<Integer>();
                                while (stringSplitter.hasMoreTokens()) {
                                    object = stringSplitter.nextToken();
                                    vector.add(new Integer((String)object));
                                }
                                bufferedReader.close();
                                object = GroupExperimentsPanel.access$000(this.this$1).getGroupAssignments();
                                if (vector.size() != ((Object)object).length) {
                                    JOptionPane.showMessageDialog(GroupExperimentsPanel.access$000((GroupExperimentsPanel)this.this$1).gPanel, "Incompatible file!", "Error", 2);
                                    break block10;
                                }
                                for (int i = 0; i < vector.size(); ++i) {
                                    int n2 = (Integer)vector.get(i);
                                    if (n2 == 1) {
                                        this.this$1.groupARadioButtons[i].setSelected(true);
                                        continue;
                                    }
                                    if (n2 == 2) {
                                        this.this$1.groupBRadioButtons[i].setSelected(true);
                                        continue;
                                    }
                                    if (n2 == 3) {
                                        this.this$1.neitherGroupRadioButtons[i].setSelected(true);
                                        continue;
                                    }
                                    for (int j = 0; j < this.val$finNum; ++j) {
                                        this.this$1.groupARadioButtons[j].setSelected(true);
                                    }
                                    JOptionPane.showMessageDialog(GroupExperimentsPanel.access$000((GroupExperimentsPanel)this.this$1).gPanel, "Incompatible file!", "Error", 2);
                                    break;
                                }
                            }
                            catch (Exception exception) {
                                JOptionPane.showMessageDialog(GroupExperimentsPanel.access$000((GroupExperimentsPanel)this.this$1).gPanel, "Incompatible file!", "Error", 2);
                            }
                        }
                    }
                }
            });
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 33, 10);
            gridBagLayout3.setConstraints(jButton, gridBagConstraints);
            jPanel2.add(jButton);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 33, 10);
            gridBagLayout3.setConstraints(jButton2, gridBagConstraints);
            jPanel2.add(jButton2);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 33, 10);
            gridBagLayout3.setConstraints(jButton3, gridBagConstraints);
            jPanel2.add(jButton3);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            SAMInitDialog.this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 0, 5);
            gridBagConstraints.anchor = 10;
            gridBagLayout2.setConstraints(jPanel2, gridBagConstraints);
            this.add(jPanel2);
        }

        private void reset() {
            for (int i = 0; i < SAMInitDialog.this.exptNames.size(); ++i) {
                this.groupARadioButtons[i].setSelected(true);
            }
        }

        static /* synthetic */ SAMInitDialog access$000(GroupExperimentsPanel groupExperimentsPanel) {
            return groupExperimentsPanel.SAMInitDialog.this;
        }
    }
}

